/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.helpers.Reporter;

public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        Object[] args = argArray;
        if (throwableCandidate != null) {
            args = MessageFormatter.trimmedCopy(argArray);
        }
        return MessageFormatter.arrayFormat(messagePattern, args, throwableCandidate);
    }

    public static final String basicArrayFormat(String messagePattern, Object[] argArray) {
        FormattingTuple ft4 = MessageFormatter.arrayFormat(messagePattern, argArray, null);
        return ft4.getMessage();
    }

    public static String basicArrayFormat(NormalizedParameters np4) {
        return MessageFormatter.basicArrayFormat(np4.getMessage(), np4.getArguments());
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray, Throwable throwable) {
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwable);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i15 = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int L11 = 0; L11 < argArray.length; ++L11) {
            int j15 = messagePattern.indexOf(DELIM_STR, i15);
            if (j15 == -1) {
                if (i15 == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwable);
                }
                sbuf.append(messagePattern, i15, messagePattern.length());
                return new FormattingTuple(sbuf.toString(), argArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j15)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j15)) {
                    --L11;
                    sbuf.append(messagePattern, i15, j15 - 1);
                    sbuf.append('{');
                    i15 = j15 + 1;
                    continue;
                }
                sbuf.append(messagePattern, i15, j15 - 1);
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L11], new HashMap<Object[], Object>());
                i15 = j15 + 2;
                continue;
            }
            sbuf.append(messagePattern, i15, j15);
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L11], new HashMap<Object[], Object>());
            i15 = j15 + 2;
        }
        sbuf.append(messagePattern, i15, messagePattern.length());
        return new FormattingTuple(sbuf.toString(), argArray, throwable);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o15, Map<Object[], Object> seenMap) {
        if (o15 == null) {
            sbuf.append("null");
            return;
        }
        if (!o15.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o15);
        } else if (o15 instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o15);
        } else if (o15 instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o15);
        } else if (o15 instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o15);
        } else if (o15 instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o15);
        } else if (o15 instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o15);
        } else if (o15 instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o15);
        } else if (o15 instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o15);
        } else if (o15 instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o15);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o15, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o15) {
        try {
            String oAsString = o15.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t15) {
            Reporter.error("Failed toString() invocation on an object of type [" + o15.getClass().getName() + "]", t15);
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a15, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a15)) {
            seenMap.put(a15, null);
            int len = a15.length;
            for (int i15 = 0; i15 < len; ++i15) {
                MessageFormatter.deeplyAppendParameter(sbuf, a15[i15], seenMap);
                if (i15 == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a15);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a15) {
        sbuf.append('[');
        int len = a15.length;
        for (int i15 = 0; i15 < len; ++i15) {
            sbuf.append(a15[i15]);
            if (i15 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        return NormalizedParameters.getThrowableCandidate(argArray);
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        return NormalizedParameters.trimmedCopy(argArray);
    }
}

