/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SmartHighlightPainter
extends ChangeableHighlightPainter {
    public static final Color DEFAULT_HIGHLIGHT_COLOR = Color.LIGHT_GRAY;
    private Color borderColor;
    private boolean paintBorder;

    public SmartHighlightPainter() {
        super(DEFAULT_HIGHLIGHT_COLOR);
    }

    public SmartHighlightPainter(Paint paint) {
        super(paint);
    }

    public boolean getPaintBorder() {
        return this.paintBorder;
    }

    @Override
    public Shape paintLayer(Graphics g15, int p05, int p15, Shape viewBounds, JTextComponent c15, View view) {
        g15.setColor((Color)this.getPaint());
        if (p05 == p15) {
            try {
                Shape s15 = view.modelToView(p05, viewBounds, Position.Bias.Forward);
                Rectangle r15 = s15.getBounds();
                g15.drawLine(r15.x, r15.y, r15.x, r15.y + r15.height);
                return r15;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        p15 = Math.min(p15, c15.getDocument().getLength());
        if (p05 == view.getStartOffset() && p15 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g15.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p05, Position.Bias.Forward, p15, Position.Bias.Backward, viewBounds);
            Rectangle r16 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g15.fillRect(r16.x, r16.y, r16.width, r16.height);
            if (this.paintBorder) {
                g15.setColor(this.borderColor);
                g15.drawRect(r16.x, r16.y, r16.width - 1, r16.height - 1);
            }
            return r16;
        }
        catch (BadLocationException e15) {
            e15.printStackTrace();
            return null;
        }
    }

    @Override
    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.borderColor = ((Color)paint).darker();
        }
    }

    public void setPaintBorder(boolean paint) {
        this.paintBorder = paint;
    }
}

