/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTextArea;

class ClipboardHistoryPopup
extends JWindow {
    private RTextArea textArea;
    private ChoiceList list;
    private transient Listener listener;
    private boolean prevCaretAlwaysVisible;
    private static final int VERTICAL_SPACE = 1;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";

    ClipboardHistoryPopup(Window parent, RTextArea textArea) {
        super(parent);
        this.textArea = textArea;
        JPanel cp4 = new JPanel(new BorderLayout());
        cp4.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        cp4.setBackground(TipUtil.getToolTipBackground());
        this.setContentPane(cp4);
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        JLabel title = new JLabel(msg.getString("Action.ClipboardHistory.Popup.Label"));
        cp4.add((Component)title, "North");
        this.list = new ChoiceList();
        JScrollPane sp4 = new JScrollPane(this.list);
        sp4.setHorizontalScrollBarPolicy(31);
        cp4.add(sp4);
        this.installKeyBindings();
        this.listener = new Listener();
        this.setLocation();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size != null) {
            size.width = Math.min(size.width, 300);
            size.width = Math.max(size.width, 200);
        }
        return size;
    }

    private void insertSelectedItem() {
        LabelValuePair lvp = (LabelValuePair)this.list.getSelectedValue();
        if (lvp != null) {
            this.listener.uninstallAndHide();
            String text = lvp.value;
            this.textArea.replaceSelection(text);
            ClipboardHistory.get().add(text);
        }
    }

    private void installKeyBindings() {
        InputMap im4 = this.getRootPane().getInputMap(1);
        ActionMap am4 = this.getRootPane().getActionMap();
        KeyStroke escapeKS = KeyStroke.getKeyStroke(27, 0);
        im4.put(escapeKS, "onEscape");
        am4.put("onEscape", new EscapeAction());
        this.list.getInputMap().remove(escapeKS);
    }

    public void setContents(List<String> contents) {
        this.list.setContents(contents);
        this.pack();
    }

    private void setLocation() {
        Rectangle r15;
        try {
            r15 = this.textArea.modelToView(this.textArea.getCaretPosition());
        }
        catch (Exception e15) {
            e15.printStackTrace();
            return;
        }
        Point p15 = r15.getLocation();
        SwingUtilities.convertPointToScreen(p15, this.textArea);
        r15.x = p15.x;
        r15.y = p15.y;
        Rectangle screenBounds = TipUtil.getScreenBoundsForPoint(r15.x, r15.y);
        int totalH = this.getHeight();
        int y15 = r15.y + r15.height + 1;
        if (y15 + totalH > screenBounds.height) {
            y15 = r15.y - 1 - this.getHeight();
        }
        int x15 = r15.x;
        if (!this.textArea.getComponentOrientation().isLeftToRight()) {
            x15 -= this.getWidth();
        }
        if (x15 < screenBounds.x) {
            x15 = screenBounds.x;
        } else if (x15 + this.getWidth() > screenBounds.x + screenBounds.width) {
            x15 = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x15, y15);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.list.getModel().getSize() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            return;
        }
        super.setVisible(visible);
        this.updateTextAreaCaret(visible);
        if (visible) {
            SwingUtilities.invokeLater(() -> {
                this.requestFocus();
                if (this.list.getModel().getSize() > 0) {
                    this.list.setSelectedIndex(0);
                }
                this.list.requestFocusInWindow();
            });
        }
    }

    private void updateTextAreaCaret(boolean visible) {
        Caret caret = this.textArea.getCaret();
        if (caret instanceof ConfigurableCaret) {
            ConfigurableCaret cc5 = (ConfigurableCaret)caret;
            if (visible) {
                this.prevCaretAlwaysVisible = cc5.isAlwaysVisible();
                cc5.setAlwaysVisible(true);
            } else {
                cc5.setAlwaysVisible(this.prevCaretAlwaysVisible);
            }
        }
    }

    private static final class ChoiceList
    extends JList<LabelValuePair> {
        private ChoiceList() {
            super(new DefaultListModel());
            this.setSelectionMode(0);
            this.installKeyboardActions();
        }

        private void installKeyboardActions() {
            InputMap im4 = this.getInputMap();
            ActionMap am4 = this.getActionMap();
            im4.put(KeyStroke.getKeyStroke(40, 0), "onDown");
            am4.put("onDown", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e15) {
                    int index = (this.getSelectedIndex() + 1) % this.getModel().getSize();
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
            im4.put(KeyStroke.getKeyStroke(38, 0), "onUp");
            am4.put("onUp", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e15) {
                    int index = this.getSelectedIndex() - 1;
                    if (index < 0) {
                        index += this.getModel().getSize();
                    }
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
        }

        private void setContents(List<String> contents) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            model.clear();
            for (String str : contents) {
                model.addElement(new LabelValuePair(str));
            }
            this.setVisibleRowCount(Math.min(model.getSize(), 8));
        }
    }

    private class Listener
    extends WindowAdapter
    implements ComponentListener {
        Listener() {
            ClipboardHistoryPopup.this.addWindowFocusListener(this);
            ClipboardHistoryPopup.this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e15) {
                    if (e15.getClickCount() == 2) {
                        ClipboardHistoryPopup.this.insertSelectedItem();
                    }
                }
            });
            ClipboardHistoryPopup.this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "onEnter");
            ClipboardHistoryPopup.this.list.getActionMap().put("onEnter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e15) {
                    ClipboardHistoryPopup.this.insertSelectedItem();
                }
            });
            Window parent = (Window)ClipboardHistoryPopup.this.getParent();
            parent.addWindowFocusListener(this);
            parent.addWindowListener(this);
            parent.addComponentListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e15) {
            this.uninstallAndHide();
        }

        @Override
        public void componentMoved(ComponentEvent e15) {
            this.uninstallAndHide();
        }

        @Override
        public void componentShown(ComponentEvent e15) {
            this.uninstallAndHide();
        }

        @Override
        public void componentHidden(ComponentEvent e15) {
            this.uninstallAndHide();
        }

        @Override
        public void windowActivated(WindowEvent e15) {
            this.checkForParentWindowEvent(e15);
        }

        @Override
        public void windowLostFocus(WindowEvent e15) {
            if (e15.getSource() == ClipboardHistoryPopup.this) {
                this.uninstallAndHide();
            }
        }

        @Override
        public void windowIconified(WindowEvent e15) {
            this.checkForParentWindowEvent(e15);
        }

        private boolean checkForParentWindowEvent(WindowEvent e15) {
            if (e15.getSource() == ClipboardHistoryPopup.this.getParent()) {
                this.uninstallAndHide();
                return true;
            }
            return false;
        }

        private void uninstallAndHide() {
            Window parent = (Window)ClipboardHistoryPopup.this.getParent();
            parent.removeWindowFocusListener(this);
            parent.removeWindowListener(this);
            parent.removeComponentListener(this);
            ClipboardHistoryPopup.this.removeWindowFocusListener(this);
            ClipboardHistoryPopup.this.setVisible(false);
            ClipboardHistoryPopup.this.dispose();
        }
    }

    private static class LabelValuePair {
        private String label;
        private String value;
        private static final int LABEL_MAX_LENGTH = 50;

        LabelValuePair(String value) {
            this.label = this.value = value;
            int newline = this.label.indexOf(10);
            boolean multiLine = false;
            if (newline > -1) {
                this.label = this.label.substring(0, newline);
                multiLine = true;
            }
            if (this.label.length() > 50) {
                this.label = this.label.substring(0, 50) + "...";
            } else if (multiLine) {
                int toRemove = 3 - (50 - this.label.length());
                if (toRemove > 0) {
                    this.label = this.label.substring(0, this.label.length() - toRemove);
                }
                this.label = this.label + "...";
            }
        }

        public String toString() {
            return this.label;
        }
    }

    private final class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            ClipboardHistoryPopup.this.listener.uninstallAndHide();
        }
    }
}

