/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.FoldingAwareIconRowHeader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldCollapser;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RecordableTextAction;

public class RSyntaxTextAreaEditorKit
extends RTextAreaEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String rstaBacktickAction = "RSTA.BacktickAction";
    public static final String rstaCloseCurlyBraceAction = "RSTA.CloseCurlyBraceAction";
    public static final String rstaCloseMarkupTagAction = "RSTA.CloseMarkupTagAction";
    public static final String rstaCollapseAllFoldsAction = "RSTA.CollapseAllFoldsAction";
    public static final String rstaCollapseAllCommentFoldsAction = "RSTA.CollapseAllCommentFoldsAction";
    public static final String rstaCollapseFoldAction = "RSTA.CollapseFoldAction";
    public static final String rstaCopyAsStyledTextAction = "RSTA.CopyAsStyledTextAction";
    public static final String rstaCutAsStyledTextAction = "RSTA.CutAsStyledTextAction";
    public static final String rstaDecreaseIndentAction = "RSTA.DecreaseIndentAction";
    public static final String rstaDoubleQuoteAction = "RSTA.DoubleQuoteAction";
    public static final String rstaExpandAllFoldsAction = "RSTA.ExpandAllFoldsAction";
    public static final String rstaExpandFoldAction = "RSTA.ExpandFoldAction";
    public static final String rstaGoToMatchingBracketAction = "RSTA.GoToMatchingBracketAction";
    public static final String rstaOpenParenAction = "RSTA.OpenParenAction";
    public static final String rstaOpenSquareBracketAction = "RSTA.OpenSquareBracketAction";
    public static final String rstaOpenCurlyAction = "RSTA.OpenCurlyAction";
    public static final String rstaPossiblyInsertTemplateAction = "RSTA.TemplateAction";
    public static final String rstaSingleQuoteAction = "RSTA.SingleQuoteAction";
    public static final String rstaToggleCommentAction = "RSTA.ToggleCommentAction";
    public static final String rstaToggleCurrentFoldAction = "RSTA.ToggleCurrentFoldAction";
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.RSyntaxTextArea";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.RSyntaxTextArea");
    private static final Action[] defaultActions = new Action[]{new CloseCurlyBraceAction(), new CloseMarkupTagAction(), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new ChangeFoldStateAction("RSTA.CollapseFoldAction", true), new ChangeFoldStateAction("RSTA.ExpandFoldAction", false), new CollapseAllFoldsAction(), new CopyCutAsStyledTextAction(false), new CopyCutAsStyledTextAction(true), new DecreaseIndentAction(), new DeletePrevWordAction(), new DumbCompleteWordAction(), new EndAction("caret-end", false), new EndAction("selection-end", true), new EndWordAction("caret-end-word", false), new EndWordAction("caret-end-word", true), new ExpandAllFoldsAction(), new GoToMatchingBracketAction(), new InsertBreakAction(), new InsertPairedCharacterAction("RSTA.OpenParenAction", '(', ')'), new InsertPairedCharacterAction("RSTA.OpenSquareBracketAction", '[', ']'), new InsertPairedCharacterAction("RSTA.OpenCurlyAction", '{', '}'), new InsertQuoteAction("RSTA.DoubleQuoteAction", InsertQuoteAction.QuoteType.DOUBLE_QUOTE), new InsertQuoteAction("RSTA.SingleQuoteAction", InsertQuoteAction.QuoteType.SINGLE_QUOTE), new InsertQuoteAction("RSTA.BacktickAction", InsertQuoteAction.QuoteType.BACKTICK), new InsertTabAction(), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PossiblyInsertTemplateAction(), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new SelectWordAction(), new ToggleCommentAction()};

    @Override
    public Document createDefaultDocument() {
        return new RSyntaxDocument("text/plain");
    }

    @Override
    public IconRowHeader createIconRowHeader(RTextArea textArea) {
        return new FoldingAwareIconRowHeader((RSyntaxTextArea)textArea);
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static String getString(String key) {
        return msg.getString(key);
    }

    public static class CloseCurlyBraceAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Point bracketInfo;
        private Segment seg = new Segment();

        public CloseCurlyBraceAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            block16: {
                boolean alignCurlyBraces;
                if (!textArea.isEditable() || !textArea.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                    return;
                }
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
                int languageIndex = 0;
                int dot = textArea.getCaretPosition();
                if (dot > 0) {
                    Token t15 = RSyntaxUtilities.getTokenAtOffset(rsta, dot - 1);
                    languageIndex = t15 == null ? 0 : t15.getLanguageIndex();
                }
                boolean bl4 = alignCurlyBraces = rsta.isAutoIndentEnabled() && doc.getCurlyBracesDenoteCodeBlocks(languageIndex);
                if (alignCurlyBraces) {
                    textArea.beginAtomicEdit();
                }
                try {
                    textArea.replaceSelection("}");
                    if (!alignCurlyBraces) break block16;
                    Element root = doc.getDefaultRootElement();
                    dot = rsta.getCaretPosition() - 1;
                    int line = root.getElementIndex(dot);
                    Element elem = root.getElement(line);
                    int start = elem.getStartOffset();
                    try {
                        doc.getText(start, dot - start, this.seg);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                        if (alignCurlyBraces) {
                            textArea.endAtomicEdit();
                        }
                        return;
                    }
                    for (int i15 = 0; i15 < this.seg.count; ++i15) {
                        char ch4 = this.seg.array[this.seg.offset + i15];
                        if (Character.isWhitespace(ch4)) continue;
                        return;
                    }
                    this.bracketInfo = RSyntaxUtilities.getMatchingBracketPosition(rsta, this.bracketInfo);
                    if (this.bracketInfo.y <= -1) break block16;
                    try {
                        String ws4 = RSyntaxUtilities.getLeadingWhitespace(doc, this.bracketInfo.y);
                        rsta.replaceRange(ws4, start, dot);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                        if (alignCurlyBraces) {
                            textArea.endAtomicEdit();
                        }
                        return;
                    }
                }
                finally {
                    if (alignCurlyBraces) {
                        textArea.endAtomicEdit();
                    }
                }
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCloseCurlyBraceAction;
        }
    }

    public static class CloseMarkupTagAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public CloseMarkupTagAction() {
            super(RSyntaxTextAreaEditorKit.rstaCloseMarkupTagAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
            Caret c15 = rsta.getCaret();
            boolean selection = c15.getDot() != c15.getMark();
            rsta.replaceSelection("/");
            int dot = c15.getDot();
            if (doc.getLanguageIsMarkup() && doc.getCompleteMarkupCloseTags() && !selection && rsta.getCloseMarkupTags() && dot > 1) {
                try {
                    char ch4 = doc.charAt(dot - 2);
                    if (ch4 == '<' || ch4 == '[') {
                        String tagName;
                        Token t15 = doc.getTokenListForLine(rsta.getCaretLineNumber());
                        if ((t15 = RSyntaxUtilities.getTokenAtOffset(t15, dot - 1)) != null && t15.getType() == 25 && (tagName = this.discoverTagName(doc, dot)) != null) {
                            rsta.replaceSelection(tagName + (char)(ch4 + 2));
                        }
                    }
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rsta);
                    ble.printStackTrace();
                }
            }
        }

        private String discoverTagName(RSyntaxDocument doc, int dot) {
            Stack<String> stack = new Stack<String>();
            Element root = doc.getDefaultRootElement();
            int curLine = root.getElementIndex(dot);
            for (int i15 = 0; i15 <= curLine; ++i15) {
                Token t15 = doc.getTokenListForLine(i15);
                while (t15 != null && t15.isPaintable()) {
                    if (t15.getType() == 25) {
                        if (t15.isSingleChar('<') || t15.isSingleChar('[')) {
                            for (t15 = t15.getNextToken(); t15 != null && t15.isPaintable(); t15 = t15.getNextToken()) {
                                if (t15.getType() != 26 && t15.getType() != 27) continue;
                                stack.push(t15.getLexeme());
                                break;
                            }
                        } else if (t15.length() == 2 && t15.charAt(0) == '/' && (t15.charAt(1) == '>' || t15.charAt(1) == ']')) {
                            if (!stack.isEmpty()) {
                                stack.pop();
                            }
                        } else if (t15.length() == 2 && (t15.charAt(0) == '<' || t15.charAt(0) == '[') && t15.charAt(1) == '/') {
                            String tagName = null;
                            if (!stack.isEmpty()) {
                                tagName = (String)stack.pop();
                            }
                            if (t15.getEndOffset() >= dot) {
                                return tagName;
                            }
                        }
                    }
                    t15 = t15 == null ? null : t15.getNextToken();
                }
            }
            return null;
        }

        @Override
        public String getMacroID() {
            return this.getName();
        }
    }

    protected static class BeginWordAction
    extends RTextAreaEditorKit.BeginWordAction {
        private Segment seg = new Segment();

        protected BeginWordAction(String name, boolean select) {
            super(name, select);
        }

        @Override
        protected int getWordStart(RTextArea textArea, int offs) throws BadLocationException {
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            int line = textArea.getLineOfOffset(offs);
            int start = textArea.getLineStartOffset(line);
            if (offs == start) {
                return start;
            }
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            doc.getText(start, end - start, this.seg);
            int firstIndex = this.seg.getBeginIndex() + (offs - start) - 1;
            this.seg.setIndex(firstIndex);
            char ch4 = this.seg.current();
            char nextCh = offs == end ? (char)'\u0000' : this.seg.array[this.seg.getIndex() + 1];
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch4)) {
                if (offs != end && !doc.isIdentifierChar(languageIndex, nextCh)) {
                    return offs;
                }
                while (doc.isIdentifierChar(languageIndex, ch4 = this.seg.previous()) && ch4 != '\uffff') {
                }
            } else if (Character.isWhitespace(ch4)) {
                if (offs != end && !Character.isWhitespace(nextCh)) {
                    return offs;
                }
                while (Character.isWhitespace(ch4 = this.seg.previous())) {
                }
            }
            offs -= firstIndex - this.seg.getIndex() + 1;
            if (ch4 != '\uffff' && nextCh != '\n') {
                ++offs;
            }
            return offs;
        }
    }

    public static class ChangeFoldStateAction
    extends FoldRelatedAction {
        private boolean collapse;

        public ChangeFoldStateAction(String name, boolean collapse) {
            super(name);
            this.collapse = collapse;
        }

        public ChangeFoldStateAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (rsta.isCodeFoldingEnabled()) {
                Fold fold = this.getClosestFold(rsta);
                if (fold != null) {
                    fold.setCollapsed(this.collapse);
                }
                RSyntaxUtilities.possiblyRepaintGutter(textArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class CollapseAllFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public CollapseAllFoldsAction() {
            this(false);
        }

        public CollapseAllFoldsAction(boolean localizedName) {
            super(RSyntaxTextAreaEditorKit.rstaCollapseAllFoldsAction);
            if (localizedName) {
                this.setProperties(msg, "Action.CollapseAllFolds");
            }
        }

        public CollapseAllFoldsAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (rsta.isCodeFoldingEnabled()) {
                FoldCollapser collapser = new FoldCollapser(){

                    @Override
                    public boolean getShouldCollapse(Fold fold) {
                        return true;
                    }
                };
                collapser.collapseFolds(rsta.getFoldManager());
                RSyntaxUtilities.possiblyRepaintGutter(textArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCollapseAllFoldsAction;
        }
    }

    public static class CopyCutAsStyledTextAction
    extends RecordableTextAction {
        private Theme theme;
        private boolean cutAction;
        private static final long serialVersionUID = 2L;

        private static String getActionName(boolean cutAction) {
            return cutAction ? RSyntaxTextAreaEditorKit.rstaCutAsStyledTextAction : RSyntaxTextAreaEditorKit.rstaCopyAsStyledTextAction;
        }

        public CopyCutAsStyledTextAction(boolean cutAction) {
            super(CopyCutAsStyledTextAction.getActionName(cutAction));
            this.cutAction = cutAction;
        }

        public CopyCutAsStyledTextAction(String themeName, Theme theme, boolean cutAction) {
            super(CopyCutAsStyledTextAction.getActionName(cutAction) + "_" + themeName);
            this.theme = theme;
            this.cutAction = cutAction;
        }

        public CopyCutAsStyledTextAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            if (!(textArea instanceof RSyntaxTextArea)) {
                this.handleActionPerformedPlainText(textArea);
                return;
            }
            if (!(!this.cutAction || textArea.isEditable() && textArea.isEnabled())) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            ((RSyntaxTextArea)textArea).copyAsStyledText(this.theme);
            if (this.cutAction) {
                int selStart = textArea.getSelectionStart();
                int selEnd = textArea.getSelectionEnd();
                try {
                    textArea.getDocument().remove(selStart, selEnd - selStart);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                }
            }
            textArea.requestFocusInWindow();
        }

        private void handleActionPerformedPlainText(RTextArea textArea) {
            if (this.cutAction) {
                textArea.cut();
            } else {
                textArea.copy();
            }
            textArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class DecreaseIndentAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Segment s = new Segment();

        public DecreaseIndentAction() {
            this(RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction);
        }

        public DecreaseIndentAction(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            Caret c15 = textArea.getCaret();
            int dot = c15.getDot();
            int mark = c15.getMark();
            int line1 = map.getElementIndex(dot);
            int tabSize = textArea.getTabSize();
            if (dot != mark) {
                int line2 = map.getElementIndex(mark);
                dot = Math.min(line1, line2);
                mark = Math.max(line1, line2);
                textArea.beginAtomicEdit();
                try {
                    Element elem;
                    for (line1 = dot; line1 < mark; ++line1) {
                        elem = map.getElement(line1);
                        this.handleDecreaseIndent(elem, document, tabSize);
                    }
                    elem = map.getElement(mark);
                    int start = elem.getStartOffset();
                    if (Math.max(c15.getDot(), c15.getMark()) == start) return;
                    this.handleDecreaseIndent(elem, document, tabSize);
                    return;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                    return;
                }
                finally {
                    textArea.endAtomicEdit();
                }
            }
            Element elem = map.getElement(line1);
            try {
                this.handleDecreaseIndent(elem, document, tabSize);
                return;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaDecreaseIndentAction;
        }

        private void handleDecreaseIndent(Element elem, Document doc, int tabSize) throws BadLocationException {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            doc.getText(start, end - start, this.s);
            int i15 = this.s.offset;
            end = i15 + this.s.count;
            if (end > i15) {
                if (this.s.array[i15] == '\t') {
                    doc.remove(start, 1);
                } else if (this.s.array[i15] == ' ') {
                    int toRemove;
                    ++i15;
                    for (toRemove = 1; i15 < end && this.s.array[i15] == ' ' && toRemove < tabSize; ++i15, ++toRemove) {
                    }
                    doc.remove(start, toRemove);
                }
            }
        }
    }

    public static class DeletePrevWordAction
    extends RTextAreaEditorKit.DeletePrevWordAction {
        private Segment seg = new Segment();

        @Override
        protected int getPreviousWordStart(RTextArea textArea, int offs) throws BadLocationException {
            int languageIndex;
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            int line = textArea.getLineOfOffset(offs);
            int start = textArea.getLineStartOffset(line);
            if (offs == start) {
                return start - 1;
            }
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            doc.getText(start, end - start, this.seg);
            int firstIndex = this.seg.getBeginIndex() + (offs - start) - 1;
            this.seg.setIndex(firstIndex);
            char ch4 = this.seg.current();
            if (Character.isWhitespace(ch4)) {
                while (Character.isWhitespace(ch4 = this.seg.previous())) {
                }
            }
            if (doc.isIdentifierChar(languageIndex = 0, ch4)) {
                while (doc.isIdentifierChar(languageIndex, ch4 = this.seg.previous())) {
                }
            } else {
                while (!Character.isWhitespace(ch4) && !doc.isIdentifierChar(languageIndex, ch4) && ch4 != '\uffff') {
                    ch4 = this.seg.previous();
                }
            }
            if (ch4 == '\uffff') {
                return start;
            }
            return offs -= firstIndex - this.seg.getIndex();
        }
    }

    public static class DumbCompleteWordAction
    extends RTextAreaEditorKit.DumbCompleteWordAction {
        @Override
        protected int getPreviousWord(RTextArea textArea, int offs) throws BadLocationException {
            int line;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element root = doc.getDefaultRootElement();
            Element elem = root.getElement(line = root.getElementIndex(offs));
            int start = elem.getStartOffset();
            if (offs > start) {
                char ch4 = doc.charAt(offs);
                if (DumbCompleteWordAction.isIdentifierChar(ch4)) {
                    --offs;
                }
            } else {
                if (line == 0) {
                    return -1;
                }
                elem = root.getElement(--line);
                offs = elem.getEndOffset() - 1;
            }
            int prevWordStart = this.getPreviousWordStartInLine(doc, elem, offs);
            while (prevWordStart == -1 && line > 0) {
                elem = root.getElement(--line);
                prevWordStart = this.getPreviousWordStartInLine(doc, elem, elem.getEndOffset());
            }
            return prevWordStart;
        }

        private int getPreviousWordStartInLine(RSyntaxDocument doc, Element elem, int offs) throws BadLocationException {
            char ch4;
            int cur;
            int start = elem.getStartOffset();
            for (cur = offs; cur >= start && !DumbCompleteWordAction.isIdentifierChar(ch4 = doc.charAt(cur)); --cur) {
            }
            if (cur < start) {
                return -1;
            }
            return DumbCompleteWordAction.getWordStartImpl(doc, elem, cur);
        }

        @Override
        protected int getWordEnd(RTextArea textArea, int offs) throws BadLocationException {
            int wordEnd;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element root = doc.getDefaultRootElement();
            int line = root.getElementIndex(offs);
            Element elem = root.getElement(line);
            int end = elem.getEndOffset() - 1;
            for (wordEnd = offs; wordEnd <= end && DumbCompleteWordAction.isIdentifierChar(doc.charAt(wordEnd)); ++wordEnd) {
            }
            return wordEnd;
        }

        @Override
        protected int getWordStart(RTextArea textArea, int offs) throws BadLocationException {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element root = doc.getDefaultRootElement();
            int line = root.getElementIndex(offs);
            Element elem = root.getElement(line);
            return DumbCompleteWordAction.getWordStartImpl(doc, elem, offs);
        }

        private static int getWordStartImpl(RSyntaxDocument doc, Element elem, int offs) throws BadLocationException {
            char ch4;
            int wordStart;
            int start = elem.getStartOffset();
            for (wordStart = offs; wordStart >= start && (DumbCompleteWordAction.isIdentifierChar(ch4 = doc.charAt(wordStart)) || ch4 == '\n'); --wordStart) {
            }
            return wordStart == offs ? offs : wordStart + 1;
        }

        @Override
        protected boolean isAcceptablePrefix(String prefix) {
            return !prefix.isEmpty() && DumbCompleteWordAction.isIdentifierChar(prefix.charAt(prefix.length() - 1));
        }

        private static boolean isIdentifierChar(char ch4) {
            return Character.isLetterOrDigit(ch4) || ch4 == '_' || ch4 == '$';
        }
    }

    public static class EndAction
    extends RTextAreaEditorKit.EndAction {
        public EndAction(String name, boolean select) {
            super(name, select);
        }

        @Override
        protected int getVisibleEnd(RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            return rsta.getLastVisibleOffset();
        }
    }

    protected static class EndWordAction
    extends RTextAreaEditorKit.EndWordAction {
        private Segment seg = new Segment();

        protected EndWordAction(String name, boolean select) {
            super(name, select);
        }

        @Override
        protected int getWordEnd(RTextArea textArea, int offs) throws BadLocationException {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (offs == doc.getLength()) {
                return offs;
            }
            int line = textArea.getLineOfOffset(offs);
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            if (offs == end) {
                return end;
            }
            doc.getText(offs, end - offs, this.seg);
            char ch4 = this.seg.first();
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch4)) {
                while (doc.isIdentifierChar(languageIndex, ch4 = this.seg.next()) && ch4 != '\uffff') {
                }
            } else if (Character.isWhitespace(ch4)) {
                while (Character.isWhitespace(ch4 = this.seg.next())) {
                }
            }
            return offs += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class ExpandAllFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public ExpandAllFoldsAction() {
            this(false);
        }

        public ExpandAllFoldsAction(boolean localizedName) {
            super(RSyntaxTextAreaEditorKit.rstaExpandAllFoldsAction);
            if (localizedName) {
                this.setProperties(msg, "Action.ExpandAllFolds");
            }
        }

        public ExpandAllFoldsAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (rsta.isCodeFoldingEnabled()) {
                FoldManager fm4 = rsta.getFoldManager();
                for (int i15 = 0; i15 < fm4.getFoldCount(); ++i15) {
                    this.expand(fm4.getFold(i15));
                }
                RSyntaxUtilities.possiblyRepaintGutter(rsta);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        private void expand(Fold fold) {
            fold.setCollapsed(false);
            for (int i15 = 0; i15 < fold.getChildCount(); ++i15) {
                this.expand(fold.getChild(i15));
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaExpandAllFoldsAction;
        }
    }

    public static class GoToMatchingBracketAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private Point bracketInfo;

        public GoToMatchingBracketAction() {
            super(RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction);
        }

        public GoToMatchingBracketAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            this.bracketInfo = RSyntaxUtilities.getMatchingBracketPosition(rsta, this.bracketInfo);
            if (this.bracketInfo.y > -1) {
                rsta.setCaretPosition(this.bracketInfo.y + 1);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaGoToMatchingBracketAction;
        }
    }

    public static class InsertBreakAction
    extends RTextAreaEditorKit.InsertBreakAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea sta = (RSyntaxTextArea)textArea;
            boolean noSelection = sta.getSelectionStart() == sta.getSelectionEnd();
            boolean handled = false;
            if (noSelection) {
                RSyntaxDocument doc = (RSyntaxDocument)sta.getDocument();
                handled = doc.insertBreakSpecialHandling(e15);
            }
            if (!handled) {
                this.handleInsertBreak(sta, noSelection);
            }
        }

        private static int atEndOfLine(int pos, String s15, int sLen) {
            for (int i15 = pos; i15 < sLen; ++i15) {
                if (RSyntaxUtilities.isWhitespace(s15.charAt(i15))) continue;
                return i15;
            }
            return -1;
        }

        private static int getOpenBraceCount(RSyntaxDocument doc, int languageIndex) {
            int openCount = 0;
            for (Token t15 : doc) {
                if (t15.getType() != 22 || t15.length() != 1 || t15.getLanguageIndex() != languageIndex) continue;
                char ch4 = t15.charAt(0);
                if (ch4 == '{') {
                    ++openCount;
                    continue;
                }
                if (ch4 != '}') continue;
                --openCount;
            }
            return openCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleInsertBreak(RSyntaxTextArea textArea, boolean noSelection) {
            if (noSelection) {
                textArea.beginAtomicEdit();
                try {
                    this.handleInsertBreakWithoutSelection(textArea);
                }
                catch (BadLocationException ble) {
                    textArea.replaceSelection("\n");
                    ble.printStackTrace();
                }
                finally {
                    textArea.endAtomicEdit();
                }
            } else {
                textArea.replaceSelection("\n");
            }
        }

        private void handleInsertBreakWithoutSelection(RSyntaxTextArea textArea) throws BadLocationException {
            int nonWhitespacePos;
            int caretPos = textArea.getCaretPosition();
            Document doc = textArea.getDocument();
            Element map = doc.getDefaultRootElement();
            int lineNum = map.getElementIndex(caretPos);
            Element line = map.getElement(lineNum);
            int start = line.getStartOffset();
            int end = line.getEndOffset() - 1;
            int len = end - start;
            String s15 = doc.getText(start, len);
            int caretOffsInLine = caretPos - start;
            StringBuilder sb5 = new StringBuilder("\n");
            String leadingWS = null;
            if (textArea.isAutoIndentEnabled()) {
                leadingWS = RSyntaxUtilities.getLeadingWhitespace(s15, caretOffsInLine);
                sb5.append(leadingWS);
            }
            if (textArea.isClearWhitespaceLinesEnabled() && InsertBreakAction.isAllWhitespace(s15, 0, caretOffsInLine)) {
                textArea.setCaretPosition(start);
            }
            textArea.moveCaretPosition((nonWhitespacePos = InsertBreakAction.atEndOfLine(caretPos - start, s15, len)) > -1 ? start + nonWhitespacePos : end);
            textArea.replaceSelection(sb5.toString());
            if (textArea.getShouldIndentNextLine(lineNum)) {
                textArea.replaceSelection("\t");
            }
            this.possiblyCloseCurlyBrace(textArea, leadingWS);
        }

        private static boolean isAllWhitespace(String str, int from, int to4) {
            for (int i15 = from; i15 < to4; ++i15) {
                if (Character.isWhitespace(str.charAt(i15))) continue;
                return false;
            }
            return true;
        }

        private void possiblyCloseCurlyBrace(RSyntaxTextArea textArea, String leadingWS) {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (textArea.getCloseCurlyBraces()) {
                int languageIndex;
                int line = textArea.getCaretLineNumber();
                Token t15 = doc.getTokenListForLine(line - 1);
                if ((t15 = t15.getLastNonCommentNonWhitespaceToken()) != null && t15.isLeftCurly() && doc.getCurlyBracesDenoteCodeBlocks(languageIndex = t15.getLanguageIndex()) && InsertBreakAction.getOpenBraceCount(doc, languageIndex) > 0) {
                    StringBuilder sb5 = new StringBuilder();
                    if (line == textArea.getLineCount() - 1) {
                        sb5.append('\n');
                    }
                    if (leadingWS != null) {
                        sb5.append(leadingWS);
                    }
                    sb5.append("}\n");
                    int dot = textArea.getCaretPosition();
                    int end = textArea.getLineEndOffsetOfCurrentLine();
                    textArea.insert(sb5.toString(), end);
                    textArea.setCaretPosition(dot);
                }
            }
        }
    }

    public static class InsertPairedCharacterAction
    extends RTextAreaEditorKit.DefaultKeyTypedAction {
        private static final long serialVersionUID = 1L;
        private final char ch;
        private final char pairedCh;

        public InsertPairedCharacterAction(String actionName, char ch4, char pairedCh) {
            super(actionName);
            this.ch = ch4;
            this.pairedCh = pairedCh;
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            boolean noSelection;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea sta = (RSyntaxTextArea)textArea;
            boolean bl4 = noSelection = sta.getSelectionStart() == sta.getSelectionEnd();
            if (noSelection || !sta.getInsertPairedCharacters()) {
                super.actionPerformedImpl(e15, textArea);
            } else {
                this.wrapSelection(textArea);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrapSelection(RTextArea textArea) {
            int selStart = textArea.getSelectionStart();
            int selEnd = textArea.getSelectionEnd();
            textArea.beginAtomicEdit();
            try {
                textArea.insert(String.valueOf(this.ch), selStart);
                textArea.insert(String.valueOf(this.pairedCh), selEnd + 1);
                textArea.setSelectionEnd(selEnd + 1);
            }
            finally {
                textArea.endAtomicEdit();
            }
        }
    }

    public static class InsertQuoteAction
    extends InsertPairedCharacterAction {
        private final QuoteType quoteType;
        private final String stringifiedQuoteTypeCh;

        public InsertQuoteAction(String actionName, QuoteType quoteType) {
            super(actionName, quoteType.ch, quoteType.ch);
            this.quoteType = quoteType;
            this.stringifiedQuoteTypeCh = String.valueOf(quoteType.ch);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            boolean isComment;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (!rsta.getInsertPairedCharacters() || textArea.getSelectionStart() != textArea.getSelectionEnd() || textArea.getTextMode() == 1) {
                super.actionPerformedImpl(e15, textArea);
                return;
            }
            int offs = rsta.getCaretPosition();
            Token t15 = RSyntaxUtilities.getTokenAtOffsetOrLastTokenIfEndOfLine(rsta, offs);
            int tokenType = t15 != null ? t15.getType() : 0;
            boolean bl4 = isComment = t15 != null && t15.isComment();
            if (tokenType == this.quoteType.validTokenType) {
                if (t15 != null && offs == t15.getEndOffset() - 1 && t15.endsWith(this.quoteType.ch)) {
                    textArea.moveCaretPosition(offs + 1);
                    textArea.replaceSelection(this.stringifiedQuoteTypeCh);
                    textArea.setCaretPosition(offs + 1);
                } else {
                    super.actionPerformedImpl(e15, textArea);
                }
            } else if (isComment || tokenType == this.quoteType.invalidTokenType) {
                super.actionPerformedImpl(e15, textArea);
            } else {
                this.insertEmptyQuoteLiteral(rsta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertEmptyQuoteLiteral(RSyntaxTextArea textArea) {
            textArea.beginAtomicEdit();
            try {
                int tokenType;
                textArea.replaceSelection(this.stringifiedQuoteTypeCh);
                int caretPos = textArea.getCaretPosition();
                Token t15 = RSyntaxUtilities.getTokenAtOffsetOrLastTokenIfEndOfLine(textArea, caretPos);
                int n15 = tokenType = t15 != null ? t15.getType() : 0;
                if (tokenType == this.quoteType.validTokenType || tokenType == this.quoteType.invalidTokenType) {
                    textArea.replaceSelection(this.stringifiedQuoteTypeCh);
                    textArea.setCaretPosition(textArea.getCaretPosition() - 1);
                }
            }
            finally {
                textArea.endAtomicEdit();
            }
        }

        public static enum QuoteType {
            DOUBLE_QUOTE('\"', 13, 37),
            SINGLE_QUOTE('\'', 14, 38),
            BACKTICK('`', 15, -1);

            private final char ch;
            private final int validTokenType;
            private final int invalidTokenType;

            private QuoteType(char ch4, int validTokenType, int invalidTokenType) {
                this.ch = ch4;
                this.validTokenType = validTokenType;
                this.invalidTokenType = invalidTokenType;
            }
        }
    }

    public static class InsertTabAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public InsertTabAction() {
            super("insert-tab");
        }

        public InsertTabAction(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            int mark;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            Caret c15 = textArea.getCaret();
            int dot = c15.getDot();
            if (dot != (mark = c15.getMark())) {
                int dotLine = map.getElementIndex(dot);
                int markLine = map.getElementIndex(mark);
                int first = Math.min(dotLine, markLine);
                int last = Math.max(dotLine, markLine);
                String replacement = "\t";
                if (textArea.getTabsEmulated()) {
                    StringBuilder sb5 = new StringBuilder();
                    int temp = textArea.getTabSize();
                    for (int i15 = 0; i15 < temp; ++i15) {
                        sb5.append(' ');
                    }
                    replacement = sb5.toString();
                }
                textArea.beginAtomicEdit();
                try {
                    int start;
                    Element elem;
                    for (int i16 = first; i16 < last; ++i16) {
                        elem = map.getElement(i16);
                        start = elem.getStartOffset();
                        document.insertString(start, replacement, null);
                    }
                    elem = map.getElement(last);
                    start = elem.getStartOffset();
                    if (Math.max(c15.getDot(), c15.getMark()) == start) return;
                    document.insertString(start, replacement, null);
                    return;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                    return;
                }
                finally {
                    textArea.endAtomicEdit();
                }
            } else {
                textArea.replaceSelection("\t");
            }
        }

        @Override
        public final String getMacroID() {
            return "insert-tab";
        }
    }

    public static class NextWordAction
    extends RTextAreaEditorKit.NextWordAction {
        private Segment seg = new Segment();

        public NextWordAction(String nm4, boolean select) {
            super(nm4, select);
        }

        @Override
        protected int getNextWord(RTextArea textArea, int offs) throws BadLocationException {
            int line;
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (offs == doc.getLength()) {
                return offs;
            }
            Element root = doc.getDefaultRootElement();
            int end = root.getElement(line = root.getElementIndex(offs)).getEndOffset() - 1;
            if (offs == end) {
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                if (rsta.isCodeFoldingEnabled()) {
                    FoldManager fm4 = rsta.getFoldManager();
                    int lineCount = root.getElementCount();
                    while (++line < lineCount && fm4.isLineHidden(line)) {
                    }
                    if (line < lineCount) {
                        offs = root.getElement(line).getStartOffset();
                    }
                    return offs;
                }
                return offs + 1;
            }
            doc.getText(offs, end - offs, this.seg);
            char ch4 = this.seg.first();
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch4)) {
                while (doc.isIdentifierChar(languageIndex, ch4 = this.seg.next()) && ch4 != '\uffff') {
                }
            } else if (!Character.isWhitespace(ch4)) {
                while ((ch4 = this.seg.next()) != '\uffff' && !doc.isIdentifierChar(languageIndex, ch4) && !Character.isWhitespace(ch4)) {
                }
            }
            while (Character.isWhitespace(ch4)) {
                ch4 = this.seg.next();
            }
            return offs += this.seg.getIndex() - this.seg.getBeginIndex();
        }
    }

    public static class PossiblyInsertTemplateAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        public PossiblyInsertTemplateAction() {
            super(RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            block6: {
                if (!textArea.isEditable() || !textArea.isEnabled()) {
                    return;
                }
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                if (RSyntaxTextArea.getTemplatesEnabled()) {
                    try {
                        CodeTemplate template;
                        CodeTemplateManager manager = RSyntaxTextArea.getCodeTemplateManager();
                        CodeTemplate codeTemplate = template = manager == null ? null : manager.getTemplate(rsta);
                        if (template != null) {
                            template.invoke(rsta);
                            break block6;
                        }
                        this.doDefaultInsert(rsta);
                    }
                    catch (BadLocationException ble) {
                        UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                    }
                } else {
                    this.doDefaultInsert(rsta);
                }
            }
        }

        private void doDefaultInsert(RTextArea textArea) {
            textArea.replaceSelection(" ");
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaPossiblyInsertTemplateAction;
        }
    }

    public static class PreviousWordAction
    extends RTextAreaEditorKit.PreviousWordAction {
        private Segment seg = new Segment();

        public PreviousWordAction(String nm4, boolean select) {
            super(nm4, select);
        }

        @Override
        protected int getPreviousWord(RTextArea textArea, int offs) throws BadLocationException {
            int line;
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element root = doc.getDefaultRootElement();
            int start = root.getElement(line = root.getElementIndex(offs)).getStartOffset();
            if (offs == start) {
                RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
                if (rsta.isCodeFoldingEnabled()) {
                    FoldManager fm4 = rsta.getFoldManager();
                    while (--line >= 0 && fm4.isLineHidden(line)) {
                    }
                    if (line >= 0) {
                        offs = root.getElement(line).getEndOffset() - 1;
                    }
                    return offs;
                }
                return start - 1;
            }
            doc.getText(start, offs - start, this.seg);
            char ch4 = this.seg.last();
            while (Character.isWhitespace(ch4)) {
                ch4 = this.seg.previous();
            }
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch4)) {
                while (doc.isIdentifierChar(languageIndex, ch4 = this.seg.previous()) && ch4 != '\uffff') {
                }
            } else if (!Character.isWhitespace(ch4)) {
                while ((ch4 = this.seg.previous()) != '\uffff' && !doc.isIdentifierChar(languageIndex, ch4) && !Character.isWhitespace(ch4)) {
                }
            }
            offs -= this.seg.getEndIndex() - this.seg.getIndex();
            if (ch4 != '\uffff') {
                ++offs;
            }
            return offs;
        }
    }

    public static class SelectWordAction
    extends RTextAreaEditorKit.SelectWordAction {
        @Override
        protected void createActions() {
            this.start = new BeginWordAction("pigdog", false);
            this.end = new EndWordAction("pigdog", true);
        }
    }

    public static class ToggleCommentAction
    extends RecordableTextAction {
        public ToggleCommentAction() {
            super(RSyntaxTextAreaEditorKit.rstaToggleCommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element map = doc.getDefaultRootElement();
            Caret c15 = textArea.getCaret();
            int dot = c15.getDot();
            int mark = c15.getMark();
            int line1 = map.getElementIndex(dot);
            int line2 = map.getElementIndex(mark);
            int start = Math.min(line1, line2);
            int end = Math.max(line1, line2);
            Token t15 = doc.getTokenListForLine(start);
            int languageIndex = t15 != null ? t15.getLanguageIndex() : 0;
            String[] startEnd = doc.getLineCommentStartAndEnd(languageIndex);
            if (startEnd == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            if (start != end) {
                Element elem = map.getElement(end);
                if (Math.max(dot, mark) == elem.getStartOffset()) {
                    --end;
                }
            }
            textArea.beginAtomicEdit();
            try {
                boolean add = this.getDoAdd(doc, map, start, end, startEnd);
                for (line1 = start; line1 <= end; ++line1) {
                    Element elem = map.getElement(line1);
                    this.handleToggleComment(elem, doc, startEnd, add);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
            }
            finally {
                textArea.endAtomicEdit();
            }
        }

        private boolean getDoAdd(Document doc, Element map, int startLine, int endLine, String[] startEnd) throws BadLocationException {
            boolean doAdd = false;
            for (int i15 = startLine; i15 <= endLine; ++i15) {
                Element elem = map.getElement(i15);
                int start = elem.getStartOffset();
                String t15 = doc.getText(start, elem.getEndOffset() - start - 1).trim();
                if (t15.startsWith(startEnd[0]) && (startEnd[1] == null || t15.endsWith(startEnd[1]))) continue;
                doAdd = true;
                break;
            }
            return doAdd;
        }

        private void handleToggleComment(Element elem, Document doc, String[] startEnd, boolean add) throws BadLocationException {
            if (add) {
                this.handleAddLineCommentToLine(elem, doc, startEnd);
            } else {
                this.handleRemoveLineCommentFromLine(elem, doc, startEnd);
            }
        }

        private void handleAddLineCommentToLine(Element elem, Document doc, String[] startEnd) throws BadLocationException {
            if (startEnd[1] != null) {
                int end = elem.getEndOffset() - 1;
                doc.insertString(end, startEnd[1], null);
            }
            int start = elem.getStartOffset();
            doc.insertString(start, startEnd[0], null);
        }

        private void handleRemoveLineCommentFromLine(Element elem, Document doc, String[] startEnd) throws BadLocationException {
            int startMarkerOffs;
            int endMarkerOffs;
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            String text = doc.getText(start, end - start + 1);
            if (startEnd[1] != null && (endMarkerOffs = text.lastIndexOf(startEnd[1])) > 0) {
                doc.remove(start + endMarkerOffs, startEnd[1].length());
            }
            if ((startMarkerOffs = text.indexOf(startEnd[0])) >= 0) {
                doc.remove(start + startMarkerOffs, startEnd[0].length());
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaToggleCommentAction;
        }
    }

    public static class ToggleCurrentFoldAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public ToggleCurrentFoldAction() {
            super(RSyntaxTextAreaEditorKit.rstaToggleCurrentFoldAction);
            this.setProperties(msg, "Action.ToggleCurrentFold");
        }

        public ToggleCurrentFoldAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (rsta.isCodeFoldingEnabled()) {
                Fold fold = this.getClosestFold(rsta);
                if (fold != null) {
                    fold.toggleCollapsedState();
                }
                RSyntaxUtilities.possiblyRepaintGutter(textArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaToggleCurrentFoldAction;
        }
    }

    public static class IncreaseFontSizeAction
    extends RTextAreaEditorKit.IncreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public IncreaseFontSizeAction() {
        }

        public IncreaseFontSizeAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            SyntaxScheme scheme = rsta.getSyntaxScheme();
            boolean changed = false;
            int count = scheme.getStyleCount();
            for (int i15 = 0; i15 < count; ++i15) {
                Font font;
                Style ss4 = scheme.getStyle(i15);
                if (ss4 == null || (font = ss4.font) == null) continue;
                float oldSize = font.getSize2D();
                float newSize = oldSize + this.increaseAmount;
                if (newSize <= 40.0f) {
                    ss4.font = font.deriveFont(newSize);
                    changed = true;
                    continue;
                }
                if (!(oldSize < 40.0f)) continue;
                ss4.font = font.deriveFont(40.0f);
                changed = true;
            }
            Font font = rsta.getFont();
            float oldSize = font.getSize2D();
            float newSize = oldSize + this.increaseAmount;
            if (newSize <= 40.0f) {
                rsta.setFont(font.deriveFont(newSize));
                changed = true;
            } else if (oldSize < 40.0f) {
                rsta.setFont(font.deriveFont(40.0f));
                changed = true;
            }
            if (changed) {
                rsta.setSyntaxScheme(scheme);
                Container parent = rsta.getParent();
                if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
                    parent.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }
    }

    static abstract class FoldRelatedAction
    extends RecordableTextAction {
        FoldRelatedAction(String name) {
            super(name);
        }

        FoldRelatedAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        protected Fold getClosestFold(RSyntaxTextArea textArea) {
            int offs = textArea.getCaretPosition();
            int line = textArea.getCaretLineNumber();
            FoldManager fm4 = textArea.getFoldManager();
            Fold fold = fm4.getFoldForLine(line);
            if (fold == null) {
                fold = fm4.getDeepestOpenFoldContaining(offs);
            }
            return fold;
        }
    }

    public static class DecreaseFontSizeAction
    extends RTextAreaEditorKit.DecreaseFontSizeAction {
        private static final long serialVersionUID = 1L;

        public DecreaseFontSizeAction() {
        }

        public DecreaseFontSizeAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            SyntaxScheme scheme = rsta.getSyntaxScheme();
            boolean changed = false;
            int count = scheme.getStyleCount();
            for (int i15 = 0; i15 < count; ++i15) {
                Font font;
                Style ss4 = scheme.getStyle(i15);
                if (ss4 == null || (font = ss4.font) == null) continue;
                float oldSize = font.getSize2D();
                float newSize = oldSize - this.decreaseAmount;
                if (newSize >= 2.0f) {
                    ss4.font = font.deriveFont(newSize);
                    changed = true;
                    continue;
                }
                if (!(oldSize > 2.0f)) continue;
                ss4.font = font.deriveFont(2.0f);
                changed = true;
            }
            Font font = rsta.getFont();
            float oldSize = font.getSize2D();
            float newSize = oldSize - this.decreaseAmount;
            if (newSize >= 2.0f) {
                rsta.setFont(font.deriveFont(newSize));
                changed = true;
            } else if (oldSize > 2.0f) {
                rsta.setFont(font.deriveFont(2.0f));
                changed = true;
            }
            if (changed) {
                rsta.setSyntaxScheme(scheme);
                Container parent = rsta.getParent();
                if (parent instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane) {
                    parent.repaint();
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }
    }

    public static class CollapseAllCommentFoldsAction
    extends FoldRelatedAction {
        private static final long serialVersionUID = 1L;

        public CollapseAllCommentFoldsAction() {
            super(RSyntaxTextAreaEditorKit.rstaCollapseAllCommentFoldsAction);
            this.setProperties(msg, "Action.CollapseCommentFolds");
        }

        public CollapseAllCommentFoldsAction(String name, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator) {
            super(name, icon, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            RSyntaxTextArea rsta = (RSyntaxTextArea)textArea;
            if (rsta.isCodeFoldingEnabled()) {
                FoldCollapser collapser = new FoldCollapser();
                collapser.collapseFolds(rsta.getFoldManager());
                RSyntaxUtilities.possiblyRepaintGutter(textArea);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rsta);
            }
        }

        @Override
        public final String getMacroID() {
            return RSyntaxTextAreaEditorKit.rstaCollapseAllCommentFoldsAction;
        }
    }
}

