/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class DefaultOccurrenceMarker
implements OccurrenceMarker {
    DefaultOccurrenceMarker() {
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        Caret c15;
        int dot;
        int line = textArea.getCaretLineNumber();
        Token tokenList = textArea.getTokenListForLine(line);
        Token t15 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot = (c15 = textArea.getCaret()).getDot());
        if (t15 == null || !this.isValidType(textArea, t15) || RSyntaxUtilities.isNonWordChar(t15)) {
            --dot;
            t15 = null;
            try {
                if (dot >= textArea.getLineStartOffset(line) && (t15 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot)) != null && RSyntaxUtilities.isNonWordChar(t15)) {
                    t15 = null;
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return t15;
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t15) {
        return textArea.getMarkOccurrencesOfTokenType(t15.getType());
    }

    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t15, RSyntaxTextAreaHighlighter h15, SmartHighlightPainter p15) {
        DefaultOccurrenceMarker.markOccurrencesOfToken(doc, t15, h15, p15);
    }

    public static void markOccurrencesOfToken(RSyntaxDocument doc, Token t15, RSyntaxTextAreaHighlighter h15, SmartHighlightPainter p15) {
        char[] lexeme = t15.getLexeme().toCharArray();
        int type = t15.getType();
        int lineCount = doc.getDefaultRootElement().getElementCount();
        for (int i15 = 0; i15 < lineCount; ++i15) {
            for (Token temp = doc.getTokenListForLine(i15); temp != null && temp.isPaintable(); temp = temp.getNextToken()) {
                if (!temp.is(type, lexeme)) continue;
                try {
                    int end = temp.getEndOffset();
                    h15.addMarkedOccurrenceHighlight(temp.getOffset(), end, p15);
                    continue;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }
}

