/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class OutlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Color color;

    OutlineHighlightPainter(Color color) {
        super(color);
        this.color = color != null ? color : Color.BLACK;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape paintLayer(Graphics g15, int p05, int p15, Shape viewBounds, JTextComponent c15, View view) {
        g15.setColor(this.getColor());
        if (++p05 == p15) {
            try {
                Shape s15 = view.modelToView(p05, viewBounds, Position.Bias.Forward);
                Rectangle r15 = s15.getBounds();
                g15.drawLine(r15.x, r15.y, r15.x, r15.y + r15.height);
                return r15;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p05 == view.getStartOffset() && p15 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g15.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height - 1);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p05, Position.Bias.Forward, p15, Position.Bias.Backward, viewBounds);
            Rectangle r16 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g15.drawRect(r16.x, r16.y, r16.width - 1, r16.height - 1);
            return r16;
        }
        catch (BadLocationException e15) {
            e15.printStackTrace();
            return null;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.color = color;
    }
}

