/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.LevenshteinResults;
import org.apache.commons.text.similarity.SimilarityInput;

public class LevenshteinDetailedDistance
implements EditDistance<LevenshteinResults> {
    private static final LevenshteinDetailedDistance INSTANCE = new LevenshteinDetailedDistance();
    private final Integer threshold;

    private static <E> LevenshteinResults findDetailedResults(SimilarityInput<E> left, SimilarityInput<E> right, int[][] matrix, boolean swapped) {
        int delCount = 0;
        int addCount = 0;
        int subCount = 0;
        int rowIndex = right.length();
        int columnIndex = left.length();
        int dataAtLeft = 0;
        int dataAtTop = 0;
        int dataAtDiagonal = 0;
        int data = 0;
        boolean deleted = false;
        boolean added = false;
        while (rowIndex >= 0 && columnIndex >= 0) {
            dataAtLeft = columnIndex == 0 ? -1 : matrix[rowIndex][columnIndex - 1];
            dataAtTop = rowIndex == 0 ? -1 : matrix[rowIndex - 1][columnIndex];
            dataAtDiagonal = rowIndex > 0 && columnIndex > 0 ? matrix[rowIndex - 1][columnIndex - 1] : -1;
            if (dataAtLeft == -1 && dataAtTop == -1 && dataAtDiagonal == -1) break;
            data = matrix[rowIndex][columnIndex];
            if (columnIndex > 0 && rowIndex > 0 && left.at(columnIndex - 1).equals(right.at(rowIndex - 1))) {
                --columnIndex;
                --rowIndex;
                continue;
            }
            deleted = false;
            added = false;
            if (data - 1 == dataAtLeft && data <= dataAtDiagonal && data <= dataAtTop || dataAtDiagonal == -1 && dataAtTop == -1) {
                --columnIndex;
                if (swapped) {
                    ++addCount;
                    added = true;
                } else {
                    ++delCount;
                    deleted = true;
                }
            } else if (data - 1 == dataAtTop && data <= dataAtDiagonal && data <= dataAtLeft || dataAtDiagonal == -1 && dataAtLeft == -1) {
                --rowIndex;
                if (swapped) {
                    ++delCount;
                    deleted = true;
                } else {
                    ++addCount;
                    added = true;
                }
            }
            if (added || deleted) continue;
            ++subCount;
            --columnIndex;
            --rowIndex;
        }
        return new LevenshteinResults(addCount + delCount + subCount, addCount, delCount, subCount);
    }

    public static LevenshteinDetailedDistance getDefaultInstance() {
        return INSTANCE;
    }

    private static <E> LevenshteinResults limitedCompare(SimilarityInput<E> left, SimilarityInput<E> right, int threshold) {
        int index;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n15 = left.length();
        int m15 = right.length();
        if (n15 == 0) {
            return m15 <= threshold ? new LevenshteinResults(m15, m15, 0, 0) : new LevenshteinResults(-1, 0, 0, 0);
        }
        if (m15 == 0) {
            return n15 <= threshold ? new LevenshteinResults(n15, 0, n15, 0) : new LevenshteinResults(-1, 0, 0, 0);
        }
        boolean swapped = false;
        if (n15 > m15) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n15 = m15;
            m15 = right.length();
            swapped = true;
        }
        int[] p15 = new int[n15 + 1];
        int[] d15 = new int[n15 + 1];
        int[][] matrix = new int[m15 + 1][n15 + 1];
        for (index = 0; index <= n15; ++index) {
            matrix[0][index] = index;
        }
        for (index = 0; index <= m15; ++index) {
            matrix[index][0] = index;
        }
        int boundary = Math.min(n15, threshold) + 1;
        for (int i15 = 0; i15 < boundary; ++i15) {
            p15[i15] = i15;
        }
        Arrays.fill(p15, boundary, p15.length, Integer.MAX_VALUE);
        Arrays.fill(d15, Integer.MAX_VALUE);
        for (int j15 = 1; j15 <= m15; ++j15) {
            int max;
            E rightJ = right.at(j15 - 1);
            d15[0] = j15;
            int min = Math.max(1, j15 - threshold);
            int n16 = max = j15 > Integer.MAX_VALUE - threshold ? n15 : Math.min(n15, j15 + threshold);
            if (min > max) {
                return new LevenshteinResults(-1, 0, 0, 0);
            }
            if (min > 1) {
                d15[min - 1] = Integer.MAX_VALUE;
            }
            for (int i16 = min; i16 <= max; ++i16) {
                d15[i16] = left.at(i16 - 1).equals(rightJ) ? p15[i16 - 1] : 1 + Math.min(Math.min(d15[i16 - 1], p15[i16]), p15[i16 - 1]);
                matrix[j15][i16] = d15[i16];
            }
            int[] tempD = p15;
            p15 = d15;
            d15 = tempD;
        }
        if (p15[n15] <= threshold) {
            return LevenshteinDetailedDistance.findDetailedResults(left, right, matrix, swapped);
        }
        return new LevenshteinResults(-1, 0, 0, 0);
    }

    private static <E> LevenshteinResults unlimitedCompare(SimilarityInput<E> left, SimilarityInput<E> right) {
        int i15;
        int index;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n15 = left.length();
        int m15 = right.length();
        if (n15 == 0) {
            return new LevenshteinResults(m15, m15, 0, 0);
        }
        if (m15 == 0) {
            return new LevenshteinResults(n15, 0, n15, 0);
        }
        boolean swapped = false;
        if (n15 > m15) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n15 = m15;
            m15 = right.length();
            swapped = true;
        }
        int[] p15 = new int[n15 + 1];
        int[] d15 = new int[n15 + 1];
        int[][] matrix = new int[m15 + 1][n15 + 1];
        for (index = 0; index <= n15; ++index) {
            matrix[0][index] = index;
        }
        for (index = 0; index <= m15; ++index) {
            matrix[index][0] = index;
        }
        for (i15 = 0; i15 <= n15; ++i15) {
            p15[i15] = i15;
        }
        for (int j15 = 1; j15 <= m15; ++j15) {
            E rightJ = right.at(j15 - 1);
            d15[0] = j15;
            for (i15 = 1; i15 <= n15; ++i15) {
                int cost = left.at(i15 - 1).equals(rightJ) ? 0 : 1;
                d15[i15] = Math.min(Math.min(d15[i15 - 1] + 1, p15[i15] + 1), p15[i15 - 1] + cost);
                matrix[j15][i15] = d15[i15];
            }
            int[] tempD = p15;
            p15 = d15;
            d15 = tempD;
        }
        return LevenshteinDetailedDistance.findDetailedResults(left, right, matrix, swapped);
    }

    @Deprecated
    public LevenshteinDetailedDistance() {
        this(null);
    }

    public LevenshteinDetailedDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public LevenshteinResults apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> LevenshteinResults apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (this.threshold != null) {
            return LevenshteinDetailedDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDetailedDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

