/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.UncheckedException;

public class AnnotationUtils {
    private static final ToStringStyle TO_STRING_STYLE = new ToStringStyle(){
        private static final long serialVersionUID = 1L;
        {
            this.setDefaultFullDetail(true);
            this.setArrayContentDetail(true);
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart("(");
            this.setContentEnd(")");
            this.setFieldSeparator(", ");
            this.setArrayStart("[");
            this.setArrayEnd("]");
        }

        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value instanceof Annotation) {
                value = AnnotationUtils.toString((Annotation)value);
            }
            super.appendDetail(buffer, fieldName, value);
        }

        @Override
        protected String getShortClassName(Class<?> cls) {
            return ClassUtils.getAllInterfaces(cls).stream().filter(Annotation.class::isAssignableFrom).findFirst().map(iface -> "@" + iface.getName()).orElse("");
        }
    };

    private static boolean annotationArrayMemberEquals(Annotation[] a15, Annotation[] a25) {
        if (a15.length != a25.length) {
            return false;
        }
        for (int i15 = 0; i15 < a15.length; ++i15) {
            if (AnnotationUtils.equals(a15[i15], a25[i15])) continue;
            return false;
        }
        return true;
    }

    private static boolean arrayMemberEquals(Class<?> componentType, Object o15, Object o25) {
        if (componentType.isAnnotation()) {
            return AnnotationUtils.annotationArrayMemberEquals((Annotation[])o15, (Annotation[])o25);
        }
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])o15, (byte[])o25);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.equals((short[])o15, (short[])o25);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.equals((int[])o15, (int[])o25);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.equals((char[])o15, (char[])o25);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.equals((long[])o15, (long[])o25);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.equals((float[])o15, (float[])o25);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.equals((double[])o15, (double[])o25);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])o15, (boolean[])o25);
        }
        return Arrays.equals((Object[])o15, (Object[])o25);
    }

    private static int arrayMemberHash(Class<?> componentType, Object o15) {
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])o15);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])o15);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])o15);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])o15);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])o15);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])o15);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])o15);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])o15);
        }
        return Arrays.hashCode((Object[])o15);
    }

    public static boolean equals(Annotation a15, Annotation a25) {
        if (a15 == a25) {
            return true;
        }
        if (a15 == null || a25 == null) {
            return false;
        }
        Class<? extends Annotation> type1 = a15.annotationType();
        Class<? extends Annotation> type2 = a25.annotationType();
        Validate.notNull(type1, "Annotation %s with null annotationType()", a15);
        Validate.notNull(type2, "Annotation %s with null annotationType()", a25);
        if (!type1.equals(type2)) {
            return false;
        }
        try {
            for (Method m15 : type1.getDeclaredMethods()) {
                if (m15.getParameterTypes().length != 0 || !AnnotationUtils.isValidAnnotationMemberType(m15.getReturnType())) continue;
                Object v15 = m15.invoke((Object)a15, new Object[0]);
                Object v25 = m15.invoke((Object)a25, new Object[0]);
                if (AnnotationUtils.memberEquals(m15.getReturnType(), v15, v25)) continue;
                return false;
            }
        }
        catch (ReflectiveOperationException ex4) {
            return false;
        }
        return true;
    }

    public static int hashCode(Annotation a15) {
        int result = 0;
        Class<? extends Annotation> type = a15.annotationType();
        for (Method m15 : type.getDeclaredMethods()) {
            try {
                Object value = m15.invoke((Object)a15, new Object[0]);
                if (value == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", m15));
                }
                result += AnnotationUtils.hashMember(m15.getName(), value);
            }
            catch (ReflectiveOperationException ex4) {
                throw new UncheckedException(ex4);
            }
        }
        return result;
    }

    private static int hashMember(String name, Object value) {
        int part1 = name.hashCode() * 127;
        if (ObjectUtils.isArray(value)) {
            return part1 ^ AnnotationUtils.arrayMemberHash(value.getClass().getComponentType(), value);
        }
        if (value instanceof Annotation) {
            return part1 ^ AnnotationUtils.hashCode((Annotation)value);
        }
        return part1 ^ value.hashCode();
    }

    public static boolean isValidAnnotationMemberType(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return type.isPrimitive() || type.isEnum() || type.isAnnotation() || String.class.equals(type) || Class.class.equals(type);
    }

    private static boolean memberEquals(Class<?> type, Object o15, Object o25) {
        if (o15 == o25) {
            return true;
        }
        if (o15 == null || o25 == null) {
            return false;
        }
        if (type.isArray()) {
            return AnnotationUtils.arrayMemberEquals(type.getComponentType(), o15, o25);
        }
        if (type.isAnnotation()) {
            return AnnotationUtils.equals((Annotation)o15, (Annotation)o25);
        }
        return o15.equals(o25);
    }

    public static String toString(Annotation a15) {
        ToStringBuilder builder = new ToStringBuilder(a15, TO_STRING_STYLE);
        for (Method m15 : a15.annotationType().getDeclaredMethods()) {
            if (m15.getParameterTypes().length > 0) continue;
            try {
                builder.append(m15.getName(), m15.invoke((Object)a15, new Object[0]));
            }
            catch (ReflectiveOperationException ex4) {
                throw new UncheckedException(ex4);
            }
        }
        return builder.build();
    }

    @Deprecated
    public AnnotationUtils() {
    }
}

