/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.insns;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.insns.InsnData;
import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.api.plugins.input.insns.custom.ICustomPayload;
import jadx.plugins.input.dex.insns.DexInsnInfo;
import jadx.plugins.input.dex.insns.DexInsnMnemonics;
import jadx.plugins.input.dex.sections.DexCodeReader;
import jadx.plugins.input.dex.sections.SectionReader;
import org.jetbrains.annotations.Nullable;

public class DexInsnData
implements InsnData {
    private final DexCodeReader codeData;
    private final SectionReader externalReader;
    private final SectionReader secondExtReader;
    private DexInsnInfo insnInfo;
    private boolean decoded;
    private int opcodeUnit;
    private int length;
    private int insnStart;
    private int offset;
    private int[] argsReg = new int[5];
    private int regsCount;
    private long literal;
    private int target;
    private int index;
    @Nullable
    private ICustomPayload payload;

    public DexInsnData(DexCodeReader codeData, SectionReader externalReader) {
        this.codeData = codeData;
        this.externalReader = externalReader;
        this.secondExtReader = externalReader.copy();
    }

    @Override
    public void decode() {
        if (this.insnInfo != null && !this.decoded) {
            this.codeData.decode(this);
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getFileOffset() {
        return this.insnStart;
    }

    @Override
    public Opcode getOpcode() {
        DexInsnInfo info = this.insnInfo;
        if (info == null) {
            return Opcode.UNKNOWN;
        }
        return info.getApiOpcode();
    }

    @Override
    public String getOpcodeMnemonic() {
        return DexInsnMnemonics.get(this.opcodeUnit);
    }

    @Override
    public byte[] getByteCode() {
        return this.externalReader.getByteCode(this.insnStart, this.length * 2);
    }

    @Override
    public int getRawOpcodeUnit() {
        return this.opcodeUnit;
    }

    @Override
    public int getRegsCount() {
        return this.regsCount;
    }

    @Override
    public int getReg(int argNum) {
        return this.argsReg[argNum];
    }

    @Override
    public int getResultReg() {
        return -1;
    }

    @Override
    public long getLiteral() {
        return this.literal;
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InsnIndexType getIndexType() {
        return this.insnInfo.getIndexType();
    }

    @Override
    public String getIndexAsString() {
        return this.externalReader.getString(this.index);
    }

    @Override
    public String getIndexAsType() {
        return this.externalReader.getType(this.index);
    }

    @Override
    public IFieldRef getIndexAsField() {
        return this.externalReader.getFieldRef(this.index);
    }

    @Override
    public IMethodRef getIndexAsMethod() {
        return this.externalReader.getMethodRef(this.index);
    }

    @Override
    public ICallSite getIndexAsCallSite() {
        return this.externalReader.getCallSite(this.index, this.secondExtReader);
    }

    @Override
    public IMethodProto getIndexAsProto(int protoIndex) {
        return this.externalReader.getMethodProto(protoIndex);
    }

    @Override
    public IMethodHandle getIndexAsMethodHandle() {
        return this.externalReader.getMethodHandle(this.index);
    }

    @Override
    @Nullable
    public ICustomPayload getPayload() {
        return this.payload;
    }

    public int[] getArgsReg() {
        return this.argsReg;
    }

    public void setArgsReg(int[] argsReg) {
        this.argsReg = argsReg;
    }

    public void setRegsCount(int regsCount) {
        this.regsCount = regsCount;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setInsnStart(int start) {
        this.insnStart = start;
    }

    public void setLiteral(long literal) {
        this.literal = literal;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public void setDecoded(boolean decoded) {
        this.decoded = decoded;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public DexInsnInfo getInsnInfo() {
        return this.insnInfo;
    }

    public void setInsnInfo(DexInsnInfo insnInfo) {
        this.insnInfo = insnInfo;
    }

    public DexCodeReader getCodeData() {
        return this.codeData;
    }

    public int getOpcodeUnit() {
        return this.opcodeUnit;
    }

    public void setOpcodeUnit(int opcodeUnit) {
        this.opcodeUnit = opcodeUnit;
    }

    public void setPayload(ICustomPayload payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(String.format("0x%04X", this.offset));
        sb5.append(": ").append((Object)this.getOpcode());
        if (this.insnInfo == null) {
            sb5.append(String.format("(0x%04X)", this.opcodeUnit));
        } else {
            int regsCount = this.getRegsCount();
            if (this.isDecoded()) {
                sb5.append(' ');
                for (int i15 = 0; i15 < regsCount; ++i15) {
                    if (i15 != 0) {
                        sb5.append(", ");
                    }
                    sb5.append("r").append(this.argsReg[i15]);
                }
            }
        }
        return sb5.toString();
    }
}

