/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.ui.tab.dnd.TabDndGhostPane;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

class TabDndTargetListener
implements DropTargetListener {
    private static final Point HIDDEN_POINT = new Point(0, -1000);
    private final transient TabDndController dnd;

    public TabDndTargetListener(TabDndController dnd) {
        this.dnd = dnd;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e15) {
        DataFlavor[] f15;
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e15.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Transferable t15 = e15.getTransferable();
        if (t15.isDataFlavorSupported((f15 = e15.getCurrentDataFlavors())[0])) {
            e15.acceptDrag(e15.getDropAction());
        } else {
            e15.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e15) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e15.getDropTargetContext().getComponent() != pane) {
            return;
        }
        pane.setPoint(HIDDEN_POINT);
        pane.setTargetRect(0, 0, 0, 0);
        pane.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e15) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e15) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e15.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Point glassPt = e15.getLocation();
        this.dnd.updateTargetMark(this.dnd.getTargetTabIndex(glassPt));
        this.dnd.scrollIfNeeded(glassPt);
        pane.setPoint(glassPt);
        pane.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent e15) {
        TabDndGhostPane pane = this.dnd.getDndGhostPane();
        if (pane == null || e15.getDropTargetContext().getComponent() != pane) {
            return;
        }
        Transferable t15 = e15.getTransferable();
        DataFlavor[] f15 = t15.getTransferDataFlavors();
        int oldIdx = this.dnd.dragTabIndex;
        int newIdx = this.dnd.getTargetTabIndex(e15.getLocation());
        if (t15.isDataFlavorSupported(f15[0]) && oldIdx != newIdx) {
            this.dnd.swapTabs(oldIdx, newIdx);
            e15.dropComplete(true);
        } else {
            e15.dropComplete(false);
        }
        pane.setVisible(false);
    }
}

