/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.resources.ResourceContentType;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.jobs.SimpleTask;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.BinaryContentPanel;
import jadx.gui.ui.codearea.CodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.FontPanel;
import jadx.gui.ui.panel.ImagePanel;
import jadx.gui.ui.popupmenu.JResourcePopupMenu;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.res.ResTableHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.Nullable;

public class JResource
extends JLoadableNode {
    private static final long serialVersionUID = -201018424302612434L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/resourcesRoot");
    private static final ImageIcon ARSC_ICON = UiUtils.openSvgIcon("nodes/resourceBundle");
    private static final ImageIcon XML_ICON = UiUtils.openSvgIcon("nodes/xml");
    private static final ImageIcon IMAGE_ICON = UiUtils.openSvgIcon("nodes/ImagesFileType");
    private static final ImageIcon SO_ICON = UiUtils.openSvgIcon("nodes/binaryFile");
    private static final ImageIcon MANIFEST_ICON = UiUtils.openSvgIcon("nodes/manifest");
    private static final ImageIcon JAVA_ICON = UiUtils.openSvgIcon("nodes/java");
    private static final ImageIcon APK_ICON = UiUtils.openSvgIcon("nodes/archiveApk");
    private static final ImageIcon AUDIO_ICON = UiUtils.openSvgIcon("nodes/audioFile");
    private static final ImageIcon VIDEO_ICON = UiUtils.openSvgIcon("nodes/videoFile");
    private static final ImageIcon FONT_ICON = UiUtils.openSvgIcon("nodes/fontFile");
    private static final ImageIcon HTML_ICON = UiUtils.openSvgIcon("nodes/html");
    private static final ImageIcon JSON_ICON = UiUtils.openSvgIcon("nodes/json");
    private static final ImageIcon TEXT_ICON = UiUtils.openSvgIcon("nodes/text");
    private static final ImageIcon ARCHIVE_ICON = UiUtils.openSvgIcon("nodes/archive");
    private static final ImageIcon UNKNOWN_ICON = UiUtils.openSvgIcon("nodes/unknown");
    public static final Comparator<JResource> RESOURCES_COMPARATOR = Comparator.comparingInt(r15 -> r15.type.ordinal()).thenComparing(JResource::getName, String.CASE_INSENSITIVE_ORDER);
    private final transient String name;
    private final transient String shortName;
    private final transient JResType type;
    private final transient ResourceFile resFile;
    private volatile transient boolean loaded;
    private transient List<JResource> subNodes = Collections.emptyList();
    private transient ICodeInfo content = ICodeInfo.EMPTY;
    private static final Map<String, String> EXTENSION_TO_FILE_SYNTAX = Utils.newConstStringMap("java", "text/java", "smali", "text/smali", "js", "text/javascript", "ts", "text/typescript", "json", "text/json", "css", "text/css", "less", "text/less", "html", "text/html", "xml", "text/xml", "yaml", "text/yaml", "properties", "text/properties", "ini", "text/ini", "sql", "text/sql");

    public JResource(@Nullable ResourceFile resFile, String name, JResType type) {
        this(resFile, name, name, type);
    }

    public JResource(@Nullable ResourceFile resFile, String name, String shortName, JResType type) {
        if (resFile == null && type == JResType.FILE) {
            throw new IllegalArgumentException("Null resource file");
        }
        this.resFile = resFile;
        this.name = name;
        this.shortName = shortName;
        this.type = type;
        this.loaded = false;
    }

    public synchronized void update() {
        this.removeAllChildren();
        if (Utils.isEmpty(this.subNodes)) {
            if (this.type == JResType.DIR || this.type == JResType.ROOT || this.resFile.getType() == ResourceType.ARSC) {
                this.add(new TextNode(NLS.str("tree.loading")));
            }
        } else {
            for (JResource res : this.subNodes) {
                res.update();
                this.add(res);
            }
            if (this.type != JResType.FILE) {
                this.loaded = true;
            }
        }
    }

    @Override
    public synchronized void loadNode() {
        this.getCodeInfo();
        this.update();
    }

    @Override
    public synchronized SimpleTask getLoadTask() {
        if (this.loaded) {
            return null;
        }
        return new SimpleTask(NLS.str("progress.load"), this::getCodeInfo, this::update);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public JResType getType() {
        return this.type;
    }

    public List<JResource> getSubNodes() {
        return this.subNodes;
    }

    public void addSubNode(JResource node) {
        this.subNodes = ListUtils.safeAdd(this.subNodes, node);
    }

    public void sortSubNodes() {
        JResource.sortResNodes(this.subNodes);
    }

    private static void sortResNodes(List<JResource> nodes) {
        if (Utils.notEmpty(nodes)) {
            nodes.forEach(JResource::sortSubNodes);
            nodes.sort(RESOURCES_COMPARATOR);
        }
    }

    @Override
    public boolean hasContent() {
        return this.resFile != null;
    }

    @Override
    @Nullable
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        if (this.resFile == null) {
            return null;
        }
        switch (this.resFile.getType()) {
            case IMG: {
                return new ImagePanel(tabbedPane, this);
            }
            case FONT: {
                return new FontPanel(tabbedPane, this);
            }
        }
        if (this.getContentType() == ResourceContentType.CONTENT_BINARY) {
            return new BinaryContentPanel(tabbedPane, this, false);
        }
        if (this.getSyntaxByExtension(this.resFile.getDeobfName()) != null) {
            return new CodeContentPanel(tabbedPane, this);
        }
        return new BinaryContentPanel(tabbedPane, this, true);
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return new JResourcePopupMenu(mainWindow, this);
    }

    @Override
    public synchronized ICodeInfo getCodeInfo() {
        ICodeInfo codeInfo;
        if (this.loaded) {
            return this.content;
        }
        this.content = codeInfo = this.loadContent();
        this.loaded = true;
        return codeInfo;
    }

    @Override
    public ResourceContentType getContentType() {
        if (this.type == JResType.FILE) {
            return this.resFile.getType().getContentType();
        }
        return ResourceContentType.CONTENT_NONE;
    }

    private ICodeInfo loadContent() {
        if (this.resFile == null || this.type != JResType.FILE) {
            return ICodeInfo.EMPTY;
        }
        ResContainer rc5 = this.resFile.loadContent();
        if (rc5 == null) {
            return ICodeInfo.EMPTY;
        }
        if (rc5.getDataType() == ResContainer.DataType.RES_TABLE) {
            ICodeInfo codeInfo = this.loadCurrentSingleRes(rc5);
            List<JResource> nodes = ResTableHelper.buildTree(this, rc5);
            JResource.sortResNodes(nodes);
            this.subNodes = nodes;
            UiUtils.uiRun(this::update);
            return codeInfo;
        }
        return this.loadCurrentSingleRes(rc5);
    }

    private ICodeInfo loadCurrentSingleRes(ResContainer rc5) {
        switch (rc5.getDataType()) {
            case TEXT: 
            case RES_TABLE: {
                return rc5.getText();
            }
            case RES_LINK: {
                try {
                    ResourceFile resourceFile = rc5.getResLink();
                    return ResourcesLoader.decodeStream(resourceFile, (size, is4) -> {
                        if (size > 0xA00000L) {
                            return new SimpleCodeInfo("File too large for view");
                        }
                        Charset charset = resourceFile.getType().getContentType() == ResourceContentType.CONTENT_TEXT ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII;
                        return ResourcesLoader.loadToCodeWriter(is4, charset);
                    });
                }
                catch (Exception e15) {
                    return new SimpleCodeInfo("Failed to load resource file:\n" + Utils.getStackTrace(e15));
                }
            }
        }
        return new SimpleCodeInfo("Unexpected resource type: " + String.valueOf(rc5));
    }

    @Override
    public String getSyntaxName() {
        if (this.resFile == null) {
            return null;
        }
        switch (this.resFile.getType()) {
            case CODE: {
                return super.getSyntaxName();
            }
            case MANIFEST: 
            case XML: 
            case ARSC: {
                return "text/xml";
            }
        }
        String syntax = this.getSyntaxByExtension(this.resFile.getDeobfName());
        if (syntax != null) {
            return syntax;
        }
        return super.getSyntaxName();
    }

    private String getSyntaxByExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String ext = name.substring(dot + 1);
        return EXTENSION_TO_FILE_SYNTAX.get(ext);
    }

    @Override
    public Icon getIcon() {
        switch (this.type.ordinal()) {
            case 0: {
                return ROOT_ICON;
            }
            case 1: {
                return Icons.FOLDER;
            }
            case 2: {
                ResourceType resType = this.resFile.getType();
                switch (resType) {
                    case MANIFEST: {
                        return MANIFEST_ICON;
                    }
                    case ARSC: {
                        return ARSC_ICON;
                    }
                    case XML: {
                        return XML_ICON;
                    }
                    case IMG: {
                        return IMAGE_ICON;
                    }
                    case LIB: {
                        return SO_ICON;
                    }
                    case CODE: {
                        return JAVA_ICON;
                    }
                    case APK: {
                        return APK_ICON;
                    }
                    case VIDEOS: {
                        return VIDEO_ICON;
                    }
                    case SOUNDS: {
                        return AUDIO_ICON;
                    }
                    case FONT: {
                        return FONT_ICON;
                    }
                    case HTML: {
                        return HTML_ICON;
                    }
                    case JSON: {
                        return JSON_ICON;
                    }
                    case TEXT: {
                        return TEXT_ICON;
                    }
                    case ARCHIVE: {
                        return ARCHIVE_ICON;
                    }
                    case UNKNOWN: {
                        return UNKNOWN_ICON;
                    }
                }
                return UNKNOWN_ICON;
            }
        }
        return Icons.FILE;
    }

    public static boolean isSupportedForView(ResourceType type) {
        switch (type) {
            case APK: 
            case VIDEOS: 
            case SOUNDS: 
            case ARCHIVE: {
                return false;
            }
            case IMG: 
            case FONT: 
            case MANIFEST: 
            case XML: 
            case ARSC: 
            case LIB: 
            case HTML: 
            case JSON: 
            case TEXT: 
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    public static boolean isOpenInExternalTool(ResourceType type) {
        switch (type) {
            case VIDEOS: 
            case SOUNDS: {
                return true;
            }
        }
        return false;
    }

    public ResourceFile getResFile() {
        return this.resFile;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String getID() {
        if (this.type == JResType.ROOT) {
            return "JResources";
        }
        return this.makeString();
    }

    @Override
    public String makeString() {
        return this.shortName;
    }

    @Override
    public String makeLongString() {
        return this.name;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        JResource other = (JResource)o15;
        return this.name.equals(other.name) && this.type.equals((Object)other.type);
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.type.ordinal();
    }

    public static enum JResType {
        ROOT,
        DIR,
        FILE;

    }
}

