/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.invokedynamic;

import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.InvokeCustomRawNode;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.invokedynamic.InvokeCustomUtils;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.EncodedValueUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;

public class CustomRawCall {
    public static InsnNode build(MethodNode mth, InsnData insn, boolean isRange, List<EncodedValue> values2) {
        IMethodHandle resolveHandle = (IMethodHandle)values2.get(0).getValue();
        String invokeName = (String)values2.get(1).getValue();
        IMethodProto invokeProto = (IMethodProto)values2.get(2).getValue();
        List<InsnArg> resolveArgs = CustomRawCall.buildArgs(mth, values2);
        if (resolveHandle.getType().isField()) {
            throw new JadxRuntimeException("Field handle not yet supported");
        }
        RootNode root = mth.root();
        MethodInfo resolveMth = MethodInfo.fromRef(root, resolveHandle.getMethodRef());
        InvokeType resolveInvokeType = InvokeCustomUtils.convertInvokeType(resolveHandle.getType());
        InvokeNode resolve = new InvokeNode(resolveMth, resolveInvokeType, resolveArgs.size());
        resolveArgs.forEach(resolve::addArg);
        ClassInfo invokeCls = ClassInfo.fromType(root, ArgType.OBJECT);
        MethodInfo invokeMth = MethodInfo.fromMethodProto(root, invokeCls, invokeName, invokeProto);
        InvokeCustomRawNode customRawNode = new InvokeCustomRawNode(resolve, invokeMth, insn, isRange);
        customRawNode.setCallSiteValues(values2);
        return customRawNode;
    }

    private static List<InsnArg> buildArgs(MethodNode mth, List<EncodedValue> values2) {
        int valuesCount = values2.size();
        ArrayList<InsnArg> list2 = new ArrayList<InsnArg>(valuesCount);
        RootNode root = mth.root();
        list2.add(EncodedValueUtils.buildLookupArg(root));
        for (int i15 = 1; i15 < valuesCount; ++i15) {
            EncodedValue value = values2.get(i15);
            try {
                list2.add(EncodedValueUtils.convertToInsnArg(root, value));
                continue;
            }
            catch (Exception e15) {
                mth.addWarnComment("Failed to build arg in invoke-custom insn: " + String.valueOf(value), e15);
                list2.add(InsnArg.wrapArg(new ConstStringNode(value.toString())));
            }
        }
        return list2;
    }
}

