/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes;

import jadx.api.CommentsLevel;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrList;
import jadx.core.dex.attributes.AttributeStorage;
import jadx.core.dex.attributes.EmptyAttrStorage;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.nodes.JadxCommentsAttr;
import java.util.List;

public abstract class AttrNode
implements IAttributeNode {
    private static final AttributeStorage EMPTY_ATTR_STORAGE = EmptyAttrStorage.INSTANCE;
    private AttributeStorage storage = EMPTY_ATTR_STORAGE;

    @Override
    public void add(AFlag flag) {
        this.initStorage().add(flag);
    }

    @Override
    public void addAttr(IJadxAttribute attr) {
        this.initStorage().add(attr);
    }

    @Override
    public void addAttrs(List<IJadxAttribute> list2) {
        if (list2.isEmpty()) {
            return;
        }
        this.initStorage().add(list2);
    }

    @Override
    public <T> void addAttr(IJadxAttrType<AttrList<T>> type, T obj) {
        this.initStorage().add(type, obj);
    }

    public <T> void addAttr(IJadxAttrType<AttrList<T>> type, List<T> list2) {
        AttributeStorage strg = this.initStorage();
        list2.forEach(attr -> strg.add(type, attr));
    }

    @Override
    public void copyAttributesFrom(AttrNode attrNode) {
        AttributeStorage copyFrom = attrNode.storage;
        if (!copyFrom.isEmpty()) {
            this.initStorage().addAll(copyFrom);
        }
    }

    @Override
    public <T extends IJadxAttribute> void copyAttributeFrom(AttrNode attrNode, AType<T> attrType) {
        T attr = attrNode.get(attrType);
        if (attr != null) {
            this.addAttr((IJadxAttribute)attr);
        }
    }

    @Override
    public <T extends IJadxAttribute> void rewriteAttributeFrom(AttrNode attrNode, AType<T> attrType) {
        this.remove(attrType);
        this.copyAttributeFrom(attrNode, attrType);
    }

    private AttributeStorage initStorage() {
        AttributeStorage store = this.storage;
        if (store == EMPTY_ATTR_STORAGE) {
            this.storage = store = new AttributeStorage();
        }
        return store;
    }

    private void unloadIfEmpty() {
        if (this.storage.isEmpty() && this.storage != EMPTY_ATTR_STORAGE) {
            this.storage = EMPTY_ATTR_STORAGE;
        }
    }

    @Override
    public boolean contains(AFlag flag) {
        return this.storage.contains(flag);
    }

    @Override
    public <T extends IJadxAttribute> boolean contains(IJadxAttrType<T> type) {
        return this.storage.contains(type);
    }

    @Override
    public <T extends IJadxAttribute> T get(IJadxAttrType<T> type) {
        return this.storage.get(type);
    }

    @Override
    public IAnnotation getAnnotation(String cls) {
        return this.storage.getAnnotation(cls);
    }

    @Override
    public <T> List<T> getAll(IJadxAttrType<AttrList<T>> type) {
        return this.storage.getAll(type);
    }

    @Override
    public void remove(AFlag flag) {
        this.storage.remove(flag);
        this.unloadIfEmpty();
    }

    @Override
    public <T extends IJadxAttribute> void remove(IJadxAttrType<T> type) {
        this.storage.remove(type);
        this.unloadIfEmpty();
    }

    @Override
    public void removeAttr(IJadxAttribute attr) {
        this.storage.remove(attr);
        this.unloadIfEmpty();
    }

    @Override
    public void clearAttributes() {
        this.storage = EMPTY_ATTR_STORAGE;
    }

    public void unloadAttributes() {
        if (this.storage == EMPTY_ATTR_STORAGE) {
            return;
        }
        this.storage.unloadAttributes();
        this.storage.clearFlags();
        this.unloadIfEmpty();
    }

    @Override
    public List<String> getAttributesStringsList() {
        return this.storage.getAttributeStrings();
    }

    @Override
    public String getAttributesString() {
        return this.storage.toString();
    }

    @Override
    public boolean isAttrStorageEmpty() {
        return this.storage.isEmpty();
    }

    private void addDebugComment(String msg) {
        JadxCommentsAttr commentsAttr = this.get(AType.JADX_COMMENTS);
        if (commentsAttr == null) {
            commentsAttr = new JadxCommentsAttr();
            this.initStorage().add(commentsAttr);
        }
        commentsAttr.add(CommentsLevel.DEBUG, msg);
    }
}

