/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncSubject<T>
extends Subject<T> {
    static final AsyncDisposable[] EMPTY = new AsyncDisposable[0];
    static final AsyncDisposable[] TERMINATED = new AsyncDisposable[0];
    final AtomicReference<AsyncDisposable<T>[]> subscribers = new AtomicReference<AsyncDisposable[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    @NonNull
    public static <T> AsyncSubject<T> create() {
        return new AsyncSubject<T>();
    }

    AsyncSubject() {
    }

    @Override
    public void onSubscribe(Disposable d15) {
        if (this.subscribers.get() == TERMINATED) {
            d15.dispose();
        }
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.value = t15;
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.value = null;
        this.error = t15;
        for (AsyncDisposable as4 : this.subscribers.getAndSet(TERMINATED)) {
            as4.onError(t15);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v15 = this.value;
        AsyncDisposable[] array = this.subscribers.getAndSet(TERMINATED);
        if (v15 == null) {
            for (AsyncDisposable as4 : array) {
                as4.onComplete();
            }
        } else {
            for (AsyncDisposable as5 : array) {
                as5.complete(v15);
            }
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    @CheckReturnValue
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        AsyncDisposable<T> as4 = new AsyncDisposable<T>(observer, this);
        observer.onSubscribe(as4);
        if (this.add(as4)) {
            if (as4.isDisposed()) {
                this.remove(as4);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                observer.onError(ex4);
            } else {
                T v15 = this.value;
                if (v15 != null) {
                    as4.complete(v15);
                } else {
                    as4.onComplete();
                }
            }
        }
    }

    boolean add(AsyncDisposable<T> ps4) {
        AsyncDisposable[] b15;
        AsyncDisposable<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new AsyncDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = ps4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(AsyncDisposable<T> ps4) {
        AsyncDisposable[] b15;
        AsyncDisposable<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != ps4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new AsyncDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    static final class AsyncDisposable<T>
    extends DeferredScalarDisposable<T> {
        private static final long serialVersionUID = 5629876084736248016L;
        final AsyncSubject<T> parent;

        AsyncDisposable(Observer<? super T> actual, AsyncSubject<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void dispose() {
            if (super.tryDispose()) {
                this.parent.remove(this);
            }
        }

        void onComplete() {
            if (!this.isDisposed()) {
                this.downstream.onComplete();
            }
        }

        void onError(Throwable t15) {
            if (this.isDisposed()) {
                RxJavaPlugins.onError(t15);
            } else {
                this.downstream.onError(t15);
            }
        }
    }
}

