/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@BackpressureSupport(value=BackpressureKind.FULL)
@SchedulerSupport(value="none")
public final class MulticastProcessor<@NonNull T>
extends FlowableProcessor<T> {
    final AtomicInteger wip;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<MulticastSubscription<T>[]> subscribers;
    final int bufferSize;
    final int limit;
    final boolean refcount;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    volatile Throwable error;
    int consumed;
    int fusionMode;
    static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
    static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create() {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(boolean refCount) {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), refCount);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, false);
    }

    @CheckReturnValue
    @NonNull
    public static <T> MulticastProcessor<T> create(int bufferSize, boolean refCount) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new MulticastProcessor<T>(bufferSize, refCount);
    }

    MulticastProcessor(int bufferSize, boolean refCount) {
        this.bufferSize = bufferSize;
        this.limit = bufferSize - (bufferSize >> 2);
        this.wip = new AtomicInteger();
        this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        this.upstream = new AtomicReference();
        this.refcount = refCount;
    }

    public void start() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
        }
    }

    public void startUnbounded() {
        if (SubscriptionHelper.setOnce(this.upstream, EmptySubscription.INSTANCE)) {
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
        }
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (SubscriptionHelper.setOnce(this.upstream, s15)) {
            if (s15 instanceof QueueSubscription) {
                QueueSubscription qs4 = (QueueSubscription)s15;
                int m15 = qs4.requestFusion(3);
                if (m15 == 1) {
                    this.fusionMode = m15;
                    this.queue = qs4;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m15 == 2) {
                    this.fusionMode = m15;
                    this.queue = qs4;
                    s15.request(this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.bufferSize);
            s15.request(this.bufferSize);
        }
    }

    @Override
    public void onNext(@NonNull T t15) {
        if (this.done) {
            return;
        }
        if (this.fusionMode == 0) {
            ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
            if (!this.queue.offer(t15)) {
                SubscriptionHelper.cancel(this.upstream);
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
        }
        this.drain();
    }

    @CheckReturnValue
    public boolean offer(@NonNull T t15) {
        ExceptionHelper.nullCheck(t15, "offer called with a null value.");
        if (this.done) {
            return false;
        }
        if (this.fusionMode == 0) {
            if (this.queue.offer(t15)) {
                this.drain();
                return true;
            }
            return false;
        }
        throw new IllegalStateException("offer() should not be called in fusion mode!");
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (!this.done) {
            this.error = t15;
            this.done = true;
            this.drain();
            return;
        }
        RxJavaPlugins.onError(t15);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    @Override
    @CheckReturnValue
    public Throwable getThrowable() {
        return this.done ? this.error : null;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> s15) {
        MulticastSubscription<T> ms4 = new MulticastSubscription<T>(s15, this);
        s15.onSubscribe(ms4);
        if (this.add(ms4)) {
            if (ms4.get() == Long.MIN_VALUE) {
                this.remove(ms4);
            } else {
                this.drain();
            }
        } else {
            Throwable ex4;
            if (this.done && (ex4 = this.error) != null) {
                s15.onError(ex4);
                return;
            }
            s15.onComplete();
        }
    }

    boolean add(MulticastSubscription<T> inner) {
        MulticastSubscription[] b15;
        MulticastSubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new MulticastSubscription[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = inner;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void remove(MulticastSubscription<T> inner) {
        MulticastSubscription<T>[] a15;
        int n15;
        while ((n15 = (a15 = this.subscribers.get()).length) != 0) {
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != inner) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) return;
            if (n15 == 1) {
                if (this.refcount) {
                    if (!this.subscribers.compareAndSet(a15, TERMINATED)) continue;
                    SubscriptionHelper.cancel(this.upstream);
                    this.done = true;
                    return;
                }
                if (!this.subscribers.compareAndSet(a15, EMPTY)) continue;
                return;
            }
            MulticastSubscription[] b15 = new MulticastSubscription[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
            if (this.subscribers.compareAndSet(a15, b15)) return;
        }
        return;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
        int c15 = this.consumed;
        int lim = this.limit;
        int fm4 = this.fusionMode;
        block2: while (true) {
            MulticastSubscription<T>[] as4;
            int n15;
            SimpleQueue<T> q15;
            if ((q15 = this.queue) != null && (n15 = (as4 = subs.get()).length) != 0) {
                MulticastSubscription<T>[] bs4;
                long r15 = -1L;
                for (MulticastSubscription<T> a15 : as4) {
                    long ra5 = a15.get();
                    if (ra5 < 0L) continue;
                    r15 = r15 == -1L ? ra5 - a15.emitted : Math.min(r15, ra5 - a15.emitted);
                }
                while (r15 > 0L) {
                    boolean empty;
                    T v15;
                    bs4 = subs.get();
                    if (bs4 == TERMINATED) {
                        q15.clear();
                        return;
                    }
                    if (as4 != bs4) continue block2;
                    boolean d15 = this.done;
                    try {
                        v15 = q15.poll();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        SubscriptionHelper.cancel(this.upstream);
                        d15 = true;
                        v15 = null;
                        this.error = ex4;
                        this.done = true;
                    }
                    boolean bl4 = empty = v15 == null;
                    if (d15 && empty) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex5);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                    if (empty) break;
                    for (MulticastSubscription<T> inner : as4) {
                        inner.onNext(v15);
                    }
                    --r15;
                    if (fm4 == 1 || ++c15 != lim) continue;
                    c15 = 0;
                    this.upstream.get().request(lim);
                }
                if (r15 == 0L) {
                    bs4 = subs.get();
                    if (bs4 == TERMINATED) {
                        q15.clear();
                        return;
                    }
                    if (as4 != bs4) continue;
                    if (this.done && q15.isEmpty()) {
                        Throwable ex6 = this.error;
                        if (ex6 != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex6);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                }
            }
            this.consumed = c15;
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    static final class MulticastSubscription<@NonNull T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -363282618957264509L;
        final Subscriber<? super T> downstream;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public void request(long n15) {
            long r15;
            if (SubscriptionHelper.validate(n15) && (r15 = BackpressureHelper.addCancel(this, n15)) != Long.MIN_VALUE && r15 != Long.MAX_VALUE) {
                this.parent.drain();
            }
        }

        @Override
        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        void onNext(T t15) {
            if (this.get() != Long.MIN_VALUE) {
                ++this.emitted;
                this.downstream.onNext(t15);
            }
        }

        void onError(Throwable t15) {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onError(t15);
            }
        }

        void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.downstream.onComplete();
            }
        }
    }
}

