/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelMap<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends R> mapper;

    public ParallelMap(ParallelFlowable<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n15 = subscribers.length;
        Subscriber[] parents = new Subscriber[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            Subscriber<R> a15 = subscribers[i15];
            parents[i15] = a15 instanceof ConditionalSubscriber ? new ParallelMapConditionalSubscriber<T, R>((ConditionalSubscriber)a15, this.mapper) : new ParallelMapSubscriber<T, R>(a15, this.mapper);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelMapConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super R> downstream;
        final Function<? super T, ? extends R> mapper;
        Subscription upstream;
        boolean done;

        ParallelMapConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            R v15;
            if (this.done) {
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.cancel();
                this.onError(ex4);
                return;
            }
            this.downstream.onNext(v15);
        }

        @Override
        public boolean tryOnNext(T t15) {
            R v15;
            if (this.done) {
                return false;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.cancel();
                this.onError(ex4);
                return false;
            }
            return this.downstream.tryOnNext(v15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }

    static final class ParallelMapSubscriber<T, R>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends R> mapper;
        Subscription upstream;
        boolean done;

        ParallelMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            R v15;
            if (this.done) {
                return;
            }
            try {
                v15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null value");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.cancel();
                this.onError(ex4);
                return;
            }
            this.downstream.onNext(v15);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

