/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableSequenceEqual<T>
extends Observable<Boolean> {
    final ObservableSource<? extends T> first;
    final ObservableSource<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int bufferSize;

    public ObservableSequenceEqual(ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer, int bufferSize) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Boolean> observer) {
        EqualCoordinator<T> ec5 = new EqualCoordinator<T>(observer, this.bufferSize, this.first, this.second, this.comparer);
        observer.onSubscribe(ec5);
        ec5.subscribe();
    }

    static final class EqualObserver<T>
    implements Observer<T> {
        final EqualCoordinator<T> parent;
        final SpscLinkedArrayQueue<T> queue;
        final int index;
        volatile boolean done;
        Throwable error;

        EqualObserver(EqualCoordinator<T> parent, int index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.parent.setDisposable(d15, this.index);
        }

        @Override
        public void onNext(T t15) {
            this.queue.offer(t15);
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -6178010334400373240L;
        final Observer<? super Boolean> downstream;
        final BiPredicate<? super T, ? super T> comparer;
        final ArrayCompositeDisposable resources;
        final ObservableSource<? extends T> first;
        final ObservableSource<? extends T> second;
        final EqualObserver<T>[] observers;
        volatile boolean cancelled;
        T v1;
        T v2;

        EqualCoordinator(Observer<? super Boolean> actual, int bufferSize, ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
            this.downstream = actual;
            this.first = first;
            this.second = second;
            this.comparer = comparer;
            EqualObserver[] as4 = new EqualObserver[2];
            this.observers = as4;
            as4[0] = new EqualObserver(this, 0, bufferSize);
            as4[1] = new EqualObserver(this, 1, bufferSize);
            this.resources = new ArrayCompositeDisposable(2);
        }

        boolean setDisposable(Disposable d15, int index) {
            return this.resources.setResource(index, d15);
        }

        void subscribe() {
            EqualObserver<T>[] as4 = this.observers;
            this.first.subscribe(as4[0]);
            this.second.subscribe(as4[1]);
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.resources.dispose();
                if (this.getAndIncrement() == 0) {
                    EqualObserver<T>[] as4 = this.observers;
                    as4[0].queue.clear();
                    as4[1].queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel(SpscLinkedArrayQueue<T> q15, SpscLinkedArrayQueue<T> q25) {
            this.cancelled = true;
            q15.clear();
            q25.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            EqualObserver<T>[] as4 = this.observers;
            EqualObserver<T> observer1 = as4[0];
            SpscLinkedArrayQueue q15 = observer1.queue;
            EqualObserver<T> observer2 = as4[1];
            SpscLinkedArrayQueue q25 = observer2.queue;
            while (true) {
                boolean e25;
                boolean e15;
                Throwable e16;
                Throwable e17;
                if (this.cancelled) {
                    q15.clear();
                    q25.clear();
                    return;
                }
                boolean d15 = observer1.done;
                if (d15 && (e17 = observer1.error) != null) {
                    this.cancel(q15, q25);
                    this.downstream.onError(e17);
                    return;
                }
                boolean d25 = observer2.done;
                if (d25 && (e16 = observer2.error) != null) {
                    this.cancel(q15, q25);
                    this.downstream.onError(e16);
                    return;
                }
                if (this.v1 == null) {
                    this.v1 = q15.poll();
                }
                boolean bl4 = e15 = this.v1 == null;
                if (this.v2 == null) {
                    this.v2 = q25.poll();
                }
                boolean bl5 = e25 = this.v2 == null;
                if (d15 && d25 && e15 && e25) {
                    this.downstream.onNext((Boolean)true);
                    this.downstream.onComplete();
                    return;
                }
                if (d15 && d25 && e15 != e25) {
                    this.cancel(q15, q25);
                    this.downstream.onNext((Boolean)false);
                    this.downstream.onComplete();
                    return;
                }
                if (!e15 && !e25) {
                    boolean c15;
                    try {
                        c15 = this.comparer.test(this.v1, this.v2);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.cancel(q15, q25);
                        this.downstream.onError(ex4);
                        return;
                    }
                    if (!c15) {
                        this.cancel(q15, q25);
                        this.downstream.onNext((Boolean)false);
                        this.downstream.onComplete();
                        return;
                    }
                    this.v1 = null;
                    this.v2 = null;
                }
                if (!e15 && !e25) continue;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

