/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableGroupJoin;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractObservableWithUpstream<TLeft, R> {
    final ObservableSource<? extends TRight> other;
    final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;

    public ObservableJoin(ObservableSource<TLeft> source, ObservableSource<? extends TRight> other, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        JoinDisposable parent = new JoinDisposable(observer, this.leftEnd, this.rightEnd, this.resultSelector);
        observer.onSubscribe(parent);
        ObservableGroupJoin.LeftRightObserver left = new ObservableGroupJoin.LeftRightObserver(parent, true);
        parent.disposables.add(left);
        ObservableGroupJoin.LeftRightObserver right = new ObservableGroupJoin.LeftRightObserver(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class JoinDisposable<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Disposable,
    ObservableGroupJoin.JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Observer<? super R> downstream;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinDisposable(Observer<? super R> actual, Function<? super TLeft, ? extends ObservableSource<TLeftEnd>> leftEnd, Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
            this.downstream = actual;
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Observer<?> a15) {
            Throwable ex4 = ExceptionHelper.terminate(this.error);
            this.lefts.clear();
            this.rights.clear();
            a15.onError(ex4);
        }

        void fail(Throwable exc, Observer<?> a15, SpscLinkedArrayQueue<?> q15) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q15.clear();
            this.cancelAll();
            this.errorAll(a15);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            Observer<R> a15 = this.downstream;
            block8: while (true) {
                boolean empty;
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                Throwable ex4 = this.error.get();
                if (ex4 != null) {
                    q15.clear();
                    this.cancelAll();
                    this.errorAll(a15);
                    return;
                }
                boolean d15 = this.active.get() == 0;
                Integer mode = (Integer)q15.poll();
                boolean bl4 = empty = mode == null;
                if (d15 && empty) {
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a15.onComplete();
                    return;
                }
                if (!empty) {
                    ObservableGroupJoin.LeftRightEndObserver end;
                    R w15;
                    Iterator<Object> iterator2;
                    ObservableGroupJoin.LeftRightEndObserver end2;
                    ObservableSource<Object> p15;
                    int idx;
                    Object val = q15.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p15 = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        end2 = new ObservableGroupJoin.LeftRightEndObserver(this, true, idx);
                        this.disposables.add(end2);
                        p15.subscribe(end2);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        iterator2 = this.rights.values().iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block8;
                            Object right = iterator2.next();
                            try {
                                w15 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a15, q15);
                                return;
                            }
                            a15.onNext(w15);
                        }
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p15 = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null ObservableSource");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a15, q15);
                            return;
                        }
                        end2 = new ObservableGroupJoin.LeftRightEndObserver(this, false, idx);
                        this.disposables.add(end2);
                        p15.subscribe(end2);
                        ex4 = this.error.get();
                        if (ex4 != null) {
                            q15.clear();
                            this.cancelAll();
                            this.errorAll(a15);
                            return;
                        }
                        iterator2 = this.lefts.values().iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block8;
                            Object left = iterator2.next();
                            try {
                                w15 = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a15, q15);
                                return;
                            }
                            a15.onNext(w15);
                        }
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (ObservableGroupJoin.LeftRightEndObserver)val;
                        this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        continue;
                    }
                    end = (ObservableGroupJoin.LeftRightEndObserver)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        @Override
        public void innerComplete(ObservableGroupJoin.LeftRightObserver sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o15) {
            JoinDisposable joinDisposable = this;
            synchronized (joinDisposable) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o15);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, ObservableGroupJoin.LeftRightEndObserver index) {
            JoinDisposable joinDisposable = this;
            synchronized (joinDisposable) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex4) {
            if (ExceptionHelper.addThrowable(this.error, ex4)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

