/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWithLatestFrom<T, U, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final Publisher<? extends U> other;

    public FlowableWithLatestFrom(Flowable<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, Publisher<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        SerializedSubscriber<R> serial = new SerializedSubscriber<R>(s15);
        WithLatestFromSubscriber<? super T, ? super U, ? extends R> wlf = new WithLatestFromSubscriber<T, U, R>(serial, this.combiner);
        serial.onSubscribe(wlf);
        this.other.subscribe(new FlowableWithLatestSubscriber(wlf));
        this.source.subscribe(wlf);
    }

    final class FlowableWithLatestSubscriber
    implements FlowableSubscriber<U> {
        private final WithLatestFromSubscriber<T, U, R> wlf;

        FlowableWithLatestSubscriber(WithLatestFromSubscriber<T, U, R> wlf) {
            this.wlf = wlf;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (this.wlf.setOther(s15)) {
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(U t15) {
            this.wlf.lazySet(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.wlf.otherError(t15);
        }

        @Override
        public void onComplete() {
        }
    }

    static final class WithLatestFromSubscriber<T, U, R>
    extends AtomicReference<U>
    implements ConditionalSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -312246233408980075L;
        final Subscriber<? super R> downstream;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Subscription> other = new AtomicReference();

        WithLatestFromSubscriber(Subscriber<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.downstream = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s15);
        }

        @Override
        public void onNext(T t15) {
            if (!this.tryOnNext(t15)) {
                this.upstream.get().request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t15) {
            Object u15 = this.get();
            if (u15 != null) {
                R r15;
                try {
                    r15 = Objects.requireNonNull(this.combiner.apply(t15, u15), "The combiner returned a null value");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.cancel();
                    this.downstream.onError(e15);
                    return false;
                }
                this.downstream.onNext(r15);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t15) {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n15);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.other);
        }

        public boolean setOther(Subscription o15) {
            return SubscriptionHelper.setOnce(this.other, o15);
        }

        public void otherError(Throwable e15) {
            SubscriptionHelper.cancel(this.upstream);
            this.downstream.onError(e15);
        }
    }
}

