/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class FlowableLastMaybe<T>
extends Maybe<T> {
    final Publisher<T> source;

    public FlowableLastMaybe(Publisher<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new LastSubscriber<T>(observer));
    }

    static final class LastSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        Subscription upstream;
        T item;

        LastSubscriber(MaybeObserver<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.upstream == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            this.item = t15;
        }

        @Override
        public void onError(Throwable t15) {
            this.upstream = SubscriptionHelper.CANCELLED;
            this.item = null;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.upstream = SubscriptionHelper.CANCELLED;
            T v15 = this.item;
            if (v15 != null) {
                this.item = null;
                this.downstream.onSuccess(v15);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

