/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableIgnoreElements<T>
extends AbstractFlowableWithUpstream<T, T> {
    public FlowableIgnoreElements(Flowable<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t15) {
        this.source.subscribe(new IgnoreElementsSubscriber<T>(t15));
    }

    static final class IgnoreElementsSubscriber<T>
    implements FlowableSubscriber<T>,
    QueueSubscription<T> {
        final Subscriber<? super T> downstream;
        Subscription upstream;

        IgnoreElementsSubscriber(Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public boolean offer(T e15) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        public boolean offer(T v15, T v25) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        @Nullable
        public T poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public void request(long n15) {
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }
    }
}

