/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.subscribers.BlockingSubscriber;
import io.reactivex.rxjava3.internal.subscribers.BoundedSubscriber;
import io.reactivex.rxjava3.internal.subscribers.LambdaSubscriber;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.BlockingIgnoringReceiver;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableBlockingSubscribe {
    private FlowableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(Publisher<? extends T> source, Subscriber<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs4 = new BlockingSubscriber((Queue<Object>)queue);
        source.subscribe(bs4);
        try {
            while (!bs4.isCancelled()) {
                Object v15 = queue.poll();
                if (v15 == null) {
                    if (bs4.isCancelled()) break;
                    BlockingHelper.verifyNonBlocking();
                    v15 = queue.take();
                }
                if (!bs4.isCancelled() && v15 != BlockingSubscriber.TERMINATED && !NotificationLite.acceptFull(v15, subscriber)) continue;
                break;
            }
        }
        catch (InterruptedException e15) {
            bs4.cancel();
            subscriber.onError(e15);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> source) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaSubscriber ls4 = new LambdaSubscriber(Functions.emptyConsumer(), callback, callback, Functions.REQUEST_MAX);
        source.subscribe(ls4);
        BlockingHelper.awaitForComplete(callback, ls4);
        Throwable e15 = callback.error;
        if (e15 != null) {
            throw ExceptionHelper.wrapOrThrow(e15);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o15, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        FlowableBlockingSubscribe.subscribe(o15, new LambdaSubscriber<T>(onNext, onError, onComplete, Functions.REQUEST_MAX));
    }

    public static <T> void subscribe(Publisher<? extends T> o15, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, int bufferSize) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.verifyPositive(bufferSize, "number > 0 required");
        FlowableBlockingSubscribe.subscribe(o15, new BoundedSubscriber<T>(onNext, onError, onComplete, Functions.boundedConsumer(bufferSize), bufferSize));
    }
}

