/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public abstract class BasicFuseableObserver<T, R>
implements Observer<T>,
QueueDisposable<R> {
    protected final Observer<? super R> downstream;
    protected Disposable upstream;
    protected QueueDisposable<T> qd;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableObserver(Observer<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Disposable d15) {
        if (DisposableHelper.validate(this.upstream, d15)) {
            this.upstream = d15;
            if (d15 instanceof QueueDisposable) {
                this.qd = (QueueDisposable)d15;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t15) {
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        this.downstream.onError(t15);
    }

    protected final void fail(Throwable t15) {
        Exceptions.throwIfFatal(t15);
        this.upstream.dispose();
        this.onError(t15);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueDisposable<T> qd5 = this.qd;
        if (qd5 != null && (mode & 4) == 0) {
            int m15 = qd5.requestFusion(mode);
            if (m15 != 0) {
                this.sourceMode = m15;
            }
            return m15;
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public boolean isEmpty() {
        return this.qd.isEmpty();
    }

    @Override
    public void clear() {
        this.qd.clear();
    }

    @Override
    public final boolean offer(R e15) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v15, R v25) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

