/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ArrayCompositeDisposable
extends AtomicReferenceArray<Disposable>
implements Disposable {
    private static final long serialVersionUID = 2746389416410565408L;

    public ArrayCompositeDisposable(int capacity) {
        super(capacity);
    }

    public boolean setResource(int index, Disposable resource) {
        Disposable o15;
        do {
            if ((o15 = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return false;
        } while (!this.compareAndSet(index, o15, resource));
        if (o15 != null) {
            o15.dispose();
        }
        return true;
    }

    public Disposable replaceResource(int index, Disposable resource) {
        Disposable o15;
        do {
            if ((o15 = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return null;
        } while (!this.compareAndSet(index, o15, resource));
        return o15;
    }

    @Override
    public void dispose() {
        if (this.get(0) != DisposableHelper.DISPOSED) {
            int s15 = this.length();
            for (int i15 = 0; i15 < s15; ++i15) {
                Disposable o15 = (Disposable)this.get(i15);
                if (o15 == DisposableHelper.DISPOSED || (o15 = (Disposable)this.getAndSet(i15, DisposableHelper.DISPOSED)) == DisposableHelper.DISPOSED || o15 == null) continue;
                o15.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get(0) == DisposableHelper.DISPOSED;
    }
}

