/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.GsonTypes;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ArrayTypeAdapter<E>
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
                return null;
            }
            Type componentType = GsonTypes.getArrayComponentType(type);
            TypeAdapter<?> componentTypeAdapter = gson.getAdapter(TypeToken.get(componentType));
            ArrayTypeAdapter arrayAdapter = new ArrayTypeAdapter(gson, componentTypeAdapter, GsonTypes.getRawType(componentType));
            return arrayAdapter;
        }
    };
    private final Class<E> componentType;
    private final TypeAdapter<E> componentTypeAdapter;

    public ArrayTypeAdapter(Gson context, TypeAdapter<E> componentTypeAdapter, Class<E> componentType) {
        this.componentTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, componentTypeAdapter, componentType);
        this.componentType = componentType;
    }

    @Override
    public Object read(JsonReader in4) throws IOException {
        if (in4.peek() == JsonToken.NULL) {
            in4.nextNull();
            return null;
        }
        ArrayList<E> list2 = new ArrayList<E>();
        in4.beginArray();
        while (in4.hasNext()) {
            E instance = this.componentTypeAdapter.read(in4);
            list2.add(instance);
        }
        in4.endArray();
        int size = list2.size();
        if (this.componentType.isPrimitive()) {
            Object array = Array.newInstance(this.componentType, size);
            for (int i15 = 0; i15 < size; ++i15) {
                Array.set(array, i15, list2.get(i15));
            }
            return array;
        }
        Object[] array = (Object[])Array.newInstance(this.componentType, size);
        return list2.toArray(array);
    }

    @Override
    public void write(JsonWriter out, Object array) throws IOException {
        if (array == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        int length = Array.getLength(array);
        for (int i15 = 0; i15 < length; ++i15) {
            Object value = Array.get(array, i15);
            this.componentTypeAdapter.write(out, value);
        }
        out.endArray();
    }
}

