/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c15, String r15) {
        this.map.put(Character.valueOf(c15), Preconditions.checkNotNull(r15));
        if (c15 > this.max) {
            this.max = c15;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cs4, String r15) {
        Preconditions.checkNotNull(r15);
        for (char c15 : cs4) {
            this.addEscape(c15, r15);
        }
        return this;
    }

    public char[] @Nullable [] toArray() {
        char[][] result = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            result[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return result;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static final class CharArrayDecorator
    extends CharEscaper {
        private final char[] @Nullable [] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[] @Nullable [] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s15) {
            int slen = s15.length();
            for (int index = 0; index < slen; ++index) {
                char c15 = s15.charAt(index);
                if (c15 >= this.replacements.length || this.replacements[c15] == null) continue;
                return this.escapeSlow(s15, index);
            }
            return s15;
        }

        @Override
        protected char @Nullable [] escape(char c15) {
            return c15 < this.replaceLength ? this.replacements[c15] : null;
        }
    }
}

