/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScaledImageIcon
implements Icon {
    private final ImageIcon imageIcon;
    private final int iconWidth;
    private final int iconHeight;
    private double lastSystemScaleFactor;
    private float lastUserScaleFactor;
    private Image lastImage;

    public ScaledImageIcon(ImageIcon imageIcon) {
        this(imageIcon, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    public ScaledImageIcon(ImageIcon imageIcon, int iconWidth, int iconHeight) {
        this.imageIcon = imageIcon;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconWidth);
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconHeight);
    }

    @Override
    public void paintIcon(Component c15, Graphics g15, int x15, int y15) {
        float userScaleFactor;
        double systemScaleFactor = UIScale.getSystemScaleFactor((Graphics2D)g15);
        double scaleFactor = systemScaleFactor * (double)(userScaleFactor = UIScale.getUserScaleFactor());
        if (scaleFactor == 1.0 && this.imageIcon != null && this.iconWidth == this.imageIcon.getIconWidth() && this.iconHeight == this.imageIcon.getIconHeight()) {
            this.imageIcon.paintIcon(c15, g15, x15, y15);
            return;
        }
        if (systemScaleFactor == this.lastSystemScaleFactor && userScaleFactor == this.lastUserScaleFactor && this.lastImage != null) {
            this.paintLastImage(g15, x15, y15);
            return;
        }
        int destImageWidth = (int)Math.round((double)this.iconWidth * scaleFactor);
        int destImageHeight = (int)Math.round((double)this.iconHeight * scaleFactor);
        Image image = this.getResolutionVariant(destImageWidth, destImageHeight);
        int imageWidth = -1;
        int imageHeight = -1;
        if (image != null) {
            imageWidth = image.getWidth(null);
            imageHeight = image.getHeight(null);
        }
        if (imageWidth < 0 || imageHeight < 0) {
            g15.setColor(Color.red);
            g15.fillRect(x15, y15, this.getIconWidth(), this.getIconHeight());
            return;
        }
        if (imageWidth != destImageWidth || imageHeight != destImageHeight) {
            Object scalingInterpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            float imageScaleFactor = (float)destImageWidth / (float)imageWidth;
            if ((float)((int)imageScaleFactor) == imageScaleFactor && imageScaleFactor > 1.0f && imageWidth <= 16 && imageHeight <= 16) {
                scalingInterpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            BufferedImage bufferedImage = this.image2bufferedImage(image);
            image = this.scaleImage(bufferedImage, destImageWidth, destImageHeight, scalingInterpolation);
        }
        this.lastSystemScaleFactor = systemScaleFactor;
        this.lastUserScaleFactor = userScaleFactor;
        this.lastImage = image;
        this.paintLastImage(g15, x15, y15);
    }

    protected Image getResolutionVariant(int destImageWidth, int destImageHeight) {
        return MultiResolutionImageSupport.getResolutionVariant(this.imageIcon.getImage(), destImageWidth, destImageHeight);
    }

    private void paintLastImage(Graphics g15, int x15, int y15) {
        if (this.lastSystemScaleFactor > 1.0) {
            HiDPIUtils.paintAtScale1x((Graphics2D)g15, x15, y15, 100, 100, (g25, x25, y25, width2, height2, scaleFactor2) -> g25.drawImage(this.lastImage, x25, y25, null));
        } else {
            g15.drawImage(this.lastImage, x15, y15, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleImage(BufferedImage image, int targetWidth, int targetHeight, Object scalingInterpolation) {
        BufferedImage bufferedImage = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g15 = bufferedImage.createGraphics();
        try {
            g15.setRenderingHint(RenderingHints.KEY_INTERPOLATION, scalingInterpolation);
            g15.drawImage(image, 0, 0, targetWidth, targetHeight, null);
        }
        finally {
            g15.dispose();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage image2bufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g15 = bufferedImage.createGraphics();
        try {
            g15.drawImage(image, 0, 0, null);
        }
        finally {
            g15.dispose();
        }
        return bufferedImage;
    }
}

