/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.base;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseExceptionHandler
implements ExceptionHandler {
    public static final Comparator<ExceptionHandler> BY_EXCEPTION = new Comparator<ExceptionHandler>(){

        @Override
        public int compare(ExceptionHandler o15, ExceptionHandler o25) {
            String exceptionType1 = o15.getExceptionType();
            if (exceptionType1 == null) {
                if (o25.getExceptionType() != null) {
                    return 1;
                }
                return 0;
            }
            String exceptionType2 = o25.getExceptionType();
            if (exceptionType2 == null) {
                return -1;
            }
            return exceptionType1.compareTo(o25.getExceptionType());
        }
    };

    @Override
    @Nullable
    public TypeReference getExceptionTypeReference() {
        final String exceptionType = this.getExceptionType();
        if (exceptionType == null) {
            return null;
        }
        return new BaseTypeReference(){

            @Override
            @Nonnull
            public String getType() {
                return exceptionType;
            }
        };
    }

    @Override
    public int hashCode() {
        String exceptionType = this.getExceptionType();
        int hashCode = exceptionType == null ? 0 : exceptionType.hashCode();
        return hashCode * 31 + this.getHandlerCodeAddress();
    }

    @Override
    public boolean equals(@Nullable Object o15) {
        if (o15 instanceof ExceptionHandler) {
            ExceptionHandler other = (ExceptionHandler)o15;
            return Objects.equals(this.getExceptionType(), other.getExceptionType()) && this.getHandlerCodeAddress() == other.getHandlerCodeAddress();
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull ExceptionHandler o15) {
        String exceptionType = this.getExceptionType();
        if (exceptionType == null) {
            if (o15.getExceptionType() != null) {
                return 1;
            }
        } else {
            String otherExceptionType = o15.getExceptionType();
            if (otherExceptionType == null) {
                return -1;
            }
            int res = exceptionType.compareTo(o15.getExceptionType());
            if (res != 0) {
                return res;
            }
        }
        return Integer.compare(this.getHandlerCodeAddress(), o15.getHandlerCodeAddress());
    }
}

