/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceGroupConfig;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class DeviceGroupTargetingValidator
extends SubValidator {
    private static final ImmutableSet<String> NO_GROUPS = ImmutableSet.of();
    private static final Logger logger = Logger.getLogger(DeviceGroupTargetingValidator.class.getName());

    @Override
    public void validateBundle(AppBundle bundle) {
        Optional<DeviceGroupConfig> deviceGroupConfig = bundle.getDeviceGroupConfig();
        ImmutableSet<String> configGroups = deviceGroupConfig.map(dtc -> dtc.getDeviceGroupsList().stream().map(DeviceGroup::getName).collect(ImmutableSet.toImmutableSet())).orElse(NO_GROUPS);
        Optional<String> defaultDeviceGroup = bundle.getBundleConfig().getOptimizations().getSplitsConfig().getSplitDimensionList().stream().filter(d15 -> d15.getValue() == Config.SplitDimension.Value.DEVICE_GROUP).map(Config.SplitDimension::getSuffixStripping).map(Config.SuffixStripping::getDefaultSuffix).findFirst();
        if (defaultDeviceGroup.isPresent() && !configGroups.contains(defaultDeviceGroup.get())) {
            this.fail("The bundle config specified a default ", ImmutableSet.of(defaultDeviceGroup.get()), configGroups, deviceGroupConfig);
        }
        for (BundleModule module : bundle.getModules().values()) {
            ImmutableSet<String> moduleAssetGroups = TargetingUtils.extractDeviceGroups(TargetingUtils.extractAssetsTargetedDirectories(module));
            Targeting.DeviceGroupModuleTargeting moduleTargeting = module.getModuleMetadata().getTargeting().getDeviceGroupTargeting();
            ImmutableSet<String> undefinedGroups = Stream.concat(moduleAssetGroups.stream(), moduleTargeting.getValueList().stream()).filter(g15 -> !configGroups.contains(g15)).collect(ImmutableSet.toImmutableSet());
            if (undefinedGroups.isEmpty()) continue;
            this.fail(String.format("Module '%s' refers to ", module.getName()), undefinedGroups, configGroups, deviceGroupConfig);
        }
    }

    private void fail(String prefix, ImmutableSet<String> badGroups, ImmutableSet<String> configGroups, Optional<DeviceGroupConfig> deviceGroupConfig) {
        String bad = badGroups.size() == 1 ? String.format("device group %s which is not ", badGroups) : String.format("device groups %s which are not ", badGroups);
        String context = String.format("in the list %s defined in the bundle metadata.", configGroups);
        if (deviceGroupConfig.isPresent()) {
            throw InvalidBundleException.createWithUserMessage(prefix + bad + context);
        }
        logger.warning(prefix + bad + "defined. Please add DeviceGroupConfig.json to the bundle metadata.");
    }
}

