/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.LifecycleTrackingTestEventReporter;
import org.gradle.api.tasks.testing.GroupTestEventReporter;
import org.gradle.api.tasks.testing.TestEventReporter;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.jspecify.annotations.NullMarked;

@NullMarked
class LifecycleTrackingGroupTestEventReporter
extends LifecycleTrackingTestEventReporter<GroupTestEventReporter>
implements GroupTestEventReporter {
    private final Set<LifecycleTrackingTestEventReporter<?>> children = new HashSet();

    LifecycleTrackingGroupTestEventReporter(GroupTestEventReporter delegate) {
        super(delegate);
    }

    @Override
    protected void markCompleted() {
        for (LifecycleTrackingTestEventReporter<?> child : this.children) {
            if (child.isCompleted()) continue;
            throw new IllegalStateException(String.format("Group was completed before tests (%s).", child));
        }
        super.markCompleted();
    }

    @Override
    public void close() {
        super.close();
        CompositeStoppable.stoppable(this.children).stop();
        this.children.clear();
    }

    @Override
    public TestEventReporter reportTest(String name, String displayName) {
        LifecycleTrackingTestEventReporter<TestEventReporter> child = new LifecycleTrackingTestEventReporter<TestEventReporter>(((GroupTestEventReporter)this.delegate).reportTest(name, displayName));
        this.children.add(child);
        return child;
    }

    @Override
    public GroupTestEventReporter reportTestGroup(String name) {
        LifecycleTrackingGroupTestEventReporter child = new LifecycleTrackingGroupTestEventReporter(((GroupTestEventReporter)this.delegate).reportTestGroup(name));
        this.children.add(child);
        return child;
    }
}

