/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.SourceMapCopier;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class InlineAdapter
extends InstructionAdapter {
    private final SourceMapCopier sourceMapper;
    private final List<CatchBlock> blocks;
    private boolean isLambdaInlining;
    private int nextLocalIndex;
    private int nextLocalIndexBeforeInline;

    public InlineAdapter(@NotNull MethodVisitor mv2, int localsSize, @NotNull SourceMapCopier sourceMapper) {
        if (mv2 == null) {
            InlineAdapter.$$$reportNull$$$0(0);
        }
        if (sourceMapper == null) {
            InlineAdapter.$$$reportNull$$$0(1);
        }
        super(589824, mv2);
        this.blocks = new ArrayList<CatchBlock>();
        this.isLambdaInlining = false;
        this.nextLocalIndex = 0;
        this.nextLocalIndexBeforeInline = -1;
        this.nextLocalIndex = localsSize;
        this.sourceMapper = sourceMapper;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.updateIndex(var, 1);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.updateIndex(var, InlineCodegenUtilsKt.getLoadStoreArgSize(opcode));
    }

    private void updateIndex(int var, int varSize) {
        int newIndex = var + varSize;
        if (newIndex > this.nextLocalIndex) {
            this.nextLocalIndex = newIndex;
        }
    }

    public int getNextLocalIndex() {
        return this.nextLocalIndex;
    }

    public void setLambdaInlining(boolean isInlining) {
        this.isLambdaInlining = isInlining;
        if (isInlining) {
            this.nextLocalIndexBeforeInline = this.nextLocalIndex;
        } else {
            this.nextLocalIndex = this.nextLocalIndexBeforeInline;
        }
    }

    @Override
    public void visitTryCatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
        if (start == null) {
            InlineAdapter.$$$reportNull$$$0(2);
        }
        if (end == null) {
            InlineAdapter.$$$reportNull$$$0(3);
        }
        if (handler2 == null) {
            InlineAdapter.$$$reportNull$$$0(4);
        }
        if (!this.isLambdaInlining) {
            this.blocks.add(new CatchBlock(start, end, handler2, type2));
        } else {
            super.visitTryCatchBlock(start, end, handler2, type2);
        }
    }

    @Override
    public void visitLineNumber(int line, @NotNull Label start) {
        if (start == null) {
            InlineAdapter.$$$reportNull$$$0(5);
        }
        if ((line = this.sourceMapper.mapLineNumber(line)) >= 0) {
            super.visitLineNumber(line, start);
        }
    }

    @Override
    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMapper";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/InlineAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryCatchBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLineNumber";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        public CatchBlock(@NotNull Label start, @NotNull Label end, @NotNull Label handler2, @Nullable String type2) {
            if (start == null) {
                CatchBlock.$$$reportNull$$$0(0);
            }
            if (end == null) {
                CatchBlock.$$$reportNull$$$0(1);
            }
            if (handler2 == null) {
                CatchBlock.$$$reportNull$$$0(2);
            }
            this.start = start;
            this.end = end;
            this.handler = handler2;
            this.type = type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "start";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "end";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/inline/InlineAdapter$CatchBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

