/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PropertyDatabase {
    private final Set<String> inherited_properties;
    private final Map<String, Object> initialValueMap;
    private final ValueFactory valueFactory = new ValueFactory();
    private static final PropertyDatabase singleton = new PropertyDatabase();

    private PropertyDatabase() {
        this.inherited_properties = PropertyDatabase.computeInheritedPropertiesList();
        this.initialValueMap = this.createInitialValueMap();
    }

    public static PropertyDatabase getInstance() {
        return singleton;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public boolean isInherited(String name) {
        return this.inherited_properties.contains(name);
    }

    private static Set<String> computeInheritedPropertiesList() {
        String[] inherit = new String[]{"azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-feature-settings", "font-kerning", "font-language-override", "font-max-size", "font-min-size", "font-optical-sizing", "font-size", "font-size-adjust", "font-style", "font-stretch", "font-synthesis", "font-variant", "font-variant-alternates", "font-variant-caps", "font-variant-east-asian", "font-variant-numeric", "font-variant-position", "font-variation-settings", "font-weight", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "math-depth", "math-style", "orphans", "page-break-inside", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speak-as", "speech-rate", "stress", "text-align", "text-emphasis-color", "text-emphasis-position", "text-emphasis-style", "text-indent", "text-shadow", "text-transform", "text-underline-position", "visibility", "voice-balance", "voice-family", "voice-pitch", "voice-range", "voice-rate", "voice-stress", "voice-volume", "volume", "white-space", "widows", "word-spacing", "writing-mode"};
        HashSet<String> inheritSet = new HashSet<String>(inherit.length);
        Collections.addAll(inheritSet, inherit);
        return inheritSet;
    }

    public StyleValue getInitialValue(String propertyName) {
        StyleValue svalue;
        Object value = this.initialValueMap.get(propertyName);
        if (value != null && value.getClass() == String.class) {
            svalue = this.valueFactory.parseProperty((String)value);
            svalue.setReadOnly();
            this.initialValueMap.put(propertyName, svalue);
        } else {
            svalue = (StyleValue)value;
        }
        return svalue;
    }

    private Map<String, Object> createInitialValueMap() {
        String[][] initialArray = new String[][]{{"align-content", "normal"}, {"align-items", "normal"}, {"align-self", "auto"}, {"animation-name", "none"}, {"animation-duration", "0s"}, {"animation-timing-function", "ease"}, {"animation-iteration-count", "1"}, {"animation-direction", "normal"}, {"animation-play-state", "running"}, {"animation-delay", "0s"}, {"animation-fill-mode", "none"}, {"animation-timeline", "auto"}, {"animation-range-start", "normal"}, {"animation-range-end", "normal"}, {"animation-composition", "replace"}, {"appearance", "auto"}, {"azimuth", "center"}, {"background-attachment", "scroll"}, {"background-blend-mode", "normal"}, {"background-clip", "border-box"}, {"background-color", "transparent"}, {"background-image", "none"}, {"background-origin", "padding-box"}, {"background-position", "0% 0%"}, {"background-repeat", "repeat"}, {"background-size", "auto"}, {"border-collapse", "separate"}, {"border-spacing", "0"}, {"border-top-style", "none"}, {"border-right-style", "none"}, {"border-bottom-style", "none"}, {"border-left-style", "none"}, {"border-top-width", "medium"}, {"border-right-width", "medium"}, {"border-bottom-width", "medium"}, {"border-left-width", "medium"}, {"border-image-outset", "0"}, {"border-image-repeat", "stretch"}, {"border-image-slice", "100%"}, {"border-image-source", "none"}, {"border-image-width", "1"}, {"border-top-left-radius", "0"}, {"border-top-right-radius", "0"}, {"border-bottom-right-radius", "0"}, {"border-bottom-left-radius", "0"}, {"bottom", "auto"}, {"box-decoration-break", "slice"}, {"box-shadow", "none"}, {"caption-side", "top"}, {"caret-color", "auto"}, {"chains", "none"}, {"clear", "none"}, {"clip-path", "none"}, {"clip-rule", "nonzero"}, {"column-count", "auto"}, {"column-gap", "normal"}, {"column-width", "auto"}, {"column-rule-style", "none"}, {"column-rule-width", "medium"}, {"contain", "none"}, {"content", "normal"}, {"counter-increment", "none"}, {"counter-reset", "none"}, {"counter-set", "none"}, {"cue-after", "none"}, {"cue-before", "none"}, {"cursor", "auto"}, {"direction", "ltr"}, {"display", "inline"}, {"elevation", "level"}, {"empty-cells", "show"}, {"float", "none"}, {"flow", "auto"}, {"flex-direction", "row"}, {"flex-wrap", "nowrap"}, {"flex-grow", "0"}, {"flex-shrink", "1"}, {"flex-basis", "auto"}, {"font-feature-settings", "normal"}, {"font-language-override", "normal"}, {"font-min-size", "0"}, {"font-kerning", "auto"}, {"font-optical-sizing", "auto"}, {"font-size", "medium"}, {"font-size-adjust", "none"}, {"font-stretch", "normal"}, {"font-style", "normal"}, {"font-synthesis", "weight style"}, {"font-variant", "normal"}, {"font-variant-alternates", "normal"}, {"font-variant-caps", "normal"}, {"font-variant-east-asian", "normal"}, {"font-variant-ligatures", "normal"}, {"font-variant-position", "normal"}, {"font-variant-numeric", "normal"}, {"font-variation-settings", "normal"}, {"font-weight", "normal"}, {"grid-auto-columns", "auto"}, {"grid-auto-rows", "auto"}, {"grid-auto-flow", "row"}, {"grid-column-end", "auto"}, {"grid-column-start", "auto"}, {"grid-row-end", "auto"}, {"grid-row-start", "auto"}, {"grid-template-areas", "none"}, {"grid-template-columns", "none"}, {"grid-template-rows", "none"}, {"height", "auto"}, {"image-orientation", "0deg"}, {"image-resolution", "1dppx"}, {"isolation", "auto"}, {"justify-content", "normal"}, {"justify-items", "legacy"}, {"justify-self", "auto"}, {"left", "auto"}, {"letter-spacing", "normal"}, {"line-height", "normal"}, {"list-style-image", "none"}, {"list-style-position", "outside"}, {"list-style-type", "disc"}, {"margin-right", "0"}, {"margin-left", "0"}, {"margin-top", "0"}, {"margin-bottom", "0"}, {"margin-inline-start", "0"}, {"margin-inline-end", "0"}, {"mask-clip", "border-box"}, {"mask-composite", "add"}, {"mask-image", "none"}, {"mask-mode", "match-source"}, {"mask-origin", "border-box"}, {"mask-position", "0% 0%"}, {"mask-repeat", "repeat"}, {"mask-size", "auto"}, {"mask-border-mode", "alpha"}, {"mask-border-outset", "0"}, {"mask-border-repeat", "stretch"}, {"mask-border-slice", "0"}, {"mask-border-source", "none"}, {"mask-border-width", "auto"}, {"math-style", "normal"}, {"math-depth", "0"}, {"max-height", "none"}, {"max-width", "none"}, {"min-height", "0"}, {"min-width", "0"}, {"opacity", "1"}, {"orphans", "2"}, {"outline-color", "auto"}, {"outline-style", "none"}, {"outline-width", "medium"}, {"overflow", "visible"}, {"padding-top", "0"}, {"padding-right", "0"}, {"padding-bottom", "0"}, {"padding-left", "0"}, {"page", "auto"}, {"page-break-after", "auto"}, {"page-break-before", "auto"}, {"page-break-inside", "auto"}, {"pause-after", "0"}, {"pause-before", "0"}, {"pitch-range", "50"}, {"pitch", "medium"}, {"play-during", "auto"}, {"position", "static"}, {"quotes", "auto"}, {"resize", "none"}, {"rest-after", "0"}, {"rest-before", "0"}, {"richness", "50"}, {"right", "auto"}, {"rotate", "none"}, {"row-gap", "normal"}, {"scale", "none"}, {"speak-header", "once"}, {"speak-numeral", "continuous"}, {"speak-punctuation", "none"}, {"speak", "auto"}, {"speak-as", "normal"}, {"speech-rate", "medium"}, {"stress", "50"}, {"table-layout", "auto"}, {"text-decoration-line", "none"}, {"text-decoration-style", "solid"}, {"text-emphasis-style", "none"}, {"text-emphasis-position", "over right"}, {"text-indent", "0"}, {"text-transform", "none"}, {"text-shadow", "none"}, {"text-underline-position", "auto"}, {"top", "auto"}, {"transform", "none"}, {"transition-property", "all"}, {"transition-duration", "0s"}, {"transition-timing-function", "ease"}, {"transition-delay", "0s"}, {"translate", "none"}, {"unicode-bidi", "normal"}, {"unicode-range", "U+0-10FFFF"}, {"vertical-align", "baseline"}, {"visibility", "visible"}, {"voice-balance", "center"}, {"voice-duration", "auto"}, {"voice-family", "male"}, {"voice-pitch", "medium"}, {"voice-range", "medium"}, {"voice-rate", "normal"}, {"voice-stress", "normal"}, {"voice-volume", "medium"}, {"volume", "medium"}, {"white-space", "normal"}, {"widows", "2"}, {"width", "auto"}, {"will-change", "auto"}, {"word-spacing", "normal"}, {"writing-mode", "horizontal-tb"}, {"z-index", "auto"}};
        HashMap<String, Object> initialValueMap = new HashMap<String, Object>(initialArray.length);
        for (String[] iniTuple : initialArray) {
            initialValueMap.put(iniTuple[0], iniTuple[1]);
        }
        return initialValueMap;
    }

    public boolean isKnownProperty(String name) {
        return this.initialValueMap.containsKey(name);
    }

    Set<String> getKnownPropertySet() {
        return this.initialValueMap.keySet();
    }
}

