/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValueList;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.IdentValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSColor;
import org.w3c.css.om.typed.CSSStyleValueList;
import org.w3c.dom.DOMException;

public class ColorFunction
extends ColorValue
implements CSSColor {
    private static final long serialVersionUID = 1L;
    private IdentValue colorSpace;
    private AbstractValueList<NumericValue> channels;
    private static final Set<String> predefinedSpaces = new HashSet<String>(9);

    public ColorFunction(String string, CSSStyleValueList<NumericValue> cSSStyleValueList) throws DOMSyntaxException {
        this.colorSpace = new IdentValue(ColorFunction.canonicalName(string));
        this.componentize(this.colorSpace);
        this.componentizeChannels(cSSStyleValueList);
    }

    private void componentizeChannels(CSSStyleValueList<NumericValue> cSSStyleValueList) {
        boolean bl = cSSStyleValueList instanceof AbstractValue && ((AbstractValue)cSSStyleValueList).handler != null;
        int n = cSSStyleValueList.getLength();
        this.channels = new AbstractValueList(' ', n);
        for (NumericValue numericValue : cSSStyleValueList) {
            if (bl) {
                numericValue = numericValue.clone();
            }
            this.channels.add(this.numericComponent(numericValue));
        }
        this.componentize(this.channels);
    }

    public IdentValue getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public String getCSSColorSpace() {
        return this.colorSpace.getValue();
    }

    public void setColorSpace(String string) {
        this.colorSpace.setValue(ColorFunction.canonicalName(string));
        this.componentChanged(this.colorSpace);
    }

    static String canonicalName(String string) throws DOMException {
        if (!predefinedSpaces.contains(string = string.toLowerCase(Locale.ROOT).intern())) {
            throw new DOMException(9, "Unsupported color space: " + string);
        }
        return string;
    }

    public CSSStyleValueList<NumericValue> getChannels() {
        return this.channels;
    }

    @Override
    public int getLength() throws DOMException {
        return this.channels.getLength() + 2;
    }

    @Override
    public Value item(int n) throws DOMException {
        if (n == 0) {
            return this.getColorSpace();
        }
        if (n == this.channels.getLength() + 1) {
            return this.getAlpha();
        }
        return this.channels.item(n - 1);
    }

    @Override
    public ColorFunction getColorValue() {
        return this;
    }

    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder(15 + this.colorSpace.value.length() + this.channels.getLength() * 8);
        stringBuilder.append("color(").append(this.colorSpace.getCssText());
        Iterator<NumericValue> iterator = this.channels.iterator();
        while (iterator.hasNext()) {
            NumericValue numericValue = iterator.next();
            stringBuilder.append(' ').append(numericValue.getCssText());
        }
        if (!this.isOpaque()) {
            stringBuilder.append(" / ").append(this.getAlpha().getCssText());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private NumericValue numericComponent(NumericValue numericValue) throws DOMSyntaxException {
        if (numericValue.getUnitType() != 2 && numericValue.getUnitType() != 0) {
            throw new DOMSyntaxException("color() component must be a number or percentage.");
        }
        this.componentize(numericValue);
        return numericValue;
    }

    @Override
    public ColorFunction clone() {
        ColorFunction colorFunction;
        try {
            colorFunction = new ColorFunction(this.getColorSpace().getValue(), this.channels);
        }
        catch (DOMSyntaxException dOMSyntaxException) {
            colorFunction = null;
        }
        return colorFunction;
    }

    static {
        predefinedSpaces.add("srgb");
        predefinedSpaces.add("srgb-linear");
        predefinedSpaces.add("a98-rgb");
        predefinedSpaces.add("display-p3");
        predefinedSpaces.add("prophoto-rgb");
        predefinedSpaces.add("rec2020");
        predefinedSpaces.add("xyz");
        predefinedSpaces.add("xyz-d50");
        predefinedSpaces.add("xyz-d65");
    }
}

