/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import org.w3c.dom.DOMException;

public class RGBColorValue
extends ColorValue {
    private static final long serialVersionUID = 1L;
    private final RGBColor color;

    RGBColorValue() {
        this.color = new ColorValue.CSSRGBColor();
    }

    RGBColorValue(RGBColor rGBColor) {
        this.color = rGBColor;
    }

    protected RGBColorValue(RGBColorValue rGBColorValue) {
        super(rGBColorValue);
        this.color = rGBColorValue.color.clone();
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        BaseColor baseColor = (BaseColor)((ColorValue)styleValue).getColor();
        this.color.set(baseColor);
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.RGB;
    }

    @Override
    public RGBAColor getColor() {
        return this.color;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        if (this.color.getRed() == null || this.color.getGreen() == null || this.color.getBlue() == null) {
            throw new DOMException(11, "Color not set");
        }
        return this.color;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        LABColorValue lABColorValue = new LABColorValue();
        this.color.toLABColor(lABColorValue.getLABColorImpl());
        return lABColorValue;
    }

    @Override
    public HSLColorValue toHSLColorValue() throws DOMException {
        if (!this.color.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        HSLColorValue hSLColorValue = new HSLColorValue();
        this.color.toHSLColor(hSLColorValue.getHSLColorImpl());
        return hSLColorValue;
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.color.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.color.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.color.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        LABColor lABColor;
        LABColor lABColor2;
        if (!this.color.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LCH: 
            case LAB: {
                return cSSColorValue.deltaE2000(this);
            }
            case RGB: {
                lABColor2 = this.toLABColorValue().getColor();
                RGBColor rGBColor = (RGBColor)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                rGBColor.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            case XYZ: {
                lABColor2 = this.toLABColorValue().getColor();
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xYZColorImpl.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                RGBColorValue rGBColorValue = new RGBColorValue();
                rGBColorValue.setComponent(0, (StyleValue)((Object)rGBAColor.getAlpha()));
                rGBColorValue.setComponent(1, (StyleValue)((Object)rGBAColor.getRed()));
                rGBColorValue.setComponent(2, (StyleValue)((Object)rGBAColor.getGreen()));
                rGBColorValue.setComponent(3, (StyleValue)((Object)rGBAColor.getBlue()));
                lABColor = rGBColorValue.toLABColorValue().getColor();
                lABColor2 = this.toLABColorValue().getColor();
            }
        }
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)lABColor2.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor2.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor2.getB()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.color == null ? 0 : this.color.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RGBColorValue rGBColorValue = (RGBColorValue)object;
        return this.color.equals(rGBColorValue.color);
    }

    @Override
    public RGBColorValue clone() {
        return new RGBColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.RGBCOLOR) {
                    throw new DOMException(13, "No rgb() value: " + lexicalUnit.toString());
                }
                this.setLexicalRGB(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalRGB(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RGBColorValue.this.color.setRed(primitiveValue);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            RGBColorValue.this.commaSyntax = lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA;
            if (RGBColorValue.this.commaSyntax) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RGBColorValue.this.color.setGreen(primitiveValue);
            if (RGBColorValue.this.commaSyntax) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            RGBColorValue.this.color.setBlue(primitiveValue);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                if (!RGBColorValue.this.commaSyntax && primitiveValue2.getUnitType() == 0 && primitiveValue.getUnitType() == 0) {
                    ((NumberValue)primitiveValue2).setAbsolutizedUnit();
                }
                RGBColorValue.this.color.setAlpha(primitiveValue2);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
        }
    }
}

