/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeUint8ClampedArray
extends NativeTypedArrayView<Integer> {
    private static final long serialVersionUID = -3349419704390398895L;
    private static final String CLASS_NAME = "Uint8ClampedArray";

    public NativeUint8ClampedArray() {
    }

    public NativeUint8ClampedArray(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2);
    }

    public NativeUint8ClampedArray(int n) {
        this(new NativeArrayBuffer(n), 0, n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeUint8ClampedArray nativeUint8ClampedArray = new NativeUint8ClampedArray();
        IdFunctionObject idFunctionObject = nativeUint8ClampedArray.exportAsJSClass(7, scriptable, bl);
        ScriptRuntimeES6.addSymbolSpecies(context, scriptable, idFunctionObject);
    }

    protected NativeUint8ClampedArray construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeUint8ClampedArray(nativeArrayBuffer, n, n2);
    }

    @Override
    public int getBytesPerElement() {
        return 1;
    }

    protected NativeUint8ClampedArray realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeUint8ClampedArray.ensureType(scriptable, NativeUint8ClampedArray.class, idFunctionObject);
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        return ByteIo.readUint8(this.arrayBuffer.buffer, n + this.offset);
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        int n2 = Conversions.toUint8Clamp(object);
        ByteIo.writeUint8(this.arrayBuffer.buffer, n + this.offset, n2);
        return null;
    }

    @Override
    public Integer get(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_get(n);
    }

    @Override
    public Integer set(int n, Integer n2) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_set(n, n2);
    }
}

