/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;

public class OutlineEdgeView
extends EdgeView {
    public OutlineEdgeView(NodeView source, NodeView target, Component paintedComponent) {
        super(source, target, paintedComponent);
    }

    @Override
    public boolean detectCollision(Point p) {
        return false;
    }

    @Override
    protected void createStart() {
        this.start = this.getSource().getMainView().getLeftPoint();
        this.end = this.getTarget().getMainView().getLeftPoint();
    }

    @Override
    protected void draw(Graphics2D g) {
        Color color = this.getColor(g);
        g.setColor(color);
        Stroke stroke = this.getStroke();
        g.setStroke(stroke);
        g.drawLine(this.start.x, this.start.y, this.start.x, this.end.y);
        g.drawLine(this.start.x, this.end.y, this.end.x, this.end.y);
        if (this.getTarget().isSummary()) {
            int gap = this.getWidth();
            int y1 = this.end.y + gap * 13 / 8;
            g.drawLine(this.start.x, this.start.y, this.start.x, y1);
            int x2 = this.end.x;
            if (NodeStyleShape.fork.equals((Object)this.getTarget().getMainView().getShapeConfiguration().getShape())) {
                x2 += this.getTarget().getContent().getWidth();
            }
            g.drawLine(this.start.x, y1, x2, y1);
        }
    }

    @Override
    protected Stroke getStroke() {
        NodeView nodeView = this.getTarget();
        MainView mainView = nodeView.getMainView();
        float nodeLineWidth = mainView.getUnzoomedEdgeWidth();
        float zoomedLineWidth = nodeView.getMap().getZoom() * nodeLineWidth;
        float strokeWidth = Math.max(zoomedLineWidth, 1.0f);
        return this.getStroke(strokeWidth);
    }
}

