/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Collection;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;

public class MindMapNodesSelection
implements Transferable,
ClipboardOwner {
    public static DataFlavor dropActionFlavor = null;
    public static DataFlavor fileListFlavor = null;
    public static DataFlavor htmlFlavor = null;
    public static DataFlavor mindMapNodesFlavor = null;
    public static DataFlavor mindMapNodeObjectsFlavor = null;
    public static DataFlavor mindMapNodeSingleObjectsFlavor = null;
    private final String htmlContent;
    private final String nodesContent;
    private final String stringContent;
    private Integer dropActionContent;
    private Collection<NodeModel> nodes;
    private boolean selectionContainsSingleNodes;

    public MindMapNodesSelection(String nodesContent, String stringContent, String htmlContent) {
        this.nodesContent = nodesContent;
        this.stringContent = stringContent;
        this.htmlContent = htmlContent;
        this.dropActionContent = null;
    }

    public MindMapNodesSelection(String nodesContent) {
        this(nodesContent, null, null);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.stringContent;
        }
        if (flavor.equals(mindMapNodesFlavor)) {
            return this.nodesContent;
        }
        if (flavor.equals(dropActionFlavor)) {
            return this.dropActionContent;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return this.htmlContent;
        }
        if (this.containsObjectsFor(flavor)) {
            return this.nodes;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    boolean containsObjectsFor(DataFlavor flavor) {
        return this.nodes != null && (flavor.equals(mindMapNodeObjectsFlavor) && !this.selectionContainsSingleNodes || flavor.equals(mindMapNodeSingleObjectsFlavor) && this.selectionContainsSingleNodes);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor, mindMapNodesFlavor, htmlFlavor, dropActionFlavor, mindMapNodeObjectsFlavor, mindMapNodeSingleObjectsFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.stringFlavor) && this.stringContent != null) {
            return true;
        }
        if (flavor.equals(mindMapNodesFlavor) && this.nodesContent != null) {
            return true;
        }
        if (flavor.equals(dropActionFlavor) && this.dropActionContent != null) {
            return true;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return true;
        }
        return this.containsObjectsFor(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDropAction(Integer dropActionContent) {
        this.dropActionContent = dropActionContent;
    }

    public void setNodeObjects(Collection<NodeModel> collection, boolean selectionContainsSingleNodes) {
        this.nodes = collection;
        this.selectionContainsSingleNodes = selectionContainsSingleNodes;
    }

    static {
        try {
            mindMapNodesFlavor = new DataFlavor("text/freeplane-nodes; class=java.lang.String");
            mindMapNodeObjectsFlavor = new DataFlavor("application/freeplane-nodes; class=java.util.Collection");
            mindMapNodeSingleObjectsFlavor = new DataFlavor("application/freeplane-single-nodes; class=java.util.Collection");
            htmlFlavor = new DataFlavor("text/html; class=java.lang.String");
            fileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List");
            dropActionFlavor = new DataFlavor("application/freeplane-drop-action; class=java.lang.Integer");
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }
}

