/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.api.Dash;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.MultipleImageIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.FollowLinkAction;
import org.freeplane.features.link.GotoLinkNodeAction;
import org.freeplane.features.link.LinkBuilder;
import org.freeplane.features.link.LinkConditionController;
import org.freeplane.features.link.LinkMenuBuilder;
import org.freeplane.features.link.LinkTransformer;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.icons.NodeViewDecorator;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.SelectionController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.url.UrlManager;

public class LinkController
extends SelectionController
implements IExtension {
    public static final String MENUITEM_SCHEME = "menuitem";
    public static final String EXECUTE_APP_SCHEME = "execute";
    protected final ModeController modeController;
    private static final String FILE_PROTOCOL = "file:";
    protected static final String CANCEL = "CANCEL";
    protected static final String CLOSE = "CLOSE";
    public static final String RESOURCES_LINK_COLOR = "connector_color_default";
    private static final String RESOURCES_CONNECTOR_SHAPE = "connector_shape_default";
    private static final String RESOURCES_CONNECTOR_ARROWS = "connector_arrows_default";
    private static final String RESOURCES_DASH_VARIANT = "connector_dash_default";
    private static final String RESOURCES_CONNECTOR_COLOR_ALPHA = "connector_alpha_default";
    private static final String RESOURCES_CONNECTOR_WIDTH = "connector_width_default";
    public static final int LINK_ABSOLUTE = 0;
    public static final int LINK_RELATIVE_TO_MINDMAP = 1;
    static Pattern patSMB = Pattern.compile("(?:\\\\\\\\([^\\\\]+)\\\\)(.*?)(?:#([^#]*))?");
    static Pattern patFile = Pattern.compile("(?:file:)?((?:\\p{Alpha}:)?([/\\\\])?(?:[^:#?]*))?(?:#([^#]*))?");
    static Pattern patURI = Pattern.compile("(?:(\\p{Alpha}[\\p{Alnum}+.-]+):)?(.*?)(?:#([^#]*))?");
    private static final Pattern FILE_URL_PATTERN = Pattern.compile("file://[^\\s\"'<>]+|(:?https?|ftp)://[^\\s\"|<>{}]+");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("([!+\\-/=~.\\w#]+@[\\w.\\-+?&=%]+)");
    private static final HashMap<String, Icon> menuItemCache = new HashMap();
    private static final String MENUITEM_ICON = "menuitem_icon";
    private static final String EXECUTABLE_ICON = "executable_icon";
    private static final String LINK_ICON = "link_icon";
    private static final String MAIL_ICON = "mail_icon";
    private static final String LINK_LOCAL_ICON = "link_local_icon";
    private static final String DECORATED_MENUITEM_ICON = "menuitem_icon";
    private static final String DECORATED_EXECUTABLE_ICON = "executable_icon";
    private static final String DECORATED_LINK_ICON = "decorated_link_icon";
    private static final String DECORATED_MAIL_ICON = "decorated_mail_icon";
    private static final String DECORATED_LINK_LOCAL_ICON = "decorated_link_local_icon";

    public static LinkController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LinkController.getController(modeController);
    }

    public static LinkController getController(ModeController modeController) {
        return modeController.getExtension(LinkController.class);
    }

    public static void install() {
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(30, new LinkConditionController());
    }

    public static void install(LinkController linkController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LinkController.class, linkController);
        linkController.init();
    }

    public LinkController(ModeController modeController) {
        this.modeController = modeController;
    }

    public Hyperlink toLink(NodeModel node, Object object) {
        if (object instanceof Hyperlink) {
            return (Hyperlink)object;
        }
        if (object instanceof String) {
            try {
                String string = (String)object;
                if (string.startsWith("#")) {
                    String reference = string.substring(1);
                    MapExplorerController explorer = this.modeController.getExtension(MapExplorerController.class);
                    NodeModel dest = explorer.getNodeAt(node, reference);
                    if (dest != null) {
                        return LinkController.createHyperlink(string);
                    }
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return LinkController.toHyperlink(object);
    }

    private static Hyperlink toHyperlink(Object object) {
        if (object instanceof Hyperlink) {
            return (Hyperlink)object;
        }
        if (object instanceof URI) {
            return new Hyperlink((URI)object);
        }
        if (!(object instanceof File)) {
            if (object instanceof URL) {
                try {
                    return new Hyperlink(((URL)object).toURI());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return null;
        }
        String objectAsFileReference = FILE_PROTOCOL + ((File)object).getPath();
        try {
            return LinkController.createHyperlink(objectAsFileReference);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void init() {
        this.createActions();
        MapController mapController = this.modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        LinkBuilder linkBuilder = new LinkBuilder(this);
        linkBuilder.registerBy(readManager);
        LinkTransformer textTransformer = new LinkTransformer(this.modeController, 10);
        TextController.getController(this.modeController).addTextTransformer(textTransformer);
        INodeSelectionListener listener = new INodeSelectionListener(){

            @Override
            public void onDeselect(NodeModel node) {
            }

            @Override
            public void onSelect(NodeModel node) {
                String linkString;
                Hyperlink link = NodeLinks.getValidLink(node);
                String string = linkString = link != null ? link.toString() : null;
                if (linkString != null) {
                    Controller.getCurrentController().getViewController().out(linkString);
                }
            }
        };
        Controller.getCurrentModeController().getMapController().addNodeSelectionListener(listener);
    }

    private JButton addLinks(JComponent arrowLinkPopup, NodeModel source) {
        GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(this, source);
        gotoLinkNodeAction.configureText("follow_graphical_link", source);
        return this.addAction(arrowLinkPopup, gotoLinkNodeAction);
    }

    protected void addPopupComponent(JComponent arrowLinkPopup, String label, JComponent component) {
        JComponent componentBox;
        if (label != null) {
            componentBox = Box.createHorizontalBox();
            componentBox.add(Box.createHorizontalStrut(10));
            JLabel jlabel = new JLabel(label);
            componentBox.add(jlabel);
            componentBox.add(Box.createHorizontalStrut(10));
            componentBox.add(component);
        } else {
            componentBox = component;
        }
        componentBox.setAlignmentX(0.0f);
        componentBox.setMinimumSize(new Dimension());
        componentBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        arrowLinkPopup.add(componentBox);
    }

    protected void addClosingAction(final JComponent arrowLinkPopup, Action action) {
        JButton comp = this.addAction(arrowLinkPopup, action);
        comp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(arrowLinkPopup).setVisible(false);
            }
        });
    }

    protected JButton addAction(JComponent arrowLinkPopup, Action action) {
        JButton comp = new JButton(action);
        comp.setHorizontalAlignment(2);
        this.addPopupComponent(arrowLinkPopup, null, comp);
        return comp;
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction(new FollowLinkAction());
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "clone_actions", new ClonesMenuBuilder(modeController), new ChildActionEntryRemover(modeController));
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "link_actions", new LinkMenuBuilder(modeController, this), new ChildActionEntryRemover(modeController));
    }

    protected void createArrowLinkPopup(ConnectorModel link, JComponent arrowLinkPopup) {
        this.registerCloseActions(arrowLinkPopup);
        NodeModel source = link.getSource();
        NodeModel target = link.getTarget();
        if (source != target) {
            IMapSelection selection = Controller.getCurrentModeController().getController().getSelection();
            final JButton sourceButton = this.addLinks(arrowLinkPopup, source);
            sourceButton.setEnabled(!selection.isSelected(source));
            final JButton targetButton = this.addLinks(arrowLinkPopup, target);
            targetButton.setEnabled(!selection.isSelected(target));
            sourceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    sourceButton.setEnabled(false);
                    targetButton.setEnabled(true);
                }
            });
            targetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    targetButton.setEnabled(false);
                    sourceButton.setEnabled(true);
                }
            });
        }
    }

    private void registerCloseActions(final JComponent arrowLinkPopup) {
        arrowLinkPopup.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (arrowLinkPopup.isDisplayable()) {
                    arrowLinkPopup.removeHierarchyListener(this);
                    JRootPane rootPane = arrowLinkPopup.getRootPane();
                    InputMap inputMap = rootPane.getInputMap(1);
                    ActionMap actionMap = rootPane.getActionMap();
                    ClosePopupAction closeAction = new ClosePopupAction(LinkController.CLOSE);
                    ClosePopupAction cancelAction = new ClosePopupAction(LinkController.CANCEL);
                    inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
                    actionMap.put(cancelAction, cancelAction);
                    inputMap.put(KeyStroke.getKeyStroke(10, 64), closeAction);
                    inputMap.put(KeyStroke.getKeyStroke(10, 0), closeAction);
                    actionMap.put(closeAction, closeAction);
                }
            }
        });
    }

    private <T> T getProperty(ConnectorModel connector, Function<ConnectorModel, Optional<T>> connectorFunction, Supplier<T> defaultValue) {
        Optional<T> styleProperty;
        NodeModel styleNode;
        Optional<T> ownValue = connectorFunction.apply(connector);
        if (ownValue.isPresent()) {
            return ownValue.get();
        }
        if (MapStyleModel.isDefaultStyleNode(connector.getSource())) {
            return defaultValue.get();
        }
        IStyle style = connector.getStyle();
        MapModel map = connector.getSource().getMap();
        MapStyleModel mapStyles = MapStyleModel.getExtension(map);
        if (!MapStyleModel.DEFAULT_STYLE.equals(style) && (styleNode = mapStyles.getStyleNode(style)) != null && (styleProperty = NodeLinks.getSelfConnector(styleNode).flatMap(connectorFunction)).isPresent()) {
            return styleProperty.get();
        }
        NodeModel defaultStyleNode = mapStyles.getDefaultStyleNode();
        return NodeLinks.getSelfConnector(defaultStyleNode).flatMap(connectorFunction).orElseGet(defaultValue);
    }

    public Color getColor(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getColor, this::getStandardConnectorColor);
    }

    public Color getLabelColor(ConnectorModel connector) {
        return null;
    }

    public int getLabelFontStyle(ConnectorModel connector) {
        return 0;
    }

    public int[] getDashArray(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getDash, this::getStandardDashArray);
    }

    public int getWidth(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getWidth, this::getStandardConnectorWidth);
    }

    public int getOpacity(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getAlpha, this::getStandardConnectorOpacity);
    }

    public String getMiddleLabel(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getMiddleLabel, () -> "");
    }

    public String getSourceLabel(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getSourceLabel, () -> "");
    }

    public String getTargetLabel(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getTargetLabel, () -> "");
    }

    public String getLabelFontFamily(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getLabelFontFamily, this::getStandardLabelFontFamily);
    }

    public int getLabelFontSize(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getLabelFontSize, this::getStandardLabelFontSize);
    }

    public ConnectorShape getShape(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getShape, this::getStandardConnectorShape);
    }

    public ConnectorArrows getArrows(ConnectorModel connector) {
        return this.getProperty(connector, ConnectorModel::getArrows, this::getStandardConnectorArrows);
    }

    public String getLinkShortText(NodeModel node) {
        Hyperlink link = NodeLinks.getLink(node);
        if (link == null) {
            return null;
        }
        String adaptedText = link.toString();
        if (adaptedText.startsWith("#")) {
            String reference;
            MapExplorerController explorer = this.modeController.getExtension(MapExplorerController.class);
            NodeModel dest = explorer.getNodeAt(node, reference = adaptedText.substring(1));
            if (dest != null) {
                return TextController.getController(this.modeController).getShortPlainText(dest);
            }
            return TextUtils.format(reference.startsWith("ID") ? "link_not_available_any_more" : "invalid_or_ambiguous_reference", reference);
        }
        return adaptedText;
    }

    public boolean hasNodeLinks(MapModel map, JComponent component) {
        return null != component.getClientProperty(Connectors.class) || MapLinks.hasLinks(map);
    }

    public Collection<? extends NodeLinkModel> getLinksTo(NodeModel node, Configurable component) {
        Connectors connectors = (Connectors)component.getClientProperty(Connectors.class);
        if (connectors != null) {
            return connectors.getLinksTo(node);
        }
        return this.getLinksTo(node);
    }

    public Collection<? extends NodeLinkModel> getLinksFrom(NodeModel node, Configurable component) {
        Connectors connectors = (Connectors)component.getClientProperty(Connectors.class);
        if (connectors != null) {
            return connectors.getLinksFrom(node);
        }
        return this.getLinksFrom(node);
    }

    private Collection<NodeLinkModel> getLinksFrom(NodeModel node) {
        return NodeLinks.getLinks(node);
    }

    private Collection<NodeLinkModel> getLinksTo(NodeModel target) {
        if (!target.hasID()) {
            return Collections.emptySet();
        }
        MapLinks links = target.getMap().getExtension(MapLinks.class);
        if (links == null) {
            return Collections.emptySet();
        }
        Collection<NodeLinkModel> clonedLinks = null;
        for (NodeModel targetClone : target.subtreeClones()) {
            Set<NodeLinkModel> set = links.get(targetClone.createID());
            if (set == null) continue;
            if (target.subtreeClones().size() == 1) {
                return set;
            }
            if (clonedLinks == null) {
                clonedLinks = new ArrayList(10);
            }
            for (NodeLinkModel sharedLink : set) {
                Collection<NodeLinkModel> linkClones = sharedLink.clones();
                for (NodeLinkModel linkClone : linkClones) {
                    if (!target.equals(linkClone.getTarget())) continue;
                    ((ArrayList)clonedLinks).add(linkClone);
                }
            }
        }
        return clonedLinks != null ? clonedLinks : Collections.emptySet();
    }

    public Component getPopupForModel(Object obj) {
        if (obj instanceof ConnectorModel) {
            ConnectorModel link = (ConnectorModel)obj;
            Box arrowLinkPopup = Box.createVerticalBox();
            arrowLinkPopup.setName(TextUtils.getText("connector"));
            this.createArrowLinkPopup(link, arrowLinkPopup);
            return arrowLinkPopup;
        }
        return null;
    }

    public void loadLink(NodeModel node, String link) {
        NodeLinks links = NodeLinks.getLinkExtension(node);
        if (links == null) {
            links = NodeLinks.createLinkExtension(node);
        }
        if (link != null && link.startsWith("#")) {
            links.setLocalHyperlink(node, link.substring(1));
        } else {
            try {
                if (link.startsWith("\"") && link.endsWith("\"")) {
                    link = link.substring(1, link.length() - 1);
                }
                Hyperlink hyperlink = LinkController.createHyperlink(link);
                links.setHyperLink(hyperlink);
            }
            catch (URISyntaxException e1) {
                LogUtils.warn(e1);
                UITools.errorMessage(TextUtils.format("link_error", link));
                return;
            }
        }
    }

    void loadLinkFormat(NodeModel node, boolean enabled) {
        NodeLinks.createLinkExtension(node).setFormatNodeAsHyperlink(enabled);
    }

    public void loadURL(NodeModel node, MouseEvent e) {
        this.loadURL(node, new ActionEvent(e.getSource(), e.getID(), null));
    }

    public void loadURL(MouseEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        this.loadURL(modeController.getMapController().getSelectedNode(), e);
    }

    public void loadHyperlink(Hyperlink link) {
        UrlManager.getController().loadHyperlink(link);
    }

    public void loadMap(String map) throws URISyntaxException {
        UrlManager.getController().loadMap(map);
    }

    protected void loadURL(NodeModel selectedNode, ActionEvent e) {
        this.loadURL(selectedNode, e, NodeLinks.getValidLink(selectedNode));
    }

    public void loadURL(NodeModel selectedNode, ActionEvent e, Hyperlink link) {
        if (link != null) {
            this.onDeselect(selectedNode);
            ModeController modeController = Controller.getCurrentModeController();
            if (LinkController.isMenuItemLink(link)) {
                if (e == null) {
                    throw new IllegalArgumentException("ActionEvent is needed for menu item links");
                }
                String actionKey = LinkController.parseSpecialLink(link);
                AFreeplaneAction action = modeController.getAction(actionKey);
                if (action != null) {
                    action.actionPerformed(e);
                } else {
                    LogUtils.warn("Trying to call a menu hyperlink action with key '" + actionKey + "'that doesn't exist.");
                }
            } else if (LinkController.isSpecialLink(EXECUTE_APP_SCHEME, link)) {
                String command = LinkController.parseSpecialLink(link);
                Object[] commandArray = command.split(" +(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                int i = 0;
                for (String string : commandArray) {
                    if (!string.startsWith("\"") || !string.endsWith("\"")) continue;
                    commandArray[i++] = string.replaceAll("(^\"|\"$)", "");
                }
                try {
                    Controller.getCurrentController().getViewController().out(command);
                    Runtime.getRuntime().exec((String[])commandArray);
                }
                catch (IOException e1) {
                    String msg = "execute: " + Arrays.toString(commandArray) + " - " + e1.getMessage();
                    Controller.getCurrentController().getViewController().out(msg);
                }
            } else {
                this.loadURI(selectedNode, link);
            }
            IMapSelection selection = modeController.getController().getSelection();
            if (selection != null) {
                this.onSelect(selection.getSelected());
            }
        }
    }

    public static int getLinkType() {
        return LinkController.getController().linkType();
    }

    public int linkType() {
        String linkTypeProperty = ResourceController.getResourceController().getProperty("links");
        if ("relative".equals(linkTypeProperty)) {
            return 1;
        }
        return 0;
    }

    public static URI toLinkTypeDependantURI(File map, File input) {
        int type = LinkController.getLinkType();
        if (type == 0) {
            return input.getAbsoluteFile().toURI();
        }
        return LinkController.toRelativeURI(map, input, type);
    }

    public static URI toLinkTypeDependantURI(File map, File input, int linkType) {
        return LinkController.toRelativeURI(map, input, linkType);
    }

    public static URI toRelativeURI(File map, File input, int linkType) {
        return LinkController.getController().createRelativeURI(map, input, linkType);
    }

    public static URI normalizeURI(URI uri) {
        String UNC_PREFIX = "//";
        URI normalizedUri = uri.normalize();
        String normalizedPath = normalizedUri.getPath();
        if ("file".equalsIgnoreCase(uri.getScheme()) && uri.getPath() != null && uri.getPath().startsWith("//") && (normalizedPath == null || !normalizedPath.startsWith("//"))) {
            try {
                normalizedUri = new URI(normalizedUri.getScheme(), LinkController.ensureUNCPath(normalizedUri.getSchemeSpecificPart()), normalizedUri.getFragment());
            }
            catch (URISyntaxException e) {
                LogUtils.warn(e);
            }
        }
        return normalizedUri;
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuffer result = new StringBuffer(len);
        for (int i = 0; i < 4; ++i) {
            if (i < len && result.length() <= 0 && path.charAt(i) == '/') continue;
            result.append('/');
        }
        result.append(path);
        return result.toString();
    }

    public URI createRelativeURI(File mapFile, File target, int linkType) {
        if (linkType == 0) {
            return null;
        }
        URI fileUri = target.getAbsoluteFile().toURI();
        return this.createRelativeURI(mapFile, fileUri);
    }

    public URI createRelativeURI(File mapFile, URI targetUri) {
        if (mapFile != null) {
            URI mapUri = mapFile.getAbsoluteFile().toURI();
            return this.createRelativeURI(mapUri, targetUri);
        }
        return targetUri;
    }

    public URI createRelativeURI(URI mapUri, URI targetUri) {
        boolean isUNCmap;
        boolean isUNCinput = targetUri.getPath().startsWith("//");
        if (isUNCinput != (isUNCmap = mapUri.getPath().startsWith("//"))) {
            return targetUri;
        }
        String filePathAsString = targetUri.getRawPath();
        String mapPathAsString = mapUri.getRawPath();
        int lastIndexOfSeparatorInMapPath = mapPathAsString.lastIndexOf("/");
        int lastIndexOfSeparatorInFilePath = filePathAsString.lastIndexOf("/");
        int lastCommonSeparatorPos = -1;
        for (int differencePos = 0; differencePos <= lastIndexOfSeparatorInMapPath && differencePos <= lastIndexOfSeparatorInFilePath && filePathAsString.charAt(differencePos) == mapPathAsString.charAt(differencePos); ++differencePos) {
            if (filePathAsString.charAt(differencePos) != '/') continue;
            lastCommonSeparatorPos = differencePos;
        }
        if (lastCommonSeparatorPos < 0) {
            return targetUri;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = lastCommonSeparatorPos + 1; i <= lastIndexOfSeparatorInMapPath; ++i) {
            if (mapPathAsString.charAt(i) != '/') continue;
            relativePath.append("../");
        }
        relativePath.append(filePathAsString.substring(lastCommonSeparatorPos + 1));
        String rawFragment = targetUri.getRawFragment();
        if (rawFragment != null) {
            relativePath.append("#" + rawFragment);
        }
        if (relativePath.length() == 0) {
            relativePath.append(".");
        }
        try {
            return new URI(relativePath.toString());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Hyperlink createHyperlink(String inputValue) throws URISyntaxException {
        try {
            return new Hyperlink(inputValue, new URI(inputValue));
        }
        catch (URISyntaxException e) {
            Matcher mat = patSMB.matcher(inputValue);
            if (mat.matches()) {
                String scheme = "smb";
                String ssp = "//" + mat.group(1) + "/" + mat.group(2).replace('\\', '/');
                String fragment = mat.group(3);
                return new Hyperlink(new URI("smb", ssp, fragment));
            }
            mat = patFile.matcher(inputValue);
            if (mat.matches()) {
                String ssp = mat.group(1);
                if (File.separatorChar != '/') {
                    ssp = ssp.replace(File.separatorChar, '/');
                }
                String fragment = mat.group(3);
                if (mat.group(2) == null) {
                    return new Hyperlink(new URI(null, null, ssp, fragment));
                }
                String scheme = "file";
                if (ssp.startsWith("//")) {
                    ssp = "//" + ssp;
                } else if (!ssp.startsWith("/")) {
                    ssp = "/" + ssp;
                }
                return new Hyperlink(new URI("file", null, ssp, fragment));
            }
            mat = patURI.matcher(inputValue);
            if (mat.matches()) {
                String scheme = mat.group(1);
                String ssp = mat.group(2).replace('\\', '/');
                String fragment = mat.group(3);
                return new Hyperlink(inputValue, new URI(scheme, ssp, fragment));
            }
            throw new URISyntaxException(inputValue, "This doesn't look like a valid link (URI, file, SMB or URL).");
        }
    }

    public static String findLink(String text, boolean isHtml) {
        return LinkController.findLink(text, isHtml, true);
    }

    public static String findLink(String text, boolean isHtml, boolean includeEmails) {
        Matcher urlMatcher = FILE_URL_PATTERN.matcher(text);
        if (urlMatcher.find()) {
            char charBeforeLink;
            String link = urlMatcher.group();
            int start = urlMatcher.start();
            if (isHtml && start > 0 && ((charBeforeLink = text.charAt(start - 1)) == '\"' || charBeforeLink == '\'')) {
                link = HtmlUtils.toXMLUnescapedText(link);
            }
            try {
                new URL(link).toURI();
                return link;
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        if (!includeEmails) {
            return null;
        }
        Matcher mailMatcher = EMAIL_PATTERN.matcher(text);
        if (mailMatcher.find()) {
            String link = "mailto:" + mailMatcher.group();
            return link;
        }
        return null;
    }

    public static URI createMenuItemLink(String content) {
        return LinkController.createItemLink(MENUITEM_SCHEME, content);
    }

    public static URI createItemLink(String scheme, String content) {
        try {
            return new URI(scheme, "_" + content, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("huh? URI should have escaped illegal characters", e);
        }
    }

    public static boolean isMenuItemLink(Hyperlink link) {
        return LinkController.isSpecialLink(MENUITEM_SCHEME, link);
    }

    public static boolean isSpecialLink(String requiredScheme, Hyperlink link) {
        String scheme = link.getScheme();
        return scheme != null && scheme.equals(requiredScheme);
    }

    public static String parseSpecialLink(Hyperlink link) {
        return LinkController.convertPre15VersionStyleKeysToCurrent(link.getUri().getSchemeSpecificPart().substring(1));
    }

    private static String convertPre15VersionStyleKeysToCurrent(String actionKey) {
        return actionKey.startsWith("$") ? actionKey.replaceFirst("\\$(.*)\\$0", "$1") : actionKey;
    }

    public int getStandardConnectorWidth() {
        String standardWidth = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_WIDTH);
        int width = Integer.valueOf(standardWidth);
        return width;
    }

    public Color getStandardConnectorColor() {
        String standardColor = ResourceController.getResourceController().getProperty(RESOURCES_LINK_COLOR);
        Color color = ColorUtils.stringToColor(standardColor);
        return color;
    }

    public ConnectorArrows getStandardConnectorArrows() {
        String standard = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_ARROWS);
        ConnectorArrows arrows = ConnectorArrows.valueOf(standard);
        return arrows;
    }

    public Dash getStandardDash() {
        String standard = ResourceController.getResourceController().getProperty(RESOURCES_DASH_VARIANT);
        Dash variant = Dash.valueOf((String)standard);
        return variant;
    }

    public int[] getStandardDashArray() {
        return this.getStandardDash().pattern;
    }

    public ConnectorShape getStandardConnectorShape() {
        String standardShape = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_SHAPE);
        ConnectorShape shape = ConnectorShape.valueOf(standardShape);
        return shape;
    }

    public int getStandardConnectorOpacity() {
        String standardAlpha = ResourceController.getResourceController().getProperty(RESOURCES_CONNECTOR_COLOR_ALPHA);
        int alpha = Integer.valueOf(standardAlpha);
        return alpha;
    }

    public int getStandardLabelFontSize() {
        return ResourceController.getResourceController().getIntProperty("connector_label_font_size_default", 12);
    }

    public String getStandardLabelFontFamily() {
        return ResourceController.getResourceController().getProperty("connector_label_font_family_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getLinkIcon(Hyperlink link, NodeModel model) {
        LinkType linkType = LinkController.getLinkType(link, model);
        if (linkType == null) {
            return null;
        }
        if (linkType.equals((Object)LinkType.MENU)) {
            String menuItemKey = LinkController.parseSpecialLink(link);
            HashMap<String, Icon> hashMap = menuItemCache;
            synchronized (hashMap) {
                Icon icon = menuItemCache.get(menuItemKey);
                if (icon == null) {
                    Icon menuItemIcon = MenuUtils.getMenuItemIcon(menuItemKey);
                    icon = menuItemIcon == null ? LinkType.MENU.icon : menuItemIcon;
                    menuItemCache.put(menuItemKey, icon);
                }
                return icon;
            }
        }
        if (LinkType.DEFAULT == linkType && this.formatNodeAsHyperlink(model)) {
            return null;
        }
        return linkType.icon;
    }

    public void addLinkDecorationIcons(MultipleImageIcon iconImages, NodeModel model, LogicalStyleController.StyleOption option) {
        Hyperlink link = NodeLinks.getLink(model);
        if (link != null) {
            this.addIconsBasedOnLinkType(link, iconImages, model, option);
        }
    }

    public boolean containsLinkDecorationIcon(NodeModel node, String iconName) {
        Hyperlink link = NodeLinks.getLink(node);
        if (link == null) {
            return false;
        }
        NodeViewDecorator decorator = NodeViewDecorator.INSTANCE;
        List<String> iconsForLink = decorator.getIconsForLink(link);
        if (iconsForLink.isEmpty()) {
            return false;
        }
        return iconsForLink.stream().map(name -> "links/" + name).anyMatch(iconName::equals);
    }

    private void addIconsBasedOnLinkType(Hyperlink link, MultipleImageIcon iconImages, NodeModel node, LogicalStyleController.StyleOption option) {
        try {
            NodeViewDecorator decorator = NodeViewDecorator.INSTANCE;
            List<String> iconsForLink = decorator.getIconsForLink(link);
            if (iconsForLink.isEmpty()) {
                Icon linkIcon = this.getLinkIcon(link, node);
                if (linkIcon != null) {
                    iconImages.addLinkIcon(linkIcon, node, option);
                }
            } else {
                LinkType linkType = LinkController.getLinkType(link, node);
                if (linkType != null && linkType.decoratedIcon != null) {
                    iconImages.addLinkIcon(linkType.decoratedIcon, node, option);
                }
                for (String iconName : iconsForLink) {
                    MindIcon icon = IconStoreFactory.ICON_STORE.getMindIcon("links/" + iconName);
                    IconRegistry iconRegistry = node.getMap().getIconRegistry();
                    iconRegistry.addIcon(icon);
                    Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(node, option);
                    iconImages.addIcon(icon, iconHeight);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static LinkType getLinkType(Hyperlink link, NodeModel model) {
        if (link == null) {
            return null;
        }
        String linkText = link.toString();
        if (linkText.startsWith("#")) {
            String id = linkText.substring(1);
            if (model == null || linkText.startsWith("#ID") && model.getMap().getNodeForID(id) == null) {
                return null;
            }
            return LinkType.LOCAL;
        }
        if (linkText.startsWith("mailto:")) {
            return LinkType.MAIL;
        }
        if (LinkController.isMenuItemLink(link)) {
            return LinkType.MENU;
        }
        if (LinkController.isSpecialLink(EXECUTE_APP_SCHEME, link) || Compat.isWindowsExecutable(link)) {
            return LinkType.EXECUTABLE;
        }
        return LinkType.DEFAULT;
    }

    public boolean formatNodeAsHyperlink(NodeModel node) {
        String text = node.getText();
        if (text.isEmpty() || HtmlUtils.isHtml(text)) {
            return false;
        }
        Boolean ownFlag = this.ownFormatNodeAsHyperlink(node);
        if (ownFlag != null) {
            return ownFlag;
        }
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapStyleModel mapStyles = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            Boolean styleFlag;
            NodeModel styleNode = mapStyles.getStyleNode(styleKey);
            if (styleNode == null || (styleFlag = this.ownFormatNodeAsHyperlink(styleNode)) == null) continue;
            return styleFlag;
        }
        return false;
    }

    private Boolean ownFormatNodeAsHyperlink(NodeModel node) {
        NodeLinks linkModel = NodeLinks.getLinkExtension(node);
        if (linkModel == null) {
            return null;
        }
        Boolean formatNodeAsHyperlink = linkModel.formatNodeAsHyperlink();
        return formatNodeAsHyperlink;
    }

    public void loadURI(NodeModel node, Hyperlink uri) {
        String uriString = uri.toString();
        if (uriString.startsWith("#")) {
            String reference = uriString.substring(1);
            UrlManager.getController().selectNode(node, reference);
        } else {
            this.loadHyperlink(uri);
        }
    }

    public Point getStartInclination(ConnectorModel connector) {
        return this.getProperty(connector, c -> Optional.ofNullable(c.getStartInclination()), () -> null);
    }

    public Point getEndInclination(ConnectorModel connector) {
        return this.getProperty(connector, c -> Optional.ofNullable(c.getEndInclination()), () -> null);
    }

    private class ClonesMenuBuilder
    implements EntryVisitor {
        private final ModeController modeController;

        public ClonesMenuBuilder(ModeController modeController) {
            this.modeController = modeController;
        }

        @Override
        public void visit(Entry target) {
            IMapSelection selection = this.modeController.getController().getSelection();
            if (selection == null) {
                return;
            }
            NodeModel node = selection.getSelected();
            boolean firstAction = true;
            NodeModel parentNode = node.getParentNode();
            if (parentNode != null) {
                for (NodeModel clone : node.allClones()) {
                    if (clone.equals(node)) continue;
                    GotoLinkNodeAction gotoLinkNodeAction = new GotoLinkNodeAction(LinkController.this, clone);
                    NodeModel subtreeRootParentNode = clone.getSubtreeRootOrContentClone().getParentNode();
                    gotoLinkNodeAction.configureText("follow_clone", subtreeRootParentNode);
                    if (firstAction) {
                        target.addChild(new Entry().setBuilders("separator"));
                        firstAction = false;
                    }
                    this.modeController.addActionIfNotAlreadySet(gotoLinkNodeAction);
                    new EntryAccessor().addChildAction(target, gotoLinkNodeAction);
                }
            }
        }

        @Override
        public boolean shouldSkipChildren(Entry entry) {
            return true;
        }
    }

    public static enum LinkType {
        LOCAL("link_local_icon", "decorated_link_local_icon"),
        MAIL("mail_icon", "decorated_mail_icon"),
        EXECUTABLE("executable_icon", "executable_icon"),
        MENU("menuitem_icon", "menuitem_icon"),
        DEFAULT("link_icon", "decorated_link_icon");

        public final Icon icon;
        public final Icon decoratedIcon;

        private LinkType(String iconKey, String decoratedIconKey) {
            this.icon = ResourceController.getResourceController().getIcon(iconKey);
            this.decoratedIcon = ResourceController.getResourceController().getIcon(decoratedIconKey);
        }
    }

    public static final class ClosePopupAction
    extends AbstractAction {
        private final String reason;

        public ClosePopupAction(String reason) {
            this.reason = reason;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent src = (JComponent)e.getSource();
            src.putClientProperty(this.reason, Boolean.TRUE);
            SwingUtilities.getWindowAncestor(src).setVisible(false);
        }
    }
}

