/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.commandsearch.IconIndexer;
import org.freeplane.features.commandsearch.InformationItem;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.commandsearch.MenuStructureIndexer;
import org.freeplane.features.commandsearch.PreferencesIndexer;
import org.freeplane.features.commandsearch.SearchItem;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class CommandSearchDialog
extends JDialog
implements DocumentListener,
ListCellRenderer<SearchItem>,
IMapSelectionListener,
INodeSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final String LIMIT_EXCEEDED_MESSAGE = TextUtils.getText("cmdsearch.limit_exceeded");
    private static final Icon WARNING_ICON = ResourceController.getResourceController().getIcon("/images/icons/messagebox_warning.svg");
    private static final int LIMIT_EXCEEDED_RANK = 100;
    private static final String WINDOW_CONFIG_PROPERTY = "cmdsearch_window_configuration";
    private final JCheckBox searchMenus;
    private final JCheckBox searchPrefs;
    private final JCheckBox searchIcons;
    private final JTextField input;
    private final JList<SearchItem> resultList;
    private final JCheckBox closeAfterExecute;
    private final JCheckBox searchWholeWords;
    private final PreferencesIndexer preferencesIndexer;
    private final MenuStructureIndexer menuStructureIndexer;
    private final IconIndexer iconIndexer;
    private final Controller controller = Controller.getCurrentController();
    private final ModeController modeController = Controller.getCurrentModeController();

    CommandSearchDialog(Frame parent) {
        super(parent, TextUtils.getText("CommandSearchAction.text"), false);
        this.controller.getMapViewManager().addMapSelectionListener(this);
        this.modeController.getMapController().addNodeSelectionListener(this);
        this.setLocationRelativeTo(parent);
        this.preferencesIndexer = new PreferencesIndexer();
        this.menuStructureIndexer = new MenuStructureIndexer();
        this.iconIndexer = new IconIndexer();
        Handler handler = new Handler();
        this.input = new JTextField(""){

            @Override
            public void copy() {
                if (this.getSelectionStart() < this.getSelectionEnd()) {
                    super.copy();
                } else {
                    CommandSearchDialog.this.copySelectedItemToClipboard();
                }
            }
        };
        this.input.setColumns(40);
        this.input.addKeyListener(handler);
        this.resultList = new SingleSelectionList();
        this.resultList.setModel(new UpdateableListModel(Collections.emptyList()));
        this.resultList.setFocusable(false);
        this.resultList.setCellRenderer(this);
        this.resultList.addMouseListener(handler);
        this.resultList.getSelectionModel().setSelectionMode(0);
        this.resultList.addKeyListener(handler);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JScrollPane resultListScrollPane = new JScrollPane(this.resultList);
        UITools.setScrollbarIncrement(resultListScrollPane);
        this.getContentPane().add(panel);
        JPanel scopePanel = new JPanel();
        this.searchPrefs = this.createScopeButton(Scope.PREFERENCES);
        this.searchMenus = this.createScopeButton(Scope.MENUS);
        this.searchMenus.setToolTipText(TextUtils.getRawText(Scope.MENUS.labelName() + ".tooltip"));
        this.searchIcons = this.createScopeButton(Scope.ICONS);
        scopePanel.add(this.searchPrefs);
        scopePanel.add(this.searchMenus);
        scopePanel.add(this.searchIcons);
        this.searchWholeWords = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.searchWholeWords, TextUtils.getRawText("cmdsearch.searchWholeWords"));
        this.searchWholeWords.setSelected(ResourceController.getResourceController().getBooleanProperty("cmdsearch_whole_words"));
        this.searchWholeWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResourceController.getResourceController().setProperty("cmdsearch_whole_words", CommandSearchDialog.this.searchWholeWords.isSelected());
                CommandSearchDialog.this.updateMatches(CommandSearchDialog.this.input.getText());
                CommandSearchDialog.this.input.requestFocusInWindow();
            }
        });
        Box whatbox = Box.createVerticalBox();
        scopePanel.setAlignmentX(0.5f);
        whatbox.add(scopePanel);
        this.searchWholeWords.setAlignmentX(0.5f);
        whatbox.add(this.searchWholeWords);
        this.input.setAlignmentX(0.5f);
        whatbox.add(this.input);
        this.initScopeFromPrefs();
        panel.add((Component)whatbox, "North");
        panel.add((Component)resultListScrollPane, "Center");
        Box optionsBox = Box.createVerticalBox();
        this.closeAfterExecute = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.closeAfterExecute, TextUtils.getRawText("cmdsearch.closeAfterExecute"));
        this.closeAfterExecute.setSelected(ResourceController.getResourceController().getBooleanProperty("cmdsearch_close_after_execute"));
        this.closeAfterExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResourceController.getResourceController().setProperty("cmdsearch_close_after_execute", CommandSearchDialog.this.closeAfterExecute.isSelected());
                CommandSearchDialog.this.updateMatches(CommandSearchDialog.this.input.getText());
                CommandSearchDialog.this.input.requestFocusInWindow();
            }
        });
        optionsBox.add(this.closeAfterExecute);
        panel.add((Component)optionsBox, "South");
        this.setDefaultCloseOperation(2);
        this.input.setColumns(40);
        this.resultList.setVisibleRowCount(20);
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(WINDOW_CONFIG_PROPERTY);
        windowConfigurationStorage.setBounds(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MapController mapController = CommandSearchDialog.this.modeController.getMapController();
                mapController.removeNodeSelectionListener(CommandSearchDialog.this);
                CommandSearchDialog.this.controller.getMapViewManager().removeMapSelectionListener(CommandSearchDialog.this);
            }
        });
        this.input.getDocument().addDocumentListener(this);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                CommandSearchDialog.this.input.requestFocusInWindow();
                CommandSearchDialog.this.removeWindowFocusListener(this);
            }
        });
        this.setVisible(true);
    }

    @Override
    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        if (Controller.getCurrentModeController() != this.modeController) {
            this.dispose();
        }
    }

    @Override
    public void onSelect(NodeModel node) {
        SwingUtilities.invokeLater(this::updateResultList);
    }

    private JCheckBox createScopeButton(final Scope scope) {
        final JCheckBox searchPrefs = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic(searchPrefs, TextUtils.getRawText(scope.labelName()));
        searchPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = searchPrefs.isSelected();
                scope.setEnabled(selected);
                CommandSearchDialog.this.updateMatches(CommandSearchDialog.this.input.getText());
                CommandSearchDialog.this.input.requestFocusInWindow();
            }
        });
        return searchPrefs;
    }

    private void initScopeFromPrefs() {
        this.searchMenus.setSelected(Scope.MENUS.isEnabled());
        this.searchPrefs.setSelected(Scope.PREFERENCES.isEnabled());
        this.searchIcons.setSelected(Scope.ICONS.isEnabled());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateMatches(this.input.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateMatches(this.input.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateMatches(this.input.getText());
    }

    private void updateMatches(String searchInput) {
        String trimmedInput = searchInput.trim();
        List<InformationItem> matches = new ArrayList();
        boolean shouldSearchWholeWords = ResourceController.getResourceController().getBooleanProperty("cmdsearch_whole_words");
        ItemChecker textChecker = new ItemChecker(shouldSearchWholeWords);
        if (trimmedInput.length() >= 1 && (searchInput.endsWith(" ") || shouldSearchWholeWords) || searchInput.length() >= 3 && searchInput.codePoints().limit(3L).count() == 3L || !searchInput.codePoints().allMatch(Character::isAlphabetic)) {
            String[] searchTerms = SearchItem.normalizeText(trimmedInput).split("\\s+");
            if (this.searchMenus.isSelected()) {
                textChecker.findMatchingItems(this.menuStructureIndexer.getMenuItems(), searchTerms, matches::add);
            }
            if (this.searchPrefs.isSelected()) {
                textChecker.findMatchingItems(this.preferencesIndexer.getPrefs(), searchTerms, matches::add);
            }
            if (this.searchIcons.isSelected()) {
                textChecker.findMatchingItems(this.iconIndexer.getIconItems(), searchTerms, matches::add);
            }
            Collections.sort(matches);
        }
        int itemLimit = ResourceController.getResourceController().getIntProperty("cmdsearch_item_limit");
        if (matches.size() > itemLimit) {
            matches = matches.subList(0, itemLimit);
            matches.add(new InformationItem(LIMIT_EXCEEDED_MESSAGE, WARNING_ICON, 100));
        }
        UpdateableListModel model = new UpdateableListModel(matches);
        SearchItem selectedItem = this.resultList.getSelectedValue();
        this.resultList.setModel(model);
        if (this.resultList.getModel().getSize() > 0) {
            this.resultList.setSelectedValue(selectedItem, true);
            if (this.resultList.getSelectedIndex() == -1) {
                this.resultList.setSelectedIndex(0);
            }
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SearchItem> list, SearchItem item, int index, boolean isSelected, boolean cellHasFocus) {
        String text = item.getDisplayedText();
        Icon icon = item.getTypeIcon();
        String tooltip = item.getTooltip();
        JLabel label = (JLabel)new DefaultListCellRenderer().getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        if (icon != null) {
            label.setIcon(icon);
        }
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
        return label;
    }

    protected boolean shouldAssignAccelerator(InputEvent event) {
        return event.isControlDown();
    }

    private void executeItem(InputEvent event, int index) {
        ListModel<SearchItem> data = this.resultList.getModel();
        SearchItem item = data.getElementAt(index);
        if (this.shouldAssignAccelerator(event)) {
            item.assignNewAccelerator();
        } else {
            item.execute(event);
            if (this.closeAfterExecute.isSelected()) {
                this.dispose();
            }
        }
        if (item.shouldUpdateResultList()) {
            this.updateResultList();
        }
    }

    private void updateResultList() {
        UpdateableListModel model = (UpdateableListModel)this.resultList.getModel();
        int lastElementIndex = model.getSize() - 1;
        if (lastElementIndex >= 0) {
            model.fireContentsChanged(this, 0, lastElementIndex);
        }
    }

    private void copySelectedItemToClipboard() {
        SearchItem item = this.resultList.getSelectedValue();
        if (item != null) {
            String text = item.getCopiedText();
            ClipboardAccessor.getInstance().setClipboardContents(text);
        }
    }

    class Handler
    implements MouseListener,
    KeyListener {
        Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = CommandSearchDialog.this.resultList.locationToIndex(e.getPoint());
                CommandSearchDialog.this.executeItem(e, index);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean wrapAround = false;
            if (e.getKeyCode() == 27) {
                CommandSearchDialog.this.dispose();
            } else if (e.getKeyCode() == 40 && e.getSource() == CommandSearchDialog.this.input) {
                if (CommandSearchDialog.this.resultList.getModel().getSize() > 0) {
                    int selectedIndex = CommandSearchDialog.this.resultList.getSelectedIndex();
                    int newIndex = selectedIndex + 1;
                    if (newIndex >= CommandSearchDialog.this.resultList.getModel().getSize()) {
                        newIndex = CommandSearchDialog.this.resultList.getModel().getSize() - 1;
                    }
                    CommandSearchDialog.this.resultList.setSelectedIndex(newIndex);
                    CommandSearchDialog.this.resultList.ensureIndexIsVisible(newIndex);
                }
            } else if (e.getKeyCode() == 38 && e.getSource() == CommandSearchDialog.this.input) {
                if (CommandSearchDialog.this.resultList.getModel().getSize() > 0) {
                    int selectedIndex = CommandSearchDialog.this.resultList.getSelectedIndex();
                    if (selectedIndex == -1) {
                        CommandSearchDialog.this.resultList.setSelectedIndex(0);
                    } else {
                        if (selectedIndex == 0) {
                            // empty if block
                        }
                        CommandSearchDialog.this.resultList.setSelectedIndex(selectedIndex - 1);
                    }
                    CommandSearchDialog.this.resultList.ensureIndexIsVisible(CommandSearchDialog.this.resultList.getSelectedIndex());
                }
            } else if (e.getKeyCode() == 10 && CommandSearchDialog.this.resultList.getSelectedIndex() >= 0) {
                CommandSearchDialog.this.executeItem(e, CommandSearchDialog.this.resultList.getSelectedIndex());
            }
        }
    }

    private static class SingleSelectionList
    extends JList<SearchItem> {
        private static final long serialVersionUID = 1L;

        private SingleSelectionList() {
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
        }

        @Override
        public void addSelectionInterval(int anchor, int lead) {
            this.setSelectionInterval(anchor, lead);
        }
    }

    private static class UpdateableListModel<E>
    extends AbstractListModel<E> {
        private final List<E> listData;
        private static final long serialVersionUID = 1L;

        public UpdateableListModel(List<E> listData) {
            this.listData = listData;
        }

        @Override
        public int getSize() {
            return this.listData.size();
        }

        @Override
        public E getElementAt(int i) {
            return this.listData.get(i);
        }

        @Override
        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    public static enum Scope {
        MENUS,
        PREFERENCES,
        ICONS;


        String propertyName() {
            return "cmdsearch_scope_" + this.name();
        }

        String labelName() {
            return "cmdsearch.scope." + this.name();
        }

        boolean isEnabled() {
            return ResourceController.getResourceController().getBooleanProperty(this.propertyName(), true);
        }

        void setEnabled(boolean selected) {
            ResourceController.getResourceController().setProperty(this.propertyName(), selected);
        }
    }
}

