/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnitAccess;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.ClassMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

class RmiMatcher
implements GroupMatcher {
    private final GroupMatcher matcher;
    private final Map<String, GroupIdentifier> bundledGroups;
    private final Map<JavaClass, GroupIdentifier> rmiClasses;
    private final Set<String> bundledGroupIs;

    RmiMatcher(GroupMatcher matcher, Map<String, GroupIdentifier> bundledGroups, Map<JavaClass, GroupIdentifier> rmiClasses) {
        this.matcher = matcher;
        this.bundledGroups = bundledGroups;
        this.bundledGroupIs = bundledGroups.values().stream().map(GroupIdentifier::getId).collect(Collectors.toSet());
        this.rmiClasses = rmiClasses;
    }

    @Override
    public Optional<GroupIdentifier> groupIdentifier(JavaClass javaClass) {
        return this.matcher.groupIdentifier(javaClass).map(gi -> this.bundledGroups.getOrDefault(gi.getId(), (GroupIdentifier)gi));
    }

    @Override
    public Optional<GroupIdentifier> projectIdentifier(JavaClass javaClass) {
        return this.matcher.groupIdentifier(javaClass);
    }

    @Override
    public boolean belongsToGroup(JavaClass javaClass) {
        return this.matcher.belongsToGroup(javaClass);
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass javaClass) {
        return this.rmiClasses.containsKey(CodeNode.findEnclosingNamedClass(javaClass)) ? Optional.of(GroupMatcher.MatchingCriteria.RMI) : Optional.empty();
    }

    @Override
    public Optional<GroupMatcher.MatchingCriteria> matchingCriteria(JavaClass originClass, JavaClass targetClass) {
        GroupIdentifier originIdentifier = this.rmiClasses.get(CodeNode.findEnclosingNamedClass(originClass));
        if (originIdentifier == null) {
            return Optional.empty();
        }
        GroupIdentifier targetIdentifier = this.rmiClasses.get(CodeNode.findEnclosingNamedClass(targetClass));
        if (targetIdentifier == null) {
            return Optional.empty();
        }
        return !originIdentifier.equals(targetIdentifier) ? Optional.of(GroupMatcher.MatchingCriteria.RMI) : Optional.empty();
    }

    @Override
    public Optional<GroupMatcher> subgroupMatcher(String id) {
        if (!this.bundledGroupIs.contains(id)) {
            return Optional.empty();
        }
        return Optional.of(jc -> this.subgroupIdentifier(jc, id));
    }

    private Optional<GroupIdentifier> subgroupIdentifier(JavaClass javaClass, String identifier) {
        Optional<GroupIdentifier> groupIdentifier = this.groupIdentifier(javaClass);
        if (!groupIdentifier.isPresent() || !groupIdentifier.get().getId().equals(identifier)) {
            return Optional.empty();
        }
        return this.matcher.groupIdentifier(javaClass);
    }

    static class Factory {
        private final GroupMatcher matcher;
        private final JavaClasses javaClasses;
        private final Graph<GroupIdentifier, DefaultEdge> componentGraph;
        private final Map<JavaClass, GroupIdentifier> rmiClasses;
        private final RmiMatcher rmiMatcher;
        private final ClassMatcher ignoredRmi;
        private final Mode mode;

        Factory(GroupMatcher matcher, JavaClasses javaClasses, Mode mode, ClassMatcher ignoredRmi) {
            RmiMatcher rmiMatcher;
            this.matcher = matcher;
            this.javaClasses = javaClasses;
            this.mode = mode;
            this.ignoredRmi = ignoredRmi;
            this.componentGraph = new SimpleDirectedGraph(DefaultEdge.class);
            this.rmiClasses = new HashMap<JavaClass, GroupIdentifier>();
            this.fillComponentGraph();
            this.rmiMatcher = rmiMatcher = this.createMatcherFromGraph();
        }

        private void fillComponentGraph() {
            this.javaClasses.forEach(this::addComponentsToGraph);
        }

        private RmiMatcher createMatcherFromGraph() {
            HashMap<String, GroupIdentifier> bundledGroups = new HashMap<String, GroupIdentifier>();
            ConnectivityInspector inspector = new ConnectivityInspector(this.componentGraph);
            List componentGroups = inspector.connectedSets();
            for (Set group : componentGroups) {
                if (group.size() <= 1) continue;
                TreeSet<String> finalComponentNames = new TreeSet<String>();
                String id = null;
                for (GroupIdentifier componentIdentifier : group) {
                    if (!this.componentGraph.outgoingEdgesOf((Object)componentIdentifier).isEmpty()) continue;
                    finalComponentNames.add(componentIdentifier.getName());
                    if (id != null) continue;
                    id = componentIdentifier.getId();
                }
                String name = finalComponentNames.stream().collect(Collectors.joining(", "));
                GroupIdentifier groupIdentifier = new GroupIdentifier(id, name);
                for (GroupIdentifier vertex : group) {
                    bundledGroups.put(vertex.getId(), groupIdentifier);
                }
            }
            RmiMatcher rmiMatcher = new RmiMatcher(this.matcher, bundledGroups, this.rmiClasses);
            return rmiMatcher;
        }

        GroupMatcher createMatcher() {
            return this.rmiMatcher;
        }

        private void addComponentsToGraph(JavaClass javaClass) {
            if (Factory.isRemoteInterface(javaClass)) {
                this.addSubclassDependencies(Optional.empty(), null, javaClass);
            }
        }

        private void addSubclassDependencies(Optional<GroupIdentifier> dependingGroupIdentifier, JavaClass superClass, JavaClass javaClass) {
            JavaClass enclosingNamedClass = CodeNode.findEnclosingNamedClass(javaClass);
            if (!this.ignoredRmi.matches(enclosingNamedClass)) {
                Optional<GroupIdentifier> groupIdentifier = this.matcher.groupIdentifier(javaClass);
                groupIdentifier.ifPresent(gi -> {
                    GroupIdentifier dgi;
                    if (dependingGroupIdentifier.isPresent() && !(dgi = (GroupIdentifier)dependingGroupIdentifier.get()).equals(gi)) {
                        this.addRmiClass(superClass, dgi);
                        this.addRmiClass(javaClass, (GroupIdentifier)gi);
                        this.addEdge(dgi, (GroupIdentifier)gi);
                    }
                    if (this.mode == Mode.INSTANTIATIONS) {
                        Sets.union((Set)javaClass.getConstructorCallsToSelf(), (Set)javaClass.getConstructorReferencesToSelf()).forEach(access -> this.addConstructorDependencies((GroupIdentifier)gi, (JavaCodeUnitAccess<? extends AccessTarget.CodeUnitAccessTarget>)access));
                    }
                    Set subclasses = javaClass.getSubclasses();
                    subclasses.forEach(x -> this.addSubclassDependencies(groupIdentifier, javaClass, (JavaClass)x));
                });
            }
        }

        private void addRmiClass(JavaClass javaClass, GroupIdentifier identifier) {
            this.rmiClasses.put(CodeNode.findEnclosingNamedClass(javaClass), identifier);
        }

        private void addConstructorDependencies(GroupIdentifier groupIdentifier, JavaCodeUnitAccess<? extends AccessTarget.CodeUnitAccessTarget> access) {
            JavaClass callingClass = access.getOriginOwner();
            Optional<GroupIdentifier> callingGroupIdentifier = this.matcher.groupIdentifier(callingClass);
            callingGroupIdentifier.ifPresent(cgi -> {
                if (!cgi.equals(groupIdentifier)) {
                    this.addRmiClass(callingClass, (GroupIdentifier)cgi);
                    this.addRmiClass(access.getTargetOwner(), groupIdentifier);
                    this.addEdge(groupIdentifier, (GroupIdentifier)cgi);
                }
            });
        }

        private void addEdge(GroupIdentifier dependingGroupIdentifier, GroupIdentifier groupIdentifier) {
            this.componentGraph.addVertex((Object)dependingGroupIdentifier);
            this.componentGraph.addVertex((Object)groupIdentifier);
            this.componentGraph.addEdge((Object)dependingGroupIdentifier, (Object)groupIdentifier);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isRemoteInterface(JavaClass javaClass) {
            if (!javaClass.isInterface()) return false;
            if (!javaClass.getRawInterfaces().stream().map(HasName::getName).anyMatch(Remote.class.getName()::equals)) return false;
            return true;
        }
    }

    static enum Mode {
        IMPLEMENTATIONS,
        INSTANTIATIONS;

    }
}

