/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MouseEventActor;
import org.freeplane.view.swing.ui.MouseTimerDelegate;

class NodeFolder
implements MouseTimerDelegate.ActionProvider {
    private static final String MOUSE_OVER_FOLDING_TIMING = "mouse_over_folding_timing";
    private static final String MOUSE_OVER_FOLDING_ACTION = "mouse_over_folding_action";
    private static final String FOLDING_DISABLED = "disabled";
    private static final String FOLDING_DELAYED = "delayed";
    private static final String FOLDING_IMMEDIATE = "immediate";
    private static final String FOLDING_TOGGLE = "toggle";
    private static final String FOLDING_UNFOLD_ONLY = "unfold_only";
    private static final String FOLDING_PREVIEW = "preview";
    private final MouseTimerDelegate timerDelegate = new MouseTimerDelegate();
    private NodeModel previewUnfoldedNode = null;
    private TimeDelayedFolding delayedFolding;

    NodeFolder() {
    }

    private static void migratePropertyFromSelectionMethodIfUserCustomized() {
        ResourceController rc = ResourceController.getResourceController();
        if (NodeFolder.shouldMigrateFoldingMethodFromSelectionMethod(rc)) {
            String selectionMethod = rc.getProperty("selection_method");
            NodeFolder.migrateFoldingSettingsFromSelectionMethod(rc, selectionMethod);
        }
    }

    void createTimer(MouseEvent e) {
        if (this.delayedFolding != null && this.delayedFolding.wasFired) {
            return;
        }
        String foldingTiming = ResourceController.getResourceController().getProperty(MOUSE_OVER_FOLDING_TIMING);
        if (foldingTiming.equals(FOLDING_DISABLED)) {
            return;
        }
        if (foldingTiming.equals(FOLDING_IMMEDIATE)) {
            ActionListener action = this.createDelayedAction(e);
            action.actionPerformed(new ActionEvent(this, 0, ""));
            if (this.delayedFolding != null) {
                this.delayedFolding.wasFired = true;
            }
            return;
        }
        this.timerDelegate.createTimer(e, this);
    }

    void stopTimerForDelayedFolding() {
        this.timerDelegate.stopTimer();
        this.delayedFolding = null;
        this.previewUnfoldedNode = null;
    }

    void onMouseExited() {
        this.restorePreviewUnfoldedNode();
    }

    void makePreviewUnfoldingPermanent() {
        this.previewUnfoldedNode = null;
    }

    boolean isPreviewUnfolded(NodeModel node) {
        return this.previewUnfoldedNode == node;
    }

    private void restorePreviewUnfoldedNode() {
        if (this.previewUnfoldedNode != null && !this.previewUnfoldedNode.isFolded()) {
            Controller controller = Controller.getCurrentController();
            ModeController modeController = controller.getModeController();
            MapController mapController = modeController.getMapController();
            mapController.setFolded(this.previewUnfoldedNode, true, controller.getSelection().getFilter());
            this.previewUnfoldedNode = null;
        }
        this.stopTimerForDelayedFolding();
    }

    @Override
    public ActionListener createDelayedAction(MouseEvent e) {
        String foldingAction = ResourceController.getResourceController().getProperty(MOUSE_OVER_FOLDING_ACTION);
        this.delayedFolding = new TimeDelayedFolding(e, foldingAction);
        return this.delayedFolding;
    }

    @Override
    public boolean isActionEnabled() {
        String foldingTiming = ResourceController.getResourceController().getProperty(MOUSE_OVER_FOLDING_TIMING);
        return !foldingTiming.equals(FOLDING_DISABLED);
    }

    NodeView getRelatedNodeView(MouseEvent e) {
        return this.timerDelegate.getRelatedNodeView(e);
    }

    private static boolean shouldMigrateFoldingMethodFromSelectionMethod(ResourceController rc) {
        return NodeFolder.userHasCustomizedSelectionMethod(rc) && NodeFolder.userHasNotCustomizedFoldingMethod(rc);
    }

    private static boolean userHasCustomizedSelectionMethod(ResourceController rc) {
        return rc.isPropertySetByUser("selection_method");
    }

    private static boolean userHasNotCustomizedFoldingMethod(ResourceController rc) {
        return !rc.isPropertySetByUser(MOUSE_OVER_FOLDING_TIMING) && !rc.isPropertySetByUser(MOUSE_OVER_FOLDING_ACTION);
    }

    private static void migrateFoldingSettingsFromSelectionMethod(ResourceController rc, String selectionMethod) {
        switch (selectionMethod) {
            case "selection_method_direct": {
                rc.setProperty(MOUSE_OVER_FOLDING_TIMING, FOLDING_IMMEDIATE);
                rc.setProperty(MOUSE_OVER_FOLDING_ACTION, FOLDING_TOGGLE);
                break;
            }
            case "selection_method_delayed": {
                rc.setProperty(MOUSE_OVER_FOLDING_TIMING, FOLDING_DELAYED);
                rc.setProperty(MOUSE_OVER_FOLDING_ACTION, FOLDING_TOGGLE);
                break;
            }
            case "selection_method_by_click": {
                rc.setProperty(MOUSE_OVER_FOLDING_TIMING, FOLDING_DISABLED);
                rc.setProperty(MOUSE_OVER_FOLDING_ACTION, FOLDING_TOGGLE);
            }
        }
    }

    void trackWindowForComponent(Component c) {
        this.timerDelegate.trackWindowForComponent(c);
    }

    static {
        NodeFolder.migratePropertyFromSelectionMethodIfUserCustomized();
    }

    class TimeDelayedFolding
    implements ActionListener {
        private final MouseEvent mouseEvent;
        private final String foldingBehavior;
        private boolean wasFired;

        TimeDelayedFolding(MouseEvent e, String foldingBehavior) {
            this.mouseEvent = e;
            this.foldingBehavior = foldingBehavior;
            this.wasFired = false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.mouseEvent.getModifiers() != 0) {
                return;
            }
            try {
                Controller controller = Controller.getCurrentController();
                ModeController modeController = controller.getModeController();
                if (!modeController.isBlocked() && controller.getSelection().size() <= 1) {
                    NodeView nodeV = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.mouseEvent.getComponent());
                    MapView map = nodeV.getMap();
                    if (nodeV.isDisplayable() && nodeV.getNode().hasVisibleContent(map.getFilter())) {
                        map.select();
                        NodeModel node = nodeV.getNode();
                        MouseEventActor.INSTANCE.withMouseEvent(() -> {
                            MapController mapController = modeController.getMapController();
                            this.performFoldingAction(mapController, node, map, this.foldingBehavior);
                        });
                        this.wasFired = true;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private void performFoldingAction(MapController mapController, NodeModel node, MapView map, String behavior) {
            switch (behavior) {
                case "toggle": {
                    mapController.toggleFoldedAndScroll(node);
                    break;
                }
                case "unfold_only": {
                    this.unfoldIfFolded(mapController, node, map);
                    break;
                }
                case "preview": {
                    this.unfoldForPreview(mapController, node, map);
                    break;
                }
            }
        }

        private void unfoldIfFolded(MapController mapController, NodeModel node, MapView map) {
            if (node.isFolded()) {
                mapController.unfoldAndScroll(node, map.getFilter());
            }
        }

        private void unfoldForPreview(MapController mapController, NodeModel node, MapView map) {
            if (node.isFolded()) {
                mapController.unfoldAndScroll(node, map.getFilter());
                NodeFolder.this.previewUnfoldedNode = node;
            }
        }
    }
}

