/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout.mindmapmode;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.api.ChildrenSides;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ButtonSelectorPanel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.factory.IconFactory;

class LayoutSelectorPanelFactory {
    private static final ChildNodesLayout[] LAYOUTS = (ChildNodesLayout[])Arrays.asList(ChildNodesLayout.values()).stream().skip(1L).toArray(ChildNodesLayout[]::new);
    public static final Icon RIGHT_ARROW_ICON = IconFactory.getInstance().getIcon(ResourceController.getResourceController().getIconResource("/images/layouts/right_arrow.svg?useAccentColor=true"), IconFactory.DEFAULT_UI_ICON_HEIGHT.zoomBy(2.0));

    LayoutSelectorPanelFactory() {
    }

    public static ButtonSelectorPanel createLayoutSelectorPanel() {
        Vector<ButtonSelectorPanel.ButtonIcon> icons = new Vector<ButtonSelectorPanel.ButtonIcon>(LAYOUTS.length);
        ResourceController resourceController = ResourceController.getResourceController();
        for (int i = 0; i < LAYOUTS.length; ++i) {
            ChildNodesLayout layout = LAYOUTS[i];
            String name = layout.name().toLowerCase(Locale.ENGLISH);
            URL url = resourceController.getIconResource("/images/layouts/" + name + ".svg?useAccentColor=true");
            ButtonSelectorPanel.ComponentBefore componentBefore = i % 6 == 0 ? ButtonSelectorPanel.ComponentBefore.SEPARATOR : ButtonSelectorPanel.ComponentBefore.NOTHING;
            icons.add(new ButtonSelectorPanel.ButtonIcon(layout.name(), IconFactory.getInstance().getIcon(url, IconFactory.DEFAULT_UI_ICON_HEIGHT.zoomBy(2.0)), LayoutSelectorPanelFactory.description(layout), componentBefore));
        }
        Collection alignmentNames = Stream.of(LAYOUTS).map(Enum::name).collect(Collectors.toList());
        ButtonSelectorPanel buttons = new ButtonSelectorPanel(alignmentNames, icons);
        return buttons;
    }

    private static String description(ChildNodesLayout layout) {
        if (layout == ChildNodesLayout.AUTO) {
            return TextUtils.getRawText((String)layout.name());
        }
        String childNodesAlignmentText = TextUtils.getRawText((String)layout.childNodesAlignment().name());
        if (layout.layoutOrientation() == LayoutOrientation.AUTO && layout.childrenSides() == ChildrenSides.AUTO) {
            return childNodesAlignmentText;
        }
        String childrenSidesText = TextUtils.getRawText((String)layout.childrenSides().labelKey(layout.layoutOrientation()));
        String layoutOrientationText = TextUtils.getRawText((String)layout.layoutOrientation().name());
        if (layout.childNodesAlignment() == ChildNodesAlignment.AUTO) {
            return layoutOrientationText + ", " + childrenSidesText;
        }
        return layoutOrientationText + ", " + childrenSidesText + ", " + childNodesAlignmentText;
    }
}

