/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.AWTKeyStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.core.awt.GraphicsHints;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.HighlightedElements;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AntiAliasingConfigurator;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.NodeSubtrees;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.print.FitMap;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.map.IconLocation;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapScroller;
import org.freeplane.view.swing.map.MapViewScrollPane;
import org.freeplane.view.swing.map.MindMapLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewFactory;
import org.freeplane.view.swing.map.NodeViewFolder;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.SiblingSelection;
import org.freeplane.view.swing.map.TagLocation;
import org.freeplane.view.swing.map.UpdateCause;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.ConnectorView;
import org.freeplane.view.swing.map.link.EdgeLinkView;
import org.freeplane.view.swing.map.link.ILinkView;
import org.freeplane.view.swing.ui.MouseEventActor;

public class MapView
extends JPanel
implements Printable,
Autoscroll,
IMapChangeListener,
IFreeplanePropertyListener,
Configurable {
    private static final String MAP_VIEW_ZOOM_STEP_PROPERTY = "map_view_zoom_step";
    private static final int ROOT_NODE_COMPONENT_INDEX = 0;
    private static final String UNFOLD_ON_NAVIGATION = "unfold_on_navigation";
    private static final String SYNCHRONIZE_SELECTION_ACROSS_VISIBLE_VIEWS_PROPERTY = "synchronizeSelectionAcrossVisibleViews";
    private static final String SHOW_TAGS_ON_MINIMIZED_NODES_PROPERTY = "showTagsOnMinimizedNodes";
    private static final BasicStroke SELECTION_RECTANGLE_STROKE = new BasicStroke(2.0f * UITools.FONT_SCALE_FACTOR, 0, 0, 10.0f * UITools.FONT_SCALE_FACTOR, new float[]{5.0f * UITools.FONT_SCALE_FACTOR, 5.0f * UITools.FONT_SCALE_FACTOR}, 0.0f);
    private final MapScroller mapScroller;
    private MapViewLayout layoutType;
    private boolean paintConnectorsBehind;
    private Filter filter;
    private boolean showNotes;
    private PaintingMode paintingMode = null;
    private static final int AUTOSCROLL_MARGIN = (int)(UITools.FONT_SCALE_FACTOR * 40.0f);
    static boolean printOnWhiteBackground;
    private static IFreeplanePropertyListener propertyChangeListener;
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_SELECTED_NODE_RECTANGLE_COLOR = "standardselectednoderectanglecolor";
    private static final String SPOTLIGHT_BACKGROUND_COLOR = "spotlight_background_color";
    private static final String PRESENTATION_DIMMER_TRANSPARENCY = "presentation_dimmer_transparency";
    private static final String HIDE_SINGLE_END_CONNECTORS;
    private static final String SHOW_CONNECTORS_PROPERTY;
    private static final String SHOW_CONNECTOR_LINES;
    private static final String HIDE_CONNECTOR_LINES;
    private static final String SOME_CONNECTORS_PROPERTY = "connector_";
    private static final String HIDE_CONNECTORS;
    private static final String SHOW_CONNECTORS_FOR_SELECTION_ONLY;
    private static final String SHOW_ARROWS_FOR_SELECTION_ONLY;
    private static final String OUTLINE_VIEW_FITS_WINDOW_WIDTH = "outline_view_fits_window_width";
    private static final String OUTLINE_HGAP_PROPERTY = "outline_hgap";
    private static final String DRAGGING_AREA_WIDTH_PROPERTY = "dragging_area_width";
    private static final String INLINE_EDITOR_ACTIVE = "inline_editor_active";
    public static final String SPOTLIGHT_ENABLED = "spotlight";
    public static final String FOLDING_FOLLOWS_SELECTION = "folding_follows_selection";
    private static final PropertyChangeListener repaintOnClientPropertyChangeListener;
    private static final long serialVersionUID = 1L;
    private static boolean drawsRectangleForSelection;
    private static Color selectionRectangleColor;
    private Vector<ILinkView> arrowLinkViews;
    private ScalableComponent backgroundComponent;
    private Rectangle boundingRectangle = null;
    private FitMap fitMap = FitMap.USER_DEFINED;
    private boolean isPreparedForPrinting = false;
    private PaintingPurpose paintingPurpose = PaintingPurpose.PAINTING;
    private final ModeController modeController;
    private MapModel viewedMap;
    private NodeView currentRootView = null;
    private NodeModel currentSearchRoot = null;
    private NodeView currentRootParentView = null;
    private NodeView mapRootView = null;
    private List<NodeView> rootsHistory;
    private boolean selectedsValid = true;
    private final Selection selection = new Selection();
    private int siblingMaxLevel;
    private float zoom = 1.0f;
    private Font detailFont;
    private Color detailForeground;
    private Color detailBackground;
    private NodeCss detailCss;
    private int detailHorizontalAlignment;
    private Font noteFont;
    private Color noteForeground;
    private Color noteBackground;
    private NodeCss noteCss;
    private int noteHorizontalAlignment;
    private static String showConnectorsPropertyValue;
    private static boolean hideSingleEndConnectorsPropertyValue;
    private String showConnectors;
    private boolean hideSingleEndConnectors;
    private boolean fitToViewport;
    private static Color spotlightBackgroundColor;
    private static int outlineHGap;
    private static boolean outlineViewFitsWindowWidth;
    private static int draggingAreaWidth;
    private static boolean showsTagsOnMinimizedNodes;
    private Rectangle selectionRectangle = null;
    private final ComponentAdapter viewportSizeChangeListener;
    private final INodeChangeListener connectorChangeListener;
    private boolean scrollsViewAfterLayout = true;
    private boolean allowsCompactLayout;
    private TagLocation tagLocation;
    private IconLocation iconLocation;
    private boolean repaintsViewOnSelectionChange;
    public static final int SCROLL_VELOCITY_PX;
    private final NodeViewFolder nodeViewFolder;
    private final AntiAliasingConfigurator antiAliasingConfigurator;

    public static boolean isElementHighlighted(Component c, Object element) {
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, c);
        if (mapView == null) {
            return false;
        }
        HighlightedElements highlightedElements = mapView.getExtension(HighlightedElements.class);
        if (highlightedElements == null) {
            return false;
        }
        return highlightedElements.isContained(element);
    }

    public MapViewLayout getLayoutType() {
        return this.layoutType;
    }

    protected void setLayoutType(MapViewLayout layoutType) {
        if (this.layoutType != layoutType) {
            this.layoutType = layoutType;
            this.getRoot().resetLayoutPropertiesRecursively();
            if (this.outlineViewFitsWindowWidth()) {
                this.updateAllNodeViews();
            }
        }
    }

    private void updateAllNodeViews() {
        this.updateAllNodeViews(UpdateCause.UNKNOWN);
    }

    private void updateAllNodeViews(UpdateCause cause) {
        this.getRoot().updateAll(cause);
        if (this.mapRootView != this.currentRootView) {
            this.mapRootView.updateAll(cause);
        }
    }

    boolean showNotes() {
        return this.showNotes;
    }

    private void setShowNotes() {
        boolean showNotes = NoteController.getController(this.getModeController()).showNotesInMap(this.getMap());
        if (this.showNotes == showNotes) {
            return;
        }
        this.showNotes = showNotes;
        this.updateAllNodeViews();
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public MapView(MapModel viewedMap, ModeController modeController) {
        this.setOpaque(false);
        this.antiAliasingConfigurator = new AntiAliasingConfigurator(this);
        this.viewedMap = viewedMap;
        this.modeController = modeController;
        this.setLayout(new MindMapLayout());
        this.rootsHistory = new ArrayList<NodeView>();
        this.mapScroller = new MapScroller(this);
        this.setAutoscrolls(true);
        IUserInputListenerFactory userInputListenerFactory = this.getModeController().getUserInputListenerFactory();
        this.addMouseListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseMotionListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseWheelListener(userInputListenerFactory.getMapMouseWheelListener());
        this.setFocusTraversalKeys(0, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(1, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(2, this.emptyNodeViewSet());
        this.viewportSizeChangeListener = new ComponentAdapter(){
            boolean firstRun = true;

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.firstRun) {
                    MapView.this.loadBackgroundImage();
                    this.firstRun = false;
                }
                if (MapView.this.fitToViewport) {
                    MapView.this.adjustBackgroundComponentScale();
                }
                if (MapView.this.usesLayoutSpecificMaxNodeWidth()) {
                    MapView.this.currentRootView.updateAll();
                    MapView.this.repaint();
                }
            }
        };
        this.connectorChangeListener = new INodeChangeListener(){

            @Override
            public void nodeChanged(NodeChangeEvent event) {
                if (NodeLinks.CONNECTOR.equals(event.getProperty()) && event.getNode().getMap().equals(MapView.this.getMap())) {
                    MapView.this.repaint();
                }
            }
        };
        this.addPropertyChangeListener(SPOTLIGHT_ENABLED, repaintOnClientPropertyChangeListener);
        if (ResourceController.getResourceController().getBooleanProperty("activateSpotlightByDefault")) {
            this.putClientProperty(SPOTLIGHT_ENABLED, Boolean.TRUE);
        }
        this.nodeViewFolder = new NodeViewFolder(true);
        this.setMap(viewedMap);
        this.mapScroller.setAnchorView(this.currentRootView);
    }

    private NodeModel getSearchRoot() {
        return this.currentSearchRoot;
    }

    public void setMap(MapModel viewedMap) {
        if (this.viewedMap != null) {
            this.viewedMap.removeMapChangeListener(this);
        }
        Point rootLocationOnScreen = this.isShowing() ? this.getRoot().getMainView().getLocationOnScreen() : null;
        this.viewedMap = viewedMap;
        this.setName(viewedMap.getTitle());
        NoteController noteController = NoteController.getController(this.getModeController());
        this.showNotes = noteController != null && noteController.showNotesInMap(this.getMap());
        this.updateContentStyle();
        this.initRoot();
        this.setBackground(this.requiredBackground());
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(viewedMap);
        this.zoom = mapStyleModel.getZoom();
        this.layoutType = mapStyleModel.getMapViewLayout();
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        String fitToViewportAsString = mapStyle.getPropertySetDefault(viewedMap, "fit_to_viewport");
        this.fitToViewport = Boolean.parseBoolean(fitToViewportAsString);
        this.allowsCompactLayout = mapStyle.allowsCompactLayout(viewedMap);
        this.tagLocation = mapStyle.tagLocation(viewedMap);
        this.iconLocation = mapStyle.iconLocation(viewedMap);
        this.rootsHistory.clear();
        this.filter = Filter.createTransparentFilter();
        viewedMap.addMapChangeListener(this);
        if (rootLocationOnScreen != null) {
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(() -> {
                Point newRootLocationOnScreen = this.getRoot().getMainView().getLocationOnScreen();
                Rectangle visibleRect = this.getVisibleRect();
                visibleRect.translate(newRootLocationOnScreen.x - rootLocationOnScreen.x, newRootLocationOnScreen.y - rootLocationOnScreen.y);
                this.scrollRectToVisible(visibleRect);
                this.preserveRootNodeLocationOnScreen();
            });
        }
    }

    public void replaceSelection(NodeView[] views) {
        this.selection.replace(views);
        if (views.length > 0) {
            views[0].requestFocusInWindow();
        }
    }

    private Set<AWTKeyStroke> emptyNodeViewSet() {
        return Collections.emptySet();
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        int distanceToEdge;
        JViewport viewPort = (JViewport)this.getParent();
        Rectangle viewRectangle = viewPort.getViewRect();
        if (!viewRectangle.contains(cursorLocn)) {
            return;
        }
        int distanceToLeft = cursorLocn.x - viewRectangle.x;
        int distanceToRight = viewRectangle.x + viewRectangle.width - cursorLocn.x;
        int distanceToTop = cursorLocn.y - viewRectangle.y;
        int distanceToBottom = viewRectangle.y + viewRectangle.height - cursorLocn.y;
        int deltaX = 0;
        int deltaY = 0;
        if (distanceToLeft < AUTOSCROLL_MARGIN && distanceToLeft < distanceToRight) {
            distanceToEdge = AUTOSCROLL_MARGIN - distanceToLeft;
            deltaX = -this.calculateAutoscrollAmount(distanceToEdge);
        } else if (distanceToRight < AUTOSCROLL_MARGIN) {
            distanceToEdge = AUTOSCROLL_MARGIN - distanceToRight;
            deltaX = this.calculateAutoscrollAmount(distanceToEdge);
        }
        if (distanceToTop < AUTOSCROLL_MARGIN && distanceToTop < distanceToBottom) {
            distanceToEdge = AUTOSCROLL_MARGIN - distanceToTop;
            deltaY = -this.calculateAutoscrollAmount(distanceToEdge);
        } else if (distanceToBottom < AUTOSCROLL_MARGIN) {
            distanceToEdge = AUTOSCROLL_MARGIN - distanceToBottom;
            deltaY = this.calculateAutoscrollAmount(distanceToEdge);
        }
        Rectangle newViewRectangle = new Rectangle(viewRectangle.x + deltaX, viewRectangle.y + deltaY, viewRectangle.width, viewRectangle.height);
        this.scrollRectToVisible(newViewRectangle);
    }

    private int calculateAutoscrollAmount(int distanceToEdge) {
        return distanceToEdge * distanceToEdge * 2 / AUTOSCROLL_MARGIN;
    }

    boolean frameLayoutCompleted() {
        Frame frame = JOptionPane.getFrameForComponent(this);
        Insets frameInsets = frame.getInsets();
        Component rootPane = frame.getComponent(0);
        boolean frameLayoutCompleted = rootPane.getWidth() == frame.getWidth() - frameInsets.left - frameInsets.right && rootPane.getHeight() == frame.getHeight() - frameInsets.top - frameInsets.bottom;
        return frameLayoutCompleted;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.modeController.getMapController().addUINodeChangeListener(this.connectorChangeListener);
        this.getParent().addComponentListener(this.viewportSizeChangeListener);
    }

    @Override
    public void removeNotify() {
        this.modeController.getMapController().removeNodeChangeListener(this.connectorChangeListener);
        this.getParent().removeComponentListener(this.viewportSizeChangeListener);
        super.removeNotify();
    }

    boolean isLayoutCompleted() {
        JViewport viewPort = (JViewport)this.getParent();
        Dimension visibleDimension = viewPort.getExtentSize();
        return visibleDimension.width > 0;
    }

    private static void createPropertyChangeListener() {
        propertyChangeListener = new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("printonwhitebackground")) {
                    printOnWhiteBackground = TreeXmlReader.xmlToBoolean(newValue);
                    return;
                }
                if (propertyName.equals(MapView.DRAGGING_AREA_WIDTH_PROPERTY)) {
                    draggingAreaWidth = ResourceController.getResourceController().getLengthProperty(MapView.DRAGGING_AREA_WIDTH_PROPERTY);
                    return;
                }
                JComponent c = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
                if (!(c instanceof MapView)) {
                    return;
                }
                MapView mapView = (MapView)c;
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_COLOR)) {
                    mapView.repaintSelecteds(true);
                    return;
                }
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_RECTANGLE_COLOR)) {
                    mapView.repaintSelecteds(true);
                    return;
                }
                if (propertyName.equals("standarddrawrectangleforselection")) {
                    drawsRectangleForSelection = TreeXmlReader.xmlToBoolean(newValue);
                    mapView.repaintSelecteds(true);
                    return;
                }
                if (propertyName.equals(MapView.SPOTLIGHT_BACKGROUND_COLOR)) {
                    spotlightBackgroundColor = ColorUtils.stringToColor(newValue);
                    mapView.repaint();
                    return;
                }
                for (Component component : Controller.getCurrentController().getMapViewManager().getMapViews()) {
                    if (!(component instanceof MapView)) continue;
                    MapView mapView2 = (MapView)component;
                    if (propertyName.equals(MapView.SHOW_TAGS_ON_MINIMIZED_NODES_PROPERTY)) {
                        showsTagsOnMinimizedNodes = TreeXmlReader.xmlToBoolean(newValue);
                        mapView2.updateIconsRecursively();
                        mapView2.repaint();
                        continue;
                    }
                    if (propertyName.equals(SHOW_CONNECTORS_PROPERTY)) {
                        showConnectorsPropertyValue = ResourceController.getResourceController().getProperty(SHOW_CONNECTORS_PROPERTY).intern();
                        mapView2.repaint();
                        continue;
                    }
                    if (propertyName.startsWith(MapView.SOME_CONNECTORS_PROPERTY)) {
                        showConnectorsPropertyValue = ResourceController.getResourceController().getProperty(SHOW_CONNECTORS_PROPERTY).intern();
                        mapView2.repaint();
                        continue;
                    }
                    if (propertyName.equals(MapView.OUTLINE_HGAP_PROPERTY)) {
                        outlineHGap = ResourceController.getResourceController().getLengthProperty(MapView.OUTLINE_HGAP_PROPERTY);
                        if (!mapView2.isOutlineLayoutSet()) continue;
                        mapView2.getRoot().updateAll();
                        mapView2.repaint();
                        continue;
                    }
                    if (propertyName.equals(HIDE_SINGLE_END_CONNECTORS)) {
                        hideSingleEndConnectorsPropertyValue = ResourceController.getResourceController().getBooleanProperty(HIDE_SINGLE_END_CONNECTORS);
                        mapView2.repaint();
                        continue;
                    }
                    if (!propertyName.equals(MapView.OUTLINE_VIEW_FITS_WINDOW_WIDTH)) break;
                    outlineViewFitsWindowWidth = ResourceController.getResourceController().getBooleanProperty(MapView.OUTLINE_VIEW_FITS_WINDOW_WIDTH);
                    if (!mapView2.isOutlineLayoutSet()) continue;
                    mapView2.getRoot().updateAll();
                    mapView2.repaint();
                }
            }
        };
        ResourceController.getResourceController().addPropertyChangeListener(propertyChangeListener);
    }

    private void updateIconsRecursively() {
        this.updateIconsRecursively(this.currentRootView);
        if (this.mapRootView != this.currentRootView) {
            this.updateIconsRecursively(this.mapRootView);
        }
    }

    public void deselect(NodeView newSelected) {
        if (this.selection.contains(newSelected) && this.selection.deselect(newSelected) && newSelected.getParent() != null) {
            this.repaintAfterSelectionChange(newSelected, true);
        }
    }

    void updateSelectedNode() {
        this.selection.updateSelectedNode();
    }

    private void repaintAfterSelectionChange(NodeView node, boolean update) {
        if (!node.isShowing()) {
            return;
        }
        if (update) {
            node.update(UpdateCause.SELECTION);
        }
        if (SHOW_CONNECTORS_FOR_SELECTION_ONLY == this.showConnectors || SHOW_ARROWS_FOR_SELECTION_ONLY == this.showConnectors || this.repaintsViewOnSelectionChange) {
            this.repaint(this.getVisibleRect());
        } else {
            node.repaintSelected();
        }
    }

    public Object detectView(Point p) {
        ILinkView arrowView;
        int i;
        if (this.arrowLinkViews == null) {
            return null;
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, true)) continue;
            return arrowView;
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, false)) continue;
            return arrowView;
        }
        return null;
    }

    public Object detectObject(Point p) {
        Object view = this.detectView(p);
        if (view instanceof ILinkView) {
            return ((ILinkView)view).getConnector();
        }
        return null;
    }

    public void endPrinting() {
        if (!this.isPreparedForPrinting) {
            return;
        }
        this.paintingPurpose = PaintingPurpose.PAINTING;
        this.updatePrintedNodes();
        this.isPreparedForPrinting = false;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Container parent = this.getParent();
        if (parent == null) {
            return new Insets(0, 0, 0, 0);
        }
        Rectangle outer = this.getBounds();
        Rectangle inner = parent.getBounds();
        return new Insets(inner.y - outer.y + AUTOSCROLL_MARGIN, inner.x - outer.x + AUTOSCROLL_MARGIN, outer.height - inner.height - inner.y + outer.y + AUTOSCROLL_MARGIN, outer.width - inner.width - inner.x + outer.x + AUTOSCROLL_MARGIN);
    }

    public Rectangle getInnerBounds() {
        Rectangle innerBounds = this.currentRootView.getBounds();
        Rectangle maxBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.arrowLinkViews != null) {
            for (int i = 0; i < this.arrowLinkViews.size(); ++i) {
                ILinkView arrowView = this.arrowLinkViews.get(i);
                arrowView.increaseBounds(innerBounds);
            }
        }
        return innerBounds.intersection(maxBounds);
    }

    public IMapSelection getMapSelection() {
        return new MapSelection();
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public MapModel getMap() {
        return this.viewedMap;
    }

    public Point getNodeContentLocation(NodeView nodeView) {
        Point contentXY = new Point(0, 0);
        UITools.convertPointToAncestor((Component)nodeView.getContent(), contentXY, this);
        return contentXY;
    }

    private NodeView getNodeView(Object o) {
        if (!(o instanceof NodeModel)) {
            return null;
        }
        NodeView nodeView = this.getNodeView((NodeModel)o);
        return nodeView;
    }

    private NodeView getDisplayedNodeView(NodeModel node) {
        NodeView nodeView = this.getNodeView(node);
        return this.currentRootView == this.mapRootView || nodeView != null && this.isAncestorOf(nodeView) ? nodeView : null;
    }

    public NodeView getNodeView(NodeModel node) {
        if (node == null) {
            return null;
        }
        for (INodeView iNodeView : node.getViewers()) {
            NodeView candidateView;
            if (!(iNodeView instanceof NodeView) || (candidateView = (NodeView)iNodeView).getMap() != this) continue;
            return candidateView;
        }
        NodeView root = this.getRoot();
        if (root.getNode().equals(node)) {
            return root;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public NodeView getRoot() {
        return this.currentRootView;
    }

    public NodeView getSelected() {
        if (!this.selectedsValid) {
            NodeView node = this.selection.selectedNode;
            if (node == null || !SwingUtilities.isDescendingFrom(node, this)) {
                this.validateSelecteds();
            } else {
                JComponent content = node.getContent();
                if (content == null || !content.isVisible()) {
                    this.validateSelecteds();
                }
            }
        }
        return this.selection.selectedNode;
    }

    public NodeView getSelectionEnd() {
        this.getSelected();
        return this.selection.getSelectionEnd();
    }

    public Set<NodeModel> getSelectedNodes() {
        this.validateSelecteds();
        return new AbstractSet<NodeModel>(){

            @Override
            public int size() {
                return MapView.this.selection.size();
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                if (MapView.this.selection.deselect(nodeView)) {
                    MapView.this.updateSelectedNode();
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<NodeModel> iterator() {
                return new Iterator<NodeModel>(){
                    final Iterator<NodeView> i;
                    {
                        this.i = MapView.this.selection.getSelectedSet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public NodeModel next() {
                        return this.i.next().getNode();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    public List<NodeModel> getOrderedSelectedNodes() {
        this.validateSelecteds();
        return new AbstractList<NodeModel>(){

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                if (MapView.this.selection.deselect(nodeView)) {
                    MapView.this.updateSelectedNode();
                    return true;
                }
                return false;
            }

            @Override
            public NodeModel get(int index) {
                return ((NodeView)MapView.this.selection.getSelectedList().get(index)).getNode();
            }

            @Override
            public int size() {
                return MapView.this.selection.size();
            }
        };
    }

    ArrayList<NodeModel> getSelectedNodesSortedByY(boolean differentSubtrees) {
        this.validateSelecteds();
        TreeSet<NodeModel> sortedNodes = new TreeSet<NodeModel>(NodeRelativePath.comparator());
        for (NodeView view : this.selection.getSelectedSet()) {
            if (differentSubtrees && this.viewBelongsToSelectedSubtreeOrItsClone(view)) continue;
            sortedNodes.add(view.getNode());
        }
        if (differentSubtrees) {
            return NodeSubtrees.getUniqueSubtreeRoots(sortedNodes);
        }
        return new ArrayList<NodeModel>(sortedNodes);
    }

    private boolean viewBelongsToSelectedSubtreeOrItsClone(NodeView view) {
        HashSet<NodeModel> selectedNodesWithClones = new HashSet<NodeModel>();
        for (NodeView selectedView : this.selection.getSelectedList()) {
            for (NodeModel clone : selectedView.getNode().subtreeClones()) {
                selectedNodesWithClones.add(clone);
            }
        }
        Container parent = view.getParent();
        while (parent instanceof NodeView) {
            if (selectedNodesWithClones.contains(((NodeView)parent).getNode())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public Collection<NodeView> getSelection() {
        this.validateSelecteds();
        return this.selection.getSelection();
    }

    boolean synchronizesSelectionAcrossVisibleViews() {
        return ResourceController.getResourceController().getBooleanProperty(SYNCHRONIZE_SELECTION_ACROSS_VISIBLE_VIEWS_PROPERTY);
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public Dimension getViewportSize() {
        JViewport mapViewport = (JViewport)this.getParent();
        return mapViewport == null ? null : mapViewport.getSize();
    }

    private boolean unfoldsOnNavigation() {
        return ResourceController.getResourceController().getBooleanProperty(UNFOLD_ON_NAVIGATION);
    }

    boolean isOutlineLayoutSet() {
        return this.layoutType.equals((Object)MapViewLayout.OUTLINE);
    }

    int getIndex(NodeView node) {
        NodeView parent = node.getParentView();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!parent.getComponent(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)Math.ceil((float)number * this.zoom);
    }

    public int getZoomed(double number) {
        return (int)Math.ceil(number * (double)this.zoom);
    }

    private void initRoot() {
        if (this.currentRootView != null) {
            this.remove(this.currentRootView);
        }
        this.currentRootParentView = null;
        this.mapRootView = this.currentRootView = NodeViewFactory.getInstance().newNodeView(this.getMap().getRootNode(), this, this, 0);
        this.selection.clear();
    }

    @Override
    public Color getBackground() {
        return super.getBackground();
    }

    public boolean isPrinting() {
        return this.paintingPurpose != PaintingPurpose.PAINTING;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting() || !this.selectedsValid && (this.selection.selectedNode == null || !SwingUtilities.isDescendingFrom(this.selection.selectedNode, this) || !this.selection.selectedNode.getContent().isVisible())) {
            return false;
        }
        return this.selection.contains(n);
    }

    void addSelected(NodeView newSelected, boolean scroll) {
        if (newSelected.isContentVisible()) {
            this.selection.add(newSelected);
            if (scroll) {
                this.mapScroller.scrollNodeToVisible(newSelected);
            }
        }
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        MapStyle mapStyle;
        String fitToViewportAsString;
        Object property = event.getProperty();
        if (property.equals("standardbackgroundcolor")) {
            this.setBackground(this.requiredBackground());
            return;
        }
        if (property.equals("MAP_STYLES")) {
            this.updateContentStyle();
            this.getRoot().resetLayoutPropertiesRecursively();
            this.revalidate();
            this.repaint();
        }
        if (property.equals(Filter.class)) {
            this.setSiblingMaxLevel(this.getSelected());
        }
        if (property.equals((Object)IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT)) {
            this.currentRootView.updateIcons();
            this.setSiblingMaxLevel(this.getSelected());
        }
        if (property.equals("MAP_STYLES") && event.getMap().equals(this.viewedMap) || property.equals("AttributeViewType") || property.equals(Filter.class) || property.equals("map_url")) {
            this.setBackground(this.requiredBackground());
            this.updateAllNodeViews();
            return;
        }
        if (property instanceof Tag || property.equals(TagCategories.class)) {
            if (TagLocation.BESIDE_NODES == this.getTagLocation()) {
                this.updateIconsRecursively(this.getRoot());
            } else {
                this.updateAllNodeViews();
            }
            return;
        }
        if (property.equals("show_icon_for_attributes") || property.equals("show_note_icons") || property.equals("show_tags")) {
            this.updateIconsRecursively(this.getRoot());
        }
        if (property.equals("show_notes_in_map")) {
            this.setShowNotes();
        }
        if (property.equals("backgroundImageURI")) {
            fitToViewportAsString = MapStyle.getController(this.modeController).getPropertySetDefault(this.viewedMap, "fit_to_viewport");
            this.setFitToViewport(Boolean.parseBoolean(fitToViewportAsString));
            this.loadBackgroundImage();
        }
        if (property.equals("allow_compact_layout")) {
            mapStyle = this.getModeController().getExtension(MapStyle.class);
            this.allowsCompactLayout = mapStyle.allowsCompactLayout(this.viewedMap);
            this.getRoot().resetLayoutPropertiesRecursively();
            this.revalidate();
            this.repaint();
        }
        if (property.equals("show_tags") || property.equals("showTagCategories")) {
            mapStyle = this.getModeController().getExtension(MapStyle.class);
            this.tagLocation = mapStyle.tagLocation(this.viewedMap);
            this.updateAllNodeViews();
            this.repaint();
        }
        if (property.equals("show_icons")) {
            mapStyle = this.getModeController().getExtension(MapStyle.class);
            this.iconLocation = mapStyle.iconLocation(this.viewedMap);
            this.updateIconsRecursively(this.getRoot());
            this.repaint();
        }
        if (property.equals("fit_to_viewport")) {
            fitToViewportAsString = MapStyle.getController(this.modeController).getPropertySetDefault(this.viewedMap, "fit_to_viewport");
            this.setFitToViewport(Boolean.parseBoolean(fitToViewportAsString));
            this.adjustBackgroundComponentScale();
        }
        if (property.equals("edgeColorConfiguration")) {
            this.updateAllNodeViews();
            this.repaint();
        }
    }

    private void setFitToViewport(boolean fitToViewport) {
        this.fitToViewport = fitToViewport;
        this.updateBackground();
    }

    private void loadBackgroundImage() {
        ViewerController vc;
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        this.backgroundComponent = null;
        this.updateBackground();
        URI uri = mapStyle.getBackgroundImage(this.viewedMap);
        if (uri != null && (vc = this.getModeController().getExtension(ViewerController.class)) != null) {
            IViewerFactory factory = vc.getViewerFactory();
            this.assignViewerToBackgroundComponent(factory, uri);
        }
        this.repaint();
    }

    private void assignViewerToBackgroundComponent(IViewerFactory factory, URI uri) {
        try {
            if (this.fitToViewport) {
                JViewport vp = (JViewport)this.getParent();
                Dimension viewPortSize = vp.getVisibleRect().getSize();
                ScalableComponent viewer = factory.createViewer(uri, viewPortSize, () -> this.getParent().repaint());
                this.setBackgroundComponent(viewer);
            } else {
                ScalableComponent viewer = factory.createViewer(uri, this.zoom, () -> this.getParent().repaint());
                this.setBackgroundComponent(viewer);
            }
            if (this.backgroundComponent == null) {
                LogUtils.warn("no viewer created for " + uri);
                return;
            }
        }
        catch (FileNotFoundException e1) {
            LogUtils.warn(e1);
        }
        catch (Exception e1) {
            LogUtils.severe(e1);
        }
    }

    private void setBackgroundComponent(ScalableComponent viewer) {
        this.backgroundComponent = viewer;
        this.updateBackground();
    }

    private void updateBackground() {
        MapViewScrollPane.MapViewPort viewport = (MapViewScrollPane.MapViewPort)this.getParent();
        Color background = this.getBackground();
        if (viewport != null) {
            if (this.fitToViewport) {
                viewport.setBackground(background);
                viewport.setBackgroundComponent(this.backgroundComponent);
            } else {
                viewport.setBackgroundComponent(null);
            }
        }
        this.setOpaque((!this.fitToViewport || this.backgroundComponent == null) && background.getAlpha() == 255);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.updateBackground();
    }

    private void updateIconsRecursively(NodeView node) {
        MainView mainView = node.getMainView();
        if (mainView == null) {
            return;
        }
        mainView.updateIcons(node);
        for (int i = 0; i < node.getComponentCount(); ++i) {
            Component component = node.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            this.updateIconsRecursively((NodeView)component);
        }
    }

    void synchronizeSelection() {
        if (this.isSelected()) {
            return;
        }
        IMapSelection mainSelection = this.modeController.getController().getSelection();
        if (mainSelection == null) {
            return;
        }
        if (this.getSelectedNodes().size() > 1) {
            return;
        }
        NodeModel node = mainSelection.getSelected();
        NodeView selectedNodeView = this.getSelected();
        NodeModel selectedNode = selectedNodeView.getNode();
        if (selectedNode.equals(node) || selectedNode.isDescendantOf(node)) {
            return;
        }
        NodeModel anotherMapViewRootNode = this.getRoot().getNode();
        if (anotherMapViewRootNode != node && !node.isDescendantOf(anotherMapViewRootNode)) {
            return;
        }
        for (NodeModel nodeOrAncestor = node; nodeOrAncestor != null; nodeOrAncestor = nodeOrAncestor.getParentNode()) {
            NodeView anotherNodeView = this.getNodeView(nodeOrAncestor);
            if (anotherNodeView == null || !anotherNodeView.isContentVisible()) continue;
            this.selectAsTheOnlyOneSelected(anotherNodeView, false);
            break;
        }
    }

    private void updateContentStyle() {
        NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        MapModel map = this.getMap();
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel detailStyleNode = model.getStyleNodeSafe(MapStyleModel.DETAILS_STYLE);
        this.detailFont = UITools.scale(style.getFont(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        this.detailBackground = style.getBackgroundColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.detailForeground = style.getColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.detailHorizontalAlignment = style.getHorizontalTextAlignment((NodeModel)detailStyleNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant;
        this.detailCss = style.getStyleSheet(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        NodeModel noteStyleNode = model.getStyleNodeSafe(MapStyleModel.NOTE_STYLE);
        this.noteFont = UITools.scale(style.getFont(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        this.noteBackground = style.getBackgroundColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.noteForeground = style.getColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.noteHorizontalAlignment = style.getHorizontalTextAlignment((NodeModel)noteStyleNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant;
        this.noteCss = style.getStyleSheet(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.updateSelectionColors();
    }

    public boolean selectLeft(boolean continious) {
        return this.selectRelatedNode(SelectionDirection.LEFT, continious);
    }

    private void select(NodeView newSelected, boolean continious) {
        if (continious) {
            if (newSelected.isSelected()) {
                if (this.selection.getSelectionBeforeEnd() == newSelected) {
                    this.deselect(this.selection.getSelectionEnd());
                    this.setSiblingMaxLevel(this.selection.getSelectionEnd());
                    this.mapScroller.scrollNodeToVisible(newSelected);
                }
            } else {
                this.addSelected(newSelected, true);
                this.mapScroller.scrollNodeToVisible(newSelected);
                this.setSiblingMaxLevel(newSelected);
            }
        } else {
            this.selectAsTheOnlyOneSelected(newSelected);
            this.modeController.getMapController().scrollNodeTreeAfterSelect(newSelected.getNode());
        }
    }

    public boolean selectRight(boolean continious) {
        return this.selectRelatedNode(SelectionDirection.RIGHT, continious);
    }

    private boolean selectRelatedNode(SelectionDirection direction, boolean continious) {
        if (this.selection.getSelectionEnd() == null) {
            return false;
        }
        return this.selectSingleNode(direction, continious) || this.selectPreferredVisibleChild(direction, continious) || this.selectSiblingOnTheOtherSide(direction, continious) || this.selectPreferredVisibleSiblingOrAncestor(direction, continious) || this.selectPreferredVisibleAncestorSibling(direction, continious) || this.unfoldInDirection(direction) || this.scroll(direction);
    }

    private boolean selectSingleNode(SelectionDirection direction, boolean continious) {
        NodeView newSelected;
        NodeView selectionEnd;
        if (continious) {
            return false;
        }
        NodeView selectionStart = this.selection.getSelectionStart();
        if (selectionStart == (selectionEnd = this.selection.getSelectionEnd())) {
            return false;
        }
        Point startLocation = this.currentRootView.getRelativeLocation(selectionStart, 0.5, 0.5);
        Point endLocation = this.currentRootView.getRelativeLocation(selectionEnd, 0.5, 0.5);
        switch (direction.ordinal()) {
            case 2: {
                newSelected = startLocation.y > endLocation.y ? selectionStart : selectionEnd;
                break;
            }
            case 3: {
                newSelected = startLocation.y < endLocation.y ? selectionStart : selectionEnd;
                break;
            }
            case 1: {
                newSelected = startLocation.x < endLocation.x ? selectionStart : selectionEnd;
                break;
            }
            case 0: {
                newSelected = startLocation.x > endLocation.x ? selectionStart : selectionEnd;
                break;
            }
            default: {
                return false;
            }
        }
        this.select(newSelected, false);
        return true;
    }

    public boolean scroll(SelectionDirection direction) {
        switch (direction.ordinal()) {
            case 2: {
                this.scrollBy(0, SCROLL_VELOCITY_PX);
                break;
            }
            case 3: {
                this.scrollBy(0, -SCROLL_VELOCITY_PX);
                break;
            }
            case 1: {
                this.scrollBy(-SCROLL_VELOCITY_PX, 0);
                break;
            }
            case 0: {
                this.scrollBy(SCROLL_VELOCITY_PX, 0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean selectPreferredVisibleChild(SelectionDirection direction, boolean continious) {
        boolean isOutlineLayoutSet = this.isOutlineLayoutSet();
        if (isOutlineLayoutSet && direction != SelectionDirection.DOWN) {
            return false;
        }
        NodeView oldSelected = this.selection.getSelectionEnd();
        NodeView newSelected = null;
        boolean selectedUsesHorizontalLayout = oldSelected.usesHorizontalLayout();
        ChildNodesAlignment childNodesAlignment = oldSelected.getChildNodesAlignment();
        if (isOutlineLayoutSet || selectedUsesHorizontalLayout && (!childNodesAlignment.isStacked() && (direction == SelectionDirection.UP || direction == SelectionDirection.DOWN) || childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && direction == SelectionDirection.LEFT || childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && direction == SelectionDirection.RIGHT) || !selectedUsesHorizontalLayout && (!childNodesAlignment.isStacked() && (direction == SelectionDirection.LEFT || direction == SelectionDirection.RIGHT) || childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && direction == SelectionDirection.UP || childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && direction == SelectionDirection.DOWN)) {
            NodeView.PreferredChild preferredChild;
            boolean looksAtTopOrLeft;
            boolean bl = looksAtTopOrLeft = direction == SelectionDirection.LEFT || direction == SelectionDirection.UP;
            NodeView.PreferredChild preferredChild2 = isOutlineLayoutSet || !selectedUsesHorizontalLayout && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT || continious ? NodeView.PreferredChild.FIRST : (preferredChild = !selectedUsesHorizontalLayout && childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT ? NodeView.PreferredChild.LAST : NodeView.PreferredChild.LAST_SELECTED);
            newSelected = isOutlineLayoutSet || (direction == SelectionDirection.LEFT || direction == SelectionDirection.RIGHT) == selectedUsesHorizontalLayout ? oldSelected.getPreferredVisibleChild(preferredChild, ChildrenSides.BOTH_SIDES) : oldSelected.getPreferredVisibleChild(preferredChild, looksAtTopOrLeft);
        }
        if (newSelected != null) {
            this.select(newSelected, continious);
            return true;
        }
        return false;
    }

    private boolean selectSiblingOnTheOtherSide(SelectionDirection direction, boolean continious) {
        if (this.isOutlineLayoutSet()) {
            return false;
        }
        NodeView oldSelected = this.selection.getSelectionEnd();
        boolean isTopOrLeft = oldSelected.isTopOrLeft();
        NodeView ancestorView = oldSelected.getParentView();
        while (true) {
            if (ancestorView == null) {
                return false;
            }
            if ((ancestorView.getChildNodesAlignment().isStacked() || !ancestorView.isContentVisible()) && ancestorView.childrenSides() == ChildrenSides.BOTH_SIDES) break;
            if (ancestorView.isContentVisible()) {
                return false;
            }
            isTopOrLeft = ancestorView.isTopOrLeft();
            ancestorView = ancestorView.getParentView();
        }
        NodeView newSelected = null;
        if (ancestorView.layoutOrientation() == LayoutOrientation.TOP_TO_BOTTOM && (isTopOrLeft && direction == SelectionDirection.RIGHT || !isTopOrLeft && direction == SelectionDirection.LEFT) || ancestorView.layoutOrientation() == LayoutOrientation.LEFT_TO_RIGHT && (isTopOrLeft && direction == SelectionDirection.DOWN || !isTopOrLeft && direction == SelectionDirection.UP)) {
            newSelected = ancestorView.selectNearest(NodeView.PreferredChild.NEAREST_SIBLING, ChildrenSides.ofTopOrLeft((!isTopOrLeft ? 1 : 0) != 0), oldSelected);
        }
        if (newSelected != null) {
            this.selectPreservingSiblingMaxLevel(newSelected, continious);
            return true;
        }
        return false;
    }

    private boolean selectPreferredVisibleSiblingOrAncestor(SelectionDirection direction, boolean continious) {
        boolean isOutlineLayoutSet = this.isOutlineLayoutSet();
        if (isOutlineLayoutSet && direction == SelectionDirection.RIGHT) {
            return false;
        }
        NodeView oldSelected = this.selection.getSelectionEnd();
        if (!oldSelected.isRoot()) {
            NodeView newSelectedAncestor = this.suggestNewSelectedAncestor(direction, oldSelected);
            NodeView newSelectedSibling = this.suggestNewSelectedSibling(direction, oldSelected);
            NodeView newSelectedSummary = this.suggestNewSelectedSummary(direction, oldSelected);
            NodeView newSelected = newSelectedSibling;
            if (newSelectedSummary != null && (newSelectedSibling == null || newSelectedSummary.getNode().isDescendantOf(newSelectedSibling.getAncestorWithVisibleContent().getNode()))) {
                newSelected = newSelectedSummary;
            }
            if (!(newSelectedAncestor == null || newSelected != null && oldSelected != newSelected && newSelected.getNode().isDescendantOf(newSelectedAncestor.getNode()))) {
                newSelected = newSelectedAncestor;
            }
            if (newSelected != null && newSelected != oldSelected) {
                NodeView parentView = oldSelected.getParentView();
                if (newSelected.getParent() == parentView && parentView.layoutOrientation() == LayoutOrientation.TOP_TO_BOTTOM) {
                    ChildNodesAlignment childNodesAlignment = parentView.getChildNodesAlignment();
                    if (childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && direction == SelectionDirection.UP) {
                        this.selectDescendant(newSelected, continious, NodeView.PreferredChild.LAST);
                        return true;
                    }
                    if (childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && direction == SelectionDirection.DOWN) {
                        this.selectDescendant(newSelected, continious, NodeView.PreferredChild.FIRST);
                        return true;
                    }
                }
                if (newSelected == newSelectedAncestor) {
                    this.select(newSelected, continious);
                } else {
                    this.selectPreservingSiblingMaxLevel(newSelected, continious);
                }
                return true;
            }
        }
        return false;
    }

    private boolean selectPreferredVisibleAncestorSibling(SelectionDirection direction, boolean continious) {
        boolean isOutlineLayoutSet = this.isOutlineLayoutSet();
        if (isOutlineLayoutSet) {
            return false;
        }
        int oldSiblingMaxLevel = this.siblingMaxLevel;
        this.siblingMaxLevel = -1;
        for (NodeView oldSelectedParent = this.selection.getSelectionEnd().getParentNodeView(); oldSelectedParent != null && !oldSelectedParent.isRoot(); oldSelectedParent = oldSelectedParent.getParentNodeView()) {
            NodeView newSelected = this.suggestNewSelectedSibling(direction, oldSelectedParent);
            if (newSelected == null) continue;
            this.siblingMaxLevel = oldSiblingMaxLevel;
            this.select(newSelected, continious);
            return true;
        }
        this.siblingMaxLevel = oldSiblingMaxLevel;
        return false;
    }

    private void selectPreservingSiblingMaxLevel(NodeView newSelected, boolean continious) {
        int oldSiblingMaxLevel = this.siblingMaxLevel;
        this.siblingMaxLevel = -1;
        this.select(newSelected, continious);
        this.siblingMaxLevel = oldSiblingMaxLevel;
    }

    private NodeView suggestNewSelectedSibling(SelectionDirection direction, NodeView oldSelected) {
        boolean down;
        LayoutOrientation orientation;
        SiblingSelection siblingSelection = ResourceController.getResourceController().getEnumProperty("siblingSelection", SiblingSelection.CHANGE_PARENT);
        switch (direction.ordinal()) {
            case 2: {
                orientation = LayoutOrientation.TOP_TO_BOTTOM;
                down = true;
                break;
            }
            case 3: {
                orientation = LayoutOrientation.TOP_TO_BOTTOM;
                down = false;
                break;
            }
            case 0: {
                orientation = LayoutOrientation.LEFT_TO_RIGHT;
                down = true;
                break;
            }
            case 1: {
                orientation = LayoutOrientation.LEFT_TO_RIGHT;
                down = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction");
            }
        }
        return this.getNextVisibleSibling(oldSelected, orientation, down, siblingSelection);
    }

    private NodeView getNextVisibleSibling(NodeView oldSelected, LayoutOrientation orientation, boolean down, SiblingSelection siblingSelection) {
        NodeView nextVisibleSiblingOrSame;
        NodeView nextSelectedSibling = oldSelected;
        do {
            if ((nextVisibleSiblingOrSame = this.getNextVisibleSiblingAtAnyLevel(nextSelectedSibling, orientation, down, siblingSelection)) != nextSelectedSibling) continue;
            return oldSelected;
        } while ((nextSelectedSibling = nextVisibleSiblingOrSame) != null && nextSelectedSibling.getNode().getNodeLevel(this.filter) < this.siblingMaxLevel);
        return nextSelectedSibling;
    }

    private NodeView suggestNewSelectedAncestor(SelectionDirection direction, NodeView oldSelected) {
        NodeView newSelectedParent = null;
        NodeView parentView = oldSelected.getParentView();
        ChildNodesAlignment childNodesAlignment = parentView.getChildNodesAlignment();
        LayoutOrientation layoutOrientation = parentView.layoutOrientation();
        if (direction == SelectionDirection.DOWN) {
            newSelectedParent = oldSelected.getVisibleSummarizedOrParentView(layoutOrientation == LayoutOrientation.TOP_TO_BOTTOM && childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT ? LayoutOrientation.TOP_TO_BOTTOM : LayoutOrientation.LEFT_TO_RIGHT, layoutOrientation == LayoutOrientation.TOP_TO_BOTTOM && childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT ? oldSelected.isTopOrLeft() : true);
        } else if (direction == SelectionDirection.UP) {
            newSelectedParent = oldSelected.getVisibleSummarizedOrParentView(layoutOrientation == LayoutOrientation.TOP_TO_BOTTOM && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT ? LayoutOrientation.TOP_TO_BOTTOM : LayoutOrientation.LEFT_TO_RIGHT, layoutOrientation == LayoutOrientation.TOP_TO_BOTTOM && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT ? oldSelected.isTopOrLeft() : false);
        } else if (direction == SelectionDirection.RIGHT) {
            newSelectedParent = oldSelected.getVisibleSummarizedOrParentView(layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT && childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT ? LayoutOrientation.LEFT_TO_RIGHT : LayoutOrientation.TOP_TO_BOTTOM, layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT && childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT ? oldSelected.isTopOrLeft() : true);
        } else if (direction == SelectionDirection.LEFT) {
            newSelectedParent = oldSelected.getVisibleSummarizedOrParentView(layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT ? LayoutOrientation.LEFT_TO_RIGHT : LayoutOrientation.TOP_TO_BOTTOM, layoutOrientation == LayoutOrientation.LEFT_TO_RIGHT && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT ? oldSelected.isTopOrLeft() : false);
        }
        return newSelectedParent;
    }

    private boolean canHaveSummary(NodeView node, SelectionDirection direction) {
        return node.usesHorizontalLayout() && (direction == SelectionDirection.UP && node.isTopOrLeft() || direction == SelectionDirection.DOWN && !node.isTopOrLeft()) || !node.usesHorizontalLayout() && (direction == SelectionDirection.LEFT && node.isTopOrLeft() || direction == SelectionDirection.RIGHT && !node.isTopOrLeft());
    }

    private NodeView suggestNewSelectedSummary(SelectionDirection direction, NodeView node) {
        int currentSummaryLevel;
        if (this.isOutlineLayoutSet() || this.isRoot(node)) {
            return null;
        }
        int level = currentSummaryLevel = SummaryNode.getSummaryLevel(this.currentRootView.getNode(), node.getNode());
        int requiredSummaryLevel = level + 1;
        NodeView parent = node.getParentView();
        if (this.canHaveSummary(node, direction)) {
            Component component;
            for (int i = 1 + this.getIndex(node); i < parent.getComponentCount() && (component = parent.getComponent(i)) instanceof NodeView; ++i) {
                NodeView next = (NodeView)component;
                if (next.isTopOrLeft() != node.isTopOrLeft()) continue;
                level = next.isSummary() ? ++level : 0;
                if (level == requiredSummaryLevel) {
                    if (next.getNode().hasVisibleContent(this.filter)) {
                        return next;
                    }
                    NodeView preferredVisibleChild = next.getPreferredVisibleChild(this.isOutlineLayoutSet() ? NodeView.PreferredChild.FIRST : NodeView.PreferredChild.LAST_SELECTED, next.isTopOrLeft());
                    if (preferredVisibleChild == null) break;
                    return preferredVisibleChild;
                }
                if (level == currentSummaryLevel && SummaryNode.isFirstGroupNode(next.getNode())) break;
            }
        }
        return this.suggestNewSelectedSummary(direction, parent);
    }

    private void selectDescendant(NodeView newSelected, boolean continious, NodeView.PreferredChild preferredChild) {
        newSelected = newSelected.getDescendant(preferredChild);
        this.select(newSelected, continious);
    }

    private boolean unfoldInDirection(SelectionDirection direction) {
        NodeView oldSelected = this.selection.getSelectionEnd();
        boolean selectedUsesHorizontalLayout = oldSelected.usesHorizontalLayout();
        if (oldSelected.isFolded() && this.unfoldsOnNavigation() && (oldSelected.getChildNodesAlignment().isStacked() || selectedUsesHorizontalLayout && (direction == SelectionDirection.UP || direction == SelectionDirection.DOWN) || !selectedUsesHorizontalLayout && (direction == SelectionDirection.LEFT || direction == SelectionDirection.RIGHT))) {
            NodeModel oldModel = oldSelected.getNode();
            this.getModeController().getMapController().unfoldAndScroll(oldModel, this.filter);
            if (oldSelected.isContentVisible()) {
                return true;
            }
        }
        return false;
    }

    public boolean selectUp(boolean continious) {
        return this.selectRelatedNode(SelectionDirection.UP, continious);
    }

    private boolean selectDistantSibling(NodeView oldSelectionEnd, boolean continious, boolean selectsForward) {
        NodeView sibling;
        if (oldSelectionEnd == null || oldSelectionEnd.isRoot()) {
            return false;
        }
        LayoutOrientation layoutOrientation = oldSelectionEnd.getParentView().layoutOrientation();
        SiblingSelection siblingSelection = ResourceController.getResourceController().getEnumProperty("siblingSelection", SiblingSelection.CHANGE_PARENT);
        NodeView nextSelected = oldSelectionEnd;
        while ((sibling = this.getNextVisibleSibling(nextSelected, layoutOrientation, selectsForward, SiblingSelection.STAY_AT_THE_END)) != null && sibling != nextSelected) {
            nextSelected = sibling;
            if (!continious) continue;
            this.selectPreservingSiblingMaxLevel(nextSelected, continious);
        }
        if (nextSelected == oldSelectionEnd && siblingSelection != SiblingSelection.STAY_AT_THE_END) {
            nextSelected = this.getNextVisibleSibling(nextSelected, layoutOrientation, selectsForward, siblingSelection);
        }
        if (nextSelected != oldSelectionEnd && nextSelected != null) {
            if (!continious || siblingSelection != SiblingSelection.STAY_AT_THE_END) {
                this.selectPreservingSiblingMaxLevel(nextSelected, continious);
            }
            return true;
        }
        return false;
    }

    private NodeView getNextVisibleSiblingAtAnyLevel(NodeView node, LayoutOrientation layoutOrientation, boolean down, SiblingSelection siblingSelection) {
        return down ? node.getNextVisibleSibling(layoutOrientation, siblingSelection) : node.getPreviousVisibleSibling(layoutOrientation, siblingSelection);
    }

    public boolean selectDown(boolean continious) {
        return this.selectRelatedNode(SelectionDirection.DOWN, continious);
    }

    public boolean selectPageDown(boolean continious) {
        return this.selectDistantSibling(this.selection.getSelectionEnd(), continious, true);
    }

    public boolean selectPageUp(boolean continious) {
        return this.selectDistantSibling(this.selection.getSelectionEnd(), continious, false);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isPrinting() && this.isPreparedForPrinting) {
            this.isPreparedForPrinting = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapView.this.endPrinting();
                    MapView.this.repaint();
                }
            });
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.antiAliasingConfigurator.withAntialias(g2, () -> {
                if (!this.isPrinting() && g2.getRenderingHint(GraphicsHints.CACHE_ICONS) == null) {
                    g2.setRenderingHint(GraphicsHints.CACHE_ICONS, Boolean.TRUE);
                }
                if (this.containsExtension(Connectors.class)) {
                    this.hideSingleEndConnectors = false;
                    this.showConnectors = SHOW_CONNECTOR_LINES;
                    this.paintConnectorsBehind = false;
                } else {
                    this.hideSingleEndConnectors = hideSingleEndConnectorsPropertyValue;
                    this.showConnectors = showConnectorsPropertyValue;
                    this.paintConnectorsBehind = ResourceController.getResourceController().getBooleanProperty("paint_connectors_behind");
                }
                super.paint(g2);
            });
        }
        finally {
            this.paintingMode = null;
            g2.dispose();
        }
    }

    public void paintOverview(Graphics2D g) {
        g.setRenderingHint(GraphicsHints.CACHE_ICONS, Boolean.FALSE);
        this.paintingPurpose = PaintingPurpose.OVERVIEW;
        this.isPreparedForPrinting = true;
        this.updatePrintedSelectedNodes();
        super.print(g);
        this.paintingPurpose = PaintingPurpose.PAINTING;
        this.updatePrintedSelectedNodes();
        this.isPreparedForPrinting = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean backgroundIsPaintedByViewport;
        boolean usesTransparentBackgroundForPrinting = this.paintingPurpose == PaintingPurpose.PRINTING && printOnWhiteBackground;
        boolean bl = backgroundIsPaintedByViewport = this.paintingPurpose == PaintingPurpose.PAINTING && this.backgroundComponent != null && this.fitToViewport;
        if (!usesTransparentBackgroundForPrinting && !backgroundIsPaintedByViewport) {
            g.setColor(this.getBackground());
            Rectangle clip = g.getClipBounds();
            if (clip != null) {
                int x = Math.max(0, clip.x);
                int y = Math.max(0, clip.y);
                int w = Math.min(this.getWidth() - x, clip.width - (x - clip.x));
                int h = Math.min(this.getHeight() - y, clip.height - (y - clip.y));
                g.fillRect(x, y, w, h);
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (this.backgroundComponent != null && this.paintingPurpose != PaintingPurpose.OVERVIEW && !this.fitToViewport) {
            this.paintBackgroundComponent(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBackgroundComponent(Graphics g) {
        Graphics backgroundGraphics = g.create();
        try {
            Point centerPoint = this.getRootCenterPoint();
            Point backgroundImageTopLeft = this.getBackgroundImageTopLeft(centerPoint);
            backgroundGraphics.translate(backgroundImageTopLeft.x, backgroundImageTopLeft.y);
            this.backgroundComponent.paintComponent(backgroundGraphics);
        }
        finally {
            backgroundGraphics.dispose();
        }
    }

    private Point getRootCenterPoint() {
        Point centerPoint = new Point(this.getRoot().getMainView().getWidth() / 2, this.getRoot().getMainView().getHeight() / 2);
        UITools.convertPointToAncestor((Component)this.getRoot().getMainView(), centerPoint, this);
        return centerPoint;
    }

    private Point getBackgroundImageTopLeft(Point centerPoint) {
        int x = centerPoint.x - this.backgroundComponent.getWidth() / 2;
        int y = centerPoint.y - this.backgroundComponent.getHeight() / 2;
        return new Point(x, y);
    }

    @Override
    protected void paintChildren(Graphics g) {
        PaintingMode[] paintModes = this.paintConnectorsBehind ? new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.LINKS, PaintingMode.NODES, PaintingMode.SELECTED_NODES} : new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.NODES, PaintingMode.SELECTED_NODES, PaintingMode.LINKS};
        Graphics2D g2 = (Graphics2D)g;
        this.paintChildren(g2, paintModes);
        if (this.isSpotlightEnabled()) {
            this.paintDimmer(g2, paintModes);
        }
        this.paintSelecteds(g2);
        this.highlightEditor(g2);
        this.paintSelectionRectangle(g);
    }

    private void paintSelectionRectangle(Graphics g) {
        if (this.selectionRectangle == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(SELECTION_RECTANGLE_STROKE);
        g2d.setColor(MapView.getSelectionRectangleColor());
        g2d.draw(this.selectionRectangle);
    }

    public void setSelectionRectangle(Rectangle newRectangle) {
        Rectangle repaintedRectangle;
        Rectangle oldRectangle = this.selectionRectangle;
        this.selectionRectangle = newRectangle;
        Rectangle rectangle = oldRectangle == null ? newRectangle : (repaintedRectangle = newRectangle == null ? oldRectangle : oldRectangle.union(newRectangle));
        if (repaintedRectangle != null) {
            int lineWidth = 1 + (int)SELECTION_RECTANGLE_STROKE.getLineWidth() / 2;
            this.repaint(repaintedRectangle.x - lineWidth, repaintedRectangle.y - lineWidth, repaintedRectangle.width + 2 * lineWidth, repaintedRectangle.height + 2 * lineWidth);
        }
    }

    public boolean isSpotlightEnabled() {
        return this.isClientPropertyTrue(SPOTLIGHT_ENABLED);
    }

    private boolean isClientPropertyTrue(String name) {
        return Boolean.TRUE == this.getClientProperty(name);
    }

    private void paintChildren(Graphics2D g2, PaintingMode[] paintModes) {
        PaintingMode[] paintingModeArray = paintModes;
        int n = paintingModeArray.length;
        block3: for (int i = 0; i < n; ++i) {
            PaintingMode paintingMode;
            this.paintingMode = paintingMode = paintingModeArray[i];
            switch (paintingMode) {
                case LINKS: {
                    if (HIDE_CONNECTORS == this.showConnectors || this.paintingPurpose == PaintingPurpose.OVERVIEW) continue block3;
                    this.paintConnectors(g2);
                    continue block3;
                }
                default: {
                    super.paintChildren(g2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDimmer(Graphics2D g2, PaintingMode[] paintModes) {
        Color color = g2.getColor();
        try {
            Color dimmer = spotlightBackgroundColor;
            g2.setColor(dimmer);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            g2.setColor(color);
        }
        for (NodeView selected : this.getSelection()) {
            this.highlightSelected(g2, selected, paintModes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightEditor(Graphics2D g2) {
        Component editor = this.getComponent(0);
        if (editor instanceof NodeView) {
            return;
        }
        Shape oldClip = g2.getClip();
        try {
            g2.setClip(editor.getX(), editor.getY(), editor.getWidth(), editor.getHeight());
            super.paintChildren(g2);
        }
        finally {
            g2.setClip(oldClip);
        }
    }

    protected PaintingMode getPaintingMode() {
        return this.paintingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintConnectors(Collection<? extends NodeLinkModel> links, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedLinks) {
        Font font = graphics.getFont();
        try {
            for (NodeLinkModel nodeLinkModel : links) {
                AConnectorView arrowLink;
                NodeModel target;
                NodeView targetView;
                ConnectorModel ref;
                if (!(nodeLinkModel instanceof ConnectorModel) || !alreadyPaintedLinks.add(ref = (ConnectorModel)nodeLinkModel)) continue;
                if (!ref.isVisible(this.getFilter())) {
                    return;
                }
                NodeModel source = ref.getSource();
                NodeView sourceView = this.getDisplayedNodeView(source);
                if (!this.isConnectorVisibleOnView(sourceView, targetView = this.getDisplayedNodeView(target = ref.getTarget()))) continue;
                boolean areBothNodesVisible = sourceView != null && targetView != null && sourceView.isContentVisible() && targetView.isContentVisible();
                boolean b = sourceView != null && sourceView.isSelected() || targetView != null && targetView.isSelected();
                boolean showsConnectorLinesOrArrows = this.showsConnectorLinesOrArrows(b);
                if (!showsConnectorLinesOrArrows) continue;
                LinkController linkController = LinkController.getController(this.getModeController());
                if (areBothNodesVisible && (ConnectorShape.EDGE_LIKE.equals((Object)linkController.getShape(ref)) && !ref.isSelfLink() || sourceView.getMap().getLayoutType() == MapViewLayout.OUTLINE)) {
                    arrowLink = new EdgeLinkView(ref, this.getModeController(), sourceView, targetView);
                } else {
                    if (!areBothNodesVisible && this.hideSingleEndConnectors) break;
                    arrowLink = new ConnectorView(ref, sourceView, targetView, this.getBackground());
                }
                arrowLink.paint(graphics);
                this.arrowLinkViews.add(arrowLink);
            }
        }
        finally {
            graphics.setFont(font);
        }
    }

    private boolean isConnectorVisibleOnView(NodeView sourceView, NodeView targetView) {
        Rectangle targetRectangle;
        if (this.paintingPurpose == PaintingPurpose.PRINTING) {
            return true;
        }
        Rectangle sourceRectangle = sourceView != null && sourceView.isContentVisible() ? SwingUtilities.convertRectangle(sourceView, sourceView.getMainView().getBounds(), this) : null;
        Rectangle rectangle = targetRectangle = targetView != null && targetView.isContentVisible() ? SwingUtilities.convertRectangle(targetView, targetView.getMainView().getBounds(), this) : null;
        if (sourceRectangle == null && targetRectangle == null) {
            return false;
        }
        Rectangle connectorRectangle = sourceRectangle == null ? targetRectangle : (targetRectangle == null ? sourceRectangle : sourceRectangle.union(targetRectangle));
        JViewport vp = (JViewport)this.getParent();
        Rectangle viewRect = vp.getViewRect();
        viewRect.x -= viewRect.width;
        viewRect.y -= viewRect.height;
        viewRect.width *= 3;
        viewRect.height *= 3;
        return viewRect.intersects(connectorRectangle);
    }

    private void paintConnectors(Graphics2D graphics) {
        this.arrowLinkViews = new Vector();
        if (this.hasNodeLinks()) {
            this.paintConnectors(this.currentRootView, graphics, new HashSet<ConnectorModel>());
        }
    }

    private void paintConnectors(NodeView source, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedConnectors) {
        NodeModel node = source.getNode();
        Collection<? extends NodeLinkModel> outLinks = this.getLinksFrom(node);
        this.paintConnectors(outLinks, graphics, alreadyPaintedConnectors);
        Collection<? extends NodeLinkModel> inLinks = this.getLinksTo(node);
        this.paintConnectors(inLinks, graphics, alreadyPaintedConnectors);
        this.paintDescendantConnectors(source, graphics, alreadyPaintedConnectors);
    }

    private void paintDescendantConnectors(NodeView source, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedConnectors) {
        int nodeViewCount = source.getComponentCount();
        for (int i = 0; i < nodeViewCount; ++i) {
            NodeView child;
            Component component = source.getComponent(i);
            if (!(component instanceof NodeView) || !(child = (NodeView)component).isSubtreeVisible()) continue;
            if (this.paintingPurpose == PaintingPurpose.PAINTING && !child.isSelected()) {
                Rectangle bounds = SwingUtilities.convertRectangle(source, child.getBounds(), this);
                JViewport vp = (JViewport)this.getParent();
                Rectangle viewRect = vp.getViewRect();
                viewRect.x -= viewRect.width;
                viewRect.y -= viewRect.height;
                viewRect.width *= 3;
                viewRect.height *= 3;
                if (!viewRect.intersects(bounds)) {
                    this.paintDescendantConnectors(child, graphics, alreadyPaintedConnectors);
                    continue;
                }
            }
            this.paintConnectors(child, graphics, alreadyPaintedConnectors);
        }
    }

    private boolean hasNodeLinks() {
        return LinkController.getController(this.getModeController()).hasNodeLinks(this.getMap(), this);
    }

    private Collection<? extends NodeLinkModel> getLinksTo(NodeModel node) {
        return LinkController.getController(this.getModeController()).getLinksTo(node, this);
    }

    private Collection<? extends NodeLinkModel> getLinksFrom(NodeModel node) {
        return LinkController.getController(this.getModeController()).getLinksFrom(node, this);
    }

    private void paintSelecteds(Graphics2D g) {
        if (!drawsRectangleForSelection || this.isPrinting()) {
            return;
        }
        Color c = g.getColor();
        Stroke s = g.getStroke();
        g.setColor(MapView.getSelectionRectangleColor());
        g.setStroke(NodeHighlighter.DEFAULT_STROKE);
        for (NodeView selected : this.getSelection()) {
            this.paintSelectionRectangle(g, selected);
        }
        g.setColor(c);
        g.setStroke(s);
    }

    private void updateSelectionColors() {
        ResourceController resourceController = ResourceController.getResourceController();
        selectionRectangleColor = ColorUtils.stringToColor(resourceController.getProperty(RESOURCES_SELECTED_NODE_RECTANGLE_COLOR));
    }

    private RoundRectangle2D.Float getRoundRectangleAround(NodeView selected, int gap, int arcw) {
        JComponent content = selected.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, this);
        RoundRectangle2D.Float roundRectClip = new RoundRectangle2D.Float(contentLocation.x - --gap, contentLocation.y - gap, content.getWidth() + 2 * gap, content.getHeight() + 2 * gap, arcw, arcw);
        return roundRectClip;
    }

    private void paintSelectionRectangle(Graphics2D g, NodeView selected) {
        if (Boolean.TRUE.equals(selected.getMainView().getClientProperty(INLINE_EDITOR_ACTIVE))) {
            return;
        }
        RoundRectangle2D.Float roundRectClip = this.getRoundRectangleAround(selected, 4, 15);
        g.draw(roundRectClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightSelected(Graphics2D g, NodeView selected, PaintingMode[] paintedModes) {
        RoundRectangle2D.Float highlightClip = drawsRectangleForSelection ? this.getRoundRectangleAround(selected, 4, 15) : this.getRoundRectangleAround(selected, 4, 2);
        Shape oldClip = g.getClip();
        Rectangle oldClipBounds = g.getClipBounds();
        try {
            g.setClip(highlightClip);
            if (oldClipBounds != null) {
                g.clipRect(oldClipBounds.x, oldClipBounds.y, oldClipBounds.width, oldClipBounds.height);
            }
            Rectangle clipBounds = highlightClip.getBounds();
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            g.setColor(color);
            this.paintChildren(g, paintedModes);
        }
        finally {
            g.setClip(oldClip);
        }
    }

    public void preparePrinting() {
        this.paintingPurpose = PaintingPurpose.PRINTING;
        if (!this.isPreparedForPrinting) {
            this.isPreparedForPrinting = true;
            this.updatePrintedNodes();
            this.fitMap = FitMap.valueOf();
            this.boundingRectangle = this.backgroundComponent != null && this.fitMap == FitMap.BACKGROUND ? this.getBackgroundImageInnerBounds() : this.getInnerBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrintedNodes() {
        if (this.zoom == 1.0f) {
            this.updateAllNodeViews();
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        } else {
            this.updatePrintedSelectedNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrintedSelectedNodes() {
        if (!drawsRectangleForSelection) {
            this.selection.selectedSet.forEach(n -> n.update(UpdateCause.SELECTION));
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        }
    }

    private Rectangle getBackgroundImageInnerBounds() {
        Point centerPoint = this.getRootCenterPoint();
        Point backgroundImageTopLeft = this.getBackgroundImageTopLeft(centerPoint);
        return new Rectangle(backgroundImageTopLeft.x, backgroundImageTopLeft.y, this.backgroundComponent.getWidth(), this.backgroundComponent.getHeight());
    }

    @Override
    public void print(Graphics g) {
        try {
            this.preparePrinting();
            super.print(g);
        }
        finally {
            this.paintingPurpose = PaintingPurpose.PAINTING;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double zoomFactor;
        double userZoomFactor = ResourceController.getResourceController().getDoubleProperty("user_zoom", 1.0);
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if ((this.fitMap == FitMap.PAGE || this.fitMap == FitMap.BACKGROUND) && pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        this.preparePrinting();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double imageableWidth = pageFormat.getImageableWidth();
        double imageableHeight = pageFormat.getImageableHeight();
        g2.clipRect((int)imageableX, (int)imageableY, (int)imageableWidth, (int)imageableHeight);
        double mapWidth = this.boundingRectangle.getWidth();
        double mapHeight = this.boundingRectangle.getHeight();
        if (this.fitMap == FitMap.PAGE || this.fitMap == FitMap.BACKGROUND) {
            double zoomFactorX = imageableWidth / mapWidth;
            double zoomFactorY = imageableHeight / mapHeight;
            zoomFactor = Math.min(zoomFactorX, zoomFactorY) * 0.99;
        } else {
            int nrPagesInHeight;
            zoomFactor = this.fitMap == FitMap.WIDTH ? imageableWidth / mapWidth * 0.99 : (this.fitMap == FitMap.HEIGHT ? imageableHeight / mapHeight * 0.99 : userZoomFactor / (double)UITools.FONT_SCALE_FACTOR);
            int nrPagesInWidth = (int)Math.ceil(zoomFactor * mapWidth / imageableWidth);
            if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * mapHeight / imageableHeight))) {
                return 1;
            }
            int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
            int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
            g2.translate(-imageableWidth * (double)xPageCoord, -imageableHeight * (double)yPageCoord);
        }
        g2.translate(imageableX, imageableY);
        g2.scale(zoomFactor, zoomFactor);
        double mapX = this.boundingRectangle.getX();
        double mapY = this.boundingRectangle.getY();
        g2.translate(-mapX, -mapY);
        this.print(g2);
        g2.dispose();
        return 0;
    }

    private void repaintSelecteds(boolean update) {
        this.updateSelectionColors();
        for (NodeView selected : this.getSelection()) {
            this.repaintAfterSelectionChange(selected, update);
        }
    }

    private Color requiredBackground() {
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        Color mapBackground = mapStyle.getBackground(this.viewedMap);
        return mapBackground;
    }

    void revalidateSelecteds() {
        this.selectedsValid = false;
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        NodeModel node = newSelected.getNode();
        if (node.isHiddenSummary()) {
            throw new AssertionError((Object)"select invisible node");
        }
        this.selectAsTheOnlyOneSelected(newSelected, true);
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected, boolean requestFocus) {
        if (requestFocus && !newSelected.focused()) {
            newSelected.requestFocusInWindow();
        }
        this.selection.select(newSelected);
        ResourceController resourceController = ResourceController.getResourceController();
        if (!(!resourceController.getBooleanProperty("center_selected_node") || MouseEventActor.INSTANCE.isActive() && resourceController.getBooleanProperty("autoscroll_disabled_for_mouse_interaction"))) {
            this.mapScroller.scrollNodeToCenter(newSelected);
        } else {
            this.mapScroller.scrollNodeToVisible(newSelected);
        }
        Container selectionParent = newSelected.getParent();
        if (selectionParent instanceof NodeView) {
            ((NodeView)selectionParent).setLastSelectedChild(newSelected);
        }
        this.setSiblingMaxLevel(newSelected);
    }

    private void addBranchToSelection(NodeView newlySelectedNodeView) {
        if (newlySelectedNodeView.isContentVisible()) {
            this.addSelected(newlySelectedNodeView, false);
        }
        for (NodeView target : newlySelectedNodeView.getChildrenViews()) {
            this.addBranchToSelection(target);
        }
    }

    void selectContinuous(NodeView newSelected) {
        NodeView selectionStart = this.selection.getSelectionStart();
        NodeView selectionEnd = this.selection.getSelectionEnd();
        NodeView parentView = newSelected.getParentView();
        boolean left = newSelected.isTopOrLeft();
        if (this.isRoot(newSelected) || selectionStart == null || selectionEnd == null || parentView != selectionStart.getParentView() || parentView != selectionEnd.getParentView() || left != selectionStart.isTopOrLeft() || newSelected.isTopOrLeft() != selectionEnd.isTopOrLeft()) {
            if (!newSelected.isSelected()) {
                this.selection.add(newSelected);
            }
            this.mapScroller.scrollNodeToVisible(newSelected);
            return;
        }
        boolean selectionFound = false;
        boolean selectionRequired = false;
        for (NodeView child : parentView.getChildrenViews()) {
            if (child.isTopOrLeft() != left) continue;
            boolean onOldSelectionMargin = child == selectionStart || child == selectionEnd;
            boolean selectionFoundNow = !selectionFound && onOldSelectionMargin;
            selectionFound = selectionFound || selectionFoundNow;
            boolean onNewSelectionMargin = child == selectionStart || child == newSelected;
            boolean selectionRequiredNow = !selectionRequired && onNewSelectionMargin;
            boolean bl = selectionRequired = selectionRequired || selectionRequiredNow;
            if (selectionRequired && !selectionFound && child.getNode().hasVisibleContent(this.filter)) {
                this.selection.add(child);
            } else if (!selectionRequired && selectionFound) {
                this.selection.deselect(child);
                this.updateSelectedNode();
            }
            if (selectionFound && (selectionStart == selectionEnd || !selectionFoundNow && onOldSelectionMargin)) {
                selectionFound = false;
            }
            if (!selectionRequired || selectionStart != newSelected && (selectionRequiredNow || !onNewSelectionMargin)) continue;
            selectionRequired = false;
        }
        this.mapScroller.scrollNodeToVisible(newSelected);
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    private void setSiblingMaxLevel(NodeView newSelected) {
        if (this.siblingMaxLevel >= 0) {
            this.siblingMaxLevel = newSelected.getNode().getNodeLevel(this.filter);
        }
    }

    public void setZoom(float zoom) {
        if (this.zoom != zoom) {
            this.zoom = zoom;
            this.scrollsViewAfterLayout = true;
            this.mapScroller.anchorToNode(this.getSelected(), 0.5f, 0.5f);
            this.updateAllNodeViews(UpdateCause.ZOOM);
            this.adjustBackgroundComponentScale();
        }
    }

    public void setZoom(float zoom, Point keptPoint) {
        if (this.zoom != zoom) {
            this.zoom = zoom;
            NodeView selected = this.getSelected();
            MainView mainView = selected.getMainView();
            float referenceWidth = mainView.getWidth();
            float referenceHeight = mainView.getHeight();
            Point mainViewLocation = new Point();
            UITools.convertPointToAncestor((Component)mainView, mainViewLocation, this);
            float x = referenceWidth > 0.0f ? (float)(keptPoint.x - mainViewLocation.x) / referenceWidth : 0.0f;
            float y = referenceHeight > 0.0f ? (float)(keptPoint.y - mainViewLocation.y) / referenceHeight : 0.0f;
            this.scrollsViewAfterLayout = true;
            this.mapScroller.anchorToNode(selected, x, y);
            this.updateAllNodeViews(UpdateCause.ZOOM);
            this.adjustBackgroundComponentScale();
        }
    }

    private void adjustBackgroundComponentScale() {
        if (this.backgroundComponent != null) {
            if (this.fitToViewport) {
                JViewport vp = (JViewport)this.getParent();
                Dimension viewPortSize = vp.getVisibleRect().getSize();
                this.backgroundComponent.setFinalViewerSize(viewPortSize);
            } else {
                this.backgroundComponent.setMaximumComponentSize(this.getPreferredSize());
                this.backgroundComponent.setFinalViewerSize(this.zoom);
            }
            SwingUtilities.invokeLater(this::repaint);
        }
    }

    private void toggleSelected(NodeView nodeView) {
        if (this.isSelected(nodeView)) {
            if (this.selection.size() > 1) {
                this.selection.deselect(nodeView);
                this.updateSelectedNode();
            }
        } else {
            this.selection.add(nodeView);
            this.mapScroller.scrollNodeToVisible(nodeView);
        }
    }

    private void validateSelecteds() {
        if (this.selectedsValid) {
            return;
        }
        this.selectedsValid = true;
        NodeView selectedView = this.getSelected();
        if (selectedView == null) {
            NodeView root = this.getRoot();
            this.selectAsTheOnlyOneSelected(root);
            this.mapScroller.scrollToRootNode();
            return;
        }
        NodeModel selectedNode = selectedView.getNode();
        List lastSelectedNodes = this.selection.getSelectedList();
        ArrayList<NodeView> selectedNodes = new ArrayList<NodeView>(lastSelectedNodes.size());
        for (NodeView nodeView : this.getSelection()) {
            if (nodeView == null || !nodeView.isContentVisible()) continue;
            selectedNodes.add(nodeView);
        }
        if (lastSelectedNodes.size() == selectedNodes.size() && selectedNodes.size() > 0) {
            return;
        }
        this.selection.replace(selectedNodes);
        if (this.getSelected() != null) {
            return;
        }
        for (NodeModel node = selectedNode.getParentNode(); node != null; node = node.getParentNode()) {
            NodeView newNodeView = this.getNodeView(node);
            if (newNodeView == null || !newNodeView.isContentVisible()) continue;
            this.selectAsTheOnlyOneSelected(newNodeView);
            return;
        }
        this.selectAsTheOnlyOneSelected(this.getRoot());
    }

    @Override
    protected void validateTree() {
        if (this.isDisplayable() && this.getRoot().isDisplayable()) {
            this.validateSelecteds();
            this.getRoot().validateTree();
            super.validateTree();
        }
    }

    public void repaintVisible() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint();
        }
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("highlight_formulas")) {
            UITools.repaintAll(this.getRoot());
        }
    }

    public void selectVisibleAncestorOrSelf(NodeView preferred) {
        while (!preferred.isContentVisible()) {
            preferred = preferred.getParentView();
        }
        this.selectAsTheOnlyOneSelected(preferred);
    }

    public Font getNoteFont() {
        return this.noteFont;
    }

    public Color getNoteForeground() {
        return this.noteForeground;
    }

    public Color getNoteBackground() {
        return this.noteBackground;
    }

    public NodeCss getDetailCss() {
        return this.detailCss;
    }

    public NodeCss getNoteCss() {
        return this.noteCss;
    }

    public int getNoteHorizontalAlignment() {
        return this.noteHorizontalAlignment;
    }

    public Font getDetailFont() {
        return this.detailFont;
    }

    public Color getDetailForeground() {
        return this.detailForeground;
    }

    public Color getDetailBackground() {
        return this.detailBackground;
    }

    public int getDetailHorizontalAlignment() {
        return this.detailHorizontalAlignment;
    }

    public boolean isSelected() {
        return Controller.getCurrentController().getMapViewManager().getMapViewComponent() == this;
    }

    void selectIfSelectionIsEmpty(NodeView nodeView) {
        if (this.selection.selectedNode == null) {
            this.selectAsTheOnlyOneSelected(nodeView);
        }
    }

    public static MapView getMapView(Component component) {
        if (component instanceof MapView) {
            return (MapView)component;
        }
        return (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
    }

    public void select() {
        this.getModeController().getController().getMapViewManager().changeToMapView(this);
    }

    @Override
    public void setSize(int width, int height) {
        boolean sizeChanged;
        boolean bl = sizeChanged = this.getWidth() != width || this.getHeight() != height;
        if (sizeChanged) {
            super.setSize(width, height);
            this.validate();
        }
    }

    void scrollViewAfterLayout() {
        if (this.isDisplayable()) {
            if (this.scrollsViewAfterLayout) {
                this.scrollsViewAfterLayout = false;
                this.mapScroller.scrollView();
            } else {
                this.setAnchorContentLocation();
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.mapScroller.scrollBy(x, y);
    }

    public void scrollNodeToVisible(NodeView node) {
        this.mapScroller.scrollNodeToVisible(node);
    }

    public void setAnchorContentLocation() {
        this.mapScroller.setAnchorContentLocation();
    }

    public void preserveRootNodeLocationOnScreen() {
        this.mapScroller.anchorToRoot();
    }

    public void preserveSelectedNodeLocation() {
        if (this.selectedsValid) {
            this.preserveNodeLocationOnScreen(this.getSelected());
        }
    }

    public void preserveNodeLocationOnScreen(NodeView nodeView) {
        boolean horizontalPoint = nodeView.isTopOrLeft();
        this.preserveNodeLocationOnScreen(nodeView, (float)horizontalPoint, 0.0f);
    }

    public void preserveNodeLocationOnScreen(NodeView nodeView, float horizontalPoint, float verticalPoint) {
        this.mapScroller.anchorToNode(nodeView, horizontalPoint, verticalPoint);
    }

    public void setShowsSelectedAfterScroll(boolean showSelectedAfterScroll) {
        this.mapScroller.setShowsSelectedAfterScroll(showSelectedAfterScroll);
    }

    public void display(NodeModel node) {
        this.display(node, false);
    }

    private void display(NodeModel node, boolean unfoldParentNodes) {
        NodeView nodeView;
        NodeModel currentRoot = this.currentRootView.getNode();
        if (currentRoot != node && !node.isDescendantOf(currentRoot)) {
            this.restoreRootNode();
        }
        if ((nodeView = this.getNodeView(node)) != null) {
            return;
        }
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        this.display(parentNode, unfoldParentNodes);
        NodeView parentView = this.getNodeView(parentNode);
        if (parentView == null) {
            return;
        }
        if (unfoldParentNodes && parentNode.isFolded() && this.isSelected()) {
            parentNode.setFolded(false);
        } else if (parentView.isFolded()) {
            parentView.setFolded(false);
        }
    }

    private boolean showsConnectorLinesOrArrows(boolean isSelected) {
        boolean showsConnectorLinesOrArrows = SHOW_CONNECTOR_LINES == this.showConnectors || HIDE_CONNECTOR_LINES == this.showConnectors || isSelected && (SHOW_ARROWS_FOR_SELECTION_ONLY == this.showConnectors || SHOW_CONNECTORS_FOR_SELECTION_ONLY == this.showConnectors);
        return showsConnectorLinesOrArrows;
    }

    public boolean showsConnectorLines(boolean isSelected) {
        return this.showConnectors == SHOW_CONNECTOR_LINES || isSelected && this.showConnectors == SHOW_CONNECTORS_FOR_SELECTION_ONLY;
    }

    public boolean showsIcons() {
        return this.iconLocation != IconLocation.HIDE;
    }

    public IconLocation getIconLocation() {
        return this.iconLocation;
    }

    public int getLayoutSpecificMaxNodeWidth() {
        return this.usesLayoutSpecificMaxNodeWidth() ? Math.max(0, this.getViewportSize().width - 10 * this.getZoomed(outlineHGap)) : 0;
    }

    public boolean usesLayoutSpecificMaxNodeWidth() {
        return this.isOutlineLayoutSet() && this.outlineViewFitsWindowWidth();
    }

    private boolean outlineViewFitsWindowWidth() {
        return outlineViewFitsWindowWidth;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public static Color getSelectionRectangleColor() {
        return selectionRectangleColor;
    }

    public static boolean drawsRectangleForSelection() {
        return drawsRectangleForSelection;
    }

    public void onEditingStarted(ZoomableLabel label) {
        if (label instanceof MainView) {
            label.putClientProperty(INLINE_EDITOR_ACTIVE, Boolean.TRUE);
            if (drawsRectangleForSelection) {
                this.repaintSelecteds(false);
            }
        }
    }

    public void onEditingFinished(ZoomableLabel label) {
        if (label instanceof MainView) {
            label.putClientProperty(INLINE_EDITOR_ACTIVE, null);
            if (drawsRectangleForSelection) {
                this.repaintSelecteds(false);
            }
        }
    }

    boolean allowsCompactLayout() {
        return this.allowsCompactLayout;
    }

    @Override
    public void invalidate() {
        if (!this.currentRootView.isValid() && !this.isPreparedForPrinting) {
            this.scrollsViewAfterLayout = true;
        }
        super.invalidate();
    }

    boolean isRoot(NodeView nodeView) {
        return nodeView == this.currentRootView;
    }

    boolean isSearchRoot(NodeView nodeView) {
        return nodeView.getNode() == this.currentSearchRoot;
    }

    private void setSearchRoot(NodeModel searchRoot) {
        if (searchRoot == this.currentSearchRoot) {
            return;
        }
        NodeView lastSearchRootView = this.getNodeView(this.currentSearchRoot);
        if (lastSearchRootView != null) {
            this.currentSearchRoot = null;
            lastSearchRootView.updateIcons();
        }
        this.currentSearchRoot = searchRoot;
        NodeView currentSearchRootView = this.getNodeView(searchRoot);
        if (currentSearchRootView != null) {
            currentSearchRootView.updateIcons();
        }
    }

    void setRootNode(NodeModel node) {
        RootChange rootChange;
        NodeModel currentRootNode = this.currentRootView.getNode();
        if (currentRootNode == node) {
            return;
        }
        NodeView nodeView = this.getNodeView(node);
        if (nodeView == null) {
            nodeView = NodeViewFactory.getInstance().newNodeView(node, this);
            rootChange = RootChange.ANY;
        } else {
            rootChange = SwingUtilities.isDescendingFrom(nodeView, this.currentRootView) ? RootChange.JUMP_IN : RootChange.ANY;
        }
        if (!currentRootNode.isRoot() && rootChange == RootChange.JUMP_IN) {
            this.rootsHistory.add(this.currentRootView);
        }
        this.setRootNode(nodeView, rootChange);
        this.validateAndScroll();
    }

    public void usePreviousViewRoot() {
        NodeView lastRoot = this.currentRootView;
        NodeView newRoot = this.rootsHistory.size() == 0 ? this.mapRootView : this.rootsHistory.remove(this.rootsHistory.size() - 1);
        this.setRootNode(newRoot, RootChange.JUMP_OUT);
        if (lastRoot.isFolded()) {
            lastRoot.fireFoldingChanged();
        }
        this.validateAndScroll();
    }

    private void validateAndScroll() {
        JViewport mapViewport = (JViewport)this.getParent();
        if (mapViewport != null) {
            mapViewport.validate();
        }
    }

    int calculateComponentIndex(Container parent, int index) {
        if (parent == this.currentRootParentView && index > this.calculateCurrentRootNodePosition()) {
            return index - 1;
        }
        return index;
    }

    private int calculateCurrentRootNodePosition() {
        NodeModel currentRoot = this.currentRootView.getNode();
        NodeModel currentParent = this.currentRootParentView.getNode();
        return currentParent.getIndex(currentRoot);
    }

    void restoreRootNode() {
        this.restoreRootNode(-1, false);
    }

    void restoreRootNodeTemporarily() {
        this.restoreRootNode(-1, true);
    }

    void restoreRootNode(int index) {
        this.restoreRootNode(index, false);
    }

    private void restoreRootNode(int index, boolean temporarily) {
        if (this.currentRootView == this.mapRootView) {
            return;
        }
        if (this.currentRootParentView != null) {
            this.remove(0);
            this.currentRootParentView.add((Component)this.currentRootView, index >= 0 ? index : this.calculateCurrentRootNodePosition());
        } else {
            this.currentRootView.remove();
            this.updateSelectedNode();
        }
        this.add((Component)this.mapRootView, 0);
        NodeView lastRoot = this.currentRootView;
        this.currentRootView.invalidate();
        this.currentRootView = this.mapRootView;
        this.currentRootParentView = null;
        if (!temporarily) {
            this.rootsHistory.forEach(NodeView::keepUnfolded);
            this.rootsHistory.clear();
            this.mapRootView.resetLayoutPropertiesRecursively();
            this.fireRootChanged();
            if (lastRoot.getParent() != null && lastRoot.isFolded()) {
                lastRoot.fireFoldingChanged();
            }
        }
        lastRoot.updateIcons();
    }

    private void fireRootChanged() {
        MapController mapController = this.modeController.getMapController();
        mapController.fireMapChanged(new MapChangeEvent(this, this.getMap(), (Object)IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT, null, null, false));
    }

    private void setRootNode(NodeView newRootView, RootChange rootChange) {
        boolean newRootWasFolded;
        if (this.currentRootView == newRootView) {
            return;
        }
        boolean bl = newRootWasFolded = newRootView.isFolded() && rootChange != RootChange.JUMP_OUT;
        if (rootChange == RootChange.JUMP_OUT) {
            this.preserveNodeLocationOnScreen(this.currentRootView, 0.0f, 0.0f);
        } else if (rootChange == RootChange.JUMP_IN) {
            this.preserveNodeLocationOnScreen(newRootView, 0.0f, 0.0f);
        }
        NodeView nextSelectedNode = rootChange == RootChange.JUMP_OUT ? this.selection.selectedNode : newRootView;
        if (rootChange == RootChange.ANY) {
            this.restoreRootNode();
        } else {
            this.restoreRootNodeTemporarily();
        }
        if (this.currentRootView != newRootView) {
            this.currentRootView.invalidate();
            this.currentRootView = newRootView;
            this.currentRootParentView = newRootView.getParentView();
            this.remove(0);
            this.add((Component)newRootView, 0);
        } else {
            this.rootsHistory.clear();
        }
        if (!nextSelectedNode.isContentVisible()) {
            nextSelectedNode = newRootView;
        }
        if (newRootWasFolded) {
            newRootView.fireFoldingChanged();
        }
        newRootView.resetLayoutPropertiesRecursively();
        this.fireRootChanged();
        if (nextSelectedNode.isDisplayable()) {
            if (nextSelectedNode == this.selection.selectedNode) {
                nextSelectedNode.requestFocusInWindow();
            } else {
                this.selectAsTheOnlyOneSelected(nextSelectedNode);
            }
        }
        this.revalidate();
        this.repaint();
        if (rootChange == RootChange.ANY) {
            this.mapScroller.scrollToRootNode();
        }
    }

    public int getDraggingAreaWidth() {
        return this.getZoomed(draggingAreaWidth);
    }

    public boolean repaintsViewOnSelectionChange() {
        return this.repaintsViewOnSelectionChange;
    }

    public void setRepaintsViewOnSelectionChange(boolean repaintsViewOnSelectionChange) {
        this.repaintsViewOnSelectionChange = repaintsViewOnSelectionChange;
    }

    void foldingWasSet(NodeView nodeView) {
        this.selection.foldingWasSet(nodeView);
    }

    public TagLocation getTagLocation() {
        return this.tagLocation;
    }

    public float calculateNewZoom(MouseWheelEvent e) {
        float oldZoom = this.getZoom();
        float zoomFactor = 1.0f + (float)ResourceController.getResourceController().getIntProperty(MAP_VIEW_ZOOM_STEP_PROPERTY) / 100.0f;
        float zoom = e.getWheelRotation() > 0 ? oldZoom / zoomFactor : oldZoom * zoomFactor;
        double x = Math.round(Math.log(zoom) / Math.log(zoomFactor));
        zoom = (float)Math.pow(zoomFactor, x);
        zoom = Math.max(Math.min(zoom, 32.0f), 0.03f);
        return zoom;
    }

    public void selectNodeViewBySelectionRectangle(boolean replace) {
        List<NodeView> intersectingNodes = this.getIntersectingNodes();
        if (!intersectingNodes.isEmpty()) {
            if (replace) {
                this.selection.replace(intersectingNodes);
            } else {
                intersectingNodes.forEach(x$0 -> this.selection.add(x$0));
            }
        }
    }

    private List<NodeView> getIntersectingNodes() {
        ArrayList<NodeView> intersectingComponents = new ArrayList<NodeView>();
        if (this.selectionRectangle != null) {
            this.findNodesInSelectingRectangle(this, this.selectionRectangle, intersectingComponents);
        }
        return intersectingComponents;
    }

    private void findNodesInSelectingRectangle(Component comp, Rectangle rect, List<NodeView> results) {
        Rectangle compBounds = new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
        if (compBounds.intersects(rect)) {
            Container parent = comp.getParent();
            if (parent instanceof NodeView && comp == ((NodeView)parent).getContent()) {
                results.add((NodeView)parent);
            } else {
                for (Component child : ((Container)comp).getComponents()) {
                    Rectangle childRect = SwingUtilities.convertRectangle(comp, rect, child);
                    this.findNodesInSelectingRectangle(child, childRect, results);
                }
            }
        }
    }

    public static boolean showsTagsOnMinimizedNodes() {
        return showsTagsOnMinimizedNodes;
    }

    static {
        HIDE_SINGLE_END_CONNECTORS = "hide_single_end_connectors".intern();
        SHOW_CONNECTORS_PROPERTY = "show_connectors".intern();
        SHOW_CONNECTOR_LINES = "true".intern();
        HIDE_CONNECTOR_LINES = "false".intern();
        HIDE_CONNECTORS = "never".intern();
        SHOW_CONNECTORS_FOR_SELECTION_ONLY = "for_selection".intern();
        SHOW_ARROWS_FOR_SELECTION_ONLY = "only_arrows_for_selection".intern();
        repaintOnClientPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MapView source = (MapView)evt.getSource();
                source.repaint();
            }
        };
        SCROLL_VELOCITY_PX = (int)(UITools.FONT_SCALE_FACTOR * 10.0f);
        ResourceController resourceController = ResourceController.getResourceController();
        String drawCircle = resourceController.getProperty("standarddrawrectangleforselection");
        drawsRectangleForSelection = TreeXmlReader.xmlToBoolean(drawCircle);
        String printOnWhite = resourceController.getProperty("printonwhitebackground");
        printOnWhiteBackground = TreeXmlReader.xmlToBoolean(printOnWhite);
        int alpha = 255 - resourceController.getIntProperty(PRESENTATION_DIMMER_TRANSPARENCY, 112);
        resourceController.setDefaultProperty(SPOTLIGHT_BACKGROUND_COLOR, ColorUtils.colorToRGBAString(new Color(0, 0, 0, alpha)));
        spotlightBackgroundColor = resourceController.getColorProperty(SPOTLIGHT_BACKGROUND_COLOR);
        hideSingleEndConnectorsPropertyValue = resourceController.getBooleanProperty(HIDE_SINGLE_END_CONNECTORS);
        showConnectorsPropertyValue = resourceController.getProperty(SHOW_CONNECTORS_PROPERTY).intern();
        outlineHGap = resourceController.getLengthProperty(OUTLINE_HGAP_PROPERTY);
        draggingAreaWidth = resourceController.getLengthProperty(DRAGGING_AREA_WIDTH_PROPERTY);
        outlineViewFitsWindowWidth = resourceController.getBooleanProperty(OUTLINE_VIEW_FITS_WINDOW_WIDTH);
        showsTagsOnMinimizedNodes = resourceController.getBooleanProperty(SHOW_TAGS_ON_MINIMIZED_NODES_PROPERTY);
        MapView.createPropertyChangeListener();
    }

    private class Selection {
        private final Set<NodeView> selectedSet = new LinkedHashSet<NodeView>();
        private final List<NodeView> selectedList = new ArrayList<NodeView>();
        private NodeView selectedNode = null;
        private boolean selectionChanged = false;

        private void select(NodeView node) {
            NodeView[] oldSelecteds = MapView.this.selection.toArray();
            this.clear();
            this.addToSelectedSet(node);
            this.selectedList.add(node);
            this.selectedNode = node;
            this.addSelectionForHooks();
            MapView.this.repaintAfterSelectionChange(node, true);
            for (NodeView oldSelected : oldSelecteds) {
                if (oldSelected == null || oldSelected == node) continue;
                MapView.this.repaintAfterSelectionChange(oldSelected, true);
            }
        }

        private boolean add(NodeView node) {
            if (this.selectedNode == null) {
                this.select(node);
                return true;
            }
            if (this.addToSelectedSet(node)) {
                this.selectedList.add(node);
                MapView.this.repaintAfterSelectionChange(node, true);
                return true;
            }
            return false;
        }

        private boolean addToSelectedSet(NodeView node) {
            boolean hasChanged = this.selectedSet.add(node);
            if (hasChanged) {
                this.fireSelectionChangedLater();
            }
            return hasChanged;
        }

        private void fireSelectionChangedLater() {
            if (!this.selectionChanged && MapView.this.isSelected()) {
                this.selectionChanged = true;
                SwingUtilities.invokeLater(this::fireSelectionChanged);
            }
        }

        private void addSelectionForHooks() {
            if (!MapView.this.isSelected()) {
                return;
            }
            MapController mapController = MapView.this.modeController.getMapController();
            NodeModel node = this.selectedNode.getNode();
            mapController.onSelect(node);
            this.synchronizeSelectionAcrossVisibleViews();
        }

        private void synchronizeSelectionAcrossVisibleViews() {
            boolean synchronizesSelectionAcrossVisibleViews = MapView.this.synchronizesSelectionAcrossVisibleViews();
            if (synchronizesSelectionAcrossVisibleViews) {
                List<Component> views = Controller.getCurrentController().getMapViewManager().getViews(MapView.this.viewedMap);
                for (Component view : views) {
                    if (view == MapView.this || !(view instanceof MapView) || !view.isShowing()) continue;
                    ((MapView)view).synchronizeSelection();
                }
            }
        }

        private void clear() {
            if (this.selectedNode != null) {
                this.removeSelectionForHooks(this.selectedNode);
                this.selectedNode = null;
                this.clearSelectedSet();
                this.selectedList.clear();
            }
        }

        private void clearSelectedSet() {
            boolean hasChanged;
            boolean bl = hasChanged = !this.selectedSet.isEmpty();
            if (hasChanged) {
                this.selectedSet.clear();
                this.fireSelectionChangedLater();
            }
        }

        private boolean contains(NodeView node) {
            return this.selectedSet.contains(node);
        }

        public Set<NodeView> getSelection() {
            return Collections.unmodifiableSet(this.selectedSet);
        }

        private boolean deselect(NodeView node) {
            boolean selectedChanged;
            boolean bl = selectedChanged = this.selectedNode != null && this.selectedNode.equals(node);
            if (selectedChanged) {
                this.removeSelectionForHooks(node);
            }
            if (this.removeFromSelectedSet(node)) {
                int last = this.selectedList.size() - 1;
                if (this.selectedList.get(last).equals(node)) {
                    this.selectedList.remove(last);
                } else {
                    this.selectedList.remove(node);
                }
                MapView.this.repaintAfterSelectionChange(node, true);
                return true;
            }
            return false;
        }

        private boolean removeFromSelectedSet(NodeView node) {
            boolean hasChanged = this.selectedSet.remove(node);
            if (hasChanged) {
                this.fireSelectionChangedLater();
            }
            return hasChanged;
        }

        private void updateSelectedNode() {
            if (this.selectedNode != null && !this.selectedSet.contains(this.selectedNode)) {
                if (this.size() > 0) {
                    this.selectedNode = this.selectedSet.iterator().next();
                    this.addSelectionForHooks();
                } else {
                    this.selectedNode = null;
                }
            }
        }

        private void removeSelectionForHooks(NodeView node) {
            if (node.getNode() == null || !MapView.this.isSelected()) {
                return;
            }
            MapView.this.getModeController().getMapController().onDeselect(node.getNode());
        }

        private int size() {
            return this.selectedSet.size();
        }

        private void replace(NodeView[] newSelection) {
            this.replace(Arrays.asList(newSelection));
        }

        private void replace(List<NodeView> newSelection) {
            boolean selectedChanges;
            if (newSelection.size() == 0) {
                return;
            }
            NodeView firstSelectedNode = newSelection.get(0);
            boolean bl = selectedChanges = !firstSelectedNode.equals(this.selectedNode);
            if (selectedChanges) {
                if (this.selectedNode != null) {
                    this.removeSelectionForHooks(this.selectedNode);
                }
                this.selectedNode = firstSelectedNode;
            }
            NodeView[] nodesAddedToSelection = (NodeView[])newSelection.stream().filter(view -> !this.selectedSet.contains(view)).toArray(NodeView[]::new);
            NodeView[] oldSelection = this.selectedSet.toArray(new NodeView[this.selectedSet.size()]);
            this.clearSelectedSet();
            this.selectedList.clear();
            for (NodeView view2 : newSelection) {
                if (!this.addToSelectedSet(view2)) continue;
                this.selectedList.add(view2);
            }
            for (NodeView view3 : nodesAddedToSelection) {
                MapView.this.repaintAfterSelectionChange(view3, true);
            }
            if (selectedChanges) {
                this.addSelectionForHooks();
            }
            for (NodeView view3 : oldSelection) {
                if (this.selectedSet.contains(view3)) continue;
                MapView.this.repaintAfterSelectionChange(view3, true);
            }
        }

        public NodeView[] toArray() {
            return this.selectedList.toArray(new NodeView[this.selectedList.size()]);
        }

        private List<NodeView> getSelectedList() {
            return this.selectedList;
        }

        private Set<NodeView> getSelectedSet() {
            return this.selectedSet;
        }

        public NodeView getSelectionStart() {
            return this.selectedList.size() > 0 ? this.selectedList.get(0) : null;
        }

        public NodeView getSelectionEnd() {
            int selectedNodeCount = this.selectedList.size();
            return selectedNodeCount > 0 ? this.selectedList.get(selectedNodeCount - 1) : null;
        }

        public NodeView getSelectionBeforeEnd() {
            int selectedNodeCount = this.selectedList.size();
            return selectedNodeCount > 1 ? this.selectedList.get(selectedNodeCount - 2) : null;
        }

        void foldingWasSet(NodeView view) {
            if (MapView.this.isClientPropertyTrue(MapView.FOLDING_FOLLOWS_SELECTION)) {
                MapView.this.nodeViewFolder.foldingWasSet(view);
            }
        }

        private void fireSelectionChanged() {
            if (this.selectionChanged) {
                this.selectionChanged = false;
                if (MapView.this.isSelected()) {
                    if (((MapView)MapView.this).selection.selectedNode != null) {
                        MapView.this.modeController.getMapController().onSelectionChange(MapView.this.getMapSelection());
                    }
                    if (MapView.this.isClientPropertyTrue(MapView.FOLDING_FOLLOWS_SELECTION)) {
                        boolean wasFolded = this.selectedNode.isFolded();
                        MapView.this.nodeViewFolder.adjustFolding(this.selectedSet);
                        ResourceController resourceController = ResourceController.getResourceController();
                        if (wasFolded && !this.selectedNode.isFolded() && MapView.this.selection.size() == 1 && (resourceController.getBooleanProperty("scrollOnUnfold") || resourceController.getBooleanProperty("scrollOnSelect"))) {
                            SwingUtilities.invokeLater(() -> MapView.this.mapScroller.scrollNodeTreeToVisible(this.selectedNode));
                        } else {
                            MapView.this.scrollNodeToVisible(this.selectedNode);
                        }
                    }
                }
            }
        }
    }

    private static enum PaintingPurpose {
        PAINTING,
        PRINTING,
        OVERVIEW;

    }

    private class MapSelection
    implements IMapSelection {
        private MapSelection() {
        }

        @Override
        public void centerNode(NodeModel node) {
            boolean slowScroll = false;
            this.centerNode(node, false);
        }

        @Override
        public void centerNodeSlowly(NodeModel node) {
            boolean slowScroll = true;
            this.centerNode(node, true);
        }

        private void centerNode(NodeModel node, boolean slowScroll) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNode(nodeView, IMapSelection.NodePosition.CENTER, slowScroll);
            }
        }

        @Override
        public void moveNodeTo(NodeModel node, IMapSelection.NodePosition position) {
            boolean slowScroll = false;
            this.moveNodeTo(node, position, false);
        }

        @Override
        public void slowlyMoveNodeTo(NodeModel node, IMapSelection.NodePosition position) {
            boolean slowScroll = true;
            this.moveNodeTo(node, position, true);
        }

        private void moveNodeTo(NodeModel node, IMapSelection.NodePosition position, boolean slowScroll) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNode(nodeView, position, slowScroll);
            }
        }

        @Override
        public NodeModel getSelected() {
            NodeView selected = MapView.this.getSelected();
            return selected != null ? selected.getNode() : null;
        }

        @Override
        public NodeModel getSelectionRoot() {
            NodeView root = MapView.this.getRoot();
            return root != null ? root.getNode() : null;
        }

        @Override
        public NodeModel getSearchRoot() {
            if (MapView.this.currentRootView == null) {
                return null;
            }
            NodeModel searchRoot = MapView.this.getSearchRoot();
            if (searchRoot == null) {
                return null;
            }
            NodeModel currentRoot = MapView.this.currentRootView.getNode();
            return searchRoot == currentRoot || searchRoot.isDescendantOf(currentRoot) ? searchRoot : null;
        }

        @Override
        public NodeModel getEffectiveSearchRoot() {
            if (MapView.this.currentRootView == null) {
                return null;
            }
            NodeModel searchRoot = this.getSearchRoot();
            return searchRoot == null ? MapView.this.currentRootView.getNode() : searchRoot;
        }

        @Override
        public Set<NodeModel> getSelection() {
            return MapView.this.getSelectedNodes();
        }

        @Override
        public List<NodeModel> getOrderedSelection() {
            return MapView.this.getOrderedSelectedNodes();
        }

        @Override
        public List<NodeModel> getSortedSelection(boolean differentSubtrees) {
            return MapView.this.getSelectedNodesSortedByY(differentSubtrees);
        }

        @Override
        public boolean isSelected(NodeModel node) {
            if (!this.getMap().equals(node.getMap())) {
                return false;
            }
            NodeView nodeView = MapView.this.getNodeView(node);
            return nodeView != null && MapView.this.isSelected(nodeView);
        }

        @Override
        public void preserveRootNodeLocationOnScreen() {
            MapView.this.preserveRootNodeLocationOnScreen();
        }

        @Override
        public void preserveSelectedNodeLocationOnScreen() {
            MapView.this.preserveSelectedNodeLocation();
        }

        @Override
        public void preserveNodeLocationOnScreen(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            MapView.this.preserveNodeLocationOnScreen(nodeView);
        }

        @Override
        public void preserveNodeLocationOnScreen(NodeModel node, float horizontalPoint, float verticalPoint) {
            NodeView nodeView = MapView.this.getNodeView(node);
            MapView.this.preserveNodeLocationOnScreen(nodeView, horizontalPoint, verticalPoint);
        }

        @Override
        public void scrollNodeTreeToVisible(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNodeTreeToVisible(nodeView);
            }
        }

        @Override
        public void makeTheSelected(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.addSelected(nodeView, false);
            }
        }

        @Override
        public void makeTheSearchRoot(NodeModel node) {
            MapView.this.setSearchRoot(node);
        }

        @Override
        public void scrollNodeToVisible(NodeModel node) {
            MapView.this.mapScroller.scrollNodeToVisible(MapView.this.getNodeView(node));
        }

        @Override
        public void selectAsTheOnlyOneSelected(NodeModel node) {
            NodeView nodeView;
            if (node.isVisible(MapView.this.filter) || MapView.this.currentRootView.getNode() == node) {
                MapView.this.display(node, true);
            }
            if ((nodeView = MapView.this.getNodeView(node)) != null) {
                MapView.this.selectAsTheOnlyOneSelected(nodeView);
            }
        }

        @Override
        public void selectBranch(NodeModel node, boolean extend) {
            if (!extend) {
                this.selectAsTheOnlyOneSelected(node);
            }
            MapView.this.addBranchToSelection(MapView.this.getNodeView(node));
        }

        @Override
        public void selectContinuous(NodeModel node) {
            MapView.this.selectContinuous(MapView.this.getNodeView(node));
        }

        @Override
        public void selectRoot() {
            NodeModel rootNode = MapView.this.currentRootView.getNode();
            this.selectAsTheOnlyOneSelected(rootNode);
            MapView.this.mapScroller.scrollToRootNode();
        }

        @Override
        public int size() {
            return MapView.this.selection.size();
        }

        @Override
        public void toggleSelected(NodeModel node) {
            MapView.this.display(node, true);
            NodeView nodeView = MapView.this.getNodeView(node);
            MapView.this.toggleSelected(nodeView);
        }

        @Override
        public void replaceSelection(NodeModel[] nodes) {
            if (nodes.length == 0) {
                return;
            }
            ArrayList<NodeView> views = new ArrayList<NodeView>(nodes.length);
            for (NodeModel node : nodes) {
                if (node == null || !node.isVisible(MapView.this.filter) && MapView.this.currentRootView.getNode() != node) continue;
                MapView.this.display(node, true);
                NodeView nodeView = MapView.this.getNodeView(node);
                if (nodeView == null) continue;
                views.add(nodeView);
            }
            if (!views.isEmpty()) {
                MapView.this.replaceSelection(views.toArray(new NodeView[0]));
            }
        }

        @Override
        public List<String> getOrderedSelectionIds() {
            List<NodeModel> orderedSelection = this.getOrderedSelection();
            ArrayList<String> ids = new ArrayList<String>(orderedSelection.size());
            for (NodeModel node : orderedSelection) {
                ids.add(node.getID());
            }
            return ids;
        }

        @Override
        public Filter getFilter() {
            return MapView.this.filter;
        }

        @Override
        public void setFilter(Filter filter) {
            MapView.this.filter = filter;
        }

        @Override
        public boolean isFolded(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            return nodeView != null ? nodeView.isFolded() : node.isFolded();
        }

        @Override
        public boolean isVisible(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            return nodeView != null && nodeView.isContentVisible() && SwingUtilities.isDescendingFrom(nodeView, MapView.this.currentRootView);
        }
    }

    public static enum SelectionDirection {
        RIGHT,
        LEFT,
        DOWN,
        UP;


        boolean isHorizontal() {
            return this == RIGHT || this == LEFT;
        }

        boolean isVertical() {
            return this == DOWN || this == UP;
        }

        boolean isForward() {
            return this == RIGHT || this == DOWN;
        }

        boolean isBackward() {
            return this == LEFT || this == UP;
        }
    }

    static enum RootChange {
        JUMP_IN,
        JUMP_OUT,
        ANY;

    }
}

