/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;

public class FileOpener
implements DropTargetListener {
    private final String fileExtension;
    private Listener listener;
    private static final Pattern filePattern = Pattern.compile("file://[^\\s" + File.pathSeparatorChar + "]+");

    public FileOpener(String fileExtension, Listener listener) {
        this.listener = listener;
        this.fileExtension = fileExtension;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.isDragAcceptable(dtde)) {
            dtde.rejectDrag();
            return;
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    private boolean isMindMapUrl(String urlString) {
        return urlString.substring(urlString.length() - this.fileExtension.length() - 1).equalsIgnoreCase("." + this.fileExtension);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (!this.isDropAcceptable(dtde)) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(1);
        try {
            ArrayList<URL> droppedUrls = new ArrayList<URL>();
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : list) {
                    if (file.isDirectory() || !this.isMindMapUrl(file.getName()) || !file.canRead()) continue;
                    URL url = Compat.fileToUrl(file);
                    droppedUrls.add(url);
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String urlStringRepresentation = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (urlStringRepresentation.startsWith("file:")) {
                    Matcher matcher = filePattern.matcher(urlStringRepresentation);
                    while (matcher.find()) {
                        String urlString = matcher.group();
                        if (!this.isMindMapUrl(urlString)) continue;
                        try {
                            URI uri = new URI(urlString);
                            URL url = new URL(uri.getScheme(), uri.getHost() == null ? "" : uri.getHost(), uri.getPath());
                            File file = Compat.urlToFile(url);
                            if (!file.exists() || file.isDirectory()) continue;
                            droppedUrls.add(url);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (urlStringRepresentation.startsWith("http://") && this.isMindMapUrl(urlStringRepresentation)) {
                    URL url = new URL(urlStringRepresentation);
                    droppedUrls.add(url);
                }
            }
            if (droppedUrls.isEmpty()) {
                dtde.dropComplete(false);
            } else {
                this.listener.filesDropped(droppedUrls);
                dtde.dropComplete(true);
            }
        }
        catch (Exception e) {
            UITools.errorMessage(TextUtils.format("dropped_file_error", e.getMessage()));
            dtde.dropComplete(false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || !event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor) && event.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || event.isDataFlavorSupported(DataFlavor.stringFlavor)) && !event.isDataFlavorSupported(TagSelection.tagFlavor) && !event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor);
    }

    public static interface Listener {
        public void filesDropped(Collection<URL> var1) throws Exception;
    }
}

