/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.plaf.LAFUtilities;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColMenuUI
extends BasicMenuUI {
    private AncestorListener ancestorListener = this.createAncestorListener();
    private boolean topLevelMenuItem = false;

    public static ComponentUI createUI(JComponent c) {
        return new FreeColMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addAncestorListener(this.ancestorListener);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LAFUtilities.setProperties(g, c);
        if (this.topLevelMenuItem) {
            Insets insets = c.getInsets();
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
            ImageUtils.fillTexture(g2d, ImageLibrary.getMenuBackground(), insets.left, insets.top, c.getWidth() - insets.right - insets.left, c.getHeight() - insets.top - insets.bottom);
            g2d.setComposite(oldComposite);
        }
        super.paint(g, c);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (!this.topLevelMenuItem) {
            super.paintBackground(g, menuItem, bgColor);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color bgColorModified = model.isSelected() ? new Color(255, 255, 255, 128) : bgColor;
        super.paintBackground(g, menuItem, bgColorModified);
    }

    private AncestorListener createAncestorListener() {
        return new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JComponent c = event.getComponent();
                if (c.getParent() instanceof JMenuBar) {
                    int padding = (int)(2.0f * FontLibrary.getFontScaling());
                    c.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(padding, padding, padding, padding), FreeColImageBorder.simpleButtonBorder));
                    FreeColMenuUI.this.topLevelMenuItem = true;
                } else {
                    c.setBorder(null);
                    FreeColMenuUI.this.topLevelMenuItem = false;
                }
            }
        };
    }
}

