#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 xmobar
version:              0.38
visibility:           public
id:                   xmobar-0.38-H5gjoQuVyjqIxe8OGkiVuQ
key:                  xmobar-0.38-H5gjoQuVyjqIxe8OGkiVuQ
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             http://xmobar.org
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  0c1f521a97fd0fd7d80fe892fa89a6c2
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Run.Types Xmobar.Run.Template Xmobar.Run.Exec
    Xmobar.Run.Command Xmobar.Run.Runnable Xmobar.App.EventLoop
    Xmobar.App.Config Xmobar.App.Main Xmobar.App.Opts
    Xmobar.App.Compile Xmobar.App.Timer Xmobar.System.Utils
    Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.X11.Actions Xmobar.X11.Events Xmobar.X11.Parsers
    Xmobar.X11.Types Xmobar.X11.Text Xmobar.X11.Bitmap
    Xmobar.X11.ColorCache Xmobar.X11.Window Xmobar.X11.Draw
    Xmobar.Plugins.BufferedPipeReader Xmobar.Plugins.CommandReader
    Xmobar.Plugins.Date Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.PipeReader Xmobar.Plugins.MarqueePipeReader
    Xmobar.Plugins.StdinReader Xmobar.Plugins.XMonadLog
    Xmobar.Plugins.Kbd Xmobar.Plugins.Locks Xmobar.Plugins.NotmuchMail
    Xmobar.Plugins.Monitors Xmobar.Plugins.Monitors.Batt
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Mem
    Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Swap Xmobar.Plugins.Monitors.Thermal
    Xmobar.Plugins.Monitors.ThermalZone Xmobar.Plugins.Monitors.Top
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.MinXft
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather

import-dirs:          /usr/lib/ghc-8.10.5/site-local/xmobar-0.38
library-dirs:         /usr/lib/ghc-8.10.5/site-local/xmobar-0.38
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/xmobar-0.38
hs-libraries:         HSxmobar-0.38-H5gjoQuVyjqIxe8OGkiVuQ
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10-HbpsQ2GV6c9KOqYJVkRlFu
    X11-xft-0.3.1-HCIlXgFW6xyIVhjwXQV6if
    alsa-core-0.5.0.1-21ZABdX9DCCCoc3hXQrDOJ
    alsa-mixer-0.3.0-5HURTTVUaoZ47a0GxIGkNx
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    bytestring-0.10.12.0 cereal-0.5.8.1-4r85zOZIbEW4fo8WFnBuTl
    containers-0.6.4.1 dbus-1.2.21-4BuaoGPbLoKIeRj8BORILn
    directory-1.3.6.0
    extensible-exceptions-0.1.1.4-9nRdO96RVgFCedKm18TbaI
    filepath-1.4.2.1 hinotify-0.4.1-KwE8JUlbtoaC5QMAMrUgJB
    http-client-tls-0.3.5.3-1EuJcCGFPgBHafkDNjffQC
    http-conduit-2.3.8-EHVj4SxGcYE5sNggtZCndH
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    libmpd-0.10.0.0-G5dNaNP6o6cEq0QS0CYDUE mtl-2.2.2
    netlink-1.1.1.0-1sh2rjC98zV9n9qwh9hdFs
    old-locale-1.0.0.7-L6Wsx5CTYHFJNpULKIS1yv parsec-3.1.14.0
    parsec-numbers-0.1.0-3DpUQ2w4KxcFj9LWjOgXQe process-1.6.9.0
    regex-compat-0.95.2.1-Go1uCLOxvzSI9Xd7tyszIC stm-2.5.0.1 time-1.9.3
    timezone-olson-0.2.0-GzaPING4jDX6dNV7trRKlc
    timezone-series-0.1.9-B4SpoD8WeBZF5k3MGSL530 transformers-0.5.6.2
    unix-2.7.2.2 utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:
    /usr/share/doc/i386-linux-ghc-8.10.5/xmobar-0.38/html/xmobar.haddock

haddock-html:         /usr/share/doc/i386-linux-ghc-8.10.5/xmobar-0.38/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

