// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3X4C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsam3x4c
// +build sam,atsam3x4c

// Atmel ATSAM3X4C Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM3X4C"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller 0
	IRQ_EFC0 = 6

	// Embedded Flash Controller 1
	IRQ_EFC1 = 7

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART = 8

	// Parallel Input/Output Controller A
	IRQ_PIOA = 11

	// Parallel Input/Output Controller B
	IRQ_PIOB = 12

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 17

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 18

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 19

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 21

	// Two-wire Interface 0
	IRQ_TWI0 = 22

	// Two-wire Interface 1
	IRQ_TWI1 = 23

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 24

	// Synchronous Serial Controller
	IRQ_SSC = 26

	// Timer Counter 0
	IRQ_TC0 = 27

	// Timer Counter 0
	IRQ_TC1 = 28

	// Timer Counter 0
	IRQ_TC2 = 29

	// Timer Counter 1
	IRQ_TC3 = 30

	// Timer Counter 1
	IRQ_TC4 = 31

	// Timer Counter 1
	IRQ_TC5 = 32

	// Pulse Width Modulation Controller
	IRQ_PWM = 36

	// Analog-to-Digital Converter
	IRQ_ADC = 37

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 38

	// DMA Controller
	IRQ_DMAC = 39

	// USB On-The-Go Interface
	IRQ_UOTGHS = 40

	// True Random Number Generator
	IRQ_TRNG = 41

	// Ethernet MAC 10/100
	IRQ_EMAC = 42

	// Controller Area Network 0
	IRQ_CAN0 = 43

	// Controller Area Network 1
	IRQ_CAN1 = 44

	// Highest interrupt number on this device.
	IRQ_max = 44
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC0_IRQHandler
func interruptEFC0() {
	callHandlers(IRQ_EFC0)
}

//export EFC1_IRQHandler
func interruptEFC1() {
	callHandlers(IRQ_EFC1)
}

//export UART_IRQHandler
func interruptUART() {
	callHandlers(IRQ_UART)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export UOTGHS_IRQHandler
func interruptUOTGHS() {
	callHandlers(IRQ_UOTGHS)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export EMAC_IRQHandler
func interruptEMAC() {
	callHandlers(IRQ_EMAC)
}

//export CAN0_IRQHandler
func interruptCAN0() {
	callHandlers(IRQ_CAN0)
}

//export CAN1_IRQHandler
func interruptCAN1() {
	callHandlers(IRQ_CAN1)
}

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// USB On-The-Go Interface
	UOTGHS = (*UOTGHS_Type)(unsafe.Pointer(uintptr(0x400ac000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0x400b0000)))

	// Controller Area Network 0
	CAN0 = (*CAN_Type)(unsafe.Pointer(uintptr(0x400b4000)))

	// Controller Area Network 1
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x400c4000)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x400c8000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Universal Asynchronous Receiver Transmitter
	UART = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0940)))

	// Embedded Flash Controller 0
	EFC0 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Embedded Flash Controller 1
	EFC1 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a00)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a10)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a50)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a60)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1a90)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_SDIOIRQforSlotA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_SDIOIRQforSlotA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOIRQforSlotB(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *HSMCI_Type) GetSR_SDIOIRQforSlotB() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_SDIOIRQforSlotA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_SDIOIRQforSlotA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOIRQforSlotB(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *HSMCI_Type) GetIER_SDIOIRQforSlotB() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_SDIOIRQforSlotA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQforSlotA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOIRQforSlotB(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *HSMCI_Type) GetIDR_SDIOIRQforSlotB() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_SDIOIRQforSlotA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQforSlotA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOIRQforSlotB(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *HSMCI_Type) GetIMR_SDIOIRQforSlotB() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// HSMCI.FIFO: FIFO Memory Aperture0
func (o *HSMCI_Type) SetFIFO(idx int, value uint32) {
	volatile.StoreUint32(&o.FIFO[idx].Reg, value)
}
func (o *HSMCI_Type) GetFIFO(idx int) uint32 {
	return volatile.LoadUint32(&o.FIFO[idx].Reg)
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protect Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_UNDES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_UNDES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIDR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIDR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIMR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIMR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	FMR   volatile.Register32 // 0xD8
	_     [8]byte
	WPMR  volatile.Register32 // 0xE4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.SMMR0: Stepper Motor Mode Register (channel = 0)
func (o *TC_Type) SetSMMR0_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR0_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR0.Reg) & 0x1
}
func (o *TC_Type) SetSMMR0_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR0_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR0.Reg) & 0x2) >> 1
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.SMMR1: Stepper Motor Mode Register (channel = 1)
func (o *TC_Type) SetSMMR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR1_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR1.Reg) & 0x1
}
func (o *TC_Type) SetSMMR1_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR1_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR1.Reg) & 0x2) >> 1
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.SMMR2: Stepper Motor Mode Register (channel = 2)
func (o *TC_Type) SetSMMR2_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR2_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR2.Reg) & 0x1
}
func (o *TC_Type) SetSMMR2_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR2_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR2.Reg) & 0x2) >> 1
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x80000)|value<<19)
}
func (o *TC_Type) GetBMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x80000) >> 19
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// TC.FMR: Fault Mode Register
func (o *TC_Type) SetFMR_ENCF0(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetFMR_ENCF0() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *TC_Type) SetFMR_ENCF1(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetFMR_ENCF1() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x2) >> 1
}

// TC.WPMR: Write Protect Mode Register
func (o *TC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.RPR: Receive Pointer Register
func (o *TWI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *TWI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// TWI.RCR: Receive Counter Register
func (o *TWI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TWI.TPR: Transmit Pointer Register
func (o *TWI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *TWI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// TWI.TCR: Transmit Counter Register
func (o *TWI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// TWI.RNPR: Receive Next Pointer Register
func (o *TWI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *TWI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// TWI.RNCR: Receive Next Counter Register
func (o *TWI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// TWI.TNPR: Transmit Next Pointer Register
func (o *TWI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *TWI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// TWI.TNCR: Transmit Next Counter Register
func (o *TWI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// TWI.PTCR: Transfer Control Register
func (o *TWI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *TWI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// TWI.PTSR: Transfer Status Register
func (o *TWI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *TWI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE1     volatile.Register32 // 0x6C
	FPE2     volatile.Register32 // 0x70
	_        [8]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
	CMR4     volatile.Register32 // 0x280
	CDTY4    volatile.Register32 // 0x284
	CDTYUPD4 volatile.Register32 // 0x288
	CPRD4    volatile.Register32 // 0x28C
	CPRDUPD4 volatile.Register32 // 0x290
	CCNT4    volatile.Register32 // 0x294
	DT4      volatile.Register32 // 0x298
	DTUPD4   volatile.Register32 // 0x29C
	CMR5     volatile.Register32 // 0x2A0
	CDTY5    volatile.Register32 // 0x2A4
	CDTYUPD5 volatile.Register32 // 0x2A8
	CPRD5    volatile.Register32 // 0x2AC
	CPRDUPD5 volatile.Register32 // 0x2B0
	CCNT5    volatile.Register32 // 0x2B4
	DT5      volatile.Register32 // 0x2B8
	DTUPD5   volatile.Register32 // 0x2BC
	CMR6     volatile.Register32 // 0x2C0
	CDTY6    volatile.Register32 // 0x2C4
	CDTYUPD6 volatile.Register32 // 0x2C8
	CPRD6    volatile.Register32 // 0x2CC
	CPRDUPD6 volatile.Register32 // 0x2D0
	CCNT6    volatile.Register32 // 0x2D4
	DT6      volatile.Register32 // 0x2D8
	DTUPD6   volatile.Register32 // 0x2DC
	CMR7     volatile.Register32 // 0x2E0
	CDTY7    volatile.Register32 // 0x2E4
	CDTYUPD7 volatile.Register32 // 0x2E8
	CPRD7    volatile.Register32 // 0x2EC
	CPRDUPD7 volatile.Register32 // 0x2F0
	CCNT7    volatile.Register32 // 0x2F4
	DT7      volatile.Register32 // 0x2F8
	DTUPD7   volatile.Register32 // 0x2FC
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetENA_CHID4(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetENA_CHID4() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetENA_CHID5(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetENA_CHID5() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetENA_CHID6(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetENA_CHID6() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetENA_CHID7(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetENA_CHID7() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x80) >> 7
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetDIS_CHID4(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetDIS_CHID4() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetDIS_CHID5(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetDIS_CHID5() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetDIS_CHID6(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetDIS_CHID6() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetDIS_CHID7(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetDIS_CHID7() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x80) >> 7
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSR_CHID4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetSR_CHID4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetSR_CHID5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetSR_CHID5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetSR_CHID6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetSR_CHID6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetSR_CHID7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetSR_CHID7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_CHID4(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetIER1_CHID4() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetIER1_CHID5(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetIER1_CHID5() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetIER1_CHID6(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetIER1_CHID6() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetIER1_CHID7(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetIER1_CHID7() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER1_FCHID4(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER1_FCHID4() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER1_FCHID5(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER1_FCHID5() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER1_FCHID6(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER1_FCHID6() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER1_FCHID7(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER1_FCHID7() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x800000) >> 23
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_CHID4(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetIDR1_CHID4() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetIDR1_CHID5(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetIDR1_CHID5() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetIDR1_CHID6(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetIDR1_CHID6() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetIDR1_CHID7(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetIDR1_CHID7() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR1_FCHID4(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR1_FCHID4() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR1_FCHID5(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR1_FCHID5() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR1_FCHID6(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR1_FCHID6() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR1_FCHID7(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR1_FCHID7() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x800000) >> 23
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_CHID4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetIMR1_CHID4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetIMR1_CHID5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetIMR1_CHID5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetIMR1_CHID6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetIMR1_CHID6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetIMR1_CHID7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetIMR1_CHID7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR1_FCHID4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR1_FCHID4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR1_FCHID5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR1_FCHID5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR1_FCHID6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR1_FCHID6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR1_FCHID7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR1_FCHID7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_CHID4(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetISR1_CHID4() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetISR1_CHID5(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetISR1_CHID5() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetISR1_CHID6(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetISR1_CHID6() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetISR1_CHID7(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetISR1_CHID7() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR1_FCHID4(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR1_FCHID4() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR1_FCHID5(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR1_FCHID5() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR1_FCHID6(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR1_FCHID6() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR1_FCHID7(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR1_FCHID7() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x800000) >> 23
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_SYNC4(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetSCM_SYNC4() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetSCM_SYNC5(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetSCM_SYNC5() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetSCM_SYNC6(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetSCM_SYNC6() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetSCM_SYNC7(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetSCM_SYNC7() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}
func (o *PWM_Type) SetSCM_PTRM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetSCM_PTRM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetSCM_PTRCS(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0xe00000)|value<<21)
}
func (o *PWM_Type) GetSCM_PTRCS() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0xe00000) >> 21
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR2_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR2_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR2_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVH4(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOOV_OOVH4() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOOV_OOVH5(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOOV_OOVH5() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOOV_OOVH6(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOOV_OOVH6() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOOV_OOVH7(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOOV_OOVH7() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOOV_OOVL4(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOOV_OOVL4() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOOV_OOVL5(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOOV_OOVL5() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOOV_OOVL6(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOOV_OOVL6() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOOV_OOVL7(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOOV_OOVL7() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x800000) >> 23
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSH4(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOS_OSH4() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOS_OSH5(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOS_OSH5() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOS_OSH6(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOS_OSH6() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOS_OSH7(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOS_OSH7() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOS_OSL4(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOS_OSL4() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOS_OSL5(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOS_OSL5() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOS_OSL6(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOS_OSL6() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOS_OSL7(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOS_OSL7() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x800000) >> 23
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSH4(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOSS_OSSH4() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOSS_OSSH5(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOSS_OSSH5() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOSS_OSSH6(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOSS_OSSH6() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOSS_OSSH7(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOSS_OSSH7() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOSS_OSSL4(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOSS_OSSL4() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOSS_OSSL5(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOSS_OSSL5() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOSS_OSSL6(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOSS_OSSL6() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOSS_OSSL7(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOSS_OSSL7() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x800000) >> 23
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCH4(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOSC_OSCH4() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOSC_OSCH5(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOSC_OSCH5() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOSC_OSCH6(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOSC_OSCH6() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOSC_OSCH7(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOSC_OSCH7() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOSC_OSCL4(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOSC_OSCL4() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOSC_OSCL5(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOSC_OSCL5() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOSC_OSCL6(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOSC_OSCL6() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOSC_OSCL7(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOSC_OSCL7() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x800000) >> 23
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPH4(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH4() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOSSUPD_OSSUPH5(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH5() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOSSUPD_OSSUPH6(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH6() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOSSUPD_OSSUPH7(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH7() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOSSUPD_OSSUPL4(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL4() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOSSUPD_OSSUPL5(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL5() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOSSUPD_OSSUPL6(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL6() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOSSUPD_OSSUPL7(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL7() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x800000) >> 23
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPH4(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH4() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetOSCUPD_OSCUPH5(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH5() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetOSCUPD_OSCUPH6(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH6() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetOSCUPD_OSCUPH7(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH7() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetOSCUPD_OSCUPL4(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL4() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetOSCUPD_OSCUPL5(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL5() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetOSCUPD_OSCUPL6(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL6() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetOSCUPD_OSCUPL7(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL7() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x800000) >> 23
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV: PWM Fault Protection Value Register
func (o *PWM_Type) SetFPV_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV.Reg) & 0x1
}
func (o *PWM_Type) SetFPV_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV_FPVH4(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetFPV_FPVH4() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetFPV_FPVH5(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetFPV_FPVH5() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetFPV_FPVH6(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetFPV_FPVH6() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetFPV_FPVH7(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetFPV_FPVH7() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetFPV_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetFPV_FPVL4(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetFPV_FPVL4() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetFPV_FPVL5(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetFPV_FPVL5() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetFPV_FPVL6(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetFPV_FPVL6() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetFPV_FPVL7(value uint32) {
	volatile.StoreUint32(&o.FPV.Reg, volatile.LoadUint32(&o.FPV.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetFPV_FPVL7() uint32 {
	return (volatile.LoadUint32(&o.FPV.Reg) & 0x800000) >> 23
}

// PWM.FPE1: PWM Fault Protection Enable Register 1
func (o *PWM_Type) SetFPE1_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE1.Reg, volatile.LoadUint32(&o.FPE1.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE1_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE1.Reg) & 0xff
}
func (o *PWM_Type) SetFPE1(value uint32) {
	volatile.StoreUint32(&o.FPE1.Reg, volatile.LoadUint32(&o.FPE1.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE1.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE1_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE1.Reg, volatile.LoadUint32(&o.FPE1.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE1_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE1.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE1_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE1.Reg, volatile.LoadUint32(&o.FPE1.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE1_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE1.Reg) & 0xff000000) >> 24
}

// PWM.FPE2: PWM Fault Protection Enable Register 2
func (o *PWM_Type) SetFPE2_FPE4(value uint32) {
	volatile.StoreUint32(&o.FPE2.Reg, volatile.LoadUint32(&o.FPE2.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE2_FPE4() uint32 {
	return volatile.LoadUint32(&o.FPE2.Reg) & 0xff
}
func (o *PWM_Type) SetFPE2_FPE5(value uint32) {
	volatile.StoreUint32(&o.FPE2.Reg, volatile.LoadUint32(&o.FPE2.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE2_FPE5() uint32 {
	return (volatile.LoadUint32(&o.FPE2.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE2_FPE6(value uint32) {
	volatile.StoreUint32(&o.FPE2.Reg, volatile.LoadUint32(&o.FPE2.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE2_FPE6() uint32 {
	return (volatile.LoadUint32(&o.FPE2.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE2_FPE7(value uint32) {
	volatile.StoreUint32(&o.FPE2.Reg, volatile.LoadUint32(&o.FPE2.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE2_FPE7() uint32 {
	return (volatile.LoadUint32(&o.FPE2.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_GCEN2(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSMMR_GCEN2() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSMMR_GCEN3(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSMMR_GCEN3() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetSMMR_DOWN2(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetSMMR_DOWN2() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetSMMR_DOWN3(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetSMMR_DOWN3() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x80000) >> 19
}

// PWM.WPCR: PWM Write Protect Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protect Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.TPR: Transmit Pointer Register
func (o *PWM_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *PWM_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// PWM.TCR: Transmit Counter Register
func (o *PWM_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// PWM.TNPR: Transmit Next Pointer Register
func (o *PWM_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *PWM_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// PWM.TNCR: Transmit Next Counter Register
func (o *PWM_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// PWM.PTCR: Transfer Control Register
func (o *PWM_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *PWM_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// PWM.PTSR: Transfer Status Register
func (o *PWM_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *PWM_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// PWM.CMPV0: PWM Comparison 0 Value Register
func (o *PWM_Type) SetCMPV0_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV0_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV0_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV0.Reg, volatile.LoadUint32(&o.CMPV0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV0_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV0.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD0: PWM Comparison 0 Value Update Register
func (o *PWM_Type) SetCMPVUPD0_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD0_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD0_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD0.Reg, volatile.LoadUint32(&o.CMPVUPD0.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD0_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD0.Reg) & 0x1000000) >> 24
}

// PWM.CMPM0: PWM Comparison 0 Mode Register
func (o *PWM_Type) SetCMPM0_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM0_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM0_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM0_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM0_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM0_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM0_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM0_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM0_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM0_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM0_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM0.Reg, volatile.LoadUint32(&o.CMPM0.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM0_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM0.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD0: PWM Comparison 0 Mode Update Register
func (o *PWM_Type) SetCMPMUPD0_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD0_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD0_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD0_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD0_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD0_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD0_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD0.Reg, volatile.LoadUint32(&o.CMPMUPD0.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD0_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD0.Reg) & 0xf0000) >> 16
}

// PWM.CMPV1: PWM Comparison 1 Value Register
func (o *PWM_Type) SetCMPV1_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV1_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV1_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV1.Reg, volatile.LoadUint32(&o.CMPV1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV1_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV1.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD1: PWM Comparison 1 Value Update Register
func (o *PWM_Type) SetCMPVUPD1_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD1_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD1_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD1.Reg, volatile.LoadUint32(&o.CMPVUPD1.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD1_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD1.Reg) & 0x1000000) >> 24
}

// PWM.CMPM1: PWM Comparison 1 Mode Register
func (o *PWM_Type) SetCMPM1_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM1_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM1_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM1_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM1_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM1_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM1_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM1_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM1_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM1_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM1_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM1.Reg, volatile.LoadUint32(&o.CMPM1.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM1_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM1.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD1: PWM Comparison 1 Mode Update Register
func (o *PWM_Type) SetCMPMUPD1_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD1_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD1_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD1_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD1_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD1_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD1_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD1.Reg, volatile.LoadUint32(&o.CMPMUPD1.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD1_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD1.Reg) & 0xf0000) >> 16
}

// PWM.CMPV2: PWM Comparison 2 Value Register
func (o *PWM_Type) SetCMPV2_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV2_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV2_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV2.Reg, volatile.LoadUint32(&o.CMPV2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV2_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV2.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD2: PWM Comparison 2 Value Update Register
func (o *PWM_Type) SetCMPVUPD2_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD2_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD2_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD2.Reg, volatile.LoadUint32(&o.CMPVUPD2.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD2_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD2.Reg) & 0x1000000) >> 24
}

// PWM.CMPM2: PWM Comparison 2 Mode Register
func (o *PWM_Type) SetCMPM2_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM2_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM2_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM2_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM2_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM2_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM2_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM2_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM2_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM2_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM2_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM2.Reg, volatile.LoadUint32(&o.CMPM2.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM2_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM2.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD2: PWM Comparison 2 Mode Update Register
func (o *PWM_Type) SetCMPMUPD2_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD2_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD2_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD2_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD2_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD2_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD2_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD2.Reg, volatile.LoadUint32(&o.CMPMUPD2.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD2_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD2.Reg) & 0xf0000) >> 16
}

// PWM.CMPV3: PWM Comparison 3 Value Register
func (o *PWM_Type) SetCMPV3_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV3_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV3_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV3.Reg, volatile.LoadUint32(&o.CMPV3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV3_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV3.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD3: PWM Comparison 3 Value Update Register
func (o *PWM_Type) SetCMPVUPD3_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD3_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD3_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD3.Reg, volatile.LoadUint32(&o.CMPVUPD3.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD3_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD3.Reg) & 0x1000000) >> 24
}

// PWM.CMPM3: PWM Comparison 3 Mode Register
func (o *PWM_Type) SetCMPM3_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM3_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM3_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM3_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM3_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM3_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM3_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM3_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM3_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM3_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM3_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM3.Reg, volatile.LoadUint32(&o.CMPM3.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM3_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM3.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD3: PWM Comparison 3 Mode Update Register
func (o *PWM_Type) SetCMPMUPD3_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD3_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD3_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD3_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD3_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD3_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD3_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD3.Reg, volatile.LoadUint32(&o.CMPMUPD3.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD3_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD3.Reg) & 0xf0000) >> 16
}

// PWM.CMPV4: PWM Comparison 4 Value Register
func (o *PWM_Type) SetCMPV4_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV4_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV4_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV4.Reg, volatile.LoadUint32(&o.CMPV4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV4_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV4.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD4: PWM Comparison 4 Value Update Register
func (o *PWM_Type) SetCMPVUPD4_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD4_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD4_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD4.Reg, volatile.LoadUint32(&o.CMPVUPD4.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD4_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD4.Reg) & 0x1000000) >> 24
}

// PWM.CMPM4: PWM Comparison 4 Mode Register
func (o *PWM_Type) SetCMPM4_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM4_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM4_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM4_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM4_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM4_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM4_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM4_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM4_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM4_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM4_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM4.Reg, volatile.LoadUint32(&o.CMPM4.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM4_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM4.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD4: PWM Comparison 4 Mode Update Register
func (o *PWM_Type) SetCMPMUPD4_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD4_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD4_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD4_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD4_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD4_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD4_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD4.Reg, volatile.LoadUint32(&o.CMPMUPD4.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD4_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD4.Reg) & 0xf0000) >> 16
}

// PWM.CMPV5: PWM Comparison 5 Value Register
func (o *PWM_Type) SetCMPV5_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV5_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV5_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV5.Reg, volatile.LoadUint32(&o.CMPV5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV5_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV5.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD5: PWM Comparison 5 Value Update Register
func (o *PWM_Type) SetCMPVUPD5_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD5_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD5_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD5.Reg, volatile.LoadUint32(&o.CMPVUPD5.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD5_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD5.Reg) & 0x1000000) >> 24
}

// PWM.CMPM5: PWM Comparison 5 Mode Register
func (o *PWM_Type) SetCMPM5_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM5_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM5_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM5_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM5_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM5_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM5_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM5_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM5_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM5_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM5_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM5.Reg, volatile.LoadUint32(&o.CMPM5.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM5_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM5.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD5: PWM Comparison 5 Mode Update Register
func (o *PWM_Type) SetCMPMUPD5_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD5_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD5_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD5_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD5_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD5_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD5_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD5.Reg, volatile.LoadUint32(&o.CMPMUPD5.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD5_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD5.Reg) & 0xf0000) >> 16
}

// PWM.CMPV6: PWM Comparison 6 Value Register
func (o *PWM_Type) SetCMPV6_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV6_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV6_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV6.Reg, volatile.LoadUint32(&o.CMPV6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV6_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV6.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD6: PWM Comparison 6 Value Update Register
func (o *PWM_Type) SetCMPVUPD6_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD6_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD6_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD6.Reg, volatile.LoadUint32(&o.CMPVUPD6.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD6_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD6.Reg) & 0x1000000) >> 24
}

// PWM.CMPM6: PWM Comparison 6 Mode Register
func (o *PWM_Type) SetCMPM6_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM6_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM6_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM6_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM6_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM6_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM6_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM6_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM6_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM6_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM6_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM6.Reg, volatile.LoadUint32(&o.CMPM6.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM6_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM6.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD6: PWM Comparison 6 Mode Update Register
func (o *PWM_Type) SetCMPMUPD6_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD6_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD6_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD6_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD6_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD6_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD6_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD6.Reg, volatile.LoadUint32(&o.CMPMUPD6.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD6_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD6.Reg) & 0xf0000) >> 16
}

// PWM.CMPV7: PWM Comparison 7 Value Register
func (o *PWM_Type) SetCMPV7_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPV7_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPV7_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV7.Reg, volatile.LoadUint32(&o.CMPV7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPV7_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV7.Reg) & 0x1000000) >> 24
}

// PWM.CMPVUPD7: PWM Comparison 7 Value Update Register
func (o *PWM_Type) SetCMPVUPD7_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCMPVUPD7_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0xffffff
}
func (o *PWM_Type) SetCMPVUPD7_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD7.Reg, volatile.LoadUint32(&o.CMPVUPD7.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetCMPVUPD7_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD7.Reg) & 0x1000000) >> 24
}

// PWM.CMPM7: PWM Comparison 7 Mode Register
func (o *PWM_Type) SetCMPM7_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPM7_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPM7_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPM7_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPM7_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPM7_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPM7_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_Type) GetCMPM7_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf000) >> 12
}
func (o *PWM_Type) SetCMPM7_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPM7_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf0000) >> 16
}
func (o *PWM_Type) SetCMPM7_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM7.Reg, volatile.LoadUint32(&o.CMPM7.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_Type) GetCMPM7_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM7.Reg) & 0xf00000) >> 20
}

// PWM.CMPMUPD7: PWM Comparison 7 Mode Update Register
func (o *PWM_Type) SetCMPMUPD7_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCMPMUPD7_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0x1
}
func (o *PWM_Type) SetCMPMUPD7_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetCMPMUPD7_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0) >> 4
}
func (o *PWM_Type) SetCMPMUPD7_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCMPMUPD7_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCMPMUPD7_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD7.Reg, volatile.LoadUint32(&o.CMPMUPD7.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_Type) GetCMPMUPD7_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD7.Reg) & 0xf0000) >> 16
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CES(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR0_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR0_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR0_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR0_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR0_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR0_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40000) >> 18
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, volatile.LoadUint32(&o.CDTY0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY0_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg) & 0xffffff
}

// PWM.CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
func (o *PWM_Type) SetCDTYUPD0_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD0.Reg, volatile.LoadUint32(&o.CDTYUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD0_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD0.Reg) & 0xffffff
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, volatile.LoadUint32(&o.CPRD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD0_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg) & 0xffffff
}

// PWM.CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
func (o *PWM_Type) SetCPRDUPD0_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD0.Reg, volatile.LoadUint32(&o.CPRDUPD0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD0_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD0.Reg) & 0xffffff
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, volatile.LoadUint32(&o.CCNT0.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT0_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg) & 0xffffff
}

// PWM.DT0: PWM Channel Dead Time Register (ch_num = 0)
func (o *PWM_Type) SetDT0_DTH(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT0_DTH() uint32 {
	return volatile.LoadUint32(&o.DT0.Reg) & 0xffff
}
func (o *PWM_Type) SetDT0_DTL(value uint32) {
	volatile.StoreUint32(&o.DT0.Reg, volatile.LoadUint32(&o.DT0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT0_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT0.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
func (o *PWM_Type) SetDTUPD0_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD0_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD0_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD0.Reg, volatile.LoadUint32(&o.DTUPD0.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD0_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD0.Reg) & 0xffff0000) >> 16
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CES(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR1_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR1_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR1_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR1_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR1_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR1_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40000) >> 18
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, volatile.LoadUint32(&o.CDTY1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY1_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg) & 0xffffff
}

// PWM.CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
func (o *PWM_Type) SetCDTYUPD1_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD1.Reg, volatile.LoadUint32(&o.CDTYUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD1_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD1.Reg) & 0xffffff
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, volatile.LoadUint32(&o.CPRD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD1_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg) & 0xffffff
}

// PWM.CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
func (o *PWM_Type) SetCPRDUPD1_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD1.Reg, volatile.LoadUint32(&o.CPRDUPD1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD1_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD1.Reg) & 0xffffff
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, volatile.LoadUint32(&o.CCNT1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT1_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg) & 0xffffff
}

// PWM.DT1: PWM Channel Dead Time Register (ch_num = 1)
func (o *PWM_Type) SetDT1_DTH(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT1_DTH() uint32 {
	return volatile.LoadUint32(&o.DT1.Reg) & 0xffff
}
func (o *PWM_Type) SetDT1_DTL(value uint32) {
	volatile.StoreUint32(&o.DT1.Reg, volatile.LoadUint32(&o.DT1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT1_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT1.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
func (o *PWM_Type) SetDTUPD1_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD1_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD1_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD1.Reg, volatile.LoadUint32(&o.DTUPD1.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD1_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD1.Reg) & 0xffff0000) >> 16
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CES(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR2_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR2_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR2_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR2_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR2_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR2_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40000) >> 18
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, volatile.LoadUint32(&o.CDTY2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY2_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg) & 0xffffff
}

// PWM.CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
func (o *PWM_Type) SetCDTYUPD2_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD2.Reg, volatile.LoadUint32(&o.CDTYUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD2_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD2.Reg) & 0xffffff
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, volatile.LoadUint32(&o.CPRD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD2_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg) & 0xffffff
}

// PWM.CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
func (o *PWM_Type) SetCPRDUPD2_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD2.Reg, volatile.LoadUint32(&o.CPRDUPD2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD2_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD2.Reg) & 0xffffff
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, volatile.LoadUint32(&o.CCNT2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT2_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg) & 0xffffff
}

// PWM.DT2: PWM Channel Dead Time Register (ch_num = 2)
func (o *PWM_Type) SetDT2_DTH(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT2_DTH() uint32 {
	return volatile.LoadUint32(&o.DT2.Reg) & 0xffff
}
func (o *PWM_Type) SetDT2_DTL(value uint32) {
	volatile.StoreUint32(&o.DT2.Reg, volatile.LoadUint32(&o.DT2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT2_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT2.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
func (o *PWM_Type) SetDTUPD2_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD2_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD2_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD2.Reg, volatile.LoadUint32(&o.DTUPD2.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD2_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD2.Reg) & 0xffff0000) >> 16
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CES(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR3_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR3_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR3_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR3_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR3_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR3_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x40000) >> 18
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, volatile.LoadUint32(&o.CDTY3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY3_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg) & 0xffffff
}

// PWM.CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
func (o *PWM_Type) SetCDTYUPD3_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD3.Reg, volatile.LoadUint32(&o.CDTYUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD3_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD3.Reg) & 0xffffff
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, volatile.LoadUint32(&o.CPRD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD3_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg) & 0xffffff
}

// PWM.CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
func (o *PWM_Type) SetCPRDUPD3_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD3.Reg, volatile.LoadUint32(&o.CPRDUPD3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD3_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD3.Reg) & 0xffffff
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, volatile.LoadUint32(&o.CCNT3.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT3_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg) & 0xffffff
}

// PWM.DT3: PWM Channel Dead Time Register (ch_num = 3)
func (o *PWM_Type) SetDT3_DTH(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT3_DTH() uint32 {
	return volatile.LoadUint32(&o.DT3.Reg) & 0xffff
}
func (o *PWM_Type) SetDT3_DTL(value uint32) {
	volatile.StoreUint32(&o.DT3.Reg, volatile.LoadUint32(&o.DT3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT3_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT3.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
func (o *PWM_Type) SetDTUPD3_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD3_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD3_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD3.Reg, volatile.LoadUint32(&o.DTUPD3.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD3_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD3.Reg) & 0xffff0000) >> 16
}

// PWM.CMR4: PWM Channel Mode Register (ch_num = 4)
func (o *PWM_Type) SetCMR4_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR4_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR4.Reg) & 0xf
}
func (o *PWM_Type) SetCMR4_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR4_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR4_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR4_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR4_CES(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR4_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR4_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR4_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR4_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR4_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR4_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR4.Reg, volatile.LoadUint32(&o.CMR4.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR4_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR4.Reg) & 0x40000) >> 18
}

// PWM.CDTY4: PWM Channel Duty Cycle Register (ch_num = 4)
func (o *PWM_Type) SetCDTY4_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY4.Reg, volatile.LoadUint32(&o.CDTY4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY4_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY4.Reg) & 0xffffff
}

// PWM.CDTYUPD4: PWM Channel Duty Cycle Update Register (ch_num = 4)
func (o *PWM_Type) SetCDTYUPD4_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD4.Reg, volatile.LoadUint32(&o.CDTYUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD4_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD4.Reg) & 0xffffff
}

// PWM.CPRD4: PWM Channel Period Register (ch_num = 4)
func (o *PWM_Type) SetCPRD4_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD4.Reg, volatile.LoadUint32(&o.CPRD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD4_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD4.Reg) & 0xffffff
}

// PWM.CPRDUPD4: PWM Channel Period Update Register (ch_num = 4)
func (o *PWM_Type) SetCPRDUPD4_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD4.Reg, volatile.LoadUint32(&o.CPRDUPD4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD4_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD4.Reg) & 0xffffff
}

// PWM.CCNT4: PWM Channel Counter Register (ch_num = 4)
func (o *PWM_Type) SetCCNT4_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT4.Reg, volatile.LoadUint32(&o.CCNT4.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT4_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT4.Reg) & 0xffffff
}

// PWM.DT4: PWM Channel Dead Time Register (ch_num = 4)
func (o *PWM_Type) SetDT4_DTH(value uint32) {
	volatile.StoreUint32(&o.DT4.Reg, volatile.LoadUint32(&o.DT4.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT4_DTH() uint32 {
	return volatile.LoadUint32(&o.DT4.Reg) & 0xffff
}
func (o *PWM_Type) SetDT4_DTL(value uint32) {
	volatile.StoreUint32(&o.DT4.Reg, volatile.LoadUint32(&o.DT4.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT4_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT4.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD4: PWM Channel Dead Time Update Register (ch_num = 4)
func (o *PWM_Type) SetDTUPD4_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD4.Reg, volatile.LoadUint32(&o.DTUPD4.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD4_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD4.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD4_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD4.Reg, volatile.LoadUint32(&o.DTUPD4.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD4_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD4.Reg) & 0xffff0000) >> 16
}

// PWM.CMR5: PWM Channel Mode Register (ch_num = 5)
func (o *PWM_Type) SetCMR5_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR5_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR5.Reg) & 0xf
}
func (o *PWM_Type) SetCMR5_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR5_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR5_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR5_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR5_CES(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR5_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR5_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR5_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR5_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR5_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR5_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR5.Reg, volatile.LoadUint32(&o.CMR5.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR5_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR5.Reg) & 0x40000) >> 18
}

// PWM.CDTY5: PWM Channel Duty Cycle Register (ch_num = 5)
func (o *PWM_Type) SetCDTY5_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY5.Reg, volatile.LoadUint32(&o.CDTY5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY5_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY5.Reg) & 0xffffff
}

// PWM.CDTYUPD5: PWM Channel Duty Cycle Update Register (ch_num = 5)
func (o *PWM_Type) SetCDTYUPD5_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD5.Reg, volatile.LoadUint32(&o.CDTYUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD5_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD5.Reg) & 0xffffff
}

// PWM.CPRD5: PWM Channel Period Register (ch_num = 5)
func (o *PWM_Type) SetCPRD5_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD5.Reg, volatile.LoadUint32(&o.CPRD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD5_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD5.Reg) & 0xffffff
}

// PWM.CPRDUPD5: PWM Channel Period Update Register (ch_num = 5)
func (o *PWM_Type) SetCPRDUPD5_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD5.Reg, volatile.LoadUint32(&o.CPRDUPD5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD5_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD5.Reg) & 0xffffff
}

// PWM.CCNT5: PWM Channel Counter Register (ch_num = 5)
func (o *PWM_Type) SetCCNT5_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT5.Reg, volatile.LoadUint32(&o.CCNT5.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT5_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT5.Reg) & 0xffffff
}

// PWM.DT5: PWM Channel Dead Time Register (ch_num = 5)
func (o *PWM_Type) SetDT5_DTH(value uint32) {
	volatile.StoreUint32(&o.DT5.Reg, volatile.LoadUint32(&o.DT5.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT5_DTH() uint32 {
	return volatile.LoadUint32(&o.DT5.Reg) & 0xffff
}
func (o *PWM_Type) SetDT5_DTL(value uint32) {
	volatile.StoreUint32(&o.DT5.Reg, volatile.LoadUint32(&o.DT5.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT5_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT5.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD5: PWM Channel Dead Time Update Register (ch_num = 5)
func (o *PWM_Type) SetDTUPD5_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD5.Reg, volatile.LoadUint32(&o.DTUPD5.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD5_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD5.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD5_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD5.Reg, volatile.LoadUint32(&o.DTUPD5.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD5_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD5.Reg) & 0xffff0000) >> 16
}

// PWM.CMR6: PWM Channel Mode Register (ch_num = 6)
func (o *PWM_Type) SetCMR6_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR6_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR6.Reg) & 0xf
}
func (o *PWM_Type) SetCMR6_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR6_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR6_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR6_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR6_CES(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR6_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR6_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR6_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR6_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR6_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR6_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR6.Reg, volatile.LoadUint32(&o.CMR6.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR6_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR6.Reg) & 0x40000) >> 18
}

// PWM.CDTY6: PWM Channel Duty Cycle Register (ch_num = 6)
func (o *PWM_Type) SetCDTY6_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY6.Reg, volatile.LoadUint32(&o.CDTY6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY6_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY6.Reg) & 0xffffff
}

// PWM.CDTYUPD6: PWM Channel Duty Cycle Update Register (ch_num = 6)
func (o *PWM_Type) SetCDTYUPD6_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD6.Reg, volatile.LoadUint32(&o.CDTYUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD6_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD6.Reg) & 0xffffff
}

// PWM.CPRD6: PWM Channel Period Register (ch_num = 6)
func (o *PWM_Type) SetCPRD6_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD6.Reg, volatile.LoadUint32(&o.CPRD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD6_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD6.Reg) & 0xffffff
}

// PWM.CPRDUPD6: PWM Channel Period Update Register (ch_num = 6)
func (o *PWM_Type) SetCPRDUPD6_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD6.Reg, volatile.LoadUint32(&o.CPRDUPD6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD6_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD6.Reg) & 0xffffff
}

// PWM.CCNT6: PWM Channel Counter Register (ch_num = 6)
func (o *PWM_Type) SetCCNT6_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT6.Reg, volatile.LoadUint32(&o.CCNT6.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT6_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT6.Reg) & 0xffffff
}

// PWM.DT6: PWM Channel Dead Time Register (ch_num = 6)
func (o *PWM_Type) SetDT6_DTH(value uint32) {
	volatile.StoreUint32(&o.DT6.Reg, volatile.LoadUint32(&o.DT6.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT6_DTH() uint32 {
	return volatile.LoadUint32(&o.DT6.Reg) & 0xffff
}
func (o *PWM_Type) SetDT6_DTL(value uint32) {
	volatile.StoreUint32(&o.DT6.Reg, volatile.LoadUint32(&o.DT6.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT6_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT6.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD6: PWM Channel Dead Time Update Register (ch_num = 6)
func (o *PWM_Type) SetDTUPD6_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD6.Reg, volatile.LoadUint32(&o.DTUPD6.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD6_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD6.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD6_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD6.Reg, volatile.LoadUint32(&o.DTUPD6.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD6_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD6.Reg) & 0xffff0000) >> 16
}

// PWM.CMR7: PWM Channel Mode Register (ch_num = 7)
func (o *PWM_Type) SetCMR7_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR7_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR7.Reg) & 0xf
}
func (o *PWM_Type) SetCMR7_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR7_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR7_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR7_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR7_CES(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR7_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCMR7_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetCMR7_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetCMR7_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetCMR7_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetCMR7_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR7.Reg, volatile.LoadUint32(&o.CMR7.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetCMR7_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR7.Reg) & 0x40000) >> 18
}

// PWM.CDTY7: PWM Channel Duty Cycle Register (ch_num = 7)
func (o *PWM_Type) SetCDTY7_CDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY7.Reg, volatile.LoadUint32(&o.CDTY7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTY7_CDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY7.Reg) & 0xffffff
}

// PWM.CDTYUPD7: PWM Channel Duty Cycle Update Register (ch_num = 7)
func (o *PWM_Type) SetCDTYUPD7_CDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD7.Reg, volatile.LoadUint32(&o.CDTYUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCDTYUPD7_CDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD7.Reg) & 0xffffff
}

// PWM.CPRD7: PWM Channel Period Register (ch_num = 7)
func (o *PWM_Type) SetCPRD7_CPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD7.Reg, volatile.LoadUint32(&o.CPRD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRD7_CPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD7.Reg) & 0xffffff
}

// PWM.CPRDUPD7: PWM Channel Period Update Register (ch_num = 7)
func (o *PWM_Type) SetCPRDUPD7_CPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD7.Reg, volatile.LoadUint32(&o.CPRDUPD7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCPRDUPD7_CPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD7.Reg) & 0xffffff
}

// PWM.CCNT7: PWM Channel Counter Register (ch_num = 7)
func (o *PWM_Type) SetCCNT7_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT7.Reg, volatile.LoadUint32(&o.CCNT7.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetCCNT7_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT7.Reg) & 0xffffff
}

// PWM.DT7: PWM Channel Dead Time Register (ch_num = 7)
func (o *PWM_Type) SetDT7_DTH(value uint32) {
	volatile.StoreUint32(&o.DT7.Reg, volatile.LoadUint32(&o.DT7.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDT7_DTH() uint32 {
	return volatile.LoadUint32(&o.DT7.Reg) & 0xffff
}
func (o *PWM_Type) SetDT7_DTL(value uint32) {
	volatile.StoreUint32(&o.DT7.Reg, volatile.LoadUint32(&o.DT7.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDT7_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT7.Reg) & 0xffff0000) >> 16
}

// PWM.DTUPD7: PWM Channel Dead Time Update Register (ch_num = 7)
func (o *PWM_Type) SetDTUPD7_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD7.Reg, volatile.LoadUint32(&o.DTUPD7.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetDTUPD7_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD7.Reg) & 0xffff
}
func (o *PWM_Type) SetDTUPD7_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD7.Reg, volatile.LoadUint32(&o.DTUPD7.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetDTUPD7_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD7.Reg) & 0xffff0000) >> 16
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	IER    volatile.Register32 // 0x8
	IDR    volatile.Register32 // 0xC
	IMR    volatile.Register32 // 0x10
	CSR    volatile.Register32 // 0x14
	RHR    volatile.Register32 // 0x18
	THR    volatile.Register32 // 0x1C
	BRGR   volatile.Register32 // 0x20
	RTOR   volatile.Register32 // 0x24
	TTGR   volatile.Register32 // 0x28
	_      [20]byte
	FIDI   volatile.Register32 // 0x40
	NER    volatile.Register32 // 0x44
	_      [4]byte
	IF     volatile.Register32 // 0x4C
	MAN    volatile.Register32 // 0x50
	LINMR  volatile.Register32 // 0x54
	LINIR  volatile.Register32 // 0x58
	LINBRR volatile.Register32 // 0x5C
	_      [132]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
	_      [20]byte
	RPR    volatile.Register32 // 0x100
	RCR    volatile.Register32 // 0x104
	TPR    volatile.Register32 // 0x108
	TCR    volatile.Register32 // 0x10C
	RNPR   volatile.Register32 // 0x110
	RNCR   volatile.Register32 // 0x114
	TNPR   volatile.Register32 // 0x118
	TNCR   volatile.Register32 // 0x11C
	PTCR   volatile.Register32 // 0x120
	PTSR   volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR_LINABT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR_LINABT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR_LINWKUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetCR_LINWKUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receive Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmit Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0x1ffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0x1ffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Configuration Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.LINMR: LIN Mode Register
func (o *USART_Type) SetLINMR_NACT(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x3)|value)
}
func (o *USART_Type) GetLINMR_NACT() uint32 {
	return volatile.LoadUint32(&o.LINMR.Reg) & 0x3
}
func (o *USART_Type) SetLINMR_PARDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetLINMR_PARDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetLINMR_CHKDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetLINMR_CHKDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetLINMR_CHKTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetLINMR_CHKTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetLINMR_DLM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetLINMR_DLM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetLINMR_FSDIS(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetLINMR_FSDIS() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetLINMR_WKUPTYP(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetLINMR_WKUPTYP() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetLINMR_DLC(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetLINMR_DLC() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetLINMR_PDCM(value uint32) {
	volatile.StoreUint32(&o.LINMR.Reg, volatile.LoadUint32(&o.LINMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetLINMR_PDCM() uint32 {
	return (volatile.LoadUint32(&o.LINMR.Reg) & 0x10000) >> 16
}

// USART.LINIR: LIN Identifier Register
func (o *USART_Type) SetLINIR_IDCHR(value uint32) {
	volatile.StoreUint32(&o.LINIR.Reg, volatile.LoadUint32(&o.LINIR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetLINIR_IDCHR() uint32 {
	return volatile.LoadUint32(&o.LINIR.Reg) & 0xff
}

// USART.LINBRR: LIN Baud Rate Register
func (o *USART_Type) SetLINBRR_LINCD(value uint32) {
	volatile.StoreUint32(&o.LINBRR.Reg, volatile.LoadUint32(&o.LINBRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetLINBRR_LINCD() uint32 {
	return volatile.LoadUint32(&o.LINBRR.Reg) & 0xffff
}
func (o *USART_Type) SetLINBRR_LINFP(value uint32) {
	volatile.StoreUint32(&o.LINBRR.Reg, volatile.LoadUint32(&o.LINBRR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetLINBRR_LINFP() uint32 {
	return (volatile.LoadUint32(&o.LINBRR.Reg) & 0x70000) >> 16
}

// USART.WPMR: Write Protection Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protection Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// USB On-The-Go Interface
type UOTGHS_Type struct {
	DEVCTRL        volatile.Register32 // 0x0
	DEVISR         volatile.Register32 // 0x4
	DEVICR         volatile.Register32 // 0x8
	DEVIFR         volatile.Register32 // 0xC
	DEVIMR         volatile.Register32 // 0x10
	DEVIDR         volatile.Register32 // 0x14
	DEVIER         volatile.Register32 // 0x18
	DEVEPT         volatile.Register32 // 0x1C
	DEVFNUM        volatile.Register32 // 0x20
	_              [220]byte
	DEVEPTCFG      [10]volatile.Register32 // 0x100
	_              [8]byte
	DEVEPTISR      [10]volatile.Register32 // 0x130
	_              [8]byte
	DEVEPTICR      [10]volatile.Register32 // 0x160
	_              [8]byte
	DEVEPTIFR      [10]volatile.Register32 // 0x190
	_              [8]byte
	DEVEPTIMR      [10]volatile.Register32 // 0x1C0
	_              [8]byte
	DEVEPTIER      [10]volatile.Register32 // 0x1F0
	_              [8]byte
	DEVEPTIDR      [10]volatile.Register32 // 0x220
	_              [200]byte
	DEVDMANXTDSC1  volatile.Register32 // 0x310
	DEVDMAADDRESS1 volatile.Register32 // 0x314
	DEVDMACONTROL1 volatile.Register32 // 0x318
	DEVDMASTATUS1  volatile.Register32 // 0x31C
	DEVDMANXTDSC2  volatile.Register32 // 0x320
	DEVDMAADDRESS2 volatile.Register32 // 0x324
	DEVDMACONTROL2 volatile.Register32 // 0x328
	DEVDMASTATUS2  volatile.Register32 // 0x32C
	DEVDMANXTDSC3  volatile.Register32 // 0x330
	DEVDMAADDRESS3 volatile.Register32 // 0x334
	DEVDMACONTROL3 volatile.Register32 // 0x338
	DEVDMASTATUS3  volatile.Register32 // 0x33C
	DEVDMANXTDSC4  volatile.Register32 // 0x340
	DEVDMAADDRESS4 volatile.Register32 // 0x344
	DEVDMACONTROL4 volatile.Register32 // 0x348
	DEVDMASTATUS4  volatile.Register32 // 0x34C
	DEVDMANXTDSC5  volatile.Register32 // 0x350
	DEVDMAADDRESS5 volatile.Register32 // 0x354
	DEVDMACONTROL5 volatile.Register32 // 0x358
	DEVDMASTATUS5  volatile.Register32 // 0x35C
	DEVDMANXTDSC6  volatile.Register32 // 0x360
	DEVDMAADDRESS6 volatile.Register32 // 0x364
	DEVDMACONTROL6 volatile.Register32 // 0x368
	DEVDMASTATUS6  volatile.Register32 // 0x36C
	DEVDMANXTDSC7  volatile.Register32 // 0x370
	DEVDMAADDRESS7 volatile.Register32 // 0x374
	DEVDMACONTROL7 volatile.Register32 // 0x378
	DEVDMASTATUS7  volatile.Register32 // 0x37C
	_              [128]byte
	HSTCTRL        volatile.Register32 // 0x400
	HSTISR         volatile.Register32 // 0x404
	HSTICR         volatile.Register32 // 0x408
	HSTIFR         volatile.Register32 // 0x40C
	HSTIMR         volatile.Register32 // 0x410
	HSTIDR         volatile.Register32 // 0x414
	HSTIER         volatile.Register32 // 0x418
	HSTPIP         volatile.Register32 // 0x41C
	HSTFNUM        volatile.Register32 // 0x420
	HSTADDR1       volatile.Register32 // 0x424
	HSTADDR2       volatile.Register32 // 0x428
	HSTADDR3       volatile.Register32 // 0x42C
	_              [208]byte
	HSTPIPCFG      [10]volatile.Register32 // 0x500
	_              [8]byte
	HSTPIPISR      [10]volatile.Register32 // 0x530
	_              [8]byte
	HSTPIPICR      [10]volatile.Register32 // 0x560
	_              [8]byte
	HSTPIPIFR      [10]volatile.Register32 // 0x590
	_              [8]byte
	HSTPIPIMR      [10]volatile.Register32 // 0x5C0
	_              [8]byte
	HSTPIPIER      [10]volatile.Register32 // 0x5F0
	_              [8]byte
	HSTPIPIDR      [10]volatile.Register32 // 0x620
	_              [8]byte
	HSTPIPINRQ     [10]volatile.Register32 // 0x650
	_              [8]byte
	HSTPIPERR      [10]volatile.Register32 // 0x680
	_              [104]byte
	HSTDMANXTDSC1  volatile.Register32 // 0x710
	HSTDMAADDRESS1 volatile.Register32 // 0x714
	HSTDMACONTROL1 volatile.Register32 // 0x718
	HSTDMASTATUS1  volatile.Register32 // 0x71C
	HSTDMANXTDSC2  volatile.Register32 // 0x720
	HSTDMAADDRESS2 volatile.Register32 // 0x724
	HSTDMACONTROL2 volatile.Register32 // 0x728
	HSTDMASTATUS2  volatile.Register32 // 0x72C
	HSTDMANXTDSC3  volatile.Register32 // 0x730
	HSTDMAADDRESS3 volatile.Register32 // 0x734
	HSTDMACONTROL3 volatile.Register32 // 0x738
	HSTDMASTATUS3  volatile.Register32 // 0x73C
	HSTDMANXTDSC4  volatile.Register32 // 0x740
	HSTDMAADDRESS4 volatile.Register32 // 0x744
	HSTDMACONTROL4 volatile.Register32 // 0x748
	HSTDMASTATUS4  volatile.Register32 // 0x74C
	HSTDMANXTDSC5  volatile.Register32 // 0x750
	HSTDMAADDRESS5 volatile.Register32 // 0x754
	HSTDMACONTROL5 volatile.Register32 // 0x758
	HSTDMASTATUS5  volatile.Register32 // 0x75C
	HSTDMANXTDSC6  volatile.Register32 // 0x760
	HSTDMAADDRESS6 volatile.Register32 // 0x764
	HSTDMACONTROL6 volatile.Register32 // 0x768
	HSTDMASTATUS6  volatile.Register32 // 0x76C
	HSTDMANXTDSC7  volatile.Register32 // 0x770
	HSTDMAADDRESS7 volatile.Register32 // 0x774
	HSTDMACONTROL7 volatile.Register32 // 0x778
	HSTDMASTATUS7  volatile.Register32 // 0x77C
	_              [128]byte
	CTRL           volatile.Register32 // 0x800
	SR             volatile.Register32 // 0x804
	SCR            volatile.Register32 // 0x808
	SFR            volatile.Register32 // 0x80C
	_              [28]byte
	FSM            volatile.Register32 // 0x82C
}

// UOTGHS.DEVCTRL: Device General Control Register
func (o *UOTGHS_Type) SetDEVCTRL_UADD(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x7f)|value)
}
func (o *UOTGHS_Type) GetDEVCTRL_UADD() uint32 {
	return volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x7f
}
func (o *UOTGHS_Type) SetDEVCTRL_ADDEN(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVCTRL_ADDEN() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetDEVCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetDEVCTRL_RMWKUP(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetDEVCTRL_RMWKUP() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetDEVCTRL_SPDCONF(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0xc00)|value<<10)
}
func (o *UOTGHS_Type) GetDEVCTRL_SPDCONF() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0xc00) >> 10
}
func (o *UOTGHS_Type) SetDEVCTRL_LS(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVCTRL_LS() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVCTRL_TSTJ(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVCTRL_TSTJ() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVCTRL_TSTK(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVCTRL_TSTK() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVCTRL_TSTPCKT(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVCTRL_TSTPCKT() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetDEVCTRL_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVCTRL_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x10000) >> 16
}

// UOTGHS.DEVISR: Device Global Interrupt Status Register
func (o *UOTGHS_Type) SetDEVISR_SUSP(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVISR_SUSP() uint32 {
	return volatile.LoadUint32(&o.DEVISR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVISR_MSOF(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVISR_MSOF() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVISR_SOF(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVISR_SOF() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVISR_EORST(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVISR_EORST() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVISR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVISR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVISR_EORSM(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVISR_EORSM() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVISR_UPRSM(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVISR_UPRSM() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVISR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVISR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVISR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVISR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetDEVISR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVISR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVISR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVISR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetDEVISR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetDEVISR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetDEVISR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetDEVISR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetDEVISR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetDEVISR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetDEVISR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetDEVISR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetDEVISR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetDEVISR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40000000) >> 30
}

// UOTGHS.DEVICR: Device Global Interrupt Clear Register
func (o *UOTGHS_Type) SetDEVICR_SUSPC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVICR_SUSPC() uint32 {
	return volatile.LoadUint32(&o.DEVICR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVICR_MSOFC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVICR_MSOFC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVICR_SOFC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVICR_SOFC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVICR_EORSTC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVICR_EORSTC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVICR_WAKEUPC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVICR_WAKEUPC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVICR_EORSMC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVICR_EORSMC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVICR_UPRSMC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVICR_UPRSMC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x40) >> 6
}

// UOTGHS.DEVIFR: Device Global Interrupt Set Register
func (o *UOTGHS_Type) SetDEVIFR_SUSPS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVIFR_SUSPS() uint32 {
	return volatile.LoadUint32(&o.DEVIFR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVIFR_MSOFS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVIFR_MSOFS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVIFR_SOFS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVIFR_SOFS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVIFR_EORSTS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVIFR_EORSTS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVIFR_WAKEUPS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVIFR_WAKEUPS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVIFR_EORSMS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVIFR_EORSMS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVIFR_UPRSMS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVIFR_UPRSMS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetDEVIFR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetDEVIFR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x40000000) >> 30
}

// UOTGHS.DEVIMR: Device Global Interrupt Mask Register
func (o *UOTGHS_Type) SetDEVIMR_SUSPE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVIMR_SUSPE() uint32 {
	return volatile.LoadUint32(&o.DEVIMR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVIMR_MSOFE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVIMR_MSOFE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVIMR_SOFE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVIMR_SOFE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVIMR_EORSTE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVIMR_EORSTE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVIMR_WAKEUPE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVIMR_WAKEUPE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVIMR_EORSME(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVIMR_EORSME() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVIMR_UPRSME(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVIMR_UPRSME() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetDEVIMR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetDEVIMR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetDEVIMR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetDEVIMR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40000000) >> 30
}

// UOTGHS.DEVIDR: Device Global Interrupt Disable Register
func (o *UOTGHS_Type) SetDEVIDR_SUSPEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVIDR_SUSPEC() uint32 {
	return volatile.LoadUint32(&o.DEVIDR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVIDR_MSOFEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVIDR_MSOFEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVIDR_SOFEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVIDR_SOFEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVIDR_EORSTEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVIDR_EORSTEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVIDR_WAKEUPEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVIDR_WAKEUPEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVIDR_EORSMEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVIDR_EORSMEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVIDR_UPRSMEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVIDR_UPRSMEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetDEVIDR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetDEVIDR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetDEVIDR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetDEVIDR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40000000) >> 30
}

// UOTGHS.DEVIER: Device Global Interrupt Enable Register
func (o *UOTGHS_Type) SetDEVIER_SUSPES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVIER_SUSPES() uint32 {
	return volatile.LoadUint32(&o.DEVIER.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVIER_MSOFES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVIER_MSOFES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVIER_SOFES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVIER_SOFES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVIER_EORSTES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVIER_EORSTES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVIER_WAKEUPES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVIER_WAKEUPES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVIER_EORSMES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVIER_EORSMES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVIER_UPRSMES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVIER_UPRSMES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVIER_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVIER_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVIER_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVIER_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetDEVIER_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVIER_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVIER_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVIER_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetDEVIER_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetDEVIER_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetDEVIER_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetDEVIER_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetDEVIER_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetDEVIER_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetDEVIER_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetDEVIER_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetDEVIER_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetDEVIER_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40000000) >> 30
}

// UOTGHS.DEVEPT: Device Endpoint Register
func (o *UOTGHS_Type) SetDEVEPT_EPEN0(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN0() uint32 {
	return volatile.LoadUint32(&o.DEVEPT.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN1(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN1() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN2(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN2() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN3(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN3() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN4(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN4() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN5(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN5() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN6(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN6() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN7(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN7() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPT_EPEN8(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetDEVEPT_EPEN8() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST0(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST0() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST1(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST1() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST2(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST2() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST3(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST3() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST4(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST4() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST5(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST5() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST6(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x400000)|value<<22)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST6() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x400000) >> 22
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST7(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x800000)|value<<23)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST7() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x800000) >> 23
}
func (o *UOTGHS_Type) SetDEVEPT_EPRST8(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x1000000)|value<<24)
}
func (o *UOTGHS_Type) GetDEVEPT_EPRST8() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x1000000) >> 24
}

// UOTGHS.DEVFNUM: Device Frame Number Register
func (o *UOTGHS_Type) SetDEVFNUM_MFNUM(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x7)|value)
}
func (o *UOTGHS_Type) GetDEVFNUM_MFNUM() uint32 {
	return volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x7
}
func (o *UOTGHS_Type) SetDEVFNUM_FNUM(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVFNUM_FNUM() uint32 {
	return (volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x3ff8) >> 3
}
func (o *UOTGHS_Type) SetDEVFNUM_FNCERR(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetDEVFNUM_FNCERR() uint32 {
	return (volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x8000) >> 15
}

// UOTGHS.DEVEPTCFG: Device Endpoint Configuration Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTCFG_ALLOC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_ALLOC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTCFG_EPBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0xc)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_EPBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0xc) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTCFG_EPSIZE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x70)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_EPSIZE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x70) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTCFG_EPDIR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_EPDIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetDEVEPTCFG_AUTOSW(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_AUTOSW(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetDEVEPTCFG_EPTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x1800)|value<<11)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_EPTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x1800) >> 11
}
func (o *UOTGHS_Type) SetDEVEPTCFG_NBTRANS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x6000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVEPTCFG_NBTRANS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x6000) >> 13
}

// UOTGHS.DEVEPTISR: Device Endpoint Status Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTISR_TXINI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTISR_TXINI(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTISR_RXOUTI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTISR_RXOUTI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTISR_RXSTPI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTISR_RXSTPI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTISR_NAKOUTI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTISR_NAKOUTI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTISR_NAKINI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTISR_NAKINI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTISR_OVERFI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTISR_OVERFI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTISR_STALLEDI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTISR_STALLEDI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTISR_SHORTPACKET(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTISR_SHORTPACKET(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPTISR_DTSEQ(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x300)|value<<8)
}
func (o *UOTGHS_Type) GetDEVEPTISR_DTSEQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x300) >> 8
}
func (o *UOTGHS_Type) SetDEVEPTISR_NBUSYBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x3000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVEPTISR_NBUSYBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x3000) >> 12
}
func (o *UOTGHS_Type) SetDEVEPTISR_CURRBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0xc000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVEPTISR_CURRBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0xc000) >> 14
}
func (o *UOTGHS_Type) SetDEVEPTISR_RWALL(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVEPTISR_RWALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVEPTISR_CTRLDIR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVEPTISR_CTRLDIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVEPTISR_CFGOK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVEPTISR_CFGOK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVEPTISR_BYCT(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x7ff00000)|value<<20)
}
func (o *UOTGHS_Type) GetDEVEPTISR_BYCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x7ff00000) >> 20
}

// UOTGHS.DEVEPTICR: Device Endpoint Clear Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTICR_TXINIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTICR_TXINIC(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTICR_RXOUTIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTICR_RXOUTIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTICR_RXSTPIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTICR_RXSTPIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTICR_NAKOUTIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTICR_NAKOUTIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTICR_NAKINIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTICR_NAKINIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTICR_OVERFIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTICR_OVERFIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTICR_STALLEDIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTICR_STALLEDIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTICR_SHORTPACKETC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTICR_SHORTPACKETC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x80) >> 7
}

// UOTGHS.DEVEPTIFR: Device Endpoint Set Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTIFR_TXINIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_TXINIS(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTIFR_RXOUTIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_RXOUTIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTIFR_RXSTPIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_RXSTPIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTIFR_NAKOUTIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_NAKOUTIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTIFR_NAKINIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_NAKINIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTIFR_OVERFIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_OVERFIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTIFR_STALLEDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_STALLEDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTIFR_SHORTPACKETS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_SHORTPACKETS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPTIFR_NBUSYBKS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVEPTIFR_NBUSYBKS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x1000) >> 12
}

// UOTGHS.DEVEPTIMR: Device Endpoint Mask Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTIMR_TXINE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_TXINE(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTIMR_RXOUTE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_RXOUTE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTIMR_RXSTPE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_RXSTPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTIMR_NAKOUTE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_NAKOUTE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTIMR_NAKINE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_NAKINE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTIMR_OVERFE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_OVERFE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTIMR_STALLEDE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_STALLEDE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTIMR_SHORTPACKETE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_SHORTPACKETE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPTIMR_NBUSYBKE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_NBUSYBKE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVEPTIMR_KILLBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_KILLBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVEPTIMR_FIFOCON(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_FIFOCON(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVEPTIMR_EPDISHDMA(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_EPDISHDMA(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVEPTIMR_NYETDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_NYETDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVEPTIMR_RSTDT(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_RSTDT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVEPTIMR_STALLRQ(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVEPTIMR_STALLRQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x80000) >> 19
}

// UOTGHS.DEVEPTIER: Device Endpoint Enable Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTIER_TXINES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTIER_TXINES(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTIER_RXOUTES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTIER_RXOUTES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTIER_RXSTPES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTIER_RXSTPES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTIER_NAKOUTES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTIER_NAKOUTES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTIER_NAKINES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTIER_NAKINES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTIER_OVERFES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTIER_OVERFES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTIER_STALLEDES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTIER_STALLEDES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTIER_SHORTPACKETES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTIER_SHORTPACKETES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPTIER_NBUSYBKES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVEPTIER_NBUSYBKES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVEPTIER_KILLBKS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetDEVEPTIER_KILLBKS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetDEVEPTIER_FIFOCONS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVEPTIER_FIFOCONS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVEPTIER_EPDISHDMAS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVEPTIER_EPDISHDMAS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVEPTIER_NYETDISS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVEPTIER_NYETDISS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVEPTIER_RSTDTS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetDEVEPTIER_RSTDTS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetDEVEPTIER_STALLRQS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVEPTIER_STALLRQS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x80000) >> 19
}

// UOTGHS.DEVEPTIDR: Device Endpoint Disable Register (n = 0)
func (o *UOTGHS_Type) SetDEVEPTIDR_TXINEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_TXINEC(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVEPTIDR_RXOUTEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_RXOUTEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVEPTIDR_RXSTPEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_RXSTPEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVEPTIDR_NAKOUTEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_NAKOUTEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVEPTIDR_NAKINEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_NAKINEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVEPTIDR_OVERFEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_OVERFEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVEPTIDR_STALLEDEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_STALLEDEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVEPTIDR_SHORTPACKETEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_SHORTPACKETEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVEPTIDR_NBUSYBKEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_NBUSYBKEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetDEVEPTIDR_FIFOCONC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_FIFOCONC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetDEVEPTIDR_EPDISHDMAC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_EPDISHDMAC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetDEVEPTIDR_NYETDISC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_NYETDISC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetDEVEPTIDR_STALLRQC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetDEVEPTIDR_STALLRQC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x80000) >> 19
}

// UOTGHS.DEVDMANXTDSC1: Device DMA Channel Next Descriptor Address Register (n = 1)
func (o *UOTGHS_Type) SetDEVDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC1.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC1.Reg)
}

// UOTGHS.DEVDMAADDRESS1: Device DMA Channel Address Register (n = 1)
func (o *UOTGHS_Type) SetDEVDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS1.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS1.Reg)
}

// UOTGHS.DEVDMACONTROL1: Device DMA Channel Control Register (n = 1)
func (o *UOTGHS_Type) SetDEVDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL1.Reg, volatile.LoadUint32(&o.DEVDMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS1: Device DMA Channel Status Register (n = 1)
func (o *UOTGHS_Type) SetDEVDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS1.Reg, volatile.LoadUint32(&o.DEVDMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC2: Device DMA Channel Next Descriptor Address Register (n = 2)
func (o *UOTGHS_Type) SetDEVDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC2.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC2.Reg)
}

// UOTGHS.DEVDMAADDRESS2: Device DMA Channel Address Register (n = 2)
func (o *UOTGHS_Type) SetDEVDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS2.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS2.Reg)
}

// UOTGHS.DEVDMACONTROL2: Device DMA Channel Control Register (n = 2)
func (o *UOTGHS_Type) SetDEVDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL2.Reg, volatile.LoadUint32(&o.DEVDMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS2: Device DMA Channel Status Register (n = 2)
func (o *UOTGHS_Type) SetDEVDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS2.Reg, volatile.LoadUint32(&o.DEVDMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC3: Device DMA Channel Next Descriptor Address Register (n = 3)
func (o *UOTGHS_Type) SetDEVDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC3.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC3.Reg)
}

// UOTGHS.DEVDMAADDRESS3: Device DMA Channel Address Register (n = 3)
func (o *UOTGHS_Type) SetDEVDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS3.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS3.Reg)
}

// UOTGHS.DEVDMACONTROL3: Device DMA Channel Control Register (n = 3)
func (o *UOTGHS_Type) SetDEVDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL3.Reg, volatile.LoadUint32(&o.DEVDMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS3: Device DMA Channel Status Register (n = 3)
func (o *UOTGHS_Type) SetDEVDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS3.Reg, volatile.LoadUint32(&o.DEVDMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC4: Device DMA Channel Next Descriptor Address Register (n = 4)
func (o *UOTGHS_Type) SetDEVDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC4.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC4.Reg)
}

// UOTGHS.DEVDMAADDRESS4: Device DMA Channel Address Register (n = 4)
func (o *UOTGHS_Type) SetDEVDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS4.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS4.Reg)
}

// UOTGHS.DEVDMACONTROL4: Device DMA Channel Control Register (n = 4)
func (o *UOTGHS_Type) SetDEVDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL4.Reg, volatile.LoadUint32(&o.DEVDMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS4: Device DMA Channel Status Register (n = 4)
func (o *UOTGHS_Type) SetDEVDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS4_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS4.Reg, volatile.LoadUint32(&o.DEVDMASTATUS4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS4_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS4.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC5: Device DMA Channel Next Descriptor Address Register (n = 5)
func (o *UOTGHS_Type) SetDEVDMANXTDSC5(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC5.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC5() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC5.Reg)
}

// UOTGHS.DEVDMAADDRESS5: Device DMA Channel Address Register (n = 5)
func (o *UOTGHS_Type) SetDEVDMAADDRESS5(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS5.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS5() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS5.Reg)
}

// UOTGHS.DEVDMACONTROL5: Device DMA Channel Control Register (n = 5)
func (o *UOTGHS_Type) SetDEVDMACONTROL5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL5_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL5.Reg, volatile.LoadUint32(&o.DEVDMACONTROL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL5_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL5.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS5: Device DMA Channel Status Register (n = 5)
func (o *UOTGHS_Type) SetDEVDMASTATUS5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS5_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS5_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS5_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS5_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS5_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS5.Reg, volatile.LoadUint32(&o.DEVDMASTATUS5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS5_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS5.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC6: Device DMA Channel Next Descriptor Address Register (n = 6)
func (o *UOTGHS_Type) SetDEVDMANXTDSC6(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC6.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC6() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC6.Reg)
}

// UOTGHS.DEVDMAADDRESS6: Device DMA Channel Address Register (n = 6)
func (o *UOTGHS_Type) SetDEVDMAADDRESS6(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS6.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS6() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS6.Reg)
}

// UOTGHS.DEVDMACONTROL6: Device DMA Channel Control Register (n = 6)
func (o *UOTGHS_Type) SetDEVDMACONTROL6_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL6_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL6.Reg, volatile.LoadUint32(&o.DEVDMACONTROL6.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL6_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL6.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS6: Device DMA Channel Status Register (n = 6)
func (o *UOTGHS_Type) SetDEVDMASTATUS6_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS6_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS6_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS6_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS6_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS6_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS6.Reg, volatile.LoadUint32(&o.DEVDMASTATUS6.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS6_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS6.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMANXTDSC7: Device DMA Channel Next Descriptor Address Register (n = 7)
func (o *UOTGHS_Type) SetDEVDMANXTDSC7(value uint32) {
	volatile.StoreUint32(&o.DEVDMANXTDSC7.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMANXTDSC7() uint32 {
	return volatile.LoadUint32(&o.DEVDMANXTDSC7.Reg)
}

// UOTGHS.DEVDMAADDRESS7: Device DMA Channel Address Register (n = 7)
func (o *UOTGHS_Type) SetDEVDMAADDRESS7(value uint32) {
	volatile.StoreUint32(&o.DEVDMAADDRESS7.Reg, value)
}
func (o *UOTGHS_Type) GetDEVDMAADDRESS7() uint32 {
	return volatile.LoadUint32(&o.DEVDMAADDRESS7.Reg)
}

// UOTGHS.DEVDMACONTROL7: Device DMA Channel Control Register (n = 7)
func (o *UOTGHS_Type) SetDEVDMACONTROL7_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetDEVDMACONTROL7_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DEVDMACONTROL7.Reg, volatile.LoadUint32(&o.DEVDMACONTROL7.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMACONTROL7_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DEVDMACONTROL7.Reg) & 0xffff0000) >> 16
}

// UOTGHS.DEVDMASTATUS7: Device DMA Channel Status Register (n = 7)
func (o *UOTGHS_Type) SetDEVDMASTATUS7_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0x1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS7_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetDEVDMASTATUS7_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetDEVDMASTATUS7_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetDEVDMASTATUS7_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetDEVDMASTATUS7_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DEVDMASTATUS7.Reg, volatile.LoadUint32(&o.DEVDMASTATUS7.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetDEVDMASTATUS7_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DEVDMASTATUS7.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTCTRL: Host General Control Register
func (o *UOTGHS_Type) SetHSTCTRL_SOFE(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTCTRL_SOFE() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTCTRL_RESET(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetHSTCTRL_RESET() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetHSTCTRL_RESUME(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTCTRL_RESUME() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTCTRL_SPDCONF(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x3000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTCTRL_SPDCONF() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x3000) >> 12
}

// UOTGHS.HSTISR: Host Global Interrupt Status Register
func (o *UOTGHS_Type) SetHSTISR_DCONNI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTISR_DCONNI() uint32 {
	return volatile.LoadUint32(&o.HSTISR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTISR_DDISCI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTISR_DDISCI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTISR_RSTI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTISR_RSTI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTISR_RSMEDI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTISR_RSMEDI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTISR_RXRSMI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTISR_RXRSMI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTISR_HSOFI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTISR_HSOFI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTISR_HWUPI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTISR_HWUPI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTISR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTISR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetHSTISR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTISR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetHSTISR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTISR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetHSTISR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTISR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetHSTISR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTISR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTISR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTISR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetHSTISR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetHSTISR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetHSTISR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetHSTISR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetHSTISR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetHSTISR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x40000000) >> 30
}

// UOTGHS.HSTICR: Host Global Interrupt Clear Register
func (o *UOTGHS_Type) SetHSTICR_DCONNIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTICR_DCONNIC() uint32 {
	return volatile.LoadUint32(&o.HSTICR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTICR_DDISCIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTICR_DDISCIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTICR_RSTIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTICR_RSTIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTICR_RSMEDIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTICR_RSMEDIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTICR_RXRSMIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTICR_RXRSMIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTICR_HSOFIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTICR_HSOFIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTICR_HWUPIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTICR_HWUPIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x40) >> 6
}

// UOTGHS.HSTIFR: Host Global Interrupt Set Register
func (o *UOTGHS_Type) SetHSTIFR_DCONNIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTIFR_DCONNIS() uint32 {
	return volatile.LoadUint32(&o.HSTIFR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTIFR_DDISCIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTIFR_DDISCIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTIFR_RSTIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTIFR_RSTIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTIFR_RSMEDIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTIFR_RSMEDIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTIFR_RXRSMIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTIFR_RXRSMIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTIFR_HSOFIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTIFR_HSOFIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTIFR_HWUPIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTIFR_HWUPIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetHSTIFR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetHSTIFR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x40000000) >> 30
}

// UOTGHS.HSTIMR: Host Global Interrupt Mask Register
func (o *UOTGHS_Type) SetHSTIMR_DCONNIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTIMR_DCONNIE() uint32 {
	return volatile.LoadUint32(&o.HSTIMR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTIMR_DDISCIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTIMR_DDISCIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTIMR_RSTIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTIMR_RSTIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTIMR_RSMEDIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTIMR_RSMEDIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTIMR_RXRSMIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTIMR_RXRSMIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTIMR_HSOFIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTIMR_HSOFIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTIMR_HWUPIE(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTIMR_HWUPIE() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTIMR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTIMR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetHSTIMR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTIMR.Reg, volatile.LoadUint32(&o.HSTIMR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetHSTIMR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIMR.Reg) & 0x40000000) >> 30
}

// UOTGHS.HSTIDR: Host Global Interrupt Disable Register
func (o *UOTGHS_Type) SetHSTIDR_DCONNIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTIDR_DCONNIEC() uint32 {
	return volatile.LoadUint32(&o.HSTIDR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTIDR_DDISCIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTIDR_DDISCIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTIDR_RSTIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTIDR_RSTIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTIDR_RSMEDIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTIDR_RSMEDIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTIDR_RXRSMIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTIDR_RXRSMIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTIDR_HSOFIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTIDR_HSOFIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTIDR_HWUPIEC(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTIDR_HWUPIEC() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTIDR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTIDR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetHSTIDR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTIDR.Reg, volatile.LoadUint32(&o.HSTIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetHSTIDR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIDR.Reg) & 0x40000000) >> 30
}

// UOTGHS.HSTIER: Host Global Interrupt Enable Register
func (o *UOTGHS_Type) SetHSTIER_DCONNIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTIER_DCONNIES() uint32 {
	return volatile.LoadUint32(&o.HSTIER.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTIER_DDISCIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTIER_DDISCIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTIER_RSTIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTIER_RSTIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTIER_RSMEDIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTIER_RSMEDIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTIER_RXRSMIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTIER_RXRSMIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTIER_HSOFIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTIER_HSOFIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTIER_HWUPIES(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTIER_HWUPIES() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTIER_PEP_0(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTIER_PEP_1(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetHSTIER_PEP_2(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTIER_PEP_3(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetHSTIER_PEP_4(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTIER_PEP_5(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetHSTIER_PEP_6(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTIER_PEP_7(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetHSTIER_PEP_8(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTIER_PEP_9(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTIER_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTIER_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x2000000) >> 25
}
func (o *UOTGHS_Type) SetHSTIER_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x4000000)|value<<26)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x4000000) >> 26
}
func (o *UOTGHS_Type) SetHSTIER_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x8000000)|value<<27)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x8000000) >> 27
}
func (o *UOTGHS_Type) SetHSTIER_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x10000000)|value<<28)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x10000000) >> 28
}
func (o *UOTGHS_Type) SetHSTIER_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x20000000)|value<<29)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x20000000) >> 29
}
func (o *UOTGHS_Type) SetHSTIER_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTIER.Reg, volatile.LoadUint32(&o.HSTIER.Reg)&^(0x40000000)|value<<30)
}
func (o *UOTGHS_Type) GetHSTIER_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTIER.Reg) & 0x40000000) >> 30
}

// UOTGHS.HSTPIP: Host Pipe Register
func (o *UOTGHS_Type) SetHSTPIP_PEN0(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN0() uint32 {
	return volatile.LoadUint32(&o.HSTPIP.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIP_PEN1(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN1() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIP_PEN2(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN2() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIP_PEN3(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN3() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIP_PEN4(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN4() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIP_PEN5(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN5() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIP_PEN6(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN6() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIP_PEN7(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN7() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIP_PEN8(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTPIP_PEN8() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetHSTPIP_PRST0(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST0() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIP_PRST1(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST1() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTPIP_PRST2(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST2() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetHSTPIP_PRST3(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x80000)|value<<19)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST3() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x80000) >> 19
}
func (o *UOTGHS_Type) SetHSTPIP_PRST4(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x100000)|value<<20)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST4() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x100000) >> 20
}
func (o *UOTGHS_Type) SetHSTPIP_PRST5(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x200000)|value<<21)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST5() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x200000) >> 21
}
func (o *UOTGHS_Type) SetHSTPIP_PRST6(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x400000)|value<<22)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST6() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x400000) >> 22
}
func (o *UOTGHS_Type) SetHSTPIP_PRST7(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x800000)|value<<23)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST7() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x800000) >> 23
}
func (o *UOTGHS_Type) SetHSTPIP_PRST8(value uint32) {
	volatile.StoreUint32(&o.HSTPIP.Reg, volatile.LoadUint32(&o.HSTPIP.Reg)&^(0x1000000)|value<<24)
}
func (o *UOTGHS_Type) GetHSTPIP_PRST8() uint32 {
	return (volatile.LoadUint32(&o.HSTPIP.Reg) & 0x1000000) >> 24
}

// UOTGHS.HSTFNUM: Host Frame Number Register
func (o *UOTGHS_Type) SetHSTFNUM_MFNUM(value uint32) {
	volatile.StoreUint32(&o.HSTFNUM.Reg, volatile.LoadUint32(&o.HSTFNUM.Reg)&^(0x7)|value)
}
func (o *UOTGHS_Type) GetHSTFNUM_MFNUM() uint32 {
	return volatile.LoadUint32(&o.HSTFNUM.Reg) & 0x7
}
func (o *UOTGHS_Type) SetHSTFNUM_FNUM(value uint32) {
	volatile.StoreUint32(&o.HSTFNUM.Reg, volatile.LoadUint32(&o.HSTFNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTFNUM_FNUM() uint32 {
	return (volatile.LoadUint32(&o.HSTFNUM.Reg) & 0x3ff8) >> 3
}
func (o *UOTGHS_Type) SetHSTFNUM_FLENHIGH(value uint32) {
	volatile.StoreUint32(&o.HSTFNUM.Reg, volatile.LoadUint32(&o.HSTFNUM.Reg)&^(0xff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTFNUM_FLENHIGH() uint32 {
	return (volatile.LoadUint32(&o.HSTFNUM.Reg) & 0xff0000) >> 16
}

// UOTGHS.HSTADDR1: Host Address 1 Register
func (o *UOTGHS_Type) SetHSTADDR1_HSTADDRP0(value uint32) {
	volatile.StoreUint32(&o.HSTADDR1.Reg, volatile.LoadUint32(&o.HSTADDR1.Reg)&^(0x7f)|value)
}
func (o *UOTGHS_Type) GetHSTADDR1_HSTADDRP0() uint32 {
	return volatile.LoadUint32(&o.HSTADDR1.Reg) & 0x7f
}
func (o *UOTGHS_Type) SetHSTADDR1_HSTADDRP1(value uint32) {
	volatile.StoreUint32(&o.HSTADDR1.Reg, volatile.LoadUint32(&o.HSTADDR1.Reg)&^(0x7f00)|value<<8)
}
func (o *UOTGHS_Type) GetHSTADDR1_HSTADDRP1() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR1.Reg) & 0x7f00) >> 8
}
func (o *UOTGHS_Type) SetHSTADDR1_HSTADDRP2(value uint32) {
	volatile.StoreUint32(&o.HSTADDR1.Reg, volatile.LoadUint32(&o.HSTADDR1.Reg)&^(0x7f0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTADDR1_HSTADDRP2() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR1.Reg) & 0x7f0000) >> 16
}
func (o *UOTGHS_Type) SetHSTADDR1_HSTADDRP3(value uint32) {
	volatile.StoreUint32(&o.HSTADDR1.Reg, volatile.LoadUint32(&o.HSTADDR1.Reg)&^(0x7f000000)|value<<24)
}
func (o *UOTGHS_Type) GetHSTADDR1_HSTADDRP3() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR1.Reg) & 0x7f000000) >> 24
}

// UOTGHS.HSTADDR2: Host Address 2 Register
func (o *UOTGHS_Type) SetHSTADDR2_HSTADDRP4(value uint32) {
	volatile.StoreUint32(&o.HSTADDR2.Reg, volatile.LoadUint32(&o.HSTADDR2.Reg)&^(0x7f)|value)
}
func (o *UOTGHS_Type) GetHSTADDR2_HSTADDRP4() uint32 {
	return volatile.LoadUint32(&o.HSTADDR2.Reg) & 0x7f
}
func (o *UOTGHS_Type) SetHSTADDR2_HSTADDRP5(value uint32) {
	volatile.StoreUint32(&o.HSTADDR2.Reg, volatile.LoadUint32(&o.HSTADDR2.Reg)&^(0x7f00)|value<<8)
}
func (o *UOTGHS_Type) GetHSTADDR2_HSTADDRP5() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR2.Reg) & 0x7f00) >> 8
}
func (o *UOTGHS_Type) SetHSTADDR2_HSTADDRP6(value uint32) {
	volatile.StoreUint32(&o.HSTADDR2.Reg, volatile.LoadUint32(&o.HSTADDR2.Reg)&^(0x7f0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTADDR2_HSTADDRP6() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR2.Reg) & 0x7f0000) >> 16
}
func (o *UOTGHS_Type) SetHSTADDR2_HSTADDRP7(value uint32) {
	volatile.StoreUint32(&o.HSTADDR2.Reg, volatile.LoadUint32(&o.HSTADDR2.Reg)&^(0x7f000000)|value<<24)
}
func (o *UOTGHS_Type) GetHSTADDR2_HSTADDRP7() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR2.Reg) & 0x7f000000) >> 24
}

// UOTGHS.HSTADDR3: Host Address 3 Register
func (o *UOTGHS_Type) SetHSTADDR3_HSTADDRP8(value uint32) {
	volatile.StoreUint32(&o.HSTADDR3.Reg, volatile.LoadUint32(&o.HSTADDR3.Reg)&^(0x7f)|value)
}
func (o *UOTGHS_Type) GetHSTADDR3_HSTADDRP8() uint32 {
	return volatile.LoadUint32(&o.HSTADDR3.Reg) & 0x7f
}
func (o *UOTGHS_Type) SetHSTADDR3_HSTADDRP9(value uint32) {
	volatile.StoreUint32(&o.HSTADDR3.Reg, volatile.LoadUint32(&o.HSTADDR3.Reg)&^(0x7f00)|value<<8)
}
func (o *UOTGHS_Type) GetHSTADDR3_HSTADDRP9() uint32 {
	return (volatile.LoadUint32(&o.HSTADDR3.Reg) & 0x7f00) >> 8
}

// UOTGHS.HSTPIPCFG: Host Pipe Configuration Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPCFG_ALLOC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_ALLOC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPCFG_PBK(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0xc)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_PBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0xc) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPCFG_PSIZE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0x70)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_PSIZE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0x70) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPCFG_PTOKEN(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0x300)|value<<8)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_PTOKEN(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0x300) >> 8
}
func (o *UOTGHS_Type) SetHSTPIPCFG_AUTOSW(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_AUTOSW(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetHSTPIPCFG_PTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0x3000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_PTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0x3000) >> 12
}
func (o *UOTGHS_Type) SetHSTPIPCFG_PEPNUM(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0xf0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_PEPNUM(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0xf0000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIPCFG_INTFRQ(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPCFG[idx].Reg, volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *UOTGHS_Type) GetHSTPIPCFG_INTFRQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPCFG[idx].Reg) & 0xff000000) >> 24
}

// UOTGHS.HSTPIPISR: Host Pipe Status Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPISR_RXINI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPISR_RXINI(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPISR_TXOUTI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPISR_TXOUTI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPISR_TXSTPI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPISR_TXSTPI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPISR_PERRI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPISR_PERRI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPISR_NAKEDI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPISR_NAKEDI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPISR_OVERFI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPISR_OVERFI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPISR_RXSTALLDI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPISR_RXSTALLDI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPISR_SHORTPACKETI(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPISR_SHORTPACKETI(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIPISR_DTSEQ(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x300)|value<<8)
}
func (o *UOTGHS_Type) GetHSTPIPISR_DTSEQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x300) >> 8
}
func (o *UOTGHS_Type) SetHSTPIPISR_NBUSYBK(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x3000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPISR_NBUSYBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x3000) >> 12
}
func (o *UOTGHS_Type) SetHSTPIPISR_CURRBK(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0xc000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTPIPISR_CURRBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0xc000) >> 14
}
func (o *UOTGHS_Type) SetHSTPIPISR_RWALL(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIPISR_RWALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIPISR_CFGOK(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetHSTPIPISR_CFGOK(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x40000) >> 18
}
func (o *UOTGHS_Type) SetHSTPIPISR_PBYCT(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPISR[idx].Reg, volatile.LoadUint32(&o.HSTPIPISR[idx].Reg)&^(0x7ff00000)|value<<20)
}
func (o *UOTGHS_Type) GetHSTPIPISR_PBYCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPISR[idx].Reg) & 0x7ff00000) >> 20
}

// UOTGHS.HSTPIPICR: Host Pipe Clear Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPICR_RXINIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPICR_RXINIC(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPICR_TXOUTIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPICR_TXOUTIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPICR_TXSTPIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPICR_TXSTPIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPICR_NAKEDIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPICR_NAKEDIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPICR_OVERFIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPICR_OVERFIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPICR_RXSTALLDIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPICR_RXSTALLDIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPICR_SHORTPACKETIC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPICR[idx].Reg, volatile.LoadUint32(&o.HSTPIPICR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPICR_SHORTPACKETIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPICR[idx].Reg) & 0x80) >> 7
}

// UOTGHS.HSTPIPIFR: Host Pipe Set Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPIFR_RXINIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_RXINIS(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPIFR_TXOUTIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_TXOUTIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPIFR_TXSTPIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_TXSTPIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPIFR_PERRIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_PERRIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPIFR_NAKEDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_NAKEDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPIFR_OVERFIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_OVERFIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPIFR_RXSTALLDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_RXSTALLDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPIFR_SHORTPACKETIS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_SHORTPACKETIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIPIFR_NBUSYBKS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIFR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPIFR_NBUSYBKS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIFR[idx].Reg) & 0x1000) >> 12
}

// UOTGHS.HSTPIPIMR: Host Pipe Mask Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPIMR_RXINE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_RXINE(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPIMR_TXOUTE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_TXOUTE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPIMR_TXSTPE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_TXSTPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPIMR_PERRE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_PERRE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPIMR_NAKEDE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_NAKEDE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPIMR_OVERFIE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_OVERFIE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPIMR_RXSTALLDE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_RXSTALLDE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPIMR_SHORTPACKETIE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_SHORTPACKETIE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIPIMR_NBUSYBKE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_NBUSYBKE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTPIPIMR_FIFOCON(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_FIFOCON(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTPIPIMR_PDISHDMA(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_PDISHDMA(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIPIMR_PFREEZE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_PFREEZE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTPIPIMR_RSTDT(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIMR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetHSTPIPIMR_RSTDT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIMR[idx].Reg) & 0x40000) >> 18
}

// UOTGHS.HSTPIPIER: Host Pipe Enable Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPIER_RXINES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPIER_RXINES(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPIER_TXOUTES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPIER_TXOUTES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPIER_TXSTPES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPIER_TXSTPES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPIER_PERRES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPIER_PERRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPIER_NAKEDES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPIER_NAKEDES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPIER_OVERFIES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPIER_OVERFIES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPIER_RXSTALLDES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPIER_RXSTALLDES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPIER_SHORTPACKETIES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPIER_SHORTPACKETIES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIPIER_NBUSYBKES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPIER_NBUSYBKES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTPIPIER_PDISHDMAS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIPIER_PDISHDMAS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIPIER_PFREEZES(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTPIPIER_PFREEZES(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x20000) >> 17
}
func (o *UOTGHS_Type) SetHSTPIPIER_RSTDTS(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIER[idx].Reg, volatile.LoadUint32(&o.HSTPIPIER[idx].Reg)&^(0x40000)|value<<18)
}
func (o *UOTGHS_Type) GetHSTPIPIER_RSTDTS(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIER[idx].Reg) & 0x40000) >> 18
}

// UOTGHS.HSTPIPIDR: Host Pipe Disable Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPIDR_RXINEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_RXINEC(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPIDR_TXOUTEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_TXOUTEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPIDR_TXSTPEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_TXSTPEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPIDR_PERREC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_PERREC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPIDR_NAKEDEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_NAKEDEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPIDR_OVERFIEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_OVERFIEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTPIPIDR_RXSTALLDEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_RXSTALLDEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTPIPIDR_SHORTPACKETIEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_SHORTPACKETIEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTPIPIDR_NBUSYBKEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_NBUSYBKEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetHSTPIPIDR_FIFOCONC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_FIFOCONC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetHSTPIPIDR_PDISHDMAC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_PDISHDMAC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x10000) >> 16
}
func (o *UOTGHS_Type) SetHSTPIPIDR_PFREEZEC(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPIDR[idx].Reg, volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *UOTGHS_Type) GetHSTPIPIDR_PFREEZEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPIDR[idx].Reg) & 0x20000) >> 17
}

// UOTGHS.HSTPIPINRQ: Host Pipe IN Request Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPINRQ_INRQ(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPINRQ[idx].Reg, volatile.LoadUint32(&o.HSTPIPINRQ[idx].Reg)&^(0xff)|value)
}
func (o *UOTGHS_Type) GetHSTPIPINRQ_INRQ(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPINRQ[idx].Reg) & 0xff
}
func (o *UOTGHS_Type) SetHSTPIPINRQ_INMODE(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPINRQ[idx].Reg, volatile.LoadUint32(&o.HSTPIPINRQ[idx].Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetHSTPIPINRQ_INMODE(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPINRQ[idx].Reg) & 0x100) >> 8
}

// UOTGHS.HSTPIPERR: Host Pipe Error Register (n = 0)
func (o *UOTGHS_Type) SetHSTPIPERR_DATATGL(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTPIPERR_DATATGL(idx int) uint32 {
	return volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTPIPERR_DATAPID(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTPIPERR_DATAPID(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTPIPERR_PID(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTPIPERR_PID(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTPIPERR_TIMEOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTPIPERR_TIMEOUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTPIPERR_CRC16(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTPIPERR_CRC16(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTPIPERR_COUNTER(idx int, value uint32) {
	volatile.StoreUint32(&o.HSTPIPERR[idx].Reg, volatile.LoadUint32(&o.HSTPIPERR[idx].Reg)&^(0x60)|value<<5)
}
func (o *UOTGHS_Type) GetHSTPIPERR_COUNTER(idx int) uint32 {
	return (volatile.LoadUint32(&o.HSTPIPERR[idx].Reg) & 0x60) >> 5
}

// UOTGHS.HSTDMANXTDSC1: Host DMA Channel Next Descriptor Address Register (n = 1)
func (o *UOTGHS_Type) SetHSTDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC1.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC1.Reg)
}

// UOTGHS.HSTDMAADDRESS1: Host DMA Channel Address Register (n = 1)
func (o *UOTGHS_Type) SetHSTDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS1.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS1.Reg)
}

// UOTGHS.HSTDMACONTROL1: Host DMA Channel Control Register (n = 1)
func (o *UOTGHS_Type) SetHSTDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL1.Reg, volatile.LoadUint32(&o.HSTDMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS1: Host DMA Channel Status Register (n = 1)
func (o *UOTGHS_Type) SetHSTDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS1.Reg, volatile.LoadUint32(&o.HSTDMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC2: Host DMA Channel Next Descriptor Address Register (n = 2)
func (o *UOTGHS_Type) SetHSTDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC2.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC2.Reg)
}

// UOTGHS.HSTDMAADDRESS2: Host DMA Channel Address Register (n = 2)
func (o *UOTGHS_Type) SetHSTDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS2.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS2.Reg)
}

// UOTGHS.HSTDMACONTROL2: Host DMA Channel Control Register (n = 2)
func (o *UOTGHS_Type) SetHSTDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL2.Reg, volatile.LoadUint32(&o.HSTDMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS2: Host DMA Channel Status Register (n = 2)
func (o *UOTGHS_Type) SetHSTDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS2.Reg, volatile.LoadUint32(&o.HSTDMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC3: Host DMA Channel Next Descriptor Address Register (n = 3)
func (o *UOTGHS_Type) SetHSTDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC3.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC3.Reg)
}

// UOTGHS.HSTDMAADDRESS3: Host DMA Channel Address Register (n = 3)
func (o *UOTGHS_Type) SetHSTDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS3.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS3.Reg)
}

// UOTGHS.HSTDMACONTROL3: Host DMA Channel Control Register (n = 3)
func (o *UOTGHS_Type) SetHSTDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL3.Reg, volatile.LoadUint32(&o.HSTDMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS3: Host DMA Channel Status Register (n = 3)
func (o *UOTGHS_Type) SetHSTDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS3.Reg, volatile.LoadUint32(&o.HSTDMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC4: Host DMA Channel Next Descriptor Address Register (n = 4)
func (o *UOTGHS_Type) SetHSTDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC4.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC4.Reg)
}

// UOTGHS.HSTDMAADDRESS4: Host DMA Channel Address Register (n = 4)
func (o *UOTGHS_Type) SetHSTDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS4.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS4.Reg)
}

// UOTGHS.HSTDMACONTROL4: Host DMA Channel Control Register (n = 4)
func (o *UOTGHS_Type) SetHSTDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL4.Reg, volatile.LoadUint32(&o.HSTDMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS4: Host DMA Channel Status Register (n = 4)
func (o *UOTGHS_Type) SetHSTDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS4_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS4.Reg, volatile.LoadUint32(&o.HSTDMASTATUS4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS4_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS4.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC5: Host DMA Channel Next Descriptor Address Register (n = 5)
func (o *UOTGHS_Type) SetHSTDMANXTDSC5(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC5.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC5() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC5.Reg)
}

// UOTGHS.HSTDMAADDRESS5: Host DMA Channel Address Register (n = 5)
func (o *UOTGHS_Type) SetHSTDMAADDRESS5(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS5.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS5() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS5.Reg)
}

// UOTGHS.HSTDMACONTROL5: Host DMA Channel Control Register (n = 5)
func (o *UOTGHS_Type) SetHSTDMACONTROL5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL5_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL5.Reg, volatile.LoadUint32(&o.HSTDMACONTROL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL5_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL5.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS5: Host DMA Channel Status Register (n = 5)
func (o *UOTGHS_Type) SetHSTDMASTATUS5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS5_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS5_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS5_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS5_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS5_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS5.Reg, volatile.LoadUint32(&o.HSTDMASTATUS5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS5_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS5.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC6: Host DMA Channel Next Descriptor Address Register (n = 6)
func (o *UOTGHS_Type) SetHSTDMANXTDSC6(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC6.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC6() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC6.Reg)
}

// UOTGHS.HSTDMAADDRESS6: Host DMA Channel Address Register (n = 6)
func (o *UOTGHS_Type) SetHSTDMAADDRESS6(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS6.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS6() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS6.Reg)
}

// UOTGHS.HSTDMACONTROL6: Host DMA Channel Control Register (n = 6)
func (o *UOTGHS_Type) SetHSTDMACONTROL6_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL6_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL6.Reg, volatile.LoadUint32(&o.HSTDMACONTROL6.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL6_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL6.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS6: Host DMA Channel Status Register (n = 6)
func (o *UOTGHS_Type) SetHSTDMASTATUS6_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS6_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS6_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS6_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS6_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS6_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS6.Reg, volatile.LoadUint32(&o.HSTDMASTATUS6.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS6_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS6.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMANXTDSC7: Host DMA Channel Next Descriptor Address Register (n = 7)
func (o *UOTGHS_Type) SetHSTDMANXTDSC7(value uint32) {
	volatile.StoreUint32(&o.HSTDMANXTDSC7.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMANXTDSC7() uint32 {
	return volatile.LoadUint32(&o.HSTDMANXTDSC7.Reg)
}

// UOTGHS.HSTDMAADDRESS7: Host DMA Channel Address Register (n = 7)
func (o *UOTGHS_Type) SetHSTDMAADDRESS7(value uint32) {
	volatile.StoreUint32(&o.HSTDMAADDRESS7.Reg, value)
}
func (o *UOTGHS_Type) GetHSTDMAADDRESS7() uint32 {
	return volatile.LoadUint32(&o.HSTDMAADDRESS7.Reg)
}

// UOTGHS.HSTDMACONTROL7: Host DMA Channel Control Register (n = 7)
func (o *UOTGHS_Type) SetHSTDMACONTROL7_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetHSTDMACONTROL7_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.HSTDMACONTROL7.Reg, volatile.LoadUint32(&o.HSTDMACONTROL7.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMACONTROL7_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.HSTDMACONTROL7.Reg) & 0xffff0000) >> 16
}

// UOTGHS.HSTDMASTATUS7: Host DMA Channel Status Register (n = 7)
func (o *UOTGHS_Type) SetHSTDMASTATUS7_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0x1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS7_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetHSTDMASTATUS7_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetHSTDMASTATUS7_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetHSTDMASTATUS7_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetHSTDMASTATUS7_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.HSTDMASTATUS7.Reg, volatile.LoadUint32(&o.HSTDMASTATUS7.Reg)&^(0xffff0000)|value<<16)
}
func (o *UOTGHS_Type) GetHSTDMASTATUS7_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.HSTDMASTATUS7.Reg) & 0xffff0000) >> 16
}

// UOTGHS.CTRL: General Control Register
func (o *UOTGHS_Type) SetCTRL_IDTE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetCTRL_IDTE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *UOTGHS_Type) SetCTRL_VBUSTE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetCTRL_VBUSTE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetCTRL_SRPE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetCTRL_SRPE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetCTRL_VBERRE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetCTRL_VBERRE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetCTRL_BCERRE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetCTRL_BCERRE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetCTRL_ROLEEXE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetCTRL_ROLEEXE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetCTRL_HNPERRE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetCTRL_HNPERRE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetCTRL_STOE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetCTRL_STOE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetCTRL_VBUSHWC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *UOTGHS_Type) GetCTRL_VBUSHWC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *UOTGHS_Type) SetCTRL_SRPSEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetCTRL_SRPSEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetCTRL_SRPREQ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetCTRL_SRPREQ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetCTRL_HNPREQ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetCTRL_HNPREQ() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetCTRL_OTGPADE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *UOTGHS_Type) GetCTRL_OTGPADE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000) >> 12
}
func (o *UOTGHS_Type) SetCTRL_VBUSPO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *UOTGHS_Type) GetCTRL_VBUSPO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000) >> 13
}
func (o *UOTGHS_Type) SetCTRL_FRZCLK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetCTRL_FRZCLK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *UOTGHS_Type) SetCTRL_USBE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *UOTGHS_Type) GetCTRL_USBE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *UOTGHS_Type) SetCTRL_TIMVALUE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *UOTGHS_Type) GetCTRL_TIMVALUE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30000) >> 16
}
func (o *UOTGHS_Type) SetCTRL_TIMPAGE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x300000)|value<<20)
}
func (o *UOTGHS_Type) GetCTRL_TIMPAGE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x300000) >> 20
}
func (o *UOTGHS_Type) SetCTRL_UNLOCK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *UOTGHS_Type) GetCTRL_UNLOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *UOTGHS_Type) SetCTRL_UIDE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *UOTGHS_Type) GetCTRL_UIDE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *UOTGHS_Type) SetCTRL_UIMOD(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *UOTGHS_Type) GetCTRL_UIMOD() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}

// UOTGHS.SR: General Status Register
func (o *UOTGHS_Type) SetSR_IDTI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetSR_IDTI() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetSR_VBUSTI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetSR_VBUSTI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetSR_SRPI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetSR_SRPI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetSR_VBERRI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetSR_VBERRI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetSR_BCERRI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetSR_BCERRI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetSR_ROLEEXI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetSR_ROLEEXI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetSR_HNPERRI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetSR_HNPERRI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetSR_STOI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetSR_STOI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetSR_VBUSRQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetSR_VBUSRQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UOTGHS_Type) SetSR_ID(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *UOTGHS_Type) GetSR_ID() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *UOTGHS_Type) SetSR_VBUS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UOTGHS_Type) GetSR_VBUS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UOTGHS_Type) SetSR_SPEED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3000)|value<<12)
}
func (o *UOTGHS_Type) GetSR_SPEED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3000) >> 12
}
func (o *UOTGHS_Type) SetSR_CLKUSABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *UOTGHS_Type) GetSR_CLKUSABLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}

// UOTGHS.SCR: General Status Clear Register
func (o *UOTGHS_Type) SetSCR_IDTIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetSCR_IDTIC() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetSCR_VBUSTIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetSCR_VBUSTIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetSCR_SRPIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetSCR_SRPIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetSCR_VBERRIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetSCR_VBERRIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetSCR_BCERRIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetSCR_BCERRIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetSCR_ROLEEXIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetSCR_ROLEEXIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetSCR_HNPERRIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetSCR_HNPERRIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetSCR_STOIC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetSCR_STOIC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetSCR_VBUSRQC(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetSCR_VBUSRQC() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x200) >> 9
}

// UOTGHS.SFR: General Status Set Register
func (o *UOTGHS_Type) SetSFR_IDTIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x1)|value)
}
func (o *UOTGHS_Type) GetSFR_IDTIS() uint32 {
	return volatile.LoadUint32(&o.SFR.Reg) & 0x1
}
func (o *UOTGHS_Type) SetSFR_VBUSTIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x2)|value<<1)
}
func (o *UOTGHS_Type) GetSFR_VBUSTIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x2) >> 1
}
func (o *UOTGHS_Type) SetSFR_SRPIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x4)|value<<2)
}
func (o *UOTGHS_Type) GetSFR_SRPIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x4) >> 2
}
func (o *UOTGHS_Type) SetSFR_VBERRIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x8)|value<<3)
}
func (o *UOTGHS_Type) GetSFR_VBERRIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x8) >> 3
}
func (o *UOTGHS_Type) SetSFR_BCERRIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x10)|value<<4)
}
func (o *UOTGHS_Type) GetSFR_BCERRIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x10) >> 4
}
func (o *UOTGHS_Type) SetSFR_ROLEEXIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x20)|value<<5)
}
func (o *UOTGHS_Type) GetSFR_ROLEEXIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x20) >> 5
}
func (o *UOTGHS_Type) SetSFR_HNPERRIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x40)|value<<6)
}
func (o *UOTGHS_Type) GetSFR_HNPERRIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x40) >> 6
}
func (o *UOTGHS_Type) SetSFR_STOIS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x80)|value<<7)
}
func (o *UOTGHS_Type) GetSFR_STOIS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x80) >> 7
}
func (o *UOTGHS_Type) SetSFR_VBUSRQS(value uint32) {
	volatile.StoreUint32(&o.SFR.Reg, volatile.LoadUint32(&o.SFR.Reg)&^(0x200)|value<<9)
}
func (o *UOTGHS_Type) GetSFR_VBUSRQS() uint32 {
	return (volatile.LoadUint32(&o.SFR.Reg) & 0x200) >> 9
}

// UOTGHS.FSM: General Finite State Machine Register
func (o *UOTGHS_Type) SetFSM_DRDSTATE(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0xf)|value)
}
func (o *UOTGHS_Type) GetFSM_DRDSTATE() uint32 {
	return volatile.LoadUint32(&o.FSM.Reg) & 0xf
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFGR volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// EMAC.NCR: Network Control Register
func (o *EMAC_Type) SetNCR_LB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCR_LB() uint32 {
	return volatile.LoadUint32(&o.NCR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCR_LLB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCR_LLB() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCR_RE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNCR_RE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetNCR_TE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCR_TE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCR_MPE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCR_BP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCR_BP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_Type) GetNCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x200) >> 9
}
func (o *EMAC_Type) SetNCR_THALT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetNCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x400) >> 10
}

// EMAC.NCFGR: Network Configuration Register
func (o *EMAC_Type) SetNCFGR_SPD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCFGR_SPD() uint32 {
	return volatile.LoadUint32(&o.NCFGR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCFGR_FD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCFGR_FD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCFGR_JFRAME(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCFGR_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCFGR_CAF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCFGR_CAF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCFGR_NBC(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCFGR_NBC() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCFGR_MTI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCFGR_MTI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCFGR_UNI(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCFGR_UNI() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCFGR_BIG(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCFGR_BIG() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCFGR_CLK(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc00)|value<<10)
}
func (o *EMAC_Type) GetNCFGR_CLK() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc00) >> 10
}
func (o *EMAC_Type) SetNCFGR_RTY(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetNCFGR_RTY() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetNCFGR_PAE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetNCFGR_PAE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetNCFGR_RBOF(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0xc000)|value<<14)
}
func (o *EMAC_Type) GetNCFGR_RBOF() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0xc000) >> 14
}
func (o *EMAC_Type) SetNCFGR_RLCE(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_Type) GetNCFGR_RLCE() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x10000) >> 16
}
func (o *EMAC_Type) SetNCFGR_DRFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_Type) GetNCFGR_DRFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x20000) >> 17
}
func (o *EMAC_Type) SetNCFGR_EFRHD(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_Type) GetNCFGR_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x40000) >> 18
}
func (o *EMAC_Type) SetNCFGR_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.NCFGR.Reg, volatile.LoadUint32(&o.NCFGR.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_Type) GetNCFGR_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFGR.Reg) & 0x80000) >> 19
}

// EMAC.NSR: Network Status Register
func (o *EMAC_Type) SetNSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x4) >> 2
}

// EMAC.TSR: Transmit Status Register
func (o *EMAC_Type) SetTSR_UBR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetTSR_UBR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}
func (o *EMAC_Type) SetTSR_COL(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetTSR_COL() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetTSR_RLES(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetTSR_RLES() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetTSR_TGO(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetTSR_TGO() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetTSR_BEX(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetTSR_BEX() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetTSR_COMP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetTSR_COMP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetTSR_UND(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetTSR_UND() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40) >> 6
}

// EMAC.RBQP: Receive Buffer Queue Pointer Register
func (o *EMAC_Type) SetRBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBQP.Reg, volatile.LoadUint32(&o.RBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetRBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.TBQP: Transmit Buffer Queue Pointer Register
func (o *EMAC_Type) SetTBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.TBQP.Reg, volatile.LoadUint32(&o.TBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetTBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.TBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.RSR: Receive Status Register
func (o *EMAC_Type) SetRSR_BNA(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetRSR_BNA() uint32 {
	return volatile.LoadUint32(&o.RSR.Reg) & 0x1
}
func (o *EMAC_Type) SetRSR_REC(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetRSR_REC() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetRSR_OVR(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetRSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4) >> 2
}

// EMAC.ISR: Interrupt Status Register
func (o *EMAC_Type) SetISR_MFD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetISR_MFD() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *EMAC_Type) SetISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetISR_TUND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetISR_TUND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetISR_RLEX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetISR_RLEX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetISR_PFRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetISR_PFRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// EMAC.IER: Interrupt Enable Register
func (o *EMAC_Type) SetIER_MFD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIER_MFD() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *EMAC_Type) SetIER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIER_TUND(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIER_TUND() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIER_RLE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIER_RLE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIER_TXERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIER_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIER_ROVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIER_HRESP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIER_PFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIER_PFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIER_PTZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// EMAC.IDR: Interrupt Disable Register
func (o *EMAC_Type) SetIDR_MFD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIDR_MFD() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *EMAC_Type) SetIDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIDR_TUND(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIDR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIDR_RLE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIDR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIDR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIDR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIDR_PFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIDR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// EMAC.IMR: Interrupt Mask Register
func (o *EMAC_Type) SetIMR_MFD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIMR_MFD() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EMAC_Type) SetIMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIMR_TUND(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIMR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIMR_RLE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIMR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIMR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIMR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIMR_PFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIMR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// EMAC.MAN: Phy Maintenance Register
func (o *EMAC_Type) SetMAN_DATA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMAN_DATA() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xffff
}
func (o *EMAC_Type) SetMAN_CODE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000)|value<<16)
}
func (o *EMAC_Type) GetMAN_CODE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000) >> 16
}
func (o *EMAC_Type) SetMAN_REGA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *EMAC_Type) GetMAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x7c0000) >> 18
}
func (o *EMAC_Type) SetMAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *EMAC_Type) GetMAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf800000) >> 23
}
func (o *EMAC_Type) SetMAN_RW(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *EMAC_Type) GetMAN_RW() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000000) >> 28
}
func (o *EMAC_Type) SetMAN_SOF(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xc0000000)|value<<30)
}
func (o *EMAC_Type) GetMAN_SOF() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xc0000000) >> 30
}

// EMAC.PTR: Pause Time Register
func (o *EMAC_Type) SetPTR_PTIME(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, volatile.LoadUint32(&o.PTR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPTR_PTIME() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg) & 0xffff
}

// EMAC.PFR: Pause Frames Received Register
func (o *EMAC_Type) SetPFR_FROK(value uint32) {
	volatile.StoreUint32(&o.PFR.Reg, volatile.LoadUint32(&o.PFR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPFR_FROK() uint32 {
	return volatile.LoadUint32(&o.PFR.Reg) & 0xffff
}

// EMAC.FTO: Frames Transmitted Ok Register
func (o *EMAC_Type) SetFTO_FTOK(value uint32) {
	volatile.StoreUint32(&o.FTO.Reg, volatile.LoadUint32(&o.FTO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFTO_FTOK() uint32 {
	return volatile.LoadUint32(&o.FTO.Reg) & 0xffffff
}

// EMAC.SCF: Single Collision Frames Register
func (o *EMAC_Type) SetSCF(value uint32) {
	volatile.StoreUint32(&o.SCF.Reg, volatile.LoadUint32(&o.SCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSCF() uint32 {
	return volatile.LoadUint32(&o.SCF.Reg) & 0xffff
}

// EMAC.MCF: Multiple Collision Frames Register
func (o *EMAC_Type) SetMCF(value uint32) {
	volatile.StoreUint32(&o.MCF.Reg, volatile.LoadUint32(&o.MCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMCF() uint32 {
	return volatile.LoadUint32(&o.MCF.Reg) & 0xffff
}

// EMAC.FRO: Frames Received Ok Register
func (o *EMAC_Type) SetFRO_FROK(value uint32) {
	volatile.StoreUint32(&o.FRO.Reg, volatile.LoadUint32(&o.FRO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFRO_FROK() uint32 {
	return volatile.LoadUint32(&o.FRO.Reg) & 0xffffff
}

// EMAC.FCSE: Frame Check Sequence Errors Register
func (o *EMAC_Type) SetFCSE(value uint32) {
	volatile.StoreUint32(&o.FCSE.Reg, volatile.LoadUint32(&o.FCSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetFCSE() uint32 {
	return volatile.LoadUint32(&o.FCSE.Reg) & 0xff
}

// EMAC.ALE: Alignment Errors Register
func (o *EMAC_Type) SetALE(value uint32) {
	volatile.StoreUint32(&o.ALE.Reg, volatile.LoadUint32(&o.ALE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetALE() uint32 {
	return volatile.LoadUint32(&o.ALE.Reg) & 0xff
}

// EMAC.DTF: Deferred Transmission Frames Register
func (o *EMAC_Type) SetDTF(value uint32) {
	volatile.StoreUint32(&o.DTF.Reg, volatile.LoadUint32(&o.DTF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetDTF() uint32 {
	return volatile.LoadUint32(&o.DTF.Reg) & 0xffff
}

// EMAC.LCOL: Late Collisions Register
func (o *EMAC_Type) SetLCOL(value uint32) {
	volatile.StoreUint32(&o.LCOL.Reg, volatile.LoadUint32(&o.LCOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetLCOL() uint32 {
	return volatile.LoadUint32(&o.LCOL.Reg) & 0xff
}

// EMAC.ECOL: Excessive Collisions Register
func (o *EMAC_Type) SetECOL_EXCOL(value uint32) {
	volatile.StoreUint32(&o.ECOL.Reg, volatile.LoadUint32(&o.ECOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetECOL_EXCOL() uint32 {
	return volatile.LoadUint32(&o.ECOL.Reg) & 0xff
}

// EMAC.TUND: Transmit Underrun Errors Register
func (o *EMAC_Type) SetTUND(value uint32) {
	volatile.StoreUint32(&o.TUND.Reg, volatile.LoadUint32(&o.TUND.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetTUND() uint32 {
	return volatile.LoadUint32(&o.TUND.Reg) & 0xff
}

// EMAC.CSE: Carrier Sense Errors Register
func (o *EMAC_Type) SetCSE(value uint32) {
	volatile.StoreUint32(&o.CSE.Reg, volatile.LoadUint32(&o.CSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetCSE() uint32 {
	return volatile.LoadUint32(&o.CSE.Reg) & 0xff
}

// EMAC.RRE: Receive Resource Errors Register
func (o *EMAC_Type) SetRRE(value uint32) {
	volatile.StoreUint32(&o.RRE.Reg, volatile.LoadUint32(&o.RRE.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetRRE() uint32 {
	return volatile.LoadUint32(&o.RRE.Reg) & 0xffff
}

// EMAC.ROV: Receive Overrun Errors Register
func (o *EMAC_Type) SetROV_ROVR(value uint32) {
	volatile.StoreUint32(&o.ROV.Reg, volatile.LoadUint32(&o.ROV.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetROV_ROVR() uint32 {
	return volatile.LoadUint32(&o.ROV.Reg) & 0xff
}

// EMAC.RSE: Receive Symbol Errors Register
func (o *EMAC_Type) SetRSE(value uint32) {
	volatile.StoreUint32(&o.RSE.Reg, volatile.LoadUint32(&o.RSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRSE() uint32 {
	return volatile.LoadUint32(&o.RSE.Reg) & 0xff
}

// EMAC.ELE: Excessive Length Errors Register
func (o *EMAC_Type) SetELE_EXL(value uint32) {
	volatile.StoreUint32(&o.ELE.Reg, volatile.LoadUint32(&o.ELE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetELE_EXL() uint32 {
	return volatile.LoadUint32(&o.ELE.Reg) & 0xff
}

// EMAC.RJA: Receive Jabbers Register
func (o *EMAC_Type) SetRJA_RJB(value uint32) {
	volatile.StoreUint32(&o.RJA.Reg, volatile.LoadUint32(&o.RJA.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRJA_RJB() uint32 {
	return volatile.LoadUint32(&o.RJA.Reg) & 0xff
}

// EMAC.USF: Undersize Frames Register
func (o *EMAC_Type) SetUSF(value uint32) {
	volatile.StoreUint32(&o.USF.Reg, volatile.LoadUint32(&o.USF.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetUSF() uint32 {
	return volatile.LoadUint32(&o.USF.Reg) & 0xff
}

// EMAC.STE: SQE Test Errors Register
func (o *EMAC_Type) SetSTE_SQER(value uint32) {
	volatile.StoreUint32(&o.STE.Reg, volatile.LoadUint32(&o.STE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetSTE_SQER() uint32 {
	return volatile.LoadUint32(&o.STE.Reg) & 0xff
}

// EMAC.RLE: Received Length Field Mismatch Register
func (o *EMAC_Type) SetRLE_RLFM(value uint32) {
	volatile.StoreUint32(&o.RLE.Reg, volatile.LoadUint32(&o.RLE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRLE_RLFM() uint32 {
	return volatile.LoadUint32(&o.RLE.Reg) & 0xff
}

// EMAC.HRB: Hash Register Bottom [31:0] Register
func (o *EMAC_Type) SetHRB(value uint32) {
	volatile.StoreUint32(&o.HRB.Reg, value)
}
func (o *EMAC_Type) GetHRB() uint32 {
	return volatile.LoadUint32(&o.HRB.Reg)
}

// EMAC.HRT: Hash Register Top [63:32] Register
func (o *EMAC_Type) SetHRT(value uint32) {
	volatile.StoreUint32(&o.HRT.Reg, value)
}
func (o *EMAC_Type) GetHRT() uint32 {
	return volatile.LoadUint32(&o.HRT.Reg)
}

// EMAC.SA1B: Specific Address 1 Bottom Register
func (o *EMAC_Type) SetSA1B(value uint32) {
	volatile.StoreUint32(&o.SA1B.Reg, value)
}
func (o *EMAC_Type) GetSA1B() uint32 {
	return volatile.LoadUint32(&o.SA1B.Reg)
}

// EMAC.SA1T: Specific Address 1 Top Register
func (o *EMAC_Type) SetSA1T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA1T.Reg, volatile.LoadUint32(&o.SA1T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA1T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA1T.Reg) & 0xffff
}

// EMAC.SA2B: Specific Address 2 Bottom Register
func (o *EMAC_Type) SetSA2B(value uint32) {
	volatile.StoreUint32(&o.SA2B.Reg, value)
}
func (o *EMAC_Type) GetSA2B() uint32 {
	return volatile.LoadUint32(&o.SA2B.Reg)
}

// EMAC.SA2T: Specific Address 2 Top Register
func (o *EMAC_Type) SetSA2T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA2T.Reg, volatile.LoadUint32(&o.SA2T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA2T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA2T.Reg) & 0xffff
}

// EMAC.SA3B: Specific Address 3 Bottom Register
func (o *EMAC_Type) SetSA3B(value uint32) {
	volatile.StoreUint32(&o.SA3B.Reg, value)
}
func (o *EMAC_Type) GetSA3B() uint32 {
	return volatile.LoadUint32(&o.SA3B.Reg)
}

// EMAC.SA3T: Specific Address 3 Top Register
func (o *EMAC_Type) SetSA3T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA3T.Reg, volatile.LoadUint32(&o.SA3T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA3T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA3T.Reg) & 0xffff
}

// EMAC.SA4B: Specific Address 4 Bottom Register
func (o *EMAC_Type) SetSA4B(value uint32) {
	volatile.StoreUint32(&o.SA4B.Reg, value)
}
func (o *EMAC_Type) GetSA4B() uint32 {
	return volatile.LoadUint32(&o.SA4B.Reg)
}

// EMAC.SA4T: Specific Address 4 Top Register
func (o *EMAC_Type) SetSA4T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA4T.Reg, volatile.LoadUint32(&o.SA4T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA4T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA4T.Reg) & 0xffff
}

// EMAC.TID: Type ID Checking Register
func (o *EMAC_Type) SetTID(value uint32) {
	volatile.StoreUint32(&o.TID.Reg, volatile.LoadUint32(&o.TID.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetTID() uint32 {
	return volatile.LoadUint32(&o.TID.Reg) & 0xffff
}

// EMAC.USRIO: User Input/Output Register
func (o *EMAC_Type) SetUSRIO_RMII(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetUSRIO_RMII() uint32 {
	return volatile.LoadUint32(&o.USRIO.Reg) & 0x1
}
func (o *EMAC_Type) SetUSRIO_CLKEN(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetUSRIO_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.USRIO.Reg) & 0x2) >> 1
}

// Controller Area Network 0
type CAN_Type struct {
	MR      volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	IDR     volatile.Register32 // 0x8
	IMR     volatile.Register32 // 0xC
	SR      volatile.Register32 // 0x10
	BR      volatile.Register32 // 0x14
	TIM     volatile.Register32 // 0x18
	TIMESTP volatile.Register32 // 0x1C
	ECR     volatile.Register32 // 0x20
	TCR     volatile.Register32 // 0x24
	ACR     volatile.Register32 // 0x28
	_       [184]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [276]byte
	MMR0    volatile.Register32 // 0x200
	MAM0    volatile.Register32 // 0x204
	MID0    volatile.Register32 // 0x208
	MFID0   volatile.Register32 // 0x20C
	MSR0    volatile.Register32 // 0x210
	MDL0    volatile.Register32 // 0x214
	MDH0    volatile.Register32 // 0x218
	MCR0    volatile.Register32 // 0x21C
	MMR1    volatile.Register32 // 0x220
	MAM1    volatile.Register32 // 0x224
	MID1    volatile.Register32 // 0x228
	MFID1   volatile.Register32 // 0x22C
	MSR1    volatile.Register32 // 0x230
	MDL1    volatile.Register32 // 0x234
	MDH1    volatile.Register32 // 0x238
	MCR1    volatile.Register32 // 0x23C
	MMR2    volatile.Register32 // 0x240
	MAM2    volatile.Register32 // 0x244
	MID2    volatile.Register32 // 0x248
	MFID2   volatile.Register32 // 0x24C
	MSR2    volatile.Register32 // 0x250
	MDL2    volatile.Register32 // 0x254
	MDH2    volatile.Register32 // 0x258
	MCR2    volatile.Register32 // 0x25C
	MMR3    volatile.Register32 // 0x260
	MAM3    volatile.Register32 // 0x264
	MID3    volatile.Register32 // 0x268
	MFID3   volatile.Register32 // 0x26C
	MSR3    volatile.Register32 // 0x270
	MDL3    volatile.Register32 // 0x274
	MDH3    volatile.Register32 // 0x278
	MCR3    volatile.Register32 // 0x27C
	MMR4    volatile.Register32 // 0x280
	MAM4    volatile.Register32 // 0x284
	MID4    volatile.Register32 // 0x288
	MFID4   volatile.Register32 // 0x28C
	MSR4    volatile.Register32 // 0x290
	MDL4    volatile.Register32 // 0x294
	MDH4    volatile.Register32 // 0x298
	MCR4    volatile.Register32 // 0x29C
	MMR5    volatile.Register32 // 0x2A0
	MAM5    volatile.Register32 // 0x2A4
	MID5    volatile.Register32 // 0x2A8
	MFID5   volatile.Register32 // 0x2AC
	MSR5    volatile.Register32 // 0x2B0
	MDL5    volatile.Register32 // 0x2B4
	MDH5    volatile.Register32 // 0x2B8
	MCR5    volatile.Register32 // 0x2BC
	MMR6    volatile.Register32 // 0x2C0
	MAM6    volatile.Register32 // 0x2C4
	MID6    volatile.Register32 // 0x2C8
	MFID6   volatile.Register32 // 0x2CC
	MSR6    volatile.Register32 // 0x2D0
	MDL6    volatile.Register32 // 0x2D4
	MDH6    volatile.Register32 // 0x2D8
	MCR6    volatile.Register32 // 0x2DC
	MMR7    volatile.Register32 // 0x2E0
	MAM7    volatile.Register32 // 0x2E4
	MID7    volatile.Register32 // 0x2E8
	MFID7   volatile.Register32 // 0x2EC
	MSR7    volatile.Register32 // 0x2F0
	MDL7    volatile.Register32 // 0x2F4
	MDH7    volatile.Register32 // 0x2F8
	MCR7    volatile.Register32 // 0x2FC
}

// CAN.MR: Mode Register
func (o *CAN_Type) SetMR_CANEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMR_CANEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *CAN_Type) SetMR_LPM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMR_ABM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMR_ABM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMR_OVL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMR_OVL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMR_TEOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMR_TEOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMR_TTM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMR_TTM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMR_TIMFRZ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMR_TIMFRZ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMR_DRPT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMR_DRPT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMR_RXSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMR_RXSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}

// CAN.IER: Interrupt Enable Register
func (o *CAN_Type) SetIER_MB0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_MB0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *CAN_Type) SetIER_MB1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_MB1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_MB2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_MB2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_MB3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_MB3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_MB4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_MB4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_MB5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_MB5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_MB6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_MB6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_MB7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetIER_MB7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetIER_ERRA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_ERRA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_WARN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_WARN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_ERRP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetIER_ERRP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetIER_BOFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetIER_BOFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetIER_SLEEP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetIER_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetIER_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetIER_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetIER_TOVF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetIER_TOVF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetIER_TSTP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetIER_TSTP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetIER_CERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetIER_CERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetIER_SERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetIER_SERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetIER_AERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetIER_AERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetIER_FERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetIER_FERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetIER_BERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetIER_BERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}

// CAN.IDR: Interrupt Disable Register
func (o *CAN_Type) SetIDR_MB0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIDR_MB0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *CAN_Type) SetIDR_MB1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIDR_MB1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIDR_MB2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIDR_MB2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIDR_MB3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIDR_MB3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIDR_MB4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIDR_MB4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIDR_MB5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIDR_MB5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIDR_MB6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIDR_MB6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIDR_MB7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetIDR_MB7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetIDR_ERRA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIDR_ERRA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIDR_WARN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIDR_WARN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIDR_ERRP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetIDR_ERRP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetIDR_BOFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetIDR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetIDR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetIDR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetIDR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetIDR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetIDR_TOVF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetIDR_TOVF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetIDR_TSTP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetIDR_TSTP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetIDR_CERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetIDR_CERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetIDR_SERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetIDR_SERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetIDR_AERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetIDR_AERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetIDR_FERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetIDR_FERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetIDR_BERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetIDR_BERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}

// CAN.IMR: Interrupt Mask Register
func (o *CAN_Type) SetIMR_MB0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIMR_MB0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *CAN_Type) SetIMR_MB1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIMR_MB1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIMR_MB2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIMR_MB2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIMR_MB3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIMR_MB3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIMR_MB4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIMR_MB4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIMR_MB5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIMR_MB5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIMR_MB6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIMR_MB6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIMR_MB7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetIMR_MB7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetIMR_ERRA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIMR_ERRA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIMR_WARN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIMR_WARN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIMR_ERRP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetIMR_ERRP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetIMR_BOFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetIMR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetIMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetIMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetIMR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetIMR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetIMR_TOVF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetIMR_TOVF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetIMR_TSTP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetIMR_TSTP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetIMR_CERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetIMR_CERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetIMR_SERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetIMR_SERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetIMR_AERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetIMR_AERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetIMR_FERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetIMR_FERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetIMR_BERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetIMR_BERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}

// CAN.SR: Status Register
func (o *CAN_Type) SetSR_MB0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetSR_MB0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *CAN_Type) SetSR_MB1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetSR_MB1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetSR_MB2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetSR_MB2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetSR_MB3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetSR_MB3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetSR_MB4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetSR_MB4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetSR_MB5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetSR_MB5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetSR_MB6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetSR_MB6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetSR_MB7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetSR_MB7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetSR_ERRA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetSR_ERRA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetSR_WARN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetSR_WARN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetSR_ERRP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetSR_ERRP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetSR_BOFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetSR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetSR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetSR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetSR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetSR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetSR_TOVF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetSR_TOVF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetSR_TSTP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetSR_TSTP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetSR_CERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetSR_CERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetSR_SERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetSR_SERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetSR_AERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetSR_AERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetSR_FERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetSR_FERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetSR_BERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetSR_BERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetSR_RBSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetSR_RBSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetSR_TBSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetSR_TBSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetSR_OVLSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetSR_OVLSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// CAN.BR: Baudrate Register
func (o *CAN_Type) SetBR_PHASE2(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x7)|value)
}
func (o *CAN_Type) GetBR_PHASE2() uint32 {
	return volatile.LoadUint32(&o.BR.Reg) & 0x7
}
func (o *CAN_Type) SetBR_PHASE1(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetBR_PHASE1() uint32 {
	return (volatile.LoadUint32(&o.BR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetBR_PROPAG(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x700)|value<<8)
}
func (o *CAN_Type) GetBR_PROPAG() uint32 {
	return (volatile.LoadUint32(&o.BR.Reg) & 0x700) >> 8
}
func (o *CAN_Type) SetBR_SJW(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x3000)|value<<12)
}
func (o *CAN_Type) GetBR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BR.Reg) & 0x3000) >> 12
}
func (o *CAN_Type) SetBR_BRP(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *CAN_Type) GetBR_BRP() uint32 {
	return (volatile.LoadUint32(&o.BR.Reg) & 0x7f0000) >> 16
}
func (o *CAN_Type) SetBR_SMP(value uint32) {
	volatile.StoreUint32(&o.BR.Reg, volatile.LoadUint32(&o.BR.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetBR_SMP() uint32 {
	return (volatile.LoadUint32(&o.BR.Reg) & 0x1000000) >> 24
}

// CAN.TIM: Timer Register
func (o *CAN_Type) SetTIM_TIMER(value uint32) {
	volatile.StoreUint32(&o.TIM.Reg, volatile.LoadUint32(&o.TIM.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetTIM_TIMER() uint32 {
	return volatile.LoadUint32(&o.TIM.Reg) & 0xffff
}

// CAN.TIMESTP: Timestamp Register
func (o *CAN_Type) SetTIMESTP_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.TIMESTP.Reg, volatile.LoadUint32(&o.TIMESTP.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetTIMESTP_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.TIMESTP.Reg) & 0xffff
}

// CAN.ECR: Error Counter Register
func (o *CAN_Type) SetECR_REC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetECR_REC() uint32 {
	return volatile.LoadUint32(&o.ECR.Reg) & 0xff
}
func (o *CAN_Type) SetECR_TEC(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetECR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff0000) >> 16
}

// CAN.TCR: Transfer Command Register
func (o *CAN_Type) SetTCR_MB0(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTCR_MB0() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *CAN_Type) SetTCR_MB1(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTCR_MB1() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTCR_MB2(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTCR_MB2() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTCR_MB3(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTCR_MB3() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTCR_MB4(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetTCR_MB4() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetTCR_MB5(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetTCR_MB5() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetTCR_MB6(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetTCR_MB6() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetTCR_MB7(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTCR_MB7() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTCR_TIMRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTCR_TIMRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x80000000) >> 31
}

// CAN.ACR: Abort Command Register
func (o *CAN_Type) SetACR_MB0(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetACR_MB0() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *CAN_Type) SetACR_MB1(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetACR_MB1() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetACR_MB2(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetACR_MB2() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetACR_MB3(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetACR_MB3() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetACR_MB4(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetACR_MB4() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetACR_MB5(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetACR_MB5() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetACR_MB6(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetACR_MB6() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetACR_MB7(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetACR_MB7() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x80) >> 7
}

// CAN.WPMR: Write Protect Mode Register
func (o *CAN_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *CAN_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CAN_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// CAN.WPSR: Write Protect Status Register
func (o *CAN_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *CAN_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// CAN.MMR0: Mailbox Mode Register (MB = 0)
func (o *CAN_Type) SetMMR0_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR0.Reg, volatile.LoadUint32(&o.MMR0.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR0_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR0.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR0_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR0.Reg, volatile.LoadUint32(&o.MMR0.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR0_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR0.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR0_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR0.Reg, volatile.LoadUint32(&o.MMR0.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR0_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR0.Reg) & 0x7000000) >> 24
}

// CAN.MAM0: Mailbox Acceptance Mask Register (MB = 0)
func (o *CAN_Type) SetMAM0_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM0.Reg, volatile.LoadUint32(&o.MAM0.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM0_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM0.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM0_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM0.Reg, volatile.LoadUint32(&o.MAM0.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM0_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM0.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM0_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM0.Reg, volatile.LoadUint32(&o.MAM0.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM0_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM0.Reg) & 0x20000000) >> 29
}

// CAN.MID0: Mailbox ID Register (MB = 0)
func (o *CAN_Type) SetMID0_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID0.Reg, volatile.LoadUint32(&o.MID0.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID0_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID0.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID0_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID0.Reg, volatile.LoadUint32(&o.MID0.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID0_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID0.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID0_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID0.Reg, volatile.LoadUint32(&o.MID0.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID0_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID0.Reg) & 0x20000000) >> 29
}

// CAN.MFID0: Mailbox Family ID Register (MB = 0)
func (o *CAN_Type) SetMFID0_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID0.Reg, volatile.LoadUint32(&o.MFID0.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID0_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID0.Reg) & 0x1fffffff
}

// CAN.MSR0: Mailbox Status Register (MB = 0)
func (o *CAN_Type) SetMSR0_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR0_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR0.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR0_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR0_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR0.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR0_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR0_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR0.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR0_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR0_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR0.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR0_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR0_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR0.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR0_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR0.Reg, volatile.LoadUint32(&o.MSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR0_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR0.Reg) & 0x1000000) >> 24
}

// CAN.MDL0: Mailbox Data Low Register (MB = 0)
func (o *CAN_Type) SetMDL0(value uint32) {
	volatile.StoreUint32(&o.MDL0.Reg, value)
}
func (o *CAN_Type) GetMDL0() uint32 {
	return volatile.LoadUint32(&o.MDL0.Reg)
}

// CAN.MDH0: Mailbox Data High Register (MB = 0)
func (o *CAN_Type) SetMDH0(value uint32) {
	volatile.StoreUint32(&o.MDH0.Reg, value)
}
func (o *CAN_Type) GetMDH0() uint32 {
	return volatile.LoadUint32(&o.MDH0.Reg)
}

// CAN.MCR0: Mailbox Control Register (MB = 0)
func (o *CAN_Type) SetMCR0_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR0.Reg, volatile.LoadUint32(&o.MCR0.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR0_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR0.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR0_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR0.Reg, volatile.LoadUint32(&o.MCR0.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR0_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR0.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR0_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR0.Reg, volatile.LoadUint32(&o.MCR0.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR0_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR0.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR0_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR0.Reg, volatile.LoadUint32(&o.MCR0.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR0_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR0.Reg) & 0x800000) >> 23
}

// CAN.MMR1: Mailbox Mode Register (MB = 1)
func (o *CAN_Type) SetMMR1_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR1.Reg, volatile.LoadUint32(&o.MMR1.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR1_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR1.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR1_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR1.Reg, volatile.LoadUint32(&o.MMR1.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR1_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR1.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR1_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR1.Reg, volatile.LoadUint32(&o.MMR1.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR1_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR1.Reg) & 0x7000000) >> 24
}

// CAN.MAM1: Mailbox Acceptance Mask Register (MB = 1)
func (o *CAN_Type) SetMAM1_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM1.Reg, volatile.LoadUint32(&o.MAM1.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM1_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM1.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM1_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM1.Reg, volatile.LoadUint32(&o.MAM1.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM1_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM1.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM1_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM1.Reg, volatile.LoadUint32(&o.MAM1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM1_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM1.Reg) & 0x20000000) >> 29
}

// CAN.MID1: Mailbox ID Register (MB = 1)
func (o *CAN_Type) SetMID1_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID1.Reg, volatile.LoadUint32(&o.MID1.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID1_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID1.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID1_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID1.Reg, volatile.LoadUint32(&o.MID1.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID1_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID1.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID1_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID1.Reg, volatile.LoadUint32(&o.MID1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID1_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID1.Reg) & 0x20000000) >> 29
}

// CAN.MFID1: Mailbox Family ID Register (MB = 1)
func (o *CAN_Type) SetMFID1_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID1.Reg, volatile.LoadUint32(&o.MFID1.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID1_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID1.Reg) & 0x1fffffff
}

// CAN.MSR1: Mailbox Status Register (MB = 1)
func (o *CAN_Type) SetMSR1_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR1_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR1.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR1_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR1_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR1.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR1_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR1_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR1.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR1_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR1_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR1.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR1_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR1_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR1.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR1_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR1.Reg, volatile.LoadUint32(&o.MSR1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR1_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR1.Reg) & 0x1000000) >> 24
}

// CAN.MDL1: Mailbox Data Low Register (MB = 1)
func (o *CAN_Type) SetMDL1(value uint32) {
	volatile.StoreUint32(&o.MDL1.Reg, value)
}
func (o *CAN_Type) GetMDL1() uint32 {
	return volatile.LoadUint32(&o.MDL1.Reg)
}

// CAN.MDH1: Mailbox Data High Register (MB = 1)
func (o *CAN_Type) SetMDH1(value uint32) {
	volatile.StoreUint32(&o.MDH1.Reg, value)
}
func (o *CAN_Type) GetMDH1() uint32 {
	return volatile.LoadUint32(&o.MDH1.Reg)
}

// CAN.MCR1: Mailbox Control Register (MB = 1)
func (o *CAN_Type) SetMCR1_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR1.Reg, volatile.LoadUint32(&o.MCR1.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR1_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR1.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR1_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR1.Reg, volatile.LoadUint32(&o.MCR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR1_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR1.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR1_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR1.Reg, volatile.LoadUint32(&o.MCR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR1_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR1.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR1_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR1.Reg, volatile.LoadUint32(&o.MCR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR1_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR1.Reg) & 0x800000) >> 23
}

// CAN.MMR2: Mailbox Mode Register (MB = 2)
func (o *CAN_Type) SetMMR2_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR2.Reg, volatile.LoadUint32(&o.MMR2.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR2_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR2.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR2_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR2.Reg, volatile.LoadUint32(&o.MMR2.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR2_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR2.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR2_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR2.Reg, volatile.LoadUint32(&o.MMR2.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR2_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR2.Reg) & 0x7000000) >> 24
}

// CAN.MAM2: Mailbox Acceptance Mask Register (MB = 2)
func (o *CAN_Type) SetMAM2_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM2.Reg, volatile.LoadUint32(&o.MAM2.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM2_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM2.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM2_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM2.Reg, volatile.LoadUint32(&o.MAM2.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM2_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM2.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM2_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM2.Reg, volatile.LoadUint32(&o.MAM2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM2_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM2.Reg) & 0x20000000) >> 29
}

// CAN.MID2: Mailbox ID Register (MB = 2)
func (o *CAN_Type) SetMID2_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID2.Reg, volatile.LoadUint32(&o.MID2.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID2_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID2.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID2_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID2.Reg, volatile.LoadUint32(&o.MID2.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID2_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID2.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID2_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID2.Reg, volatile.LoadUint32(&o.MID2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID2_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID2.Reg) & 0x20000000) >> 29
}

// CAN.MFID2: Mailbox Family ID Register (MB = 2)
func (o *CAN_Type) SetMFID2_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID2.Reg, volatile.LoadUint32(&o.MFID2.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID2_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID2.Reg) & 0x1fffffff
}

// CAN.MSR2: Mailbox Status Register (MB = 2)
func (o *CAN_Type) SetMSR2_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR2_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR2.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR2_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR2_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR2.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR2_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR2_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR2.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR2_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR2_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR2.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR2_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR2_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR2.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR2_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR2.Reg, volatile.LoadUint32(&o.MSR2.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR2_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR2.Reg) & 0x1000000) >> 24
}

// CAN.MDL2: Mailbox Data Low Register (MB = 2)
func (o *CAN_Type) SetMDL2(value uint32) {
	volatile.StoreUint32(&o.MDL2.Reg, value)
}
func (o *CAN_Type) GetMDL2() uint32 {
	return volatile.LoadUint32(&o.MDL2.Reg)
}

// CAN.MDH2: Mailbox Data High Register (MB = 2)
func (o *CAN_Type) SetMDH2(value uint32) {
	volatile.StoreUint32(&o.MDH2.Reg, value)
}
func (o *CAN_Type) GetMDH2() uint32 {
	return volatile.LoadUint32(&o.MDH2.Reg)
}

// CAN.MCR2: Mailbox Control Register (MB = 2)
func (o *CAN_Type) SetMCR2_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR2.Reg, volatile.LoadUint32(&o.MCR2.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR2_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR2.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR2_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR2.Reg, volatile.LoadUint32(&o.MCR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR2_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR2.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR2_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR2.Reg, volatile.LoadUint32(&o.MCR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR2_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR2.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR2_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR2.Reg, volatile.LoadUint32(&o.MCR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR2_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR2.Reg) & 0x800000) >> 23
}

// CAN.MMR3: Mailbox Mode Register (MB = 3)
func (o *CAN_Type) SetMMR3_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR3.Reg, volatile.LoadUint32(&o.MMR3.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR3_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR3.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR3_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR3.Reg, volatile.LoadUint32(&o.MMR3.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR3_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR3.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR3_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR3.Reg, volatile.LoadUint32(&o.MMR3.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR3_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR3.Reg) & 0x7000000) >> 24
}

// CAN.MAM3: Mailbox Acceptance Mask Register (MB = 3)
func (o *CAN_Type) SetMAM3_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM3.Reg, volatile.LoadUint32(&o.MAM3.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM3_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM3.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM3_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM3.Reg, volatile.LoadUint32(&o.MAM3.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM3_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM3.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM3_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM3.Reg, volatile.LoadUint32(&o.MAM3.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM3_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM3.Reg) & 0x20000000) >> 29
}

// CAN.MID3: Mailbox ID Register (MB = 3)
func (o *CAN_Type) SetMID3_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID3.Reg, volatile.LoadUint32(&o.MID3.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID3_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID3.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID3_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID3.Reg, volatile.LoadUint32(&o.MID3.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID3_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID3.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID3_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID3.Reg, volatile.LoadUint32(&o.MID3.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID3_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID3.Reg) & 0x20000000) >> 29
}

// CAN.MFID3: Mailbox Family ID Register (MB = 3)
func (o *CAN_Type) SetMFID3_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID3.Reg, volatile.LoadUint32(&o.MFID3.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID3_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID3.Reg) & 0x1fffffff
}

// CAN.MSR3: Mailbox Status Register (MB = 3)
func (o *CAN_Type) SetMSR3_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR3_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR3.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR3_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR3_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR3.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR3_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR3_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR3.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR3_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR3_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR3.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR3_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR3_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR3.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR3_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR3.Reg, volatile.LoadUint32(&o.MSR3.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR3_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR3.Reg) & 0x1000000) >> 24
}

// CAN.MDL3: Mailbox Data Low Register (MB = 3)
func (o *CAN_Type) SetMDL3(value uint32) {
	volatile.StoreUint32(&o.MDL3.Reg, value)
}
func (o *CAN_Type) GetMDL3() uint32 {
	return volatile.LoadUint32(&o.MDL3.Reg)
}

// CAN.MDH3: Mailbox Data High Register (MB = 3)
func (o *CAN_Type) SetMDH3(value uint32) {
	volatile.StoreUint32(&o.MDH3.Reg, value)
}
func (o *CAN_Type) GetMDH3() uint32 {
	return volatile.LoadUint32(&o.MDH3.Reg)
}

// CAN.MCR3: Mailbox Control Register (MB = 3)
func (o *CAN_Type) SetMCR3_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR3.Reg, volatile.LoadUint32(&o.MCR3.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR3_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR3.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR3_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR3.Reg, volatile.LoadUint32(&o.MCR3.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR3_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR3.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR3_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR3.Reg, volatile.LoadUint32(&o.MCR3.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR3_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR3.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR3_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR3.Reg, volatile.LoadUint32(&o.MCR3.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR3_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR3.Reg) & 0x800000) >> 23
}

// CAN.MMR4: Mailbox Mode Register (MB = 4)
func (o *CAN_Type) SetMMR4_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR4.Reg, volatile.LoadUint32(&o.MMR4.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR4_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR4.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR4_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR4.Reg, volatile.LoadUint32(&o.MMR4.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR4_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR4.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR4_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR4.Reg, volatile.LoadUint32(&o.MMR4.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR4_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR4.Reg) & 0x7000000) >> 24
}

// CAN.MAM4: Mailbox Acceptance Mask Register (MB = 4)
func (o *CAN_Type) SetMAM4_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM4.Reg, volatile.LoadUint32(&o.MAM4.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM4_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM4.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM4_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM4.Reg, volatile.LoadUint32(&o.MAM4.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM4_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM4.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM4_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM4.Reg, volatile.LoadUint32(&o.MAM4.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM4_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM4.Reg) & 0x20000000) >> 29
}

// CAN.MID4: Mailbox ID Register (MB = 4)
func (o *CAN_Type) SetMID4_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID4.Reg, volatile.LoadUint32(&o.MID4.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID4_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID4.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID4_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID4.Reg, volatile.LoadUint32(&o.MID4.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID4_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID4.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID4_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID4.Reg, volatile.LoadUint32(&o.MID4.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID4_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID4.Reg) & 0x20000000) >> 29
}

// CAN.MFID4: Mailbox Family ID Register (MB = 4)
func (o *CAN_Type) SetMFID4_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID4.Reg, volatile.LoadUint32(&o.MFID4.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID4_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID4.Reg) & 0x1fffffff
}

// CAN.MSR4: Mailbox Status Register (MB = 4)
func (o *CAN_Type) SetMSR4_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR4_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR4.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR4_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR4_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR4.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR4_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR4_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR4.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR4_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR4_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR4.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR4_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR4_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR4.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR4_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR4.Reg, volatile.LoadUint32(&o.MSR4.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR4_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR4.Reg) & 0x1000000) >> 24
}

// CAN.MDL4: Mailbox Data Low Register (MB = 4)
func (o *CAN_Type) SetMDL4(value uint32) {
	volatile.StoreUint32(&o.MDL4.Reg, value)
}
func (o *CAN_Type) GetMDL4() uint32 {
	return volatile.LoadUint32(&o.MDL4.Reg)
}

// CAN.MDH4: Mailbox Data High Register (MB = 4)
func (o *CAN_Type) SetMDH4(value uint32) {
	volatile.StoreUint32(&o.MDH4.Reg, value)
}
func (o *CAN_Type) GetMDH4() uint32 {
	return volatile.LoadUint32(&o.MDH4.Reg)
}

// CAN.MCR4: Mailbox Control Register (MB = 4)
func (o *CAN_Type) SetMCR4_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR4.Reg, volatile.LoadUint32(&o.MCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR4_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR4.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR4_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR4.Reg, volatile.LoadUint32(&o.MCR4.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR4_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR4.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR4_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR4.Reg, volatile.LoadUint32(&o.MCR4.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR4_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR4.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR4_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR4.Reg, volatile.LoadUint32(&o.MCR4.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR4_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR4.Reg) & 0x800000) >> 23
}

// CAN.MMR5: Mailbox Mode Register (MB = 5)
func (o *CAN_Type) SetMMR5_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR5.Reg, volatile.LoadUint32(&o.MMR5.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR5_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR5.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR5_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR5.Reg, volatile.LoadUint32(&o.MMR5.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR5_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR5.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR5_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR5.Reg, volatile.LoadUint32(&o.MMR5.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR5_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR5.Reg) & 0x7000000) >> 24
}

// CAN.MAM5: Mailbox Acceptance Mask Register (MB = 5)
func (o *CAN_Type) SetMAM5_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM5.Reg, volatile.LoadUint32(&o.MAM5.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM5_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM5.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM5_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM5.Reg, volatile.LoadUint32(&o.MAM5.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM5_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM5.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM5_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM5.Reg, volatile.LoadUint32(&o.MAM5.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM5_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM5.Reg) & 0x20000000) >> 29
}

// CAN.MID5: Mailbox ID Register (MB = 5)
func (o *CAN_Type) SetMID5_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID5.Reg, volatile.LoadUint32(&o.MID5.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID5_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID5.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID5_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID5.Reg, volatile.LoadUint32(&o.MID5.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID5_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID5.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID5_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID5.Reg, volatile.LoadUint32(&o.MID5.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID5_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID5.Reg) & 0x20000000) >> 29
}

// CAN.MFID5: Mailbox Family ID Register (MB = 5)
func (o *CAN_Type) SetMFID5_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID5.Reg, volatile.LoadUint32(&o.MFID5.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID5_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID5.Reg) & 0x1fffffff
}

// CAN.MSR5: Mailbox Status Register (MB = 5)
func (o *CAN_Type) SetMSR5_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR5_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR5.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR5_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR5_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR5.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR5_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR5_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR5.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR5_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR5_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR5.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR5_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR5_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR5.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR5_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR5.Reg, volatile.LoadUint32(&o.MSR5.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR5_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR5.Reg) & 0x1000000) >> 24
}

// CAN.MDL5: Mailbox Data Low Register (MB = 5)
func (o *CAN_Type) SetMDL5(value uint32) {
	volatile.StoreUint32(&o.MDL5.Reg, value)
}
func (o *CAN_Type) GetMDL5() uint32 {
	return volatile.LoadUint32(&o.MDL5.Reg)
}

// CAN.MDH5: Mailbox Data High Register (MB = 5)
func (o *CAN_Type) SetMDH5(value uint32) {
	volatile.StoreUint32(&o.MDH5.Reg, value)
}
func (o *CAN_Type) GetMDH5() uint32 {
	return volatile.LoadUint32(&o.MDH5.Reg)
}

// CAN.MCR5: Mailbox Control Register (MB = 5)
func (o *CAN_Type) SetMCR5_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR5.Reg, volatile.LoadUint32(&o.MCR5.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR5_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR5.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR5_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR5.Reg, volatile.LoadUint32(&o.MCR5.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR5_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR5.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR5_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR5.Reg, volatile.LoadUint32(&o.MCR5.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR5_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR5.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR5_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR5.Reg, volatile.LoadUint32(&o.MCR5.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR5_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR5.Reg) & 0x800000) >> 23
}

// CAN.MMR6: Mailbox Mode Register (MB = 6)
func (o *CAN_Type) SetMMR6_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR6.Reg, volatile.LoadUint32(&o.MMR6.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR6_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR6.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR6_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR6.Reg, volatile.LoadUint32(&o.MMR6.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR6_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR6.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR6_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR6.Reg, volatile.LoadUint32(&o.MMR6.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR6_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR6.Reg) & 0x7000000) >> 24
}

// CAN.MAM6: Mailbox Acceptance Mask Register (MB = 6)
func (o *CAN_Type) SetMAM6_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM6.Reg, volatile.LoadUint32(&o.MAM6.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM6_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM6.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM6_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM6.Reg, volatile.LoadUint32(&o.MAM6.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM6_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM6.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM6_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM6.Reg, volatile.LoadUint32(&o.MAM6.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM6_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM6.Reg) & 0x20000000) >> 29
}

// CAN.MID6: Mailbox ID Register (MB = 6)
func (o *CAN_Type) SetMID6_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID6.Reg, volatile.LoadUint32(&o.MID6.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID6_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID6.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID6_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID6.Reg, volatile.LoadUint32(&o.MID6.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID6_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID6.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID6_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID6.Reg, volatile.LoadUint32(&o.MID6.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID6_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID6.Reg) & 0x20000000) >> 29
}

// CAN.MFID6: Mailbox Family ID Register (MB = 6)
func (o *CAN_Type) SetMFID6_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID6.Reg, volatile.LoadUint32(&o.MFID6.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID6_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID6.Reg) & 0x1fffffff
}

// CAN.MSR6: Mailbox Status Register (MB = 6)
func (o *CAN_Type) SetMSR6_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR6_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR6.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR6_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR6_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR6.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR6_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR6_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR6.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR6_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR6_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR6.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR6_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR6_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR6.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR6_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR6.Reg, volatile.LoadUint32(&o.MSR6.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR6_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR6.Reg) & 0x1000000) >> 24
}

// CAN.MDL6: Mailbox Data Low Register (MB = 6)
func (o *CAN_Type) SetMDL6(value uint32) {
	volatile.StoreUint32(&o.MDL6.Reg, value)
}
func (o *CAN_Type) GetMDL6() uint32 {
	return volatile.LoadUint32(&o.MDL6.Reg)
}

// CAN.MDH6: Mailbox Data High Register (MB = 6)
func (o *CAN_Type) SetMDH6(value uint32) {
	volatile.StoreUint32(&o.MDH6.Reg, value)
}
func (o *CAN_Type) GetMDH6() uint32 {
	return volatile.LoadUint32(&o.MDH6.Reg)
}

// CAN.MCR6: Mailbox Control Register (MB = 6)
func (o *CAN_Type) SetMCR6_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR6.Reg, volatile.LoadUint32(&o.MCR6.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR6_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR6.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR6_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR6.Reg, volatile.LoadUint32(&o.MCR6.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR6_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR6.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR6_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR6.Reg, volatile.LoadUint32(&o.MCR6.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR6_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR6.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR6_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR6.Reg, volatile.LoadUint32(&o.MCR6.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR6_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR6.Reg) & 0x800000) >> 23
}

// CAN.MMR7: Mailbox Mode Register (MB = 7)
func (o *CAN_Type) SetMMR7_MTIMEMARK(value uint32) {
	volatile.StoreUint32(&o.MMR7.Reg, volatile.LoadUint32(&o.MMR7.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMMR7_MTIMEMARK() uint32 {
	return volatile.LoadUint32(&o.MMR7.Reg) & 0xffff
}
func (o *CAN_Type) SetMMR7_PRIOR(value uint32) {
	volatile.StoreUint32(&o.MMR7.Reg, volatile.LoadUint32(&o.MMR7.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMMR7_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.MMR7.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMMR7_MOT(value uint32) {
	volatile.StoreUint32(&o.MMR7.Reg, volatile.LoadUint32(&o.MMR7.Reg)&^(0x7000000)|value<<24)
}
func (o *CAN_Type) GetMMR7_MOT() uint32 {
	return (volatile.LoadUint32(&o.MMR7.Reg) & 0x7000000) >> 24
}

// CAN.MAM7: Mailbox Acceptance Mask Register (MB = 7)
func (o *CAN_Type) SetMAM7_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MAM7.Reg, volatile.LoadUint32(&o.MAM7.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMAM7_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MAM7.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMAM7_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MAM7.Reg, volatile.LoadUint32(&o.MAM7.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMAM7_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MAM7.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMAM7_MIDE(value uint32) {
	volatile.StoreUint32(&o.MAM7.Reg, volatile.LoadUint32(&o.MAM7.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMAM7_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MAM7.Reg) & 0x20000000) >> 29
}

// CAN.MID7: Mailbox ID Register (MB = 7)
func (o *CAN_Type) SetMID7_MIDvB(value uint32) {
	volatile.StoreUint32(&o.MID7.Reg, volatile.LoadUint32(&o.MID7.Reg)&^(0x3ffff)|value)
}
func (o *CAN_Type) GetMID7_MIDvB() uint32 {
	return volatile.LoadUint32(&o.MID7.Reg) & 0x3ffff
}
func (o *CAN_Type) SetMID7_MIDvA(value uint32) {
	volatile.StoreUint32(&o.MID7.Reg, volatile.LoadUint32(&o.MID7.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN_Type) GetMID7_MIDvA() uint32 {
	return (volatile.LoadUint32(&o.MID7.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN_Type) SetMID7_MIDE(value uint32) {
	volatile.StoreUint32(&o.MID7.Reg, volatile.LoadUint32(&o.MID7.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetMID7_MIDE() uint32 {
	return (volatile.LoadUint32(&o.MID7.Reg) & 0x20000000) >> 29
}

// CAN.MFID7: Mailbox Family ID Register (MB = 7)
func (o *CAN_Type) SetMFID7_MFID(value uint32) {
	volatile.StoreUint32(&o.MFID7.Reg, volatile.LoadUint32(&o.MFID7.Reg)&^(0x1fffffff)|value)
}
func (o *CAN_Type) GetMFID7_MFID() uint32 {
	return volatile.LoadUint32(&o.MFID7.Reg) & 0x1fffffff
}

// CAN.MSR7: Mailbox Status Register (MB = 7)
func (o *CAN_Type) SetMSR7_MTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0xffff)|value)
}
func (o *CAN_Type) GetMSR7_MTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.MSR7.Reg) & 0xffff
}
func (o *CAN_Type) SetMSR7_MDLC(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMSR7_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MSR7.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMSR7_MRTR(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMSR7_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MSR7.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMSR7_MABT(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMSR7_MABT() uint32 {
	return (volatile.LoadUint32(&o.MSR7.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMSR7_MRDY(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMSR7_MRDY() uint32 {
	return (volatile.LoadUint32(&o.MSR7.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetMSR7_MMI(value uint32) {
	volatile.StoreUint32(&o.MSR7.Reg, volatile.LoadUint32(&o.MSR7.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetMSR7_MMI() uint32 {
	return (volatile.LoadUint32(&o.MSR7.Reg) & 0x1000000) >> 24
}

// CAN.MDL7: Mailbox Data Low Register (MB = 7)
func (o *CAN_Type) SetMDL7(value uint32) {
	volatile.StoreUint32(&o.MDL7.Reg, value)
}
func (o *CAN_Type) GetMDL7() uint32 {
	return volatile.LoadUint32(&o.MDL7.Reg)
}

// CAN.MDH7: Mailbox Data High Register (MB = 7)
func (o *CAN_Type) SetMDH7(value uint32) {
	volatile.StoreUint32(&o.MDH7.Reg, value)
}
func (o *CAN_Type) GetMDH7() uint32 {
	return volatile.LoadUint32(&o.MDH7.Reg)
}

// CAN.MCR7: Mailbox Control Register (MB = 7)
func (o *CAN_Type) SetMCR7_MDLC(value uint32) {
	volatile.StoreUint32(&o.MCR7.Reg, volatile.LoadUint32(&o.MCR7.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetMCR7_MDLC() uint32 {
	return (volatile.LoadUint32(&o.MCR7.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetMCR7_MRTR(value uint32) {
	volatile.StoreUint32(&o.MCR7.Reg, volatile.LoadUint32(&o.MCR7.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetMCR7_MRTR() uint32 {
	return (volatile.LoadUint32(&o.MCR7.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetMCR7_MACR(value uint32) {
	volatile.StoreUint32(&o.MCR7.Reg, volatile.LoadUint32(&o.MCR7.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetMCR7_MACR() uint32 {
	return (volatile.LoadUint32(&o.MCR7.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetMCR7_MTCR(value uint32) {
	volatile.StoreUint32(&o.MCR7.Reg, volatile.LoadUint32(&o.MCR7.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetMCR7_MTCR() uint32 {
	return (volatile.LoadUint32(&o.MCR7.Reg) & 0x800000) >> 23
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// TRNG.CR: Control Register
func (o *TRNG_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TRNG_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TRNG_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffffff00) >> 8
}

// TRNG.IER: Interrupt Enable Register
func (o *TRNG_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TRNG.IDR: Interrupt Disable Register
func (o *TRNG_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// TRNG.IMR: Interrupt Mask Register
func (o *TRNG_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// TRNG.ISR: Interrupt Status Register
func (o *TRNG_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TRNG.ODATA: Output Data Register
func (o *TRNG_Type) SetODATA(value uint32) {
	volatile.StoreUint32(&o.ODATA.Reg, value)
}
func (o *TRNG_Type) GetODATA() uint32 {
	return volatile.LoadUint32(&o.ODATA.Reg)
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32     // 0x3C
	EMR   volatile.Register32     // 0x40
	CWR   volatile.Register32     // 0x44
	CGR   volatile.Register32     // 0x48
	COR   volatile.Register32     // 0x4C
	CDR   [16]volatile.Register32 // 0x50
	_     [4]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *ADC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetMR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_SETTLING(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetMR_SETTLING() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetMR_ANACH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetMR_ANACH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_TRANSFER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetMR_TRANSFER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR2_USCH12(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR2_USCH12() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR2_USCH13(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR2_USCH13() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR2_USCH14(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR2_USCH14() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR2_USCH15(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR2_USCH15() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000000) >> 24
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHER_CH12(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHER_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHER_CH13(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHER_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHER_CH14(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHER_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHER_CH15(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHER_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHDR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHDR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHDR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHDR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHDR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHDR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHDR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHDR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHSR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHSR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHSR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHSR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHSR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHSR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHSR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHSR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_EOC12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIER_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIER_EOC13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIER_EOC14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIER_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIER_EOC15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIER_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIDR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIDR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIDR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIDR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIDR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIDR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIDR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIMR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIMR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIMR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIMR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIMR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIMR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIMR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_EOC12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetISR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetISR_EOC13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetISR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetISR_EOC14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetISR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetISR_EOC15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetISR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetISR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetISR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetISR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetOVER_OVRE12(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetOVER_OVRE12() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetOVER_OVRE13(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetOVER_OVRE13() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetOVER_OVRE14(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetOVER_OVRE14() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetOVER_OVRE15(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetOVER_OVRE15() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8000) >> 15
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetEMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CGR: Channel Gain Register
func (o *ADC_Type) SetCGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.CGR.Reg) & 0x3
}
func (o *ADC_Type) SetCGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetCGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetCGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetCGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000) >> 12
}
func (o *ADC_Type) SetCGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000)|value<<14)
}
func (o *ADC_Type) GetCGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000) >> 14
}
func (o *ADC_Type) SetCGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetCGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetCGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *ADC_Type) GetCGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000) >> 18
}
func (o *ADC_Type) SetCGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *ADC_Type) GetCGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00000) >> 22
}
func (o *ADC_Type) SetCGR_GAIN12(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCGR_GAIN12() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCGR_GAIN13(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000000)|value<<26)
}
func (o *ADC_Type) GetCGR_GAIN13() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000000) >> 26
}
func (o *ADC_Type) SetCGR_GAIN14(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCGR_GAIN14() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCGR_GAIN15(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetCGR_GAIN15() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000000) >> 30
}

// ADC.COR: Channel Offset Register
func (o *ADC_Type) SetCOR_OFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCOR_OFF0() uint32 {
	return volatile.LoadUint32(&o.COR.Reg) & 0x1
}
func (o *ADC_Type) SetCOR_OFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCOR_OFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCOR_OFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCOR_OFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCOR_OFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCOR_OFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCOR_OFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCOR_OFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCOR_OFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCOR_OFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCOR_OFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCOR_OFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCOR_OFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCOR_OFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCOR_OFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCOR_OFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCOR_OFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCOR_OFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCOR_OFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCOR_OFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCOR_OFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCOR_OFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCOR_OFF12(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCOR_OFF12() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCOR_OFF13(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCOR_OFF13() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCOR_OFF14(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCOR_OFF14() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCOR_OFF15(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCOR_OFF15() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetCOR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCOR_DIFF0() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCOR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetCOR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetCOR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetCOR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetCOR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetCOR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetCOR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCOR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCOR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCOR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCOR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCOR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCOR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCOR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCOR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCOR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCOR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCOR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCOR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCOR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCOR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCOR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCOR_DIFF12(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCOR_DIFF12() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCOR_DIFF13(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCOR_DIFF13() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCOR_DIFF14(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCOR_DIFF14() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCOR_DIFF15(value uint32) {
	volatile.StoreUint32(&o.COR.Reg, volatile.LoadUint32(&o.COR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCOR_DIFF15() uint32 {
	return (volatile.LoadUint32(&o.COR.Reg) & 0x80000000) >> 31
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.ACR: Analog Control Register
func (o *ADC_Type) SetACR_TSON(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetACR_TSON() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// ADC.WPMR: Write Protect Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protect Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// ADC.RPR: Receive Pointer Register
func (o *ADC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *ADC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// ADC.RCR: Receive Counter Register
func (o *ADC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// ADC.RNPR: Receive Next Pointer Register
func (o *ADC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *ADC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// ADC.RNCR: Receive Next Counter Register
func (o *ADC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// ADC.PTCR: Transfer Control Register
func (o *ADC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *ADC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// ADC.PTSR: Transfer Status Register
func (o *ADC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *ADC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [16]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	_      [16]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	_      [200]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// DMAC.GCFG: DMAC Global Configuration Register
func (o *DMAC_Type) SetGCFG_ARB_CFG(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetGCFG_ARB_CFG() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x10) >> 4
}

// DMAC.EN: DMAC Enable Register
func (o *DMAC_Type) SetEN_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEN_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DMAC.SREQ: DMAC Software Single Request Register
func (o *DMAC_Type) SetSREQ_SSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSREQ_SSREQ0() uint32 {
	return volatile.LoadUint32(&o.SREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetSREQ_DSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSREQ_DSREQ0() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSREQ_SSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSREQ_SSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSREQ_DSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSREQ_DSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSREQ_SSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSREQ_SSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSREQ_DSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSREQ_DSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSREQ_SSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSREQ_SSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSREQ_DSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSREQ_DSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSREQ_SSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSREQ_SSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSREQ_DSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSREQ_DSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSREQ_SSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSREQ_SSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSREQ_DSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSREQ_DSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x800) >> 11
}

// DMAC.CREQ: DMAC Software Chunk Transfer Request Register
func (o *DMAC_Type) SetCREQ_SCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCREQ_SCREQ0() uint32 {
	return volatile.LoadUint32(&o.CREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetCREQ_DCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCREQ_DCREQ0() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCREQ_SCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCREQ_SCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCREQ_DCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCREQ_DCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCREQ_SCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCREQ_SCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCREQ_DCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCREQ_DCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCREQ_SCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCREQ_SCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCREQ_DCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCREQ_DCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCREQ_SCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCREQ_SCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCREQ_DCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCREQ_DCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCREQ_SCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCREQ_SCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCREQ_DCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCREQ_DCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x800) >> 11
}

// DMAC.LAST: DMAC Software Last Transfer Flag Register
func (o *DMAC_Type) SetLAST_SLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetLAST_SLAST0() uint32 {
	return volatile.LoadUint32(&o.LAST.Reg) & 0x1
}
func (o *DMAC_Type) SetLAST_DLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetLAST_DLAST0() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetLAST_SLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetLAST_SLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetLAST_DLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetLAST_DLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetLAST_SLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetLAST_SLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetLAST_DLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetLAST_DLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetLAST_SLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetLAST_SLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetLAST_DLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetLAST_DLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetLAST_SLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetLAST_SLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetLAST_DLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetLAST_DLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetLAST_SLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetLAST_SLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetLAST_DLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetLAST_DLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x800) >> 11
}

// DMAC.EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
func (o *DMAC_Type) SetEBCIER_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIER_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIER.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIER_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIER_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIER_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIER_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIER_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIER_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIER_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIER_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIER_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIER_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIER_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIER_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIER_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIER_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIER_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIER_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIER_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIER_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIER_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIER_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIER_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIER_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIER_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIER_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIER_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIER_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIER_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIER_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIER_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIER_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIER_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIER_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIER_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIER_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200000) >> 21
}

// DMAC.EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
func (o *DMAC_Type) SetEBCIDR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIDR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIDR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIDR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIDR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIDR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIDR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIDR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIDR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIDR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIDR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIDR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIDR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIDR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIDR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIDR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIDR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIDR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIDR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIDR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIDR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIDR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIDR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIDR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIDR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIDR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIDR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIDR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIDR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIDR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIDR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIDR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIDR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIDR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIDR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIDR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200000) >> 21
}

// DMAC.EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
func (o *DMAC_Type) SetEBCIMR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIMR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIMR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIMR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIMR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIMR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIMR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIMR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIMR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIMR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIMR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIMR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIMR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIMR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIMR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIMR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIMR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIMR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIMR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIMR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIMR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIMR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIMR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIMR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIMR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIMR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIMR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIMR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIMR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIMR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIMR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIMR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIMR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIMR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIMR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIMR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200000) >> 21
}

// DMAC.EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
func (o *DMAC_Type) SetEBCISR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCISR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCISR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCISR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCISR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCISR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCISR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCISR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCISR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCISR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCISR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCISR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCISR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCISR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCISR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCISR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCISR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCISR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCISR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCISR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCISR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCISR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCISR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCISR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCISR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCISR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCISR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCISR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCISR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCISR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCISR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCISR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCISR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCISR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCISR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCISR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCISR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200000) >> 21
}

// DMAC.CHER: DMAC Channel Handler Enable Register
func (o *DMAC_Type) SetCHER_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHER_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DMAC_Type) SetCHER_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHER_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHER_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHER_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHER_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHER_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHER_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHER_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHER_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHER_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHER_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHER_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHER_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHER_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHER_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHER_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHER_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHER_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHER_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHER_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHER_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHER_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHER_KEEP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHER_KEEP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHER_KEEP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHER_KEEP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHER_KEEP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHER_KEEP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHER_KEEP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHER_KEEP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHER_KEEP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHER_KEEP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHER_KEEP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHER_KEEP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20000000) >> 29
}

// DMAC.CHDR: DMAC Channel Handler Disable Register
func (o *DMAC_Type) SetCHDR_DIS0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHDR_DIS0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHDR_DIS1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHDR_DIS1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHDR_DIS2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHDR_DIS2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHDR_DIS3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHDR_DIS3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHDR_DIS4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHDR_DIS4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHDR_DIS5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHDR_DIS5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHDR_RES0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHDR_RES0() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHDR_RES1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHDR_RES1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHDR_RES2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHDR_RES2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHDR_RES3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHDR_RES3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHDR_RES4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHDR_RES4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHDR_RES5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHDR_RES5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}

// DMAC.CHSR: DMAC Channel Handler Status Register
func (o *DMAC_Type) SetCHSR_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSR_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSR_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSR_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSR_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSR_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHSR_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHSR_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHSR_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHSR_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHSR_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHSR_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHSR_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHSR_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHSR_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHSR_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHSR_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHSR_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHSR_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHSR_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHSR_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHSR_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHSR_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHSR_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHSR_EMPT0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHSR_EMPT0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHSR_EMPT1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetCHSR_EMPT1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetCHSR_EMPT2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetCHSR_EMPT2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetCHSR_EMPT3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetCHSR_EMPT3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetCHSR_EMPT4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCHSR_EMPT4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCHSR_EMPT5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCHSR_EMPT5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCHSR_STAL0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHSR_STAL0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHSR_STAL1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHSR_STAL1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHSR_STAL2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHSR_STAL2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHSR_STAL3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHSR_STAL3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHSR_STAL4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHSR_STAL4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHSR_STAL5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHSR_STAL5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000000) >> 29
}

// DMAC.SADDR0: DMAC Channel Source Address Register (ch_num = 0)
func (o *DMAC_Type) SetSADDR0(value uint32) {
	volatile.StoreUint32(&o.SADDR0.Reg, value)
}
func (o *DMAC_Type) GetSADDR0() uint32 {
	return volatile.LoadUint32(&o.SADDR0.Reg)
}

// DMAC.DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
func (o *DMAC_Type) SetDADDR0(value uint32) {
	volatile.StoreUint32(&o.DADDR0.Reg, value)
}
func (o *DMAC_Type) GetDADDR0() uint32 {
	return volatile.LoadUint32(&o.DADDR0.Reg)
}

// DMAC.DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
func (o *DMAC_Type) SetDSCR0_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR0_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR0.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA0: DMAC Channel Control A Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLA0_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA0_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA0.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA0_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA0_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA0_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA0_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA0_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA0_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA0_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA0_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA0_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB0: DMAC Channel Control B Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLB0_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB0_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB0_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB0_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB0_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB0_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB0_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB0_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB0_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB0_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB0_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB0_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x40000000) >> 30
}

// DMAC.CFG0: DMAC Channel Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetCFG0_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG0_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG0_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG0_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG0_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG0_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG0_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG0_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG0_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG0_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG0_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG0_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG0_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG0_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG0_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG0_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG0_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG0_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR1: DMAC Channel Source Address Register (ch_num = 1)
func (o *DMAC_Type) SetSADDR1(value uint32) {
	volatile.StoreUint32(&o.SADDR1.Reg, value)
}
func (o *DMAC_Type) GetSADDR1() uint32 {
	return volatile.LoadUint32(&o.SADDR1.Reg)
}

// DMAC.DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
func (o *DMAC_Type) SetDADDR1(value uint32) {
	volatile.StoreUint32(&o.DADDR1.Reg, value)
}
func (o *DMAC_Type) GetDADDR1() uint32 {
	return volatile.LoadUint32(&o.DADDR1.Reg)
}

// DMAC.DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
func (o *DMAC_Type) SetDSCR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR1.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA1: DMAC Channel Control A Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLA1_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA1_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA1.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA1_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA1_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA1_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA1_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA1_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA1_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA1_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA1_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA1_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB1: DMAC Channel Control B Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLB1_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB1_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB1_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB1_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB1_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB1_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB1_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB1_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB1_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB1_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB1_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB1_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x40000000) >> 30
}

// DMAC.CFG1: DMAC Channel Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetCFG1_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG1_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG1_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG1_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG1_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG1_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG1_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG1_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG1_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG1_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG1_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG1_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG1_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG1_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG1_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG1_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG1_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR2: DMAC Channel Source Address Register (ch_num = 2)
func (o *DMAC_Type) SetSADDR2(value uint32) {
	volatile.StoreUint32(&o.SADDR2.Reg, value)
}
func (o *DMAC_Type) GetSADDR2() uint32 {
	return volatile.LoadUint32(&o.SADDR2.Reg)
}

// DMAC.DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
func (o *DMAC_Type) SetDADDR2(value uint32) {
	volatile.StoreUint32(&o.DADDR2.Reg, value)
}
func (o *DMAC_Type) GetDADDR2() uint32 {
	return volatile.LoadUint32(&o.DADDR2.Reg)
}

// DMAC.DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
func (o *DMAC_Type) SetDSCR2_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR2_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR2.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA2: DMAC Channel Control A Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLA2_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA2_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA2.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA2_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA2_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA2_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA2_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA2_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA2_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA2_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA2_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA2_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB2: DMAC Channel Control B Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLB2_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB2_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB2_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB2_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB2_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB2_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB2_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB2_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB2_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB2_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB2_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB2_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x40000000) >> 30
}

// DMAC.CFG2: DMAC Channel Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetCFG2_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG2_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG2_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG2_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG2_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG2_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG2_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG2_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG2_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG2_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG2_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG2_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG2_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG2_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG2_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG2_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG2_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG2_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR3: DMAC Channel Source Address Register (ch_num = 3)
func (o *DMAC_Type) SetSADDR3(value uint32) {
	volatile.StoreUint32(&o.SADDR3.Reg, value)
}
func (o *DMAC_Type) GetSADDR3() uint32 {
	return volatile.LoadUint32(&o.SADDR3.Reg)
}

// DMAC.DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
func (o *DMAC_Type) SetDADDR3(value uint32) {
	volatile.StoreUint32(&o.DADDR3.Reg, value)
}
func (o *DMAC_Type) GetDADDR3() uint32 {
	return volatile.LoadUint32(&o.DADDR3.Reg)
}

// DMAC.DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
func (o *DMAC_Type) SetDSCR3_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR3_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR3.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA3: DMAC Channel Control A Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLA3_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA3_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA3.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA3_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA3_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA3_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA3_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA3_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA3_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA3_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA3_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA3_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB3: DMAC Channel Control B Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLB3_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB3_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB3_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB3_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB3_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB3_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB3_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB3_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB3_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB3_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB3_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB3_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x40000000) >> 30
}

// DMAC.CFG3: DMAC Channel Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetCFG3_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG3_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG3_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG3_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG3_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG3_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG3_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG3_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG3_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG3_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG3_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG3_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG3_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG3_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG3_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG3_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG3_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG3_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR4: DMAC Channel Source Address Register (ch_num = 4)
func (o *DMAC_Type) SetSADDR4(value uint32) {
	volatile.StoreUint32(&o.SADDR4.Reg, value)
}
func (o *DMAC_Type) GetSADDR4() uint32 {
	return volatile.LoadUint32(&o.SADDR4.Reg)
}

// DMAC.DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
func (o *DMAC_Type) SetDADDR4(value uint32) {
	volatile.StoreUint32(&o.DADDR4.Reg, value)
}
func (o *DMAC_Type) GetDADDR4() uint32 {
	return volatile.LoadUint32(&o.DADDR4.Reg)
}

// DMAC.DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
func (o *DMAC_Type) SetDSCR4_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR4_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR4.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA4: DMAC Channel Control A Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLA4_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA4_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA4.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA4_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA4_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA4_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA4_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA4_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA4_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA4_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA4_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA4_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA4_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB4: DMAC Channel Control B Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLB4_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB4_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB4_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB4_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB4_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB4_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB4_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB4_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB4_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB4_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB4_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB4_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x40000000) >> 30
}

// DMAC.CFG4: DMAC Channel Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetCFG4_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG4_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG4_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG4_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG4_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG4_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG4_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG4_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG4_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG4_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG4_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG4_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG4_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG4_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG4_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG4_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG4_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG4_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR5: DMAC Channel Source Address Register (ch_num = 5)
func (o *DMAC_Type) SetSADDR5(value uint32) {
	volatile.StoreUint32(&o.SADDR5.Reg, value)
}
func (o *DMAC_Type) GetSADDR5() uint32 {
	return volatile.LoadUint32(&o.SADDR5.Reg)
}

// DMAC.DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
func (o *DMAC_Type) SetDADDR5(value uint32) {
	volatile.StoreUint32(&o.DADDR5.Reg, value)
}
func (o *DMAC_Type) GetDADDR5() uint32 {
	return volatile.LoadUint32(&o.DADDR5.Reg)
}

// DMAC.DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
func (o *DMAC_Type) SetDSCR5_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR5_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR5.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA5: DMAC Channel Control A Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLA5_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA5_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA5.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA5_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA5_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA5_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA5_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA5_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA5_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA5_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA5_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA5_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA5_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB5: DMAC Channel Control B Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLB5_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB5_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB5_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB5_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB5_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x600000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB5_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x600000) >> 21
}
func (o *DMAC_Type) SetCTRLB5_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB5_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB5_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB5_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB5_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB5_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x40000000) >> 30
}

// DMAC.CFG5: DMAC Channel Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetCFG5_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG5_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG5_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG5_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG5_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG5_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG5_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG5_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG5_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG5_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG5_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG5_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG5_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG5_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG5_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG5_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG5_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG5_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x30000000) >> 28
}

// DMAC.WPMR: DMAC Write Protect Mode Register
func (o *DMAC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DMAC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DMAC.WPSR: DMAC Write Protect Status Register
func (o *DMAC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DMAC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32 // 0x10
	CHDR volatile.Register32 // 0x14
	CHSR volatile.Register32 // 0x18
	_    [4]byte
	CDR  volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DACC.CR: Control Register
func (o *DACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DACC.MR: Mode Register
func (o *DACC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *DACC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *DACC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *DACC_Type) SetMR_WORD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetMR_WORD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *DACC_Type) SetMR_FASTWKUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *DACC_Type) GetMR_FASTWKUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *DACC_Type) SetMR_REFRESH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetMR_REFRESH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *DACC_Type) SetMR_USER_SEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000)|value<<16)
}
func (o *DACC_Type) GetMR_USER_SEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000) >> 16
}
func (o *DACC_Type) SetMR_TAG(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *DACC_Type) GetMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *DACC_Type) SetMR_MAXS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *DACC_Type) GetMR_MAXS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *DACC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3f000000)|value<<24)
}
func (o *DACC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3f000000) >> 24
}

// DACC.CHER: Channel Enable Register
func (o *DACC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DACC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}

// DACC.CHDR: Channel Disable Register
func (o *DACC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DACC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}

// DACC.CHSR: Channel Status Register
func (o *DACC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DACC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}

// DACC.CDR: Conversion Data Register
func (o *DACC_Type) SetCDR(value uint32) {
	volatile.StoreUint32(&o.CDR.Reg, value)
}
func (o *DACC_Type) GetCDR() uint32 {
	return volatile.LoadUint32(&o.CDR.Reg)
}

// DACC.IER: Interrupt Enable Register
func (o *DACC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DACC_Type) SetIER_EOC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIER_EOC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// DACC.IDR: Interrupt Disable Register
func (o *DACC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DACC_Type) SetIDR_EOC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIDR_EOC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// DACC.IMR: Interrupt Mask Register
func (o *DACC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DACC_Type) SetIMR_EOC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIMR_EOC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// DACC.ISR: Interrupt Status Register
func (o *DACC_Type) SetISR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetISR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DACC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetISR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetISR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DACC_Type) SetISR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DACC_Type) GetISR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// DACC.ACR: Analog Current Register
func (o *DACC_Type) SetACR_IBCTLCH0(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *DACC_Type) GetACR_IBCTLCH0() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}
func (o *DACC_Type) SetACR_IBCTLCH1(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xc)|value<<2)
}
func (o *DACC_Type) GetACR_IBCTLCH1() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xc) >> 2
}
func (o *DACC_Type) SetACR_IBCTLDACCORE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *DACC_Type) GetACR_IBCTLDACCORE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// DACC.WPMR: Write Protect Mode register
func (o *DACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.WPSR: Write Protect Status register
func (o *DACC_Type) SetWPSR_WPROTERR(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPSR_WPROTERR() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetWPSR_WPROTADDR(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetWPSR_WPROTADDR() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// DACC.TPR: Transmit Pointer Register
func (o *DACC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *DACC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// DACC.TCR: Transmit Counter Register
func (o *DACC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// DACC.TNPR: Transmit Next Pointer Register
func (o *DACC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *DACC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// DACC.TNCR: Transmit Next Counter Register
func (o *DACC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// DACC.PTCR: Transfer Control Register
func (o *DACC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *DACC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// DACC.PTSR: Transfer Status Register
func (o *DACC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *DACC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [6]volatile.Register32 // 0x0
	_            [40]byte
	MATRIX_SCFG  [9]volatile.Register32 // 0x40
	_            [28]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [4]byte
	MATRIX_PRAS4 volatile.Register32 // 0xA0
	_            [4]byte
	MATRIX_PRAS5 volatile.Register32 // 0xA8
	_            [4]byte
	MATRIX_PRAS6 volatile.Register32 // 0xB0
	_            [4]byte
	MATRIX_PRAS7 volatile.Register32 // 0xB8
	_            [4]byte
	MATRIX_PRAS8 volatile.Register32 // 0xC0
	_            [60]byte
	MATRIX_MRCR  volatile.Register32 // 0x100
	_            [16]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [204]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MATRIX_MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMATRIX_MCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg) & 0x7
}

// MATRIX.MATRIX_SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetMATRIX_SCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0xff)|value)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0xff
}
func (o *MATRIX_Type) SetMATRIX_SCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_SCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x1c0000)|value<<18)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x1c0000) >> 18
}
func (o *MATRIX_Type) SetMATRIX_SCFG_ARBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_ARBT(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x3000000) >> 24
}

// MATRIX.MATRIX_PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetMATRIX_PRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetMATRIX_PRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetMATRIX_PRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetMATRIX_PRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetMATRIX_PRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS4_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS4.Reg, volatile.LoadUint32(&o.MATRIX_PRAS4.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS4_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS4.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS5: Priority Register A for Slave 5
func (o *MATRIX_Type) SetMATRIX_PRAS5_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS5_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS5_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS5_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS5_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS5_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS5.Reg, volatile.LoadUint32(&o.MATRIX_PRAS5.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS5_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS5.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS6: Priority Register A for Slave 6
func (o *MATRIX_Type) SetMATRIX_PRAS6_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS6_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS6_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS6_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS6_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS6_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS6.Reg, volatile.LoadUint32(&o.MATRIX_PRAS6.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS6_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS6.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS7: Priority Register A for Slave 7
func (o *MATRIX_Type) SetMATRIX_PRAS7_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS7_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS7_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS7_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS7_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS7_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS7.Reg, volatile.LoadUint32(&o.MATRIX_PRAS7.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS7_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS7.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_PRAS8: Priority Register A for Slave 8
func (o *MATRIX_Type) SetMATRIX_PRAS8_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS8_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS8_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS8_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetMATRIX_PRAS8_M4PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M4PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_PRAS8_M5PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS8.Reg, volatile.LoadUint32(&o.MATRIX_PRAS8.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetMATRIX_PRAS8_M5PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS8.Reg) & 0x300000) >> 20
}

// MATRIX.MATRIX_MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_MRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MRCR.Reg, volatile.LoadUint32(&o.MATRIX_MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMATRIX_MRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MRCR.Reg) & 0x40) >> 6
}

// MATRIX.CCFG_SYSIO: System I/O Configuration register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}

// MATRIX.MATRIX_WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetMATRIX_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.MATRIX_WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0xffff00) >> 8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [4]byte
	PMC_USB    volatile.Register32 // 0x38
	_          [4]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
	_          [20]byte
	PMC_PCER1  volatile.Register32 // 0x100
	PMC_PCDR1  volatile.Register32 // 0x104
	PMC_PCSR1  volatile.Register32 // 0x108
	PMC_PCR    volatile.Register32 // 0x10C
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_UOTGCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCER_UOTGCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_UOTGCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCDR_UOTGCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_UOTGCLK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_SCSR_UOTGCLK() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}

// PMC.PMC_PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPMC_PCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPMC_PCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCDR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCDR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPMC_PCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCSR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCSR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_UCKR: UTMI Clock Register
func (o *PMC_Type) SetCKGR_UCKR_UPLLEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_UCKR_UPLLCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0xf00000)|value<<20)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0xf00000) >> 20
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetPMC_MCKR_PLLADIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_MCKR_PLLADIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_MCKR_UPLLDIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_MCKR_UPLLDIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x2000) >> 13
}

// PMC.PMC_USB: USB Clock Register
func (o *PMC_Type) SetPMC_USB_USBS(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_USB_USBS() uint32 {
	return volatile.LoadUint32(&o.PMC_USB.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_USB_USBDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_USB.Reg, volatile.LoadUint32(&o.PMC_USB.Reg)&^(0xf00)|value<<8)
}
func (o *PMC_Type) GetPMC_USB_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_USB.Reg) & 0xf00) >> 8
}

// PMC.PMC_PCK: Programmable Clock 0 Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x70) >> 4
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IER_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40000) >> 18
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IDR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40000) >> 18
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SR_CFDS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SR_FOS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SR_FOS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100000) >> 20
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_IMR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40000) >> 18
}

// PMC.PMC_FSMR: Fast Start-up Mode Register
func (o *PMC_Type) SetPMC_FSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_FSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_FSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_FSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_FSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_FSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_FSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_FSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_FSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100000) >> 20
}

// PMC.PMC_FSPR: Fast Start-up Polarity Register
func (o *PMC_Type) SetPMC_FSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8000) >> 15
}

// PMC.PMC_FOCR: Fault Output Clear Register
func (o *PMC_Type) SetPMC_FOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.PMC_FOCR.Reg, volatile.LoadUint32(&o.PMC_FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.PMC_FOCR.Reg) & 0x1
}

// PMC.PMC_WPMR: Write Protect Mode Register
func (o *PMC_Type) SetPMC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.PMC_WPSR: Write Protect Status Register
func (o *PMC_Type) SetPMC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0xffff00) >> 8
}

// PMC.PMC_PCER1: Peripheral Clock Enable Register 1
func (o *PMC_Type) SetPMC_PCER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCER1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCER1_PID36(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCER1_PID36() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCER1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCER1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCER1_PID38(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCER1_PID38() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCER1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCER1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER1.Reg, volatile.LoadUint32(&o.PMC_PCER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER1.Reg) & 0x1000) >> 12
}

// PMC.PMC_PCDR1: Peripheral Clock Disable Register 1
func (o *PMC_Type) SetPMC_PCDR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCDR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCDR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCDR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCDR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCDR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCDR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCDR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCDR1_PID36(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCDR1_PID36() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCDR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCDR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCDR1_PID38(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCDR1_PID38() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCDR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCDR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCDR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR1.Reg, volatile.LoadUint32(&o.PMC_PCDR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR1.Reg) & 0x1000) >> 12
}

// PMC.PMC_PCSR1: Peripheral Clock Status Register 1
func (o *PMC_Type) SetPMC_PCSR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PCSR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PCSR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_PCSR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_PCSR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCSR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCSR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCSR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCSR1_PID36(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCSR1_PID36() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCSR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCSR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCSR1_PID38(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCSR1_PID38() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCSR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCSR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCSR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR1.Reg, volatile.LoadUint32(&o.PMC_PCSR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR1.Reg) & 0x1000) >> 12
}

// PMC.PMC_PCR: Peripheral Control Register
func (o *PMC_Type) SetPMC_PCR_PID(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x3f)|value)
}
func (o *PMC_Type) GetPMC_PCR_PID() uint32 {
	return volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x3f
}
func (o *PMC_Type) SetPMC_PCR_CMD(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCR_CMD() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCR_DIV(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x30000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCR_DIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x30000) >> 16
}
func (o *PMC_Type) SetPMC_PCR_EN(value uint32) {
	volatile.StoreUint32(&o.PMC_PCR.Reg, volatile.LoadUint32(&o.PMC_PCR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCR_EN() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCR.Reg) & 0x10000000) >> 28
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// UART.RPR: Receive Pointer Register
func (o *UART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *UART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// UART.RCR: Receive Counter Register
func (o *UART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// UART.TPR: Transmit Pointer Register
func (o *UART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *UART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// UART.TCR: Transmit Counter Register
func (o *UART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// UART.RNPR: Receive Next Pointer Register
func (o *UART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *UART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// UART.RNCR: Receive Next Counter Register
func (o *UART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// UART.TNPR: Transmit Next Pointer Register
func (o *UART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *UART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// UART.TNCR: Transmit Next Counter Register
func (o *UART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// UART.PTCR: Transfer Control Register
func (o *UART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *UART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// UART.PTSR: Transfer Status Register
func (o *UART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *UART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Embedded Flash Controller 0
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// EFC.FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetFMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *EFC_Type) SetFMR_FWS(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetFMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetFMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetFMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetFMR_FAM(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1000000)|value<<24)
}
func (o *EFC_Type) GetFMR_FAM() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x1000000) >> 24
}

// EFC.FCR: EEFC Flash Command Register
func (o *EFC_Type) SetFCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetFCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}
func (o *EFC_Type) SetFCR_FARG(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetFCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetFCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetFCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xff000000) >> 24
}

// EFC.FSR: EEFC Flash Status Register
func (o *EFC_Type) SetFSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0x1
}
func (o *EFC_Type) SetFSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetFSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetFSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetFSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x4) >> 2
}

// EFC.FRR: EEFC Flash Result Register
func (o *EFC_Type) SetFRR(value uint32) {
	volatile.StoreUint32(&o.FRR.Reg, value)
}
func (o *EFC_Type) GetFRR() uint32 {
	return volatile.LoadUint32(&o.FRR.Reg)
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ABSR   volatile.Register32 // 0x70
	_      [12]byte
	SCIFSR volatile.Register32 // 0x80
	DIFSR  volatile.Register32 // 0x84
	IFDGSR volatile.Register32 // 0x88
	SCDR   volatile.Register32 // 0x8C
	_      [16]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [4]byte
	AIMER  volatile.Register32 // 0xB0
	AIMDR  volatile.Register32 // 0xB4
	AIMMR  volatile.Register32 // 0xB8
	_      [4]byte
	ESR    volatile.Register32 // 0xC0
	LSR    volatile.Register32 // 0xC4
	ELSR   volatile.Register32 // 0xC8
	_      [4]byte
	FELLSR volatile.Register32 // 0xD0
	REHLSR volatile.Register32 // 0xD4
	FRLHSR volatile.Register32 // 0xD8
	_      [4]byte
	LOCKSR volatile.Register32 // 0xE0
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Typ