/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.CompoundEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class AtCompoundSet
extends BibEntry {
    private CompoundEntry compoundEntry;
    private GlsResource resource;

    public AtCompoundSet(GlsResource glsResource) {
        this(glsResource, "compoundset");
    }

    public AtCompoundSet(GlsResource glsResource, String string) {
        super(string);
        this.resource = glsResource;
    }

    @Override
    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList2;
        super.parseContents(teXParser, teXObjectList, teXObject);
        String string = null;
        BibValueList bibValueList = this.getField("main");
        if (bibValueList != null) {
            teXObjectList2 = bibValueList.expand(teXParser);
            string = teXObjectList2.toString(teXParser);
        }
        if ((bibValueList = this.getField("elements")) == null) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting", "elements");
        }
        teXObjectList2 = bibValueList.expand(teXParser);
        String string2 = teXObjectList2.toString(teXParser);
        bibValueList = this.getField("options");
        String string3 = null;
        if (bibValueList != null) {
            teXObjectList2 = bibValueList.expand(teXParser);
            string3 = teXObjectList2.toString(teXParser);
        }
        try {
            this.compoundEntry = new CompoundEntry(this.getId(), string2);
            if (string != null && !string.isEmpty()) {
                this.compoundEntry.setMainLabel(string);
            }
            if (string3 != null) {
                this.compoundEntry.setOptions(string3);
            }
            this.resource.addCompoundEntry(this.compoundEntry);
        }
        catch (Bib2GlsException bib2GlsException) {
            throw new BibTeXSyntaxException(bib2GlsException, teXParser, "error.syntax", bib2GlsException.getMessage());
        }
    }

    public CompoundEntry getCompoundEntry() {
        return this.compoundEntry;
    }
}

