/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class BlockingSet<T> {
    private final Set<T> set = new HashSet<T>();
    private final Condition unlock;
    private final Lock lock = new ReentrantLock();

    public BlockingSet() {
        this.unlock = this.lock.newCondition();
    }

    public void put(@NotNull T key) {
        if (key == null) {
            BlockingSet.$$$reportNull$$$0(0);
        }
        this.lock.lock();
        try {
            while (this.set.contains(key)) {
                this.unlock.awaitUninterruptibly();
            }
            this.set.add(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(@NotNull T key) throws IllegalStateException {
        if (key == null) {
            BlockingSet.$$$reportNull$$$0(1);
        }
        this.lock.lock();
        try {
            if (!this.set.contains(key)) {
                throw new IllegalStateException();
            }
            this.set.remove(key);
            this.unlock.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static <T> BlockingSet<T> newInstance() {
        return new BlockingSet<T>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "key";
        objectArray2[1] = "com/intellij/util/concurrency/BlockingSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

